/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.freertos.gdb.tad.model.views;

import com.nxp.freertos.gdb.tad.controller.TadFactoryData;
import com.nxp.freertos.gdb.tad.controller.TadFactoryDataStatus;
import com.nxp.freertos.gdb.tad.model.views.TadObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TadDataCache {
    private Map<String, TadFactoryData> dataCache = new HashMap<String, TadFactoryData>();

    public boolean isViewDataReady(String view) {
        if (this.dataCache.containsKey(view)) {
            TadFactoryData data = this.dataCache.get(view);
            return data != null && (data.getStatus() == TadFactoryDataStatus.WARNING || data.getStatus() == TadFactoryDataStatus.INFORMATION || data.isValid());
        }
        return false;
    }

    public void setViewData(String view, TadFactoryData data) {
        if (view != null && data != null) {
            this.dataCache.put(view, data);
        }
    }

    public TadFactoryData getViewData(String view) {
        if (this.isViewDataReady(view)) {
            return this.dataCache.get(view);
        }
        return null;
    }

    public List<? extends TadObject> getViewTadObjects(String view) {
        TadFactoryData data = this.getViewData(view);
        if (data != null) {
            return data.getTadObjects();
        }
        return null;
    }

    public void clear() {
        this.dataCache.clear();
    }
}

