/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.internal.migration;

import com.nxp.s32ds.cle.runtime.internal.migration.MigrationActivator;
import com.nxp.s32ds.cle.runtime.migration.MigrationObjectDescriptor;
import com.nxp.s32ds.cle.runtime.migration.MigrationRegistryBase;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class MigrationRegistryBaseImpl<T extends MigrationObjectDescriptor>
implements MigrationRegistryBase<T> {
    protected final Map<String, T> descriptorsMap = new HashMap<String, T>();

    @Override
    public void addDescriptor(T descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor is null");
        }
        String id = descriptor.getId();
        if (id == null) {
            throw new IllegalStateException("descriptor ID is null");
        }
        if (this.descriptorsMap.containsKey(id)) {
            MigrationActivator.getInstance().logError(NLS.bind((String)"An attempt to add an descriptor with an id ''{0}'' that already exists. Ignored.", (Object)id), new Exception());
        }
        this.descriptorsMap.put(descriptor.getId(), descriptor);
    }

    @Override
    public void removeDescriptor(T descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException("descriptor is null");
        }
        this.removeDescriptor(descriptor.getId());
    }

    @Override
    public void removeDescriptor(String descriptorId) {
        if (descriptorId == null) {
            throw new IllegalStateException("descriptor ID is null");
        }
        this.descriptorsMap.remove(descriptorId);
    }

    @Override
    public Collection<T> getDescriptors() {
        return this.descriptorsMap.values();
    }

    @Override
    public T getDescriptor(String descriptorId) {
        return (T)((MigrationObjectDescriptor)this.descriptorsMap.get(descriptorId));
    }
}

