/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.collateral.internal.core.handlers;

import com.nxp.s32ds.cle.ide.collateral.internal.core.CollateralCoreActivator;
import com.nxp.s32ds.cle.ide.collateral.internal.core.handlers.CollateralHandlerManagerImplementation;
import com.nxp.s32ds.cle.ide.collateral.internal.core.parsers.CollateralLoadHandler;
import com.nxp.s32ds.cle.ide.collateral.internal.core.parsers.CollateralMementoHandler;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeEvent;
import com.nxp.s32ds.cle.ide.core.listener.ComponentChangeListener;
import com.nxp.s32ds.cle.ide.core.listener.builder.ComponentChangeEventParser;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerComponent;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageDescriptor;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPayload;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManifestFilesManager;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManifestHandler;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import com.nxp.s32ds.rcp.collateral.CollateralRegistry;
import java.util.AbstractMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.ui.WorkbenchException;

public class CollateralComponentChangeEventHandler
implements ComponentChangeListener {
    public void onComponentChange(ComponentChangeEvent event) {
        Object object;
        CollateralRegistry collateralRegistry = CollateralCoreActivator.getInstance().getCollateralRegistry();
        ComponentChangeEventParser parser = new ComponentChangeEventParser(event);
        if ("software_package_eventevent appeared".equals(parser.getArchetype()) && (object = event.getParameters().get("payload")) instanceof SoftwareManagerPayload) {
            SoftwareManagerPayload managerPayload = (SoftwareManagerPayload)object;
            Set<String> actualLocations = managerPayload.getCurrentSoftwareManagerDescriptors().stream().filter(SoftwareManagerPackageDescriptor.class::isInstance).flatMap(obj -> obj.getComponents().stream()).filter(component -> "collateral".equals(component.getType())).map(component -> component.getManifest()).collect(Collectors.toSet());
            CollateralHandlerManagerImplementation collateralHandlerManagerImplementation = new CollateralHandlerManagerImplementation(actualLocations);
            SoftwareManifestHandler manifestHandler = new SoftwareManifestHandler((SoftwareManifestFilesManager)collateralHandlerManagerImplementation);
            try {
                if (!manifestHandler.isFilesChanged((RcpBundle)CollateralCoreActivator.getInstance())) {
                    CollateralMementoHandler.load(collateralRegistry);
                } else {
                    CollateralComponentChangeEventHandler.readFromSoftwareDescriptorFiles(collateralRegistry, managerPayload);
                }
            }
            catch (WorkbenchException e) {
                CollateralCoreActivator.getInstance().logError(e.getMessage());
                CollateralComponentChangeEventHandler.readFromSoftwareDescriptorFiles(collateralRegistry, managerPayload);
            }
        }
        if ("software_package_loading_finished".equals(parser.getArchetype())) {
            collateralRegistry.combineModularAndCollateralModels();
            collateralRegistry.setRegistryComplete();
            return;
        }
    }

    private static void readFromSoftwareDescriptorFiles(CollateralRegistry collateralRegistry, SoftwareManagerPayload managerPayload) {
        Map<String, SoftwareManagerComponent> manifest2Component = managerPayload.getCurrentSoftwareManagerDescriptors().stream().filter(SoftwareManagerPackageDescriptor.class::isInstance).flatMap(obj -> obj.getComponents().stream()).filter(component -> "collateral".equals(component.getType())).map(component -> new AbstractMap.SimpleEntry<String, SoftwareManagerComponent>(component.getManifest(), (SoftwareManagerComponent)component)).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
        manifest2Component.entrySet().forEach(entry -> CollateralLoadHandler.loadFromFile((String)entry.getKey(), collateralRegistry));
        CollateralMementoHandler.store(manifest2Component.keySet(), collateralRegistry);
    }
}

