/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.generation;

import com.nxp.swtools.codemanager.GeneratedCodeStatus;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.controller.Messages;
import com.nxp.swtools.provider.configuration.SharedConfigurationFactory;
import com.nxp.swtools.provider.configuration.sources.ISourceFile;
import com.nxp.swtools.provider.configuration.sources.SourceFileProviderFactory;
import com.nxp.swtools.provider.configuration.storage.ICustomCopyrightHeaderRead;
import com.nxp.swtools.utils.scripting.ScriptResult;
import com.nxp.swtools.utils.sources.ISourcesContentProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class GtmSourcesContentProvider
implements ISourcesContentProvider {
    public @Nullable String getStatus() {
        GtmController gtmController = GtmController.getInstance();
        if (!gtmController.isToolEnabled().get() || gtmController.isGeneratingCode()) {
            return null;
        }
        ScriptResult scriptResult = gtmController.getGeneratedCode();
        String mcuError = gtmController.getToolError();
        if (mcuError != null) {
            return mcuError;
        }
        if (scriptResult.isFailedDueTimeout()) {
            return Messages.Controller_SourcesGeneration_GenerationFailedDueTimeout;
        }
        if (scriptResult.isFailed() || scriptResult.containsAnyError()) {
            return Messages.Controller_SourcesGeneration_CannotGenerateDueToInternalError;
        }
        if (!UtilsText.isEmpty((String)scriptResult.getErrors())) {
            return Messages.SourcesViewProvider_SourcesGeneration_GeneratedWithErrors;
        }
        if (!UtilsText.isEmpty((String)scriptResult.getWarnings())) {
            return Messages.SourcesViewProvider_SourcesGeneration_GeneratedWithWarnings;
        }
        return Messages.CodeGenerationSuccess;
    }

    public @Nullable String getErrorText() {
        GtmController gtmController = GtmController.getInstance();
        if (!gtmController.isToolEnabled().get() || gtmController.isGeneratingCode()) {
            return null;
        }
        ScriptResult scriptResult = gtmController.getGeneratedCode();
        String mcuError = gtmController.getToolError();
        if (mcuError != null) {
            return mcuError;
        }
        if (scriptResult.isFailedDueTimeout()) {
            return Messages.Controller_SourcesGeneration_GenerationFailedDueTimeout;
        }
        return !scriptResult.isFailed() ? scriptResult.getErrors() : Messages.Controller_SourcesGeneration_CannotGenerateDueToInternalError;
    }

    public @Nullable String getWarningText() {
        GtmController gtmController = GtmController.getInstance();
        if (!gtmController.isToolEnabled().get() || gtmController.isGeneratingCode()) {
            return null;
        }
        ScriptResult scriptResult = gtmController.getGeneratedCode();
        return scriptResult.getWarnings();
    }

    public boolean isOutOfSync() {
        GtmController gtmController = GtmController.getInstance();
        ScriptResult generatedCode = gtmController.getGeneratedCode();
        return gtmController.isGeneratingCode() || generatedCode.isFailed() || GeneratedCodeStatus.getInstance().isOutOfSync();
    }

    public boolean isExportBtnDisabled() {
        return false;
    }

    public @NonNull Collection<@NonNull ISourceFile> getContent() {
        GtmController controller = GtmController.getInstance();
        String coreId = controller.getSelectedCore();
        ScriptResult lastWorkingResult = null;
        if (!controller.getSharedConfig().isEmpty()) {
            lastWorkingResult = controller.getGeneratedCode();
        }
        if (lastWorkingResult != null) {
            Map<@NonNull K, @NonNull V> coreSourceFiles = coreId != null ? lastWorkingResult.getOpenedFiles(coreId) : lastWorkingResult.getOpenedFiles();
            return SourceFileProviderFactory.buildSourceFileList((Map)(coreSourceFiles != null ? coreSourceFiles : new HashMap()), (ICustomCopyrightHeaderRead)SharedConfigurationFactory.getSharedConfigurationSingleton().getPreferences().getCustomCopyright());
        }
        return new ArrayList<ISourceFile>();
    }
}

