/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.gtm.controller.constraints;

import com.nxp.swtools.common.uct.mcu.IMcu;
import com.nxp.swtools.common.uct.ui.xml.settings.ABaseUIComponentSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.IntegerSetting;
import com.nxp.swtools.common.uct.ui.xml.settings.ItemSetting;
import com.nxp.swtools.common.uct.utils.UctUtils;
import com.nxp.swtools.common.uct.xml.settings.DisableState;
import com.nxp.swtools.common.uct.xml.settings.LimitValues;
import com.nxp.swtools.common.uct.xml.settings.VisibleState;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.gtm.controller.GtmController;
import com.nxp.swtools.gtm.model.mcu.IGtmMcu;
import com.nxp.swtools.gtm.model.utils.GtmExpressions;
import com.nxp.swtools.gtm.model.xml.settings.GtmBoolSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmConstraintsTable;
import com.nxp.swtools.gtm.model.xml.settings.GtmEnumSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmIntegerSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmStructSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmTextSetting;
import com.nxp.swtools.gtm.model.xml.settings.GtmValidationRule;
import com.nxp.swtools.gtm.model.xml.settings.IGtmSetting;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;

public class GtmConstraintsHandler {
    private GtmController gtmController;
    private Set<IGtmSetting> gtmInputDependentComponents;

    public GtmConstraintsHandler(GtmController gtmController) {
        this.gtmController = gtmController;
        this.gtmInputDependentComponents = new HashSet<IGtmSetting>();
    }

    public void createConstraintDependency(GtmStructSetting structSetting) {
        this.createStructSettingDependencies(structSetting);
        for (GtmIntegerSetting integerSetting : structSetting.getIntegerSettings()) {
            this.createIntegerSettingDependencies(integerSetting);
        }
        for (GtmTextSetting textSetting : structSetting.getTextSettings()) {
            this.createTextSettingDependencies(textSetting);
        }
        for (GtmBoolSetting boolSetting : structSetting.getBoolSettings()) {
            this.createBoolSettingDependencies(boolSetting);
        }
        for (GtmEnumSetting enumSetting : structSetting.getEnumSettings()) {
            this.createEnumSettingDependencies(enumSetting);
        }
        for (GtmStructSetting childStructSetting : structSetting.getStructSettings()) {
            this.createConstraintDependency(childStructSetting);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createStructSettingDependencies(GtmStructSetting structSetting) {
        @NonNull Set componentsDependencies = structSetting.getComponentsDependencies();
        String[] stringArray = structSetting.getConstraintsReferences();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String constraintRef = stringArray[n2];
            GtmConstraintsHandler.createVisibleStateDependencies((ABaseUIComponentSetting)structSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createDisableStateDependencies((ABaseUIComponentSetting)structSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createValidationDependencies((ABaseUIComponentSetting)structSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            ++n2;
        }
        for (ABaseUIComponentSetting dependencySetting : structSetting.getComponentsDependencies()) {
            ChangeListener<@NonNull String> constraintsListener = this.gtmController.createConstraintsListener((IGtmSetting)structSetting);
            dependencySetting.getCurrentValueProperty().addListener(constraintsListener);
            this.gtmController.addEntryToListenersMap(constraintsListener, (ObservableValue<?>)dependencySetting.getCurrentValueProperty());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createIntegerSettingDependencies(GtmIntegerSetting integerSetting) {
        @NonNull Set componentsDependencies = integerSetting.getComponentsDependencies();
        String[] stringArray = integerSetting.getConstraintsReferences();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String constraintRef = stringArray[n2];
            GtmConstraintsHandler.createLimitValueDependencies((IntegerSetting)integerSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createDisableStateDependencies((ABaseUIComponentSetting)integerSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createVisibleStateDependencies((ABaseUIComponentSetting)integerSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createValidationDependencies((ABaseUIComponentSetting)integerSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            ++n2;
        }
        for (ABaseUIComponentSetting dependencySetting : integerSetting.getComponentsDependencies()) {
            ChangeListener<@NonNull String> validateValueListener = this.gtmController.createValidateValueListener(integerSetting);
            dependencySetting.getCurrentValueProperty().addListener(validateValueListener);
            this.gtmController.addEntryToListenersMap(validateValueListener, (ObservableValue<?>)dependencySetting.getCurrentValueProperty());
            ChangeListener<@NonNull String> constraintsListener = this.gtmController.createConstraintsListener((IGtmSetting)integerSetting);
            dependencySetting.getCurrentValueProperty().addListener(constraintsListener);
            this.gtmController.addEntryToListenersMap(constraintsListener, (ObservableValue<?>)dependencySetting.getCurrentValueProperty());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createTextSettingDependencies(GtmTextSetting textSetting) {
        @NonNull Set componentsDependencies = textSetting.getComponentsDependencies();
        GtmConstraintsHandler.createGetValueDependencies((ABaseUIComponentSetting)textSetting, componentsDependencies, this.gtmController.getGtmMcu());
        String[] stringArray = textSetting.getConstraintsReferences();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String constraintRef = stringArray[n2];
            GtmConstraintsHandler.createVisibleStateDependencies((ABaseUIComponentSetting)textSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createDisableStateDependencies((ABaseUIComponentSetting)textSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createValidationDependencies((ABaseUIComponentSetting)textSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            ++n2;
        }
        for (ABaseUIComponentSetting dependencySetting : textSetting.getComponentsDependencies()) {
            ChangeListener<@NonNull String> constraintsListener = this.gtmController.createConstraintsListener((IGtmSetting)textSetting);
            dependencySetting.getCurrentValueProperty().addListener(constraintsListener);
            this.gtmController.addEntryToListenersMap(constraintsListener, (ObservableValue<?>)dependencySetting.getCurrentValueProperty());
            if (!(dependencySetting instanceof GtmTextSetting)) continue;
            ((GtmTextSetting)dependencySetting).getCurrentValueOutProperty().addListener(constraintsListener);
            this.gtmController.addEntryToListenersMap(constraintsListener, (ObservableValue<?>)((GtmTextSetting)dependencySetting).getCurrentValueOutProperty());
        }
        if (GtmExpressions.hasGtmInputResolutionInExpression((IGtmMcu)this.gtmController.getGtmMcu(), (ABaseUIComponentSetting)textSetting)) {
            this.gtmInputDependentComponents.add((IGtmSetting)textSetting);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createBoolSettingDependencies(GtmBoolSetting boolSetting) {
        @NonNull Set componentsDependencies = boolSetting.getComponentsDependencies();
        String[] stringArray = boolSetting.getConstraintsReferences();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String constraintRef = stringArray[n2];
            GtmConstraintsHandler.createVisibleStateDependencies((ABaseUIComponentSetting)boolSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createDisableStateDependencies((ABaseUIComponentSetting)boolSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createValidationDependencies((ABaseUIComponentSetting)boolSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            ++n2;
        }
        for (ABaseUIComponentSetting dependencySetting : boolSetting.getComponentsDependencies()) {
            ChangeListener<@NonNull String> constraintsListener = this.gtmController.createConstraintsListener((IGtmSetting)boolSetting);
            dependencySetting.getCurrentValueProperty().addListener(constraintsListener);
            this.gtmController.addEntryToListenersMap(constraintsListener, (ObservableValue<?>)dependencySetting.getCurrentValueProperty());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void createEnumSettingDependencies(GtmEnumSetting enumSetting) {
        @NonNull Set componentsDependencies = enumSetting.getComponentsDependencies();
        String[] stringArray = enumSetting.getConstraintsReferences();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String constraintRef = stringArray[n2];
            GtmConstraintsHandler.createVisibleStateDependencies((ABaseUIComponentSetting)enumSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createDisableStateDependencies((ABaseUIComponentSetting)enumSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            GtmConstraintsHandler.createValidationDependencies((ABaseUIComponentSetting)enumSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
            for (ItemSetting itemSetting : enumSetting.getItems()) {
                String[] stringArray2 = itemSetting.getConstraintsReferences();
                int n3 = stringArray2.length;
                int n4 = 0;
                while (n4 < n3) {
                    String itemConstraintRef = stringArray2[n4];
                    GtmConstraintsHandler.createVisibleStateDependencies((ABaseUIComponentSetting)itemSetting, componentsDependencies, itemConstraintRef, this.gtmController.getGtmMcu());
                    GtmConstraintsHandler.createDisableStateDependencies((ABaseUIComponentSetting)itemSetting, componentsDependencies, itemConstraintRef, this.gtmController.getGtmMcu());
                    GtmConstraintsHandler.createValidationDependencies((ABaseUIComponentSetting)itemSetting, componentsDependencies, constraintRef, this.gtmController.getGtmMcu());
                    ++n4;
                }
            }
            ++n2;
        }
        for (ABaseUIComponentSetting dependencySetting : enumSetting.getComponentsDependencies()) {
            ChangeListener<@NonNull String> constraintsListener = this.gtmController.createConstraintsListener((IGtmSetting)enumSetting);
            dependencySetting.getCurrentValueProperty().addListener(constraintsListener);
            this.gtmController.addEntryToListenersMap(constraintsListener, (ObservableValue<?>)dependencySetting.getCurrentValueProperty());
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void createGetValueDependencies(@NonNull ABaseUIComponentSetting componentSetting, Set<@NonNull ABaseUIComponentSetting> componentsDependencies, @NonNull IGtmMcu gtmMcu) {
        ABaseUIComponentSetting constraintSetting;
        @NonNull ArrayList dependencyIDs = GtmExpressions.getDependenciesFromExpression((String)componentSetting.getValueExpression());
        for (String dependencyID : dependencyIDs) {
            constraintSetting = UctUtils.getUIComponentSettingById((IMcu)gtmMcu, (String)dependencyID);
            if (constraintSetting == null || componentsDependencies.contains(constraintSetting)) continue;
            componentsDependencies.add(constraintSetting);
        }
        if (componentSetting instanceof GtmTextSetting) {
            dependencyIDs = GtmExpressions.getDependenciesFromExpression((String)((GtmTextSetting)componentSetting).getValueExpressionOut());
            for (String dependencyID : dependencyIDs) {
                constraintSetting = UctUtils.getUIComponentSettingById((IMcu)gtmMcu, (String)dependencyID);
                if (constraintSetting == null || componentsDependencies.contains(constraintSetting)) continue;
                componentsDependencies.add(constraintSetting);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void createVisibleStateDependencies(@NonNull ABaseUIComponentSetting componentSetting, Set<@NonNull ABaseUIComponentSetting> componentsDependencies, @NonNull String constraintRef, IGtmMcu gtmMcu) {
        VisibleState visibleConstraint = gtmMcu.getGtmXmlConfig().getConstraints().getVisibleStateById(constraintRef);
        if (visibleConstraint != null) {
            @NonNull List subConditionsList = UctUtils.getAllDependenciesFromCondition((String)visibleConstraint.getCondition());
            for (String subCondition : subConditionsList) {
                ABaseUIComponentSetting constraintComponent = UctUtils.getComponentSettingByConstraint((IMcu)gtmMcu, (ABaseUIComponentSetting)componentSetting, (String)subCondition);
                if (constraintComponent == null) continue;
                componentsDependencies.add(constraintComponent);
            }
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void createValidationDependencies(@NonNull ABaseUIComponentSetting componentSetting, Set<@NonNull ABaseUIComponentSetting> componentsDependencies, @NonNull String constraintRef, IGtmMcu gtmMcu) {
        GtmValidationRule validationRule = gtmMcu.getGtmXmlConfig().getConstraints().getValidationRuleById(constraintRef);
        if (validationRule != null) {
            @NonNull List subConditionsList = UctUtils.getAllDependenciesFromCondition((String)validationRule.getCondition());
            for (String subCondition : subConditionsList) {
                ABaseUIComponentSetting constraintComponent = UctUtils.getComponentSettingByConstraint((IMcu)gtmMcu, (ABaseUIComponentSetting)componentSetting, (String)subCondition);
                if (constraintComponent == null) continue;
                componentsDependencies.add(constraintComponent);
            }
        }
    }

    public static void createLimitValueDependencies(@NonNull IntegerSetting integerSetting, Set<@NonNull ABaseUIComponentSetting> componentsDependencies, @NonNull String constraintRef, IGtmMcu gtmMcu) {
        ABaseUIComponentSetting constraintComponent;
        LimitValues limitConstraint = gtmMcu.getGtmXmlConfig().getConstraints().getLimitValuesById(constraintRef);
        if (limitConstraint != null && (constraintComponent = UctUtils.getComponentSettingByLimitConstraint((IMcu)gtmMcu, (ABaseUIComponentSetting)integerSetting, (LimitValues)limitConstraint)) != null) {
            componentsDependencies.add(constraintComponent);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static void createDisableStateDependencies(@NonNull ABaseUIComponentSetting componentSetting, Set<@NonNull ABaseUIComponentSetting> componentsDependencies, @NonNull String constraintRef, IGtmMcu gtmMcu) {
        DisableState disableConstraint = gtmMcu.getGtmXmlConfig().getConstraints().getDisableStateById(constraintRef);
        if (disableConstraint != null) {
            @NonNull List subConditionsList = UctUtils.getAllDependenciesFromCondition((String)disableConstraint.getCondition());
            for (String subCondition : subConditionsList) {
                ABaseUIComponentSetting constraintComponent = UctUtils.getComponentSettingByConstraint((IMcu)gtmMcu, (ABaseUIComponentSetting)componentSetting, (String)subCondition);
                if (constraintComponent == null) continue;
                componentsDependencies.add(constraintComponent);
            }
        }
    }

    public void checkInputResolutionConstraints() {
        GtmConstraintsTable constraints = this.gtmController.getGtmXmlConfig().getConstraints();
        for (IGtmSetting gtmSetting : this.gtmInputDependentComponents) {
            gtmSetting.checkConstraints(this.gtmController.getGtmMcu(), constraints);
        }
    }

    public Set<IGtmSetting> getGtmInputDependentComponents() {
        return this.gtmInputDependentComponents;
    }
}

