/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.volkano.ui;

import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionAccessor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnectionDescriptor;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DebuggerConnections;
import com.nxp.s32ds.cle.runtime.debugger.connections.registry.DeviceConnection;
import com.nxp.s32ds.debug.ide.core.DebuggerUtils;
import com.nxp.s32ds.debug.ide.s32debugger.core.BoardConnectionDescriptor;
import com.nxp.s32ds.debug.ide.s32debugger.core.ProcessCheckingJob;
import com.nxp.s32ds.debug.ide.s32debugger.core.S32DebuggerBackend;
import com.nxp.s32ds.debug.ide.volkano.VolkanoUtil;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoActivator;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoTypes;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoUIMessage;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class VolkanoRegisterDialog
extends Dialog {
    private Text textKey;
    private Text textFile;
    private Text textUid;
    private Text textAddress;
    private Label lbltextUid;
    private Label lbltextAddress;
    private StyledText lblStatus;
    private ControlDecoration lblStatusDecoration;
    private Combo cmbConnections;
    private Combo cmbUsbDevice;
    private Button btnConnect;
    private Button btnSelect;
    private Button btnFinish;
    private String key;
    private String keyPath;
    private String uid;
    private List<DebuggerConnectionDescriptor> connections = new ArrayList<DebuggerConnectionDescriptor>();
    private DeviceConnection[] activeConnections;
    private DebuggerConnectionDescriptor selectedConnectionType;
    private DeviceConnection activeConnection;
    private String registerType = VolkanoTypes.ADKP_VALUE.getName();
    private Set<String> registeredUidTypes = new HashSet<String>();
    private boolean isFinishPressed = false;

    public VolkanoRegisterDialog(Shell parent, String title, Set<String> uidTypes) {
        super(parent);
        this.setText(title);
        this.registeredUidTypes = uidTypes;
    }

    public void open() {
        Shell parent = this.getParent();
        Shell shell = new Shell(parent, 67680);
        shell.setText(this.getText());
        Image icon = VolkanoActivator.getBundle().getImage("S32DS_ICON");
        shell.setImage(icon);
        this.createDialogArea(shell);
        shell.open();
        Display display = parent.getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void createDialogArea(final Shell parent) {
        Rectangle clientArea = Display.getDefault().getBounds();
        Font systemFont = Display.getDefault().getSystemFont();
        FontData[] fontData = systemFont.getFontData();
        int heightHint = 0;
        if (fontData != null && fontData.length > 0) {
            heightHint = fontData[0].getHeight() * 2;
        }
        int x = clientArea.width / 3;
        int y = clientArea.height / 3;
        parent.setLocation(x, y);
        parent.setLayout((Layout)new GridLayout(1, false));
        GridData dataParent = new GridData(4, 4, true, false, 1, 1);
        parent.setLayoutData((Object)dataParent);
        Composite cmps = new Composite((Composite)parent, 0);
        cmps.setLayout((Layout)new GridLayout(3, false));
        cmps.setLayoutData((Object)dataParent);
        GridData dataLeft = new GridData(4, 4, false, false, 1, 1);
        dataLeft.heightHint = heightHint;
        dataLeft.widthHint = 40;
        GridData dataRight = new GridData(4, 4, false, false, 2, 1);
        dataRight.widthHint = 250;
        Group groupRegister = new Group(cmps, 0);
        groupRegister.setText("Register type");
        groupRegister.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        groupRegister.setLayout((Layout)new GridLayout(3, false));
        final Combo cmbRegType = new Combo((Composite)groupRegister, 8);
        cmbRegType.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        cmbRegType.setItems(VolkanoTypes.getRegistrationTypes().toArray(new String[0]));
        cmbRegType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoRegisterDialog.this.registerType = cmbRegType.getText();
                VolkanoRegisterDialog.this.textKey.setMessage(VolkanoRegisterDialog.this.registerType);
                VolkanoRegisterDialog.this.textFile.setText("");
                VolkanoTypes type = VolkanoTypes.findRegisterTypeByName(VolkanoRegisterDialog.this.registerType);
                if (type != null) {
                    VolkanoRegisterDialog.this.setEnabledFileSelection(type.isFile());
                }
                VolkanoRegisterDialog.this.resetCurrentState();
            }
        });
        cmbRegType.select(0);
        Label lblKeyValue = new Label((Composite)groupRegister, 0);
        lblKeyValue.setText("Value");
        lblKeyValue.setLayoutData((Object)dataLeft);
        this.textKey = new Text((Composite)groupRegister, 2048);
        this.textKey.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.textKey.addVerifyListener(e -> {
            if (VolkanoTypes.ADKP_VALUE.getName().equals(this.registerType) || VolkanoTypes.KUID_VALUE.getName().equals(this.registerType)) {
                e.doit = VolkanoUtil.isHex((char)e.character);
            }
        });
        this.textKey.setMessage(this.registerType);
        Label lblKeyFile = new Label((Composite)groupRegister, 0);
        lblKeyFile.setText("File");
        lblKeyFile.setLayoutData((Object)dataLeft);
        this.textFile = new Text((Composite)groupRegister, 2048);
        this.textFile.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnSelect = new Button((Composite)groupRegister, 8);
        this.btnSelect.setText("Select");
        this.btnSelect.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.btnSelect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(Display.getDefault().getActiveShell(), 0);
                String result = dialog.open();
                if (result != null) {
                    VolkanoRegisterDialog.this.textFile.setText(new Path(result).toOSString());
                    VolkanoRegisterDialog.this.validateFile();
                }
            }
        });
        Group group = new Group(cmps, 0);
        group.setText("Connection");
        group.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        group.setLayout((Layout)new GridLayout(3, false));
        this.cmbConnections = new Combo((Composite)group, 8);
        this.cmbConnections.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.cmbConnections.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoRegisterDialog.this.selectedConnectionType = VolkanoRegisterDialog.this.connections.get(VolkanoRegisterDialog.this.cmbConnections.getSelectionIndex());
                VolkanoRegisterDialog.this.textAddress.setEditable(VolkanoRegisterDialog.this.selectedConnectionType.isEthernetConnection());
                VolkanoRegisterDialog.this.cmbUsbDevice.setEnabled(!VolkanoRegisterDialog.this.selectedConnectionType.isEthernetConnection());
                if (!VolkanoRegisterDialog.this.selectedConnectionType.isEthernetConnection()) {
                    VolkanoRegisterDialog.this.cmbUsbDevice.setItems(VolkanoRegisterDialog.this.getActiveConnections());
                    VolkanoRegisterDialog.this.textAddress.setText("");
                    if (VolkanoRegisterDialog.this.cmbUsbDevice.getItemCount() != 0) {
                        VolkanoRegisterDialog.this.cmbUsbDevice.select(0);
                        VolkanoRegisterDialog.this.cmbUsbDevice.notifyListeners(13, new Event());
                        VolkanoRegisterDialog.this.btnConnect.setEnabled(true);
                    } else {
                        VolkanoRegisterDialog.this.btnConnect.setEnabled(false);
                    }
                } else {
                    VolkanoRegisterDialog.this.cmbUsbDevice.removeAll();
                    VolkanoRegisterDialog.this.activeConnection = new DeviceConnection(VolkanoRegisterDialog.this.selectedConnectionType.getConnectionName(), VolkanoRegisterDialog.this.selectedConnectionType.isEthernetConnection());
                    VolkanoRegisterDialog.this.btnConnect.setEnabled(!VolkanoRegisterDialog.this.textAddress.getText().isEmpty());
                }
            }
        });
        this.cmbUsbDevice = new Combo((Composite)group, 8);
        this.cmbUsbDevice.setLayoutData((Object)new GridData(4, 4, false, false, 3, 1));
        this.cmbUsbDevice.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoRegisterDialog.this.activeConnection = VolkanoRegisterDialog.this.activeConnections[VolkanoRegisterDialog.this.cmbUsbDevice.getSelectionIndex()];
            }
        });
        this.lbltextAddress = new Label((Composite)group, 0);
        this.lbltextAddress.setText("IPv4");
        this.lbltextAddress.setLayoutData((Object)dataLeft);
        this.textAddress = new Text((Composite)group, 2048);
        this.textAddress.setMessage("Enter IP Address");
        this.textAddress.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.textAddress.addVerifyListener(e -> {
            boolean bl = e.doit = VolkanoUtil.isIPv4((char)e.character);
        });
        this.textAddress.addModifyListener(e -> {
            this.lblStatus.setText("");
            this.btnConnect.setEnabled(!this.textAddress.getText().isEmpty());
        });
        this.btnConnect = new Button((Composite)group, 8);
        this.btnConnect.setText("Connect");
        this.btnConnect.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnConnect.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoRegisterDialog.this.lblStatus.setText("");
                if (VolkanoRegisterDialog.this.selectedConnectionType == null) {
                    return;
                }
                IStatus status = Status.OK_STATUS;
                if (VolkanoRegisterDialog.this.selectedConnectionType.isEthernetConnection()) {
                    String address = VolkanoRegisterDialog.this.textAddress.getText();
                    VolkanoRegisterDialog.this.activeConnection.setDeviceConnectionData(address);
                    status = VolkanoRegisterDialog.validateAddress(address);
                } else if (VolkanoRegisterDialog.this.activeConnection == null) {
                    status = new Status(8, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_error_usb_device_not_specified);
                } else {
                    String activeConnectionId = VolkanoRegisterDialog.this.activeConnection.getDeviceConnectionId();
                    String[] currActiveConnections = VolkanoRegisterDialog.this.getActiveConnections();
                    if (Arrays.stream(VolkanoRegisterDialog.this.activeConnections).noneMatch(con -> activeConnectionId.equals(con.getDeviceConnectionId()))) {
                        VolkanoRegisterDialog.this.cmbUsbDevice.setItems(currActiveConnections);
                        status = new Status(8, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_error_usb_device_was_disconnected);
                    }
                }
                if (status.isOK()) {
                    VolkanoRegisterDialog.this.executeConnectionCmd(VolkanoRegisterDialog.this.activeConnection.getFullConnectionString());
                    if (VolkanoRegisterDialog.this.lblStatus.getText().isEmpty() && VolkanoRegisterDialog.this.btnSelect.isEnabled()) {
                        VolkanoRegisterDialog.this.validateFile();
                    }
                } else {
                    VolkanoRegisterDialog.this.lblStatus.setText(status.getMessage());
                    if (!VolkanoRegisterDialog.this.selectedConnectionType.isEthernetConnection()) {
                        if (VolkanoRegisterDialog.this.activeConnections.length != 0) {
                            VolkanoRegisterDialog.this.activeConnection = VolkanoRegisterDialog.this.activeConnections[0];
                            VolkanoRegisterDialog.this.cmbUsbDevice.select(0);
                        } else {
                            VolkanoRegisterDialog.this.activeConnection = null;
                            VolkanoRegisterDialog.this.btnConnect.setEnabled(false);
                        }
                    } else {
                        VolkanoRegisterDialog.this.btnConnect.setEnabled(false);
                    }
                }
            }
        });
        this.lbltextUid = new Label((Composite)group, 0);
        this.lbltextUid.setText("UID");
        this.lbltextUid.setLayoutData((Object)dataLeft);
        this.textUid = new Text((Composite)group, 2048);
        this.textUid.setLayoutData((Object)dataRight);
        this.textUid.addVerifyListener(e -> {
            boolean bl = e.doit = VolkanoUtil.isHex((char)e.character);
        });
        GridData statusGridData = new GridData(4, 4, true, true, 2, 1);
        statusGridData.heightHint = heightHint;
        statusGridData.horizontalIndent = 8;
        this.lblStatus = new StyledText(cmps, 10);
        this.lblStatus.setLayoutData((Object)statusGridData);
        this.lblStatus.setEditable(false);
        this.lblStatus.setToolTipText(VolkanoUIMessage.Volkano_ui_error_status_line);
        this.lblStatus.setBackground(cmps.getBackground());
        this.lblStatus.setCaret(null);
        this.lblStatus.setLeftMargin(3);
        this.lblStatusDecoration = VolkanoRegisterDialog.createDecoration(this.lblStatus);
        this.lblStatus.addModifyListener(e -> {
            if (this.lblStatus.getText().isEmpty()) {
                this.lblStatus.setToolTipText(VolkanoUIMessage.Volkano_ui_error_status_line);
                this.lblStatusDecoration.hide();
            } else {
                this.lblStatus.setToolTipText(this.lblStatus.getText());
                this.lblStatusDecoration.show();
            }
        });
        GridLayout btnLayout = new GridLayout(3, false);
        btnLayout.marginWidth = 1;
        btnLayout.marginBottom = 1;
        btnLayout.marginHeight = 1;
        btnLayout.marginTop = 1;
        btnLayout.marginRight = 1;
        Composite buttons = new Composite(cmps, 0);
        buttons.setLayout((Layout)btnLayout);
        buttons.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        Label space = new Label(buttons, 0);
        space.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.btnFinish = new Button(buttons, 8);
        this.btnFinish.setText("OK");
        this.btnFinish.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.btnFinish.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                VolkanoTypes type;
                VolkanoRegisterDialog.this.lblStatus.setText("");
                VolkanoRegisterDialog.this.key = VolkanoRegisterDialog.this.textKey.getText();
                VolkanoRegisterDialog.this.keyPath = VolkanoRegisterDialog.this.textFile.getText();
                VolkanoRegisterDialog.this.uid = VolkanoRegisterDialog.this.textUid.getText();
                IStatus status = VolkanoRegisterDialog.validateInput(VolkanoRegisterDialog.this.uid, VolkanoTypes.SOC_UID);
                if (!status.isOK()) {
                    VolkanoRegisterDialog.this.lblStatus.setText(status.getMessage());
                }
                if (!(type = VolkanoTypes.findRegisterTypeByName(VolkanoRegisterDialog.this.registerType)).isFile()) {
                    status = VolkanoRegisterDialog.validateInput(VolkanoRegisterDialog.this.key, type);
                    if (!status.isOK()) {
                        VolkanoRegisterDialog.this.lblStatus.setText(status.getMessage());
                    }
                } else {
                    status = VolkanoRegisterDialog.validateFileContent(VolkanoRegisterDialog.this.keyPath, type);
                    if (status.isOK()) {
                        try {
                            List<String> lines = Files.readAllLines(Paths.get(VolkanoRegisterDialog.this.keyPath, new String[0]));
                            VolkanoRegisterDialog.this.key = lines.get(0);
                        }
                        catch (IOException ex) {
                            status = new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", ex.getMessage(), (Throwable)ex);
                        }
                    }
                }
                if (!status.isOK()) {
                    VolkanoRegisterDialog.this.lblStatus.setText(status.getMessage());
                }
                if (VolkanoRegisterDialog.this.lblStatus.getText().isEmpty()) {
                    String uidPlusType = String.valueOf(VolkanoRegisterDialog.this.uid) + " + " + type.getServerSideName();
                    boolean isUidTypeUnique = VolkanoRegisterDialog.this.isUidTypeUnique(uidPlusType);
                    if (isUidTypeUnique) {
                        VolkanoRegisterDialog.this.isFinishPressed = true;
                        parent.close();
                    } else {
                        boolean readyToOverwriteExistingKey = MessageDialog.openConfirm((Shell)parent, (String)VolkanoUIMessage.Volkano_warning_dialog_title, (String)VolkanoUIMessage.Volkano_warning_uid_not_unique);
                        if (readyToOverwriteExistingKey) {
                            VolkanoRegisterDialog.this.isFinishPressed = true;
                            parent.close();
                        }
                    }
                }
            }
        });
        Button btnCancel = new Button(buttons, 8);
        btnCancel.setText("Cancel");
        btnCancel.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        btnCancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                parent.close();
            }
        });
        cmps.pack();
        parent.pack();
        this.fillConnectionTypes();
        this.setEnabledFileSelection(false);
    }

    private String[] getActiveConnections() {
        DebuggerConnectionAccessor accessor = DebuggerConnections.getDebuggerConnectionAccessorByConnectionName((String)this.selectedConnectionType.getConnectionName());
        this.activeConnections = (DeviceConnection[])accessor.getActiveDeviceConnections(this.selectedConnectionType).stream().toArray(DeviceConnection[]::new);
        return (String[])Arrays.stream(this.activeConnections).map(DeviceConnection::getDeviceUiFriendlyName).toArray(String[]::new);
    }

    public boolean isCancelled() {
        return !this.isFinishPressed;
    }

    public String getKey() {
        return this.key;
    }

    public String getPathToKey() {
        return this.keyPath;
    }

    public String getUid() {
        return this.uid;
    }

    private void executeConnectionCmd(String address) {
        block2: {
            final ProcessCheckingJob processCheckingJob = new ProcessCheckingJob("ProcessIsCancelledCheckingJob");
            ProgressMonitorDialog progress = new ProgressMonitorDialog(this.getParent()){

                protected void cancelPressed() {
                    processCheckingJob.cancel();
                }
            };
            try {
                progress.run(true, true, runnable -> {
                    block3: {
                        runnable.beginTask(VolkanoUIMessage.Volkano_gta_connection_msg, -1);
                        try {
                            String connectionString = DebuggerUtils.getConnectionStringForDeviceConnection((String)address);
                            String uid = VolkanoRegisterDialog.execGetSocInfo(connectionString, processCheckingJob);
                            if (uid != null && !uid.isEmpty()) {
                                Display.getDefault().syncExec(() -> this.textUid.setText(uid));
                            }
                        }
                        catch (CoreException exc) {
                            if (exc.getMessage() == null || processCheckingJob.getIsCancelled()) break block3;
                            Display.getDefault().syncExec(() -> this.lblStatus.setText(exc.getMessage()));
                        }
                    }
                });
            }
            catch (InterruptedException | InvocationTargetException exc) {
                if (exc.getMessage() == null) break block2;
                this.lblStatus.setText(exc.getMessage());
            }
        }
    }

    private static String execGetSocInfo(String connectionString, ProcessCheckingJob processCheckingJob) throws CoreException {
        BoardConnectionDescriptor operationResult;
        try {
            operationResult = S32DebuggerBackend.isBoardConnected((String)connectionString, (ProcessCheckingJob)processCheckingJob);
        }
        catch (IOException e) {
            Status status = new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", e.getMessage());
            throw new CoreException((IStatus)status);
        }
        if (operationResult == null) {
            Status status = new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", "Operation result is null");
            throw new CoreException((IStatus)status);
        }
        if (operationResult.getUId() == null) {
            Status status = new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", operationResult.getErrorMessage());
            throw new CoreException((IStatus)status);
        }
        return operationResult.getUId().substring(2);
    }

    public void fillConnectionTypes() {
        this.connections = DebuggerConnections.getDebuggerConnectionDeviceDescriptors((String)"s32debugger").stream().sorted((d1, d2) -> d1.getPriority() - d2.getPriority()).collect(Collectors.toList());
        String[] connectionNames = (String[])this.connections.stream().map(DebuggerConnectionDescriptor::getConnectionName).toArray(String[]::new);
        this.cmbConnections.setItems(connectionNames);
        if (this.cmbConnections.getItemCount() > 0) {
            this.cmbConnections.select(0);
            this.cmbConnections.notifyListeners(13, new Event());
        }
    }

    private static IStatus validateAddress(String address) {
        return VolkanoUtil.validateIPv4((String)address);
    }

    public String getRegisterType() {
        return this.registerType;
    }

    private void setEnabledFileSelection(boolean isEnable) {
        this.textKey.setEnabled(!isEnable);
        this.textFile.setEnabled(isEnable);
        this.textFile.setEditable(!isEnable);
        this.btnSelect.setEnabled(isEnable);
        if (isEnable) {
            this.btnSelect.setFocus();
        } else {
            this.textKey.setFocus();
        }
    }

    private static IStatus validateFileContent(String path, VolkanoTypes fileType) {
        if (path.isEmpty()) {
            return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_error_file_not_selected);
        }
        try {
            List<String> lines = Files.readAllLines(Paths.get(path, new String[0]));
            if (lines.isEmpty()) {
                return new Status(4, "com.nxp.s32ds.debug.ide.volkano.ui", VolkanoUIMessage.Volkano_error_key_file_empty);
            }
            return VolkanoRegisterDialog.validateInput(lines.get(0), fileType);
        }
        catch (IOException e) {
            return VolkanoActivator.getBundle().createError(NLS.bind((String)VolkanoUIMessage.Volkano_error_could_not_read_file, (Object)e.toString()));
        }
    }

    private static IStatus validateInput(String value, VolkanoTypes type) {
        return VolkanoUtil.validateInput((String)value, (int[])type.getValidLengths(), (String)type.getName());
    }

    private void validateFile() {
        IStatus status = VolkanoRegisterDialog.validateFileContent(this.textFile.getText(), VolkanoTypes.COMMON_FILE_INFO);
        if (status.isOK()) {
            this.lblStatus.setText("");
        } else {
            this.lblStatus.setText(status.getMessage());
        }
        this.btnFinish.setEnabled(status.isOK());
    }

    private static ControlDecoration createDecoration(StyledText parent) {
        ControlDecoration decorator = new ControlDecoration((Control)parent, 8);
        Image image = FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage();
        decorator.setImage(image);
        decorator.hide();
        return decorator;
    }

    private boolean isUidTypeUnique(String uidPlusType) {
        return this.registeredUidTypes.stream().noneMatch(item -> item.equalsIgnoreCase(uidPlusType));
    }

    private void resetCurrentState() {
        this.lblStatus.setText("");
        this.btnFinish.setEnabled(true);
    }
}

