/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.volkano.ui;

import com.nxp.s32ds.debug.ide.ui.SWTUtils;
import com.nxp.s32ds.debug.ide.volkano.internal.ui.VolkanoUIMessage;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class UpdatePasswordDialog
extends TitleAreaDialog {
    private static final int MAX_PASS_SIZE = 255;
    private static final char NULL_TERMINATOR_CHAR = '\u0000';
    private static final String PASSWORD_FORMAT = "^(?=.*[A-Za-z])(?=.*\\d)[A-Za-z\\d~!@#$%^&*]{6,}$";
    private static final char HIDDEN_CHAR_PLACEHOLDER = '\u25cf';
    private Button butOK;
    private Button butShowPassword;
    private Text passwordInput1Txt;
    private Text passwordInput2Txt;
    private Text confirmedPasswordTxt;
    private String passwordInput1Label = VolkanoUIMessage.Volkano_enter_current_password_message;
    private String passwordInput2Label = VolkanoUIMessage.Volkano_enter_new_password_message;
    private String confirmedPasswordLabel = VolkanoUIMessage.Volkano_label_confirm_password;
    private String passwordInput1 = "";
    private String passwordInput2 = "";
    private String confirmedPassword = "";
    private boolean resisableOnInit = true;
    private boolean forInitialPassword = false;

    public UpdatePasswordDialog(Shell parentShell) {
        super(parentShell);
    }

    public UpdatePasswordDialog(Shell parentShell, String passwordInput1Label, String passwordInput2Label, boolean forInitialPassword) {
        this(parentShell);
        this.passwordInput1Label = passwordInput1Label;
        this.passwordInput2Label = passwordInput2Label;
        this.forInitialPassword = forInitialPassword;
    }

    public void create() {
        super.create();
        this.setTitle(VolkanoUIMessage.Volkano_smartcard_update_password_message);
    }

    public Control createDialogArea(Composite parent) {
        Composite innerComposite = new Composite(parent, 2048);
        GridData horizontalFill = new GridData(4, 16, true, false);
        innerComposite.setLayoutData((Object)horizontalFill);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.horizontalSpacing = 5;
        gridLayout.verticalSpacing = 15;
        innerComposite.setLayout((Layout)gridLayout);
        SWTUtils.createLabel((Composite)innerComposite, (String)this.passwordInput1Label);
        this.passwordInput1Txt = SWTUtils.createWideText((Composite)innerComposite, (int)0x400804, (boolean)true, (int)1);
        this.passwordInput1Txt.setEditable(true);
        this.passwordInput1Txt.addModifyListener(listener -> this.validateInput());
        SWTUtils.createLabel((Composite)innerComposite, (String)this.passwordInput2Label);
        this.passwordInput2Txt = SWTUtils.createWideText((Composite)innerComposite, (int)0x400804, (boolean)true, (int)1);
        this.passwordInput2Txt.setEditable(true);
        this.passwordInput2Txt.addModifyListener(listener -> this.validateInput());
        if (!this.forInitialPassword) {
            SWTUtils.createLabel((Composite)innerComposite, (String)this.confirmedPasswordLabel);
            this.confirmedPasswordTxt = SWTUtils.createWideText((Composite)innerComposite, (int)0x400804, (boolean)true, (int)1);
            this.confirmedPasswordTxt.setEditable(true);
            this.confirmedPasswordTxt.addModifyListener(listener -> this.validateInput());
        } else {
            this.confirmedPasswordTxt = SWTUtils.createWideTextWithHeightHint((Composite)parent, (int)4, (boolean)false, (int)0, (int)0);
        }
        this.butShowPassword = SWTUtils.createButtonWithHorizontalSpan((Composite)innerComposite, (String)VolkanoUIMessage.Volkano_show_password_message, (int)32, (int)2);
        this.butShowPassword.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (UpdatePasswordDialog.this.butShowPassword.getSelection()) {
                    UpdatePasswordDialog.this.passwordInput1Txt.setEchoChar('\u0000');
                    UpdatePasswordDialog.this.passwordInput2Txt.setEchoChar('\u0000');
                    UpdatePasswordDialog.this.confirmedPasswordTxt.setEchoChar('\u0000');
                } else {
                    UpdatePasswordDialog.this.passwordInput1Txt.setEchoChar('\u25cf');
                    UpdatePasswordDialog.this.passwordInput2Txt.setEchoChar('\u25cf');
                    UpdatePasswordDialog.this.confirmedPasswordTxt.setEchoChar('\u25cf');
                }
            }
        });
        this.getShell().setText(VolkanoUIMessage.Volkano_smartcard_password_title);
        this.setHelpAvailable(false);
        this.setMessage(null);
        return innerComposite;
    }

    private void validateInput() {
        String passwordInput1Text = this.passwordInput1Txt.getText();
        String passwordInput2Text = this.passwordInput2Txt.getText();
        String confirmPasswordText = this.confirmedPasswordTxt.getText();
        if (this.butOK != null) {
            if (passwordInput1Text.isEmpty()) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_empty_input_fields);
            } else if (passwordInput1Text.length() > 255 || passwordInput2Text.length() > 255) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_password_too_long_message);
            } else if (this.forInitialPassword && !passwordInput1Text.matches(PASSWORD_FORMAT)) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_password_invalid_format_message);
            } else if (passwordInput2Text.isEmpty()) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_empty_input_fields);
            } else if (!this.forInitialPassword && !passwordInput2Text.matches(PASSWORD_FORMAT)) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_password_invalid_format_message);
            } else if (!this.forInitialPassword && confirmPasswordText.isEmpty()) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_empty_input_fields);
            } else if (this.forInitialPassword && !passwordInput1Text.equals(passwordInput2Text)) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_passwords_do_not_match);
            } else if (!this.forInitialPassword && !confirmPasswordText.equals(passwordInput2Text)) {
                this.butOK.setEnabled(false);
                this.setErrorMessage(VolkanoUIMessage.Volkano_passwords_do_not_match);
            } else {
                this.butOK.setEnabled(true);
                this.setErrorMessage(null);
            }
        }
    }

    protected boolean isResizable() {
        return this.resisableOnInit;
    }

    protected Control createButtonBar(Composite parent) {
        Control butBar = super.createButtonBar(parent);
        this.butOK = this.getButton(0);
        Point currentSize = super.getInitialSize();
        super.getShell().pack();
        Point newSize = super.getShell().getSize();
        super.getShell().setSize(currentSize.x, newSize.y);
        this.resisableOnInit = false;
        this.validateInput();
        return butBar;
    }

    protected void okPressed() {
        this.passwordInput1 = this.passwordInput1Txt.getText();
        this.passwordInput2 = this.passwordInput2Txt.getText();
        this.confirmedPassword = this.confirmedPasswordTxt.getText();
        super.okPressed();
    }

    public String getInput1() {
        return this.passwordInput1;
    }

    public String getInput2() {
        return this.passwordInput2;
    }

    public String getConfirmedPassword() {
        return this.confirmedPassword;
    }
}

