/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.debug.ide.volkano.internal.ui;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum VolkanoTypes {
    ADKP_VALUE("ADKP", "ADKP", new int[]{16, 32}, false),
    ADKP_WRAPPED_FILE("Wrapped ADKP from file", "ADKP", new int[]{256}, true),
    KUID_VALUE("Wrapped KUID", "kUID", new int[]{256}, false),
    KUID_FILE("Wrapped KUID from file", "kUID", new int[]{256}, true),
    SOC_UID("UID", new int[]{8, 16}, false),
    COMMON_FILE_INFO("File content", new int[]{256}, true);

    private String name;
    private String serverSideName;
    private int[] validLengths;
    private boolean isFile;
    private boolean isRegisterType;

    private VolkanoTypes(String fieldName, String serverSideName, int[] lengths, boolean isFile) {
        this(fieldName, lengths, isFile);
        this.serverSideName = serverSideName;
        this.isRegisterType = true;
    }

    private VolkanoTypes(String fieldName, int[] lengths, boolean isFile) {
        this.name = fieldName;
        this.validLengths = lengths;
        this.isFile = isFile;
    }

    public String getName() {
        return this.name;
    }

    public String getServerSideName() {
        return this.serverSideName;
    }

    public int[] getValidLengths() {
        return this.validLengths;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isRegisterType() {
        return this.isRegisterType;
    }

    public static List<String> getRegistrationTypes() {
        return Stream.of(VolkanoTypes.values()).filter(VolkanoTypes::isRegisterType).map(VolkanoTypes::getName).collect(Collectors.toList());
    }

    public static VolkanoTypes findRegisterTypeByName(String name) {
        return Stream.of(VolkanoTypes.values()).filter(type -> type.isRegisterType && type.getName().equalsIgnoreCase(name)).findFirst().orElse(null);
    }
}

