/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.internal.ui.wizards.examples;

import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.ext.rcp.jface.viewers.ContainerFilteredTree;
import com.nxp.s32ds.ext.rcp.registry.EntityDescriptor;
import com.nxp.s32ds.ext.rcp.utils.epl.viewers.ContainerFilteredCheckboxTreeViewer;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class HardwareTreeSelectionDialog
extends Dialog {
    private static final int Y_SIZE = 500;
    private static final int X_SIZE = 400;
    private Map<FamilyDescriptor, List<DeviceDescriptor>> familyToDevices;
    private List<CoreDescriptor> cores;
    private Set<EntityDescriptor> initialSelectedElements = new HashSet<EntityDescriptor>();
    private ContainerFilteredTree filteredTree;
    private List<DeviceDescriptor> initialSelections;
    private List<CoreDescriptor> coreSelections;
    private String text;

    public HardwareTreeSelectionDialog(Shell parentShell, Map<FamilyDescriptor, List<DeviceDescriptor>> familyToDevices, List<DeviceDescriptor> initialSelections, List<CoreDescriptor> coreSelections, List<CoreDescriptor> cores, String text) {
        super(parentShell);
        this.familyToDevices = familyToDevices;
        this.initialSelections = initialSelections;
        this.coreSelections = coreSelections;
        this.cores = cores;
        this.text = text;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.text);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        this.createFilteredTreeViewer(composite);
        return parent;
    }

    protected void initializeBounds() {
        super.initializeBounds();
        this.getShell().setSize(400, 500);
    }

    protected boolean isResizable() {
        return true;
    }

    private void createFilteredTreeViewer(Composite parent) {
        Button familyDevicesButton = new Button(parent, 16);
        familyDevicesButton.setText("Family-Device");
        familyDevicesButton.setSelection(true);
        Button coresButton = new Button(parent, 16);
        coresButton.setText("Cores");
        coresButton.setSelection(false);
        this.filteredTree = new ContainerFilteredTree(parent, 2048);
        final ContainerFilteredCheckboxTreeViewer treeViewer = this.filteredTree.getViewer();
        treeViewer.setContentProvider((IContentProvider)new HardwareSelectionContentProvider());
        treeViewer.setLabelProvider((IBaseLabelProvider)new HardwareSelectionLabelProvider());
        treeViewer.setInput((Object)this.familyToDevices.entrySet().toArray());
        treeViewer.setCheckedElements(this.initialSelections.toArray());
        familyDevicesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                treeViewer.setContentProvider((IContentProvider)new HardwareSelectionContentProvider());
                treeViewer.setLabelProvider((IBaseLabelProvider)new HardwareSelectionLabelProvider());
                treeViewer.setInput((Object)HardwareTreeSelectionDialog.this.familyToDevices.entrySet().toArray());
                treeViewer.setCheckedElements(HardwareTreeSelectionDialog.this.initialSelections.toArray());
            }
        });
        coresButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                treeViewer.setContentProvider((IContentProvider)new CoreSelectionContentProvider());
                treeViewer.setLabelProvider((IBaseLabelProvider)new HardwareSelectionLabelProvider());
                treeViewer.setInput((Object)HardwareTreeSelectionDialog.this.cores.toArray());
                treeViewer.setCheckedElements(HardwareTreeSelectionDialog.this.coreSelections.toArray());
            }
        });
    }

    public void setInitialElementSelections(List<DeviceDescriptor> devices) {
        this.initialSelectedElements.addAll(devices);
    }

    public List<DeviceDescriptor> getResult() {
        return Arrays.stream(this.filteredTree.getViewer().getCheckedElements()).filter(DeviceDescriptor.class::isInstance).map(DeviceDescriptor.class::cast).collect(Collectors.toList());
    }

    public List<CoreDescriptor> getResultCore() {
        return Arrays.stream(this.filteredTree.getViewer().getCheckedElements()).filter(CoreDescriptor.class::isInstance).map(CoreDescriptor.class::cast).collect(Collectors.toList());
    }

    private class CoreSelectionContentProvider
    implements ITreeContentProvider {
        private CoreSelectionContentProvider() {
        }

        public Object[] getElements(Object element) {
            return HardwareTreeSelectionDialog.this.cores.toArray();
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object[] getChildren(Object element) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }
    }

    private class HardwareSelectionContentProvider
    implements ITreeContentProvider {
        private HardwareSelectionContentProvider() {
        }

        public Object[] getChildren(Object element) {
            if (!(element instanceof FamilyDescriptor)) {
                return null;
            }
            FamilyDescriptor treeItem = (FamilyDescriptor)element;
            List<DeviceDescriptor> children = HardwareTreeSelectionDialog.this.familyToDevices.get(treeItem);
            return children == null ? null : children.toArray();
        }

        public Object[] getElements(Object element) {
            return HardwareTreeSelectionDialog.this.familyToDevices.keySet().toArray();
        }

        public Object getParent(Object element) {
            if (!(element instanceof DeviceDescriptor)) {
                return null;
            }
            DeviceDescriptor treeItem = (DeviceDescriptor)element;
            return HardwareTreeSelectionDialog.this.familyToDevices.entrySet().stream().filter(pair -> ((List)pair.getValue()).contains(treeItem)).map(Map.Entry::getKey).findFirst().orElse(null);
        }

        public boolean hasChildren(Object element) {
            Object[] children = this.getChildren(element);
            return children != null && children.length > 0;
        }
    }

    private static class HardwareSelectionLabelProvider
    extends ColumnLabelProvider {
        private HardwareSelectionLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof EntityDescriptor) {
                return ((EntityDescriptor)element).getName();
            }
            return "";
        }
    }
}

