/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.runtime.hardware.registry.core;

import com.nxp.s32ds.cle.runtime.hardware.internal.registry.core.HardwareRegistryCoreActivator;
import com.nxp.s32ds.cle.runtime.hardware.internal.registry.core.HardwareRegistryCoreMessages;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.BoardRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.CoreRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceCoreDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.DeviceRegistry;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyDeviceDescriptor;
import com.nxp.s32ds.cle.runtime.hardware.registry.FamilyRegistry;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class BoardDescriptors {
    public static BoardRegistry getBoardRegistry() {
        BoardRegistry boardRegistry = HardwareRegistryCoreActivator.getDefault().getBoardRegistry();
        return boardRegistry;
    }

    public static List<BoardDescriptor> getBoardDescriptors() {
        BoardRegistry boardRegistry = HardwareRegistryCoreActivator.getDefault().getBoardRegistry();
        return boardRegistry.getBoardDescriptors();
    }

    public static BoardDescriptor getBoardDescriptor(String boardId) {
        BoardRegistry boardRegistry = HardwareRegistryCoreActivator.getDefault().getBoardRegistry();
        return boardRegistry.getBoardDescriptor(boardId);
    }

    public static List<CoreDescriptor> getCoreDescriptors(String boardId) {
        BoardRegistry boardRegistry = HardwareRegistryCoreActivator.getDefault().getBoardRegistry();
        ArrayList<CoreDescriptor> result = new ArrayList<CoreDescriptor>();
        List boardDevices = boardRegistry.getBoardDeviceDescriptorsByBoardId(boardId);
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        HashSet<String> coreIds = new HashSet<String>();
        for (BoardDeviceDescriptor boardDevice : boardDevices) {
            String deviceId = boardDevice.getDeviceId();
            List deviceCoreDescriptors = deviceRegistry.getDeviceCoreDescriptorsByDeviceId(deviceId);
            for (DeviceCoreDescriptor deviceCoreDescriptor : deviceCoreDescriptors) {
                String coreId = deviceCoreDescriptor.getCoreId();
                coreIds.add(coreId);
            }
        }
        CoreRegistry coreRegistry = HardwareRegistryCoreActivator.getDefault().getCoreRegistry();
        for (String coreId : coreIds) {
            CoreDescriptor coreDescriptor = coreRegistry.getCoreDescriptor(coreId);
            if (coreDescriptor == null) continue;
            result.add(coreDescriptor);
        }
        return result;
    }

    public static List<DeviceDescriptor> getDeviceDescriptors(String boardId) {
        BoardRegistry boardRegistry = HardwareRegistryCoreActivator.getDefault().getBoardRegistry();
        List boardDevices = boardRegistry.getBoardDeviceDescriptorsByBoardId(boardId);
        DeviceRegistry deviceRegistry = HardwareRegistryCoreActivator.getDefault().getDeviceRegistry();
        ArrayList<DeviceDescriptor> result = new ArrayList<DeviceDescriptor>();
        for (BoardDeviceDescriptor boardDevice : boardDevices) {
            DeviceDescriptor deviceDescriptor = deviceRegistry.getDeviceDescriptor(boardDevice.getDeviceId());
            if (deviceDescriptor == null) continue;
            result.add(deviceDescriptor);
        }
        return result;
    }

    public static List<FamilyDescriptor> getFamilyDescriptors(String boardId) {
        BoardRegistry boardRegistry = HardwareRegistryCoreActivator.getDefault().getBoardRegistry();
        List boardDevices = boardRegistry.getBoardDeviceDescriptorsByBoardId(boardId);
        LinkedHashSet<String> deviceIds = new LinkedHashSet<String>();
        for (BoardDeviceDescriptor boardDeviceDescriptor : boardDevices) {
            deviceIds.add(boardDeviceDescriptor.getDeviceId());
        }
        FamilyRegistry familyRegistry = HardwareRegistryCoreActivator.getDefault().getFamilyRegistry();
        ArrayList familyDevices = new ArrayList();
        for (String deviceId : deviceIds) {
            familyDevices.addAll(familyRegistry.getFamilyDeviceDescriptorsByDeviceId(deviceId));
        }
        LinkedHashSet<String> familyIds = new LinkedHashSet<String>();
        for (FamilyDeviceDescriptor familyDeviceDescriptor : familyDevices) {
            familyIds.add(familyDeviceDescriptor.getFamilyId());
        }
        ArrayList<FamilyDescriptor> familyDescriptors = new ArrayList<FamilyDescriptor>();
        for (String familyId : familyIds) {
            FamilyDescriptor familyDescriptor = familyRegistry.getFamilyDescriptor(familyId);
            if (familyDescriptor == null) continue;
            familyDescriptors.add(familyDescriptor);
        }
        return familyDescriptors;
    }

    public static String getBoardLabel(BoardDescriptor boardDescriptor) {
        if (boardDescriptor == null) {
            return null;
        }
        List<FamilyDescriptor> familyDescriptors = BoardDescriptors.getFamilyDescriptors(boardDescriptor.getId());
        if (familyDescriptors.size() == 1) {
            FamilyDescriptor familyDescriptor = familyDescriptors.get(0);
            String label = NLS.bind((String)HardwareRegistryCoreMessages.BoardDescriptors_family_board_label, (Object)familyDescriptor.getName(), (Object)boardDescriptor.getName());
            return label;
        }
        return boardDescriptor.getName();
    }
}

