/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.rcp.collateral.core.internal;

import com.nxp.s32ds.rcp.collateral.CollateralFeature;
import com.nxp.s32ds.rcp.collateral.CollateralPack;
import com.nxp.s32ds.rcp.collateral.CollateralResource;
import com.nxp.s32ds.rcp.collateral.CollateralResourceType;
import com.nxp.s32ds.rcp.collateral.CollateralTag;
import com.nxp.s32ds.rcp.collateral.core.CollateralFactory;
import com.nxp.s32ds.rcp.collateral.core.internal.CollateralMaterialsActivator;
import com.nxp.s32ds.rcp.collateral.core.internal.CollatorRegistryCompiler;
import com.nxp.s32ds.rcp.collateral.core.internal.Messages;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;

public class CollateralRegistryLoader {
    private CollateralFactory collateralFactory = CollateralFactory.INSTANCE;

    public void loadTags(IExtension[] tagExtensions, CollatorRegistryCompiler collatorModelCompiler) {
        if (collatorModelCompiler == null) {
            return;
        }
        this.loadTagExtensions(tagExtensions, collatorModelCompiler.getTags());
    }

    public void loadPacks(IExtension[] pakExtensions, CollatorRegistryCompiler collatorModelCompiler) {
        if (collatorModelCompiler == null) {
            return;
        }
        this.loadPaksExtensions(pakExtensions, collatorModelCompiler.getPacks(), collatorModelCompiler.getPackIdToFeatureIds());
    }

    public void loadFeatures(IExtension[] featureExtensions, CollatorRegistryCompiler collatorModelCompiler) {
        if (collatorModelCompiler == null) {
            return;
        }
        this.loadFeatureExtensions(featureExtensions, collatorModelCompiler.getFeatures(), collatorModelCompiler.getFeatureIdToResoursesId());
    }

    public void loadResources(IExtension[] resourcesExtensions, CollatorRegistryCompiler collatorModelCompiler) {
        if (collatorModelCompiler == null) {
            return;
        }
        this.loadResourceExtensions(resourcesExtensions, collatorModelCompiler.getResources(), collatorModelCompiler.getResourceTypesIdToResourceTypes(), collatorModelCompiler.getResourceToResourseTypeId(), collatorModelCompiler.getResourceIdToTagId());
    }

    private void loadPaksExtensions(IExtension[] pakExtensions, Collection<CollateralPack> collateralPacks, Map<String, Collection<String>> packIdToFeatureIds) {
        if (pakExtensions == null || pakExtensions.length == 0) {
            return;
        }
        IExtension[] iExtensionArray = pakExtensions;
        int n = pakExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n4];
                if ("pack".equals(configurationElement.getName())) {
                    this.createPack(collateralPacks, configurationElement);
                } else if ("packFeature".equals(configurationElement.getName())) {
                    this.createPackReferenceToFeature(packIdToFeatureIds, configurationElement);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createPackReferenceToFeature(Map<String, Collection<String>> packIdToFeatureIds, IConfigurationElement el) {
        ArrayList<String> referenceResourceIds = new ArrayList<String>();
        String faetureId = el.getAttribute("packId");
        IConfigurationElement[] iConfigurationElementArray = el.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("featureReference".equals(element.getName())) {
                referenceResourceIds.add(element.getAttribute("featureId"));
            }
            ++n2;
        }
        packIdToFeatureIds.put(faetureId, referenceResourceIds);
    }

    private void createPack(Collection<CollateralPack> collateralPacks, IConfigurationElement configurationElement) {
        String id = configurationElement.getAttribute("id");
        if (id == null) {
            CollateralMaterialsActivator.getDefault().logError(Messages.bind((String)Messages.CollateralRegistryImplementation_IdForCollateralObjectCannotBeNull, (Object)"pack"));
            return;
        }
        CollateralPack collateralPackImplementation = this.collateralFactory.createPack(id, configurationElement.getAttribute("name"), configurationElement.getAttribute("description"), configurationElement.getAttribute("image"));
        collateralPacks.add(collateralPackImplementation);
    }

    private void loadResourceExtensions(IExtension[] resourcesExtensions, Map<String, CollateralResource> resourcesIdToResource, Map<String, CollateralResourceType> resourceTypesIdToResourceTypes, Map<String, String> ResourseIdToResourceTypeId, Map<String, Collection<String>> resourceIdToTagId) {
        if (resourcesExtensions == null || resourcesExtensions.length == 0) {
            return;
        }
        IExtension[] iExtensionArray = resourcesExtensions;
        int n = resourcesExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if ("resource".equals(el.getName())) {
                    this.createResource(resourcesIdToResource, el, ResourseIdToResourceTypeId);
                } else if ("resourceType".equals(el.getName())) {
                    this.createResourceType(resourceTypesIdToResourceTypes, el);
                } else if ("resourceTag".equals(el.getName())) {
                    this.loadTagsLinkToResource(resourceIdToTagId, el);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void loadTagsLinkToResource(Map<String, Collection<String>> resourceIdToTagId, IConfigurationElement el) {
        String resourseId = el.getAttribute("resourceId");
        ArrayList<String> tagsId = new ArrayList<String>();
        IConfigurationElement[] iConfigurationElementArray = el.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("tagReference".equals(element.getName())) {
                tagsId.add(element.getAttribute("tagId"));
            }
            ++n2;
        }
        resourceIdToTagId.put(resourseId, tagsId);
    }

    private void createResourceType(Map<String, CollateralResourceType> resourceTypesIdToResourceTypes, IConfigurationElement configurationElement) {
        String id = configurationElement.getAttribute("id");
        if (id == null) {
            CollateralMaterialsActivator.getDefault().logError(Messages.bind((String)Messages.CollateralRegistryImplementation_IdForCollateralObjectCannotBeNull, (Object)"resourceType"));
            return;
        }
        CollateralResourceType collateralResourceImplementation = this.collateralFactory.createResourceType(id, configurationElement.getAttribute("name"), configurationElement.getAttribute("description"), configurationElement.getAttribute("image"));
        resourceTypesIdToResourceTypes.put(collateralResourceImplementation.getId(), collateralResourceImplementation);
    }

    private void createResource(Map<String, CollateralResource> resourcesIdToResource, IConfigurationElement configurationElement, Map<String, String> resourseIdToResourceTypeId) {
        String id = configurationElement.getAttribute("id");
        if (id == null) {
            CollateralMaterialsActivator.getDefault().logError(Messages.bind((String)Messages.CollateralRegistryImplementation_IdForCollateralObjectCannotBeNull, (Object)"resource"));
            return;
        }
        CollateralResource collateralResourceImplementation = this.collateralFactory.createResource(id, configurationElement.getAttribute("name"), configurationElement.getAttribute("description"), configurationElement.getAttribute("urlLink"), configurationElement.getAttribute("image"));
        resourcesIdToResource.put(collateralResourceImplementation.getId(), collateralResourceImplementation);
        resourseIdToResourceTypeId.put(collateralResourceImplementation.getId(), configurationElement.getAttribute("referenceResourceType"));
    }

    private void loadTagExtensions(IExtension[] tagExtensions, Map<String, CollateralTag> tagIdToTags) {
        if (tagExtensions == null || tagExtensions.length == 0) {
            return;
        }
        IExtension[] iExtensionArray = tagExtensions;
        int n = tagExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if ("tag".equals(el.getName())) {
                    this.createTag(tagIdToTags, el);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createTag(Map<String, CollateralTag> tagIdToTags, IConfigurationElement configurationElement) {
        String id = configurationElement.getAttribute("id");
        if (id == null) {
            CollateralMaterialsActivator.getDefault().logError(Messages.bind((String)Messages.CollateralRegistryImplementation_IdForCollateralObjectCannotBeNull, (Object)"tag"));
            return;
        }
        CollateralTag collateralTagImplementation = this.collateralFactory.createTag(id, configurationElement.getAttribute("name"), configurationElement.getAttribute("description"), configurationElement.getAttribute("image"));
        tagIdToTags.put(collateralTagImplementation.getId(), collateralTagImplementation);
    }

    private void loadFeatureExtensions(IExtension[] featureExtensions, Map<String, CollateralFeature> featureIdTofeature, Map<String, Collection<String>> fFeatureIdToResoursesId) {
        if (featureExtensions == null || featureExtensions.length == 0) {
            return;
        }
        IExtension[] iExtensionArray = featureExtensions;
        int n = featureExtensions.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = extension.getConfigurationElements();
            int n3 = iConfigurationElementArray.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement el = iConfigurationElementArray[n4];
                if ("feature".equals(el.getName())) {
                    this.createCollateralFeature(featureIdTofeature, el);
                } else if ("featureResource".equals(el.getName())) {
                    this.createCollateralFeatureLinkToCollateralResource(el, fFeatureIdToResoursesId);
                }
                ++n4;
            }
            ++n2;
        }
    }

    private void createCollateralFeatureLinkToCollateralResource(IConfigurationElement el, Map<String, Collection<String>> fFeatureIdToResoursesId) {
        ArrayList<String> referenceResourceIds = new ArrayList<String>();
        String faetureId = el.getAttribute("featureId");
        IConfigurationElement[] iConfigurationElementArray = el.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if ("resourceReference".equals(element.getName())) {
                referenceResourceIds.add(element.getAttribute("resourceId"));
            }
            ++n2;
        }
        fFeatureIdToResoursesId.put(faetureId, referenceResourceIds);
    }

    private void createCollateralFeature(Map<String, CollateralFeature> featureIdTofeature, IConfigurationElement el) {
        String id = el.getAttribute("id");
        if (id == null) {
            CollateralMaterialsActivator.getDefault().logError(Messages.bind((String)Messages.CollateralRegistryImplementation_IdForCollateralObjectCannotBeNull, (Object)"feature"));
            return;
        }
        CollateralFeature collateralFeatureImplementation = this.collateralFactory.createFeature(id, el.getAttribute("name"), el.getAttribute("description"), el.getAttribute("image"));
        featureIdTofeature.put(collateralFeatureImplementation.getId(), collateralFeatureImplementation);
    }
}

