/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.ui.utils.swt.UtilsImage;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Transform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class UIResourceManager {
    protected static final Logger LOGGER = LogManager.getLogger(UIResourceManager.class);
    public static final String SELECT_CUSTOM = "platform:/plugin/org.eclipse.ui.ide/icons/full/obj16/incomplete_tsk.png";
    public static final String TABLE = "platform:/plugin/org.eclipse.ui/icons/full/eview16/prop_ps.png";
    public static final String FOLDER = "platform:/plugin/org.eclipse.ui/icons/full/obj16/fldr_obj.png";
    public static final String VALIDATION_FAILURE_HINT = "platform:/plugin/org.eclipse.ui/icons/full/obj16/info_tsk.png";
    public static final String PAUSE_TASK = "platform:/plugin/org.eclipse.ui.navigator/icons/full/clcl16/pause.png";
    public static final String START_TASK = "platform:/plugin/org.eclipse.ui.cheatsheets/icons/elcl16/start_task.png";
    public static final String FIND_TASK = "platform:/plugin/org.eclipse.ui.ide/icons/full/etool16/search_src.png";
    static final String[] IMAGES = new String[]{"platform:/plugin/org.eclipse.ui.ide/icons/full/obj16/incomplete_tsk.png", "platform:/plugin/org.eclipse.ui/icons/full/eview16/prop_ps.png", "platform:/plugin/org.eclipse.ui/icons/full/obj16/fldr_obj.png", "platform:/plugin/org.eclipse.ui/icons/full/obj16/info_tsk.png", "platform:/plugin/org.eclipse.ui.navigator/icons/full/clcl16/pause.png", "platform:/plugin/org.eclipse.ui.cheatsheets/icons/elcl16/start_task.png", "platform:/plugin/org.eclipse.ui.ide/icons/full/etool16/search_src.png"};
    public static final String DEFAULT_IMAGE_DIR = "images";
    public static final String ERROR_STATE = "errorstate.gif";
    public static final String CONN_NOT_VALID = "link-broken.png";
    public static final String CONN_VALID = "link.png";
    public static final String CONN_PROGRESS = "progress.gif";
    public static final String TEST_PASS = "ok.png";
    public static final String TEST_FAIL = "fail.png";
    public static final String TEST_RUNNING = "running.png";
    public static final String NEW_CONNECTION = "new.gif";
    public static final String EDIT_CONNECTION = "edit.png";
    public static final String DELETE_CONNECTION = "remove.png";
    public static final String TARGET_CHECK_CONNECT = "lrun_obj.png";
    public static final String TARGET_DISCONNECT = "terminatedlaunch_obj.png";
    public static final String ADD_USER_TEST = "add-icon.gif";
    public static final String USER_ADDED_TEST = "addedByUser.png";
    public static final String STOP_TASK = "nav_stop.gif";
    public static final String MBOARD = "motherboard.png";
    public static final String SCENARIO = "datasheetx_s.gif";
    public static final String SELECT_ALL = "24p_select_all.png";
    public static final String INVERT = "24p_select_invert.png";
    public static final String ERROR_COLORING = "24p_error_coloring.png";
    public static final String ERROR = "errorstate.gif";
    public static final String WARNING = "warning.gif";
    public static final String RESET_CONFIG = "reset.gif";
    public static final String AUTO_REPORT = "autoreport.png";
    public static final String REPORT = "report.png";
    public static final String SNAPSHOT_DDRV = "ddrv.png";
    public static final String SWITCH_CC = "switch_cc.png";
    static final String[] CUSTOM_IMAGES = new String[]{"errorstate.gif", "link-broken.png", "link.png", "progress.gif", "ok.png", "fail.png", "running.png", "new.gif", "edit.png", "remove.png", "lrun_obj.png", "terminatedlaunch_obj.png", "add-icon.gif", "addedByUser.png", "nav_stop.gif", "motherboard.png", "datasheetx_s.gif", "24p_select_all.png", "24p_select_invert.png", "24p_error_coloring.png", "errorstate.gif", "warning.gif", "reset.gif", "autoreport.png", "ddrv.png", "report.png"};
    private Map<ColorId, Color> colorMap = new EnumMap<ColorId, Color>(ColorId.class);
    private Map<String, // Could not load outer class - annotation placement on inner may be incorrect
    CollectionsUtils.Pair<@NonNull Boolean, @NonNull Image>> imageMap = new HashMap<String, CollectionsUtils.Pair<Boolean, Image>>();
    @Nullable
    private Transform transform;
    @Nullable
    private Color color;
    @Nullable
    private Color color2;

    public UIResourceManager() {
        this.allocateDefaultResources();
    }

    private void allocateDefaultResources() {
        ColorId imageName;
        Object[] objectArray = ColorId.values();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColorId cid = objectArray[n2];
            this.color2 = new Color((Device)Display.getDefault(), cid.red(), cid.green(), cid.blue());
            this.colorMap.put(cid, this.color2);
            ++n2;
        }
        objectArray = CUSTOM_IMAGES;
        n = CUSTOM_IMAGES.length;
        n2 = 0;
        while (n2 < n) {
            Image image;
            imageName = objectArray[n2];
            String pluginImagePath = DEFAULT_IMAGE_DIR + File.separator + (String)((Object)imageName);
            ImageDescriptor imageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"com.nxp.swtools.mem.validation", (String)pluginImagePath);
            if (imageDescriptor != null && (image = imageDescriptor.createImage()) != null) {
                this.imageMap.put((String)((Object)imageName), (CollectionsUtils.Pair<Boolean, Image>)new CollectionsUtils.Pair((Object)Boolean.TRUE, (Object)image));
            }
            ++n2;
        }
        objectArray = IMAGES;
        n = IMAGES.length;
        n2 = 0;
        while (n2 < n) {
            imageName = objectArray[n2];
            URL url = null;
            try {
                url = new URL((String)((Object)imageName));
                Image image = UtilsImage.getImage((URL)url);
                if (image != null) {
                    this.imageMap.put((String)((Object)imageName), (CollectionsUtils.Pair<Boolean, Image>)new CollectionsUtils.Pair((Object)Boolean.FALSE, (Object)image));
                }
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.SEVERE, "Failed to load import image", e);
            }
            assert (url != null);
            ++n2;
        }
        this.transform = new Transform((Device)Display.getDefault());
    }

    public void dispose() {
        ColorId[] colorIdArray = ColorId.values();
        int n = colorIdArray.length;
        int n2 = 0;
        while (n2 < n) {
            ColorId cid = colorIdArray[n2];
            this.color = this.colorMap.get((Object)cid);
            if (this.color != null) {
                this.color.dispose();
            }
            ++n2;
        }
        this.colorMap.clear();
        for (CollectionsUtils.Pair<Boolean, Image> imagePair : this.imageMap.values()) {
            Image image;
            Boolean isCustom = (Boolean)imagePair.getFirst();
            if (!isCustom.booleanValue() || (image = (Image)imagePair.getSecond()).isDisposed()) continue;
            image.dispose();
        }
        this.imageMap.clear();
        if (this.transform != null) {
            this.transform.dispose();
            this.transform = null;
        }
    }

    public @Nullable Color getColor(ColorId colorId) {
        return this.colorMap.get((Object)colorId);
    }

    public @Nullable Image getImage(String imageFile) {
        CollectionsUtils.Pair<Boolean, Image> imagePair = this.imageMap.get(imageFile);
        if (imagePair != null) {
            return (Image)imagePair.getSecond();
        }
        return null;
    }

    public @Nullable Transform getTransform() {
        return this.transform;
    }

    public static enum ColorId {
        DARK_GRAY(127, 127, 127),
        LIGHT_GRAY(200, 200, 200),
        LIGHT_BLUE(136, 238, 255),
        DARK_GREEN(133, 168, 86),
        LIGHT_RED(255, 70, 70),
        CELL_TEST_FAILED(255, 255, 0),
        CELL_CONFIGURATION_ERROR(249, 173, 111),
        CELL_TARGET_ERROR(255, 90, 80),
        CELL_STABLE(198, 239, 206),
        CELL_SELECTED(85, 255, 0);

        private final int red;
        private final int green;
        private final int blue;

        private ColorId(int red, int green, int blue) {
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        public int blue() {
            return this.blue;
        }

        public int green() {
            return this.green;
        }

        public int red() {
            return this.red;
        }
    }
}

