/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.model.DiagsEyeResultHandler;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsChartsFigure;
import com.nxp.swtools.mem.validation.model.presenter.VDiagsPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VScenarioPresentation;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.IChartView;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Objects;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.nebula.visualization.widgets.datadefinition.ColorMap;
import org.eclipse.nebula.visualization.widgets.figures.IntensityGraphFigure;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class DiagsView
implements IChartView {
    private static final int DataWidth = 35;
    private static final int DataHeight = 75;
    private int numGraphs = 0;
    private int numColumns;
    private int numRows;
    @Nullable
    private ScrolledComposite graphScrolledPanel;
    @Nullable
    private Font axisFont = null;
    @Nullable
    private Canvas graphCanvas;
    @Nullable
    private PaintListener paintListener;
    @Nullable
    private IntensityGraphFigure[] intensityGraphs = new IntensityGraphFigure[0];
    @Nullable
    private VStagePresentation selectedStage;
    @Nullable
    private Label[] intensityGraphsLabels = new Label[0];
    @Nullable
    private Label[] goldenGraphsLabels = new Label[0];

    @Override
    public @Nullable Canvas createChart(CTabFolder scenTabFolder, @Nullable CTabItem diagsTab) {
        CTabItem diagsTabLoc;
        Canvas crtGraphCanvas;
        this.numGraphs = this.readNumGraphs();
        ScrolledComposite crtGraphScrolledPanel = this.graphScrolledPanel;
        if (crtGraphScrolledPanel != null) {
            crtGraphScrolledPanel.setExpandHorizontal(true);
            crtGraphScrolledPanel.setExpandVertical(true);
        }
        if ((crtGraphCanvas = this.graphCanvas) != null) {
            crtGraphCanvas.setData((Object)Messages.VScenarioView_diagsTabName);
            crtGraphCanvas.setLayout((Layout)new GridLayout(this.numColumns == 0 ? 1 : this.numColumns, true));
            if (this.paintListener != null) {
                crtGraphCanvas.addPaintListener(this.paintListener);
            }
            if (this.numGraphs == 0) {
                this.createStatusLabel(crtGraphCanvas);
            }
        }
        this.intensityGraphs = new IntensityGraphFigure[this.numGraphs];
        this.intensityGraphsLabels = new Label[this.numGraphs];
        this.goldenGraphsLabels = new Label[this.numGraphs];
        int row = 0;
        while (row < this.numRows) {
            int col = 0;
            while (col < this.numColumns) {
                Canvas graphs = new Canvas((Composite)this.graphCanvas, 0);
                GridData layoutData = new GridData(4, 4, true, true);
                graphs.setLayoutData((Object)layoutData);
                graphs.setLayout((Layout)new GridLayout(2, true));
                Label goldenCLabel = new Label((Composite)graphs, 65);
                goldenCLabel.setText(Messages.VScenarioView_defaultGoldenCoord);
                layoutData = new GridData(16384, 128, true, true);
                layoutData.horizontalIndent = 46;
                layoutData.grabExcessHorizontalSpace = true;
                goldenCLabel.setLayoutData((Object)layoutData);
                goldenCLabel.setVisible(true);
                goldenCLabel.pack();
                Label label = new Label((Composite)graphs, 1);
                label.setText(Messages.VScenarioView_defaultDQ);
                layoutData = new GridData(0x1000008, 128, true, true);
                layoutData.verticalAlignment = 128;
                layoutData.horizontalAlignment = 0x1000008;
                label.setLayoutData((Object)layoutData);
                label.setVisible(true);
                IntensityGraphFigure intensityGraph = new IntensityGraphFigure();
                intensityGraph.setMax(255.0);
                intensityGraph.setMin(0.0);
                intensityGraph.setDataHeight(75);
                intensityGraph.setDataWidth(35);
                ColorMap colorMap = new ColorMap();
                LinkedHashMap<Double, RGB> colorMapHash = new LinkedHashMap<Double, RGB>();
                colorMapHash.put(0.0, new RGB(120, 239, 206));
                colorMapHash.put(255.0, new RGB(255, 255, 150));
                colorMap.setColorMap(colorMapHash);
                colorMap.setInterpolate(true);
                intensityGraph.setColorMap(colorMap);
                FontData[] axisFontData = intensityGraph.getXAxis().getTitleFont().getFontData();
                axisFontData[0].setHeight(8);
                axisFontData[0].setStyle(0);
                Composite compositeParent = scenTabFolder.getParent();
                if (compositeParent != null && this.axisFont == null) {
                    this.axisFont = new Font((Device)compositeParent.getDisplay(), axisFontData);
                }
                intensityGraph.getXAxis().setTitle(Messages.VScenarioView_horizontalLabel);
                intensityGraph.getXAxis().setTitleFont(this.axisFont);
                intensityGraph.getXAxis().setRange(0.0, 35.0, true);
                intensityGraph.getYAxis().setTitle(Messages.VScenarioView_verticalLabel);
                intensityGraph.getYAxis().setTitleFont(this.axisFont);
                intensityGraph.getYAxis().setRange(0.0, 1.2, true);
                intensityGraph.setShowRamp(false);
                this.intensityGraphs[row * this.numColumns + col] = intensityGraph;
                this.intensityGraphsLabels[row * this.numColumns + col] = label;
                this.goldenGraphsLabels[row * this.numColumns + col] = goldenCLabel;
                GC gc = new GC((Drawable)graphs);
                graphs.addDisposeListener(e -> {
                    intensityGraph.dispose();
                    gc.dispose();
                });
                LightweightSystem lws = new LightweightSystem(graphs);
                lws.setContents((IFigure)intensityGraph);
                ++col;
            }
            ++row;
        }
        float cellSizeRatio = 1.5f;
        int cellMinHeight = 200;
        int cellMinWidth = (int)((float)cellMinHeight * cellSizeRatio);
        int panelNumColumns = this.numColumns == 0 ? 1 : this.numColumns;
        int panelNumRows = this.numRows == 0 ? 1 : this.numRows;
        int panelMinHeight = panelNumRows * cellMinHeight;
        int numPaddingPanels = panelNumRows;
        if (this.numGraphs > 1) {
            @NonNull CTabFolder crtTab = Objects.requireNonNull(scenTabFolder);
            Point tabSize = crtTab.getSize();
            if (panelMinHeight < tabSize.y) {
                numPaddingPanels = tabSize.y / cellMinHeight + (tabSize.y % cellMinHeight > 0 ? 1 : 0) - panelNumRows;
            }
            int i = 0;
            while (i < numPaddingPanels) {
                Canvas canvasLoc = new Canvas((Composite)this.graphCanvas, 0);
                canvasLoc.setLayoutData((Object)new GridData(4, 4, true, true, panelNumColumns, 1));
                ++i;
            }
        }
        if (crtGraphScrolledPanel != null) {
            crtGraphScrolledPanel.setContent((Control)this.graphCanvas);
            crtGraphScrolledPanel.setMinSize(panelNumColumns * cellMinWidth, (panelNumRows + numPaddingPanels) * cellMinHeight);
            crtGraphScrolledPanel.getVerticalBar().setIncrement(crtGraphScrolledPanel.getVerticalBar().getIncrement() * 6);
            crtGraphScrolledPanel.setDragDetect(true);
        }
        if ((diagsTabLoc = diagsTab) != null && !diagsTabLoc.isDisposed()) {
            diagsTabLoc.setControl((Control)this.graphScrolledPanel);
        }
        return this.graphCanvas;
    }

    private int readNumGraphs() {
        VDiagsPresentation diagsScenario;
        VDiagsChartsFigure diagsFigure;
        VScenarioPresentation scenario;
        this.numGraphs = 0;
        VStagePresentation stage = this.selectedStage;
        if (stage != null && (scenario = stage.getSelectedScenario()) instanceof VDiagsPresentation && (diagsFigure = (diagsScenario = (VDiagsPresentation)scenario).getChartAt()) != null) {
            this.numGraphs = diagsFigure.getNoEyeTables();
        }
        switch (this.numGraphs) {
            case 72: {
                this.numColumns = 8;
                this.numRows = 9;
                break;
            }
            case 64: {
                this.numColumns = 8;
                this.numRows = 8;
                break;
            }
            case 32: {
                this.numColumns = 8;
                this.numRows = 4;
                break;
            }
            case 16: {
                this.numColumns = 8;
                this.numRows = 2;
                break;
            }
            case 9: {
                this.numColumns = 9;
                this.numRows = 1;
                break;
            }
            case 8: {
                this.numRows = 1;
                this.numColumns = 8;
                break;
            }
            case 4: {
                this.numRows = 1;
                this.numColumns = 4;
                break;
            }
            case 1: {
                this.numRows = 1;
                this.numColumns = 1;
                break;
            }
            case 2: {
                this.numRows = 2;
                this.numColumns = 1;
                break;
            }
            default: {
                this.numColumns = 0;
                this.numRows = 0;
            }
        }
        return this.numGraphs;
    }

    private void createStatusLabel(Canvas graphCanvas2) {
        VParamVariation cell;
        VTable table;
        GridData layoutData = new GridData(64, 64, true, true);
        graphCanvas2.setLayoutData((Object)layoutData);
        graphCanvas2.setLayout((Layout)new GridLayout(1, true));
        VStagePresentation stage = this.selectedStage;
        if (stage != null && (table = stage.getSelectedScenarioTable()) != null && (cell = table.getParamVariation(new Point(0, 0))) != null) {
            ArrayList<DiagsEyeResultHandler.EyeTable> dqTables = cell.getDqTables();
            if (dqTables != null) {
                this.numGraphs = dqTables.size();
            }
            VRunResult runResult = cell.getResult(0);
            layoutData = new GridData(64, 64, true, true);
            layoutData.verticalAlignment = 128;
            layoutData.horizontalAlignment = 1;
            if (runResult != null && runResult.getType() == VRunResult.ResultType.FAILED) {
                Text label = new Text((Composite)graphCanvas2, 515);
                label.setText(runResult.getErrorMessage());
                label.setLayoutData((Object)layoutData);
                label.setVisible(true);
            } else if (table.getState() == VTable.TableState.RUNNING) {
                Label label = new Label((Composite)graphCanvas2, 1);
                label.setText(Messages.DiagTestCollectingData);
                label.setLayoutData((Object)layoutData);
                label.setVisible(true);
            } else {
                Label label = new Label((Composite)graphCanvas2, 1);
                label.setText(Messages.DiagTestNoData);
                label.setLayoutData((Object)layoutData);
                label.setVisible(true);
            }
        }
    }

    @Override
    public @Nullable Canvas setInput(VStagePresentation selectedStage, CTabFolder scenTabFolder, CTabItem diagsTab) {
        VDiagsPresentation diagScenario;
        VDiagsChartsFigure diagsTabFigure;
        this.selectedStage = selectedStage;
        this.graphCanvas = this.createChart(scenTabFolder, diagsTab);
        VScenarioPresentation scenario = selectedStage.getSelectedScenario();
        if (scenario instanceof VDiagsPresentation && (diagsTabFigure = (diagScenario = (VDiagsPresentation)scenario).getChartAt()) != null) {
            diagsTabFigure.updateDiagsInfo(this.intensityGraphs, this.intensityGraphsLabels, this.goldenGraphsLabels);
            if (this.graphCanvas != null) {
                this.graphCanvas.redraw();
            }
        }
        return this.graphCanvas;
    }

    @Override
    public void setScenarioPaintListener(PaintListener paintListener) {
        this.paintListener = paintListener;
    }

    @Override
    public @Nullable Canvas createEmptyView(CTabFolder scenTabFolder, @Nullable CTabItem diagsTab) {
        ScrolledComposite crtGraphScrolledPanel = this.graphScrolledPanel = new ScrolledComposite((Composite)scenTabFolder, 2816);
        crtGraphScrolledPanel.setExpandHorizontal(true);
        crtGraphScrolledPanel.setExpandVertical(true);
        Canvas crtGraphCanvas = this.graphCanvas = new Canvas((Composite)this.graphScrolledPanel, 0);
        crtGraphCanvas.setData((Object)Messages.VScenarioView_diagsTabName);
        this.createStatusLabel(crtGraphCanvas);
        if (this.paintListener != null) {
            crtGraphCanvas.addPaintListener(this.paintListener);
        }
        return this.graphCanvas;
    }

    @Override
    public void dispose() {
        if (this.graphScrolledPanel != null) {
            this.graphScrolledPanel.dispose();
        }
        if (this.axisFont != null) {
            this.axisFont.dispose();
        }
    }
}

