/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.ui;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.cproviders.TestRunResultContentLazyProvider;
import com.nxp.swtools.mem.validation.cproviders.TestRunResultContentProvider;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.CellCustomView;
import com.nxp.swtools.mem.validation.ui.CellLogsView;
import com.nxp.swtools.mem.validation.ui.CellSummaryView;
import com.nxp.swtools.mem.validation.ui.PhyDebugView;
import java.util.Objects;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class CellResultsMainView
extends Composite {
    private CellSummaryView summaryView;
    private CellLogsView logsView;
    @Nullable
    private PhyDebugView phyDebugView;
    private CellCustomView customView;
    private CTabFolder resultsTabFolder;
    private CTabItem resultsSummaryTab;
    @Nullable
    protected CTabItem resultLogsTab;
    @Nullable
    protected CTabItem phyDebugTab;
    protected boolean hasPhyDebug = false;

    public CellResultsMainView(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout(1, false));
        GridData mainGridData = new GridData(4, 1024, true, false, 1, 1);
        mainGridData.minimumHeight = 200;
        mainGridData.heightHint = 200;
        this.setLayoutData(mainGridData);
        this.resultsTabFolder = new CTabFolder((Composite)this, 2048);
        this.resultsTabFolder.setSimple(false);
        this.resultsTabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.summaryView = new CellSummaryView((Composite)this.resultsTabFolder);
        this.logsView = new CellLogsView((Composite)this.resultsTabFolder);
        this.customView = new CellCustomView((Composite)this.resultsTabFolder);
        this.resultsSummaryTab = new CTabItem(this.resultsTabFolder, 0);
        this.resultsSummaryTab.setText(Messages.SummaryLabel);
        this.resultsSummaryTab.setControl((Control)this.summaryView);
        @NonNull CTabItem crtTab = this.resultLogsTab = new CTabItem(this.resultsTabFolder, 0);
        crtTab.setText(Messages.LogsLabel);
        crtTab.setControl((Control)this.logsView);
        this.resultsTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.item == CellResultsMainView.this.resultLogsTab) {
                    CellResultsMainView.this.getLogsView().defaultFocus();
                }
            }
        });
        this.resultsTabFolder.setSelection(0);
    }

    protected void checkSubclass() {
    }

    public void createPhyDebugView() {
        String phyDebugOption;
        VModel vModel;
        VPresentationModel vData = ValidationContext.getInstance().getData();
        if (vData != null && (vModel = vData.getModel()) != null && (phyDebugOption = vModel.getCustomOption("phy_debug_option")) != null) {
            this.hasPhyDebug = Boolean.parseBoolean(phyDebugOption);
        }
        if (this.hasPhyDebug) {
            this.phyDebugView = new PhyDebugView((Composite)this.resultsTabFolder);
            CTabItem phyDebugTabLoc = this.phyDebugTab = new CTabItem(this.resultsTabFolder, 0);
            phyDebugTabLoc.setControl((Control)this.phyDebugView);
            phyDebugTabLoc.setText(Messages.PhyDebugLabel);
        }
    }

    public CellCustomView getCustomView() {
        return this.customView;
    }

    public CellLogsView getLogsView() {
        return this.logsView;
    }

    public @Nullable PhyDebugView getPhyDebugView() {
        return this.phyDebugView;
    }

    public CellSummaryView getSummaryView() {
        return this.summaryView;
    }

    public void setCellTestContentProvider(TestRunResultContentProvider contentProvider) {
        this.logsView.setCellTestContentProvider(contentProvider);
    }

    public void setCellTestLabelProvider(ILabelProvider labelProvider) {
        this.logsView.setCellTestLabelProvider(labelProvider);
    }

    public void setCellTestSelectionChangedListener(ISelectionChangedListener selChangedListener) {
        this.logsView.setLogsSelectionListener(selChangedListener);
    }

    public void setInput(VParamVariation cell, @Nullable VModel vModel, boolean force) {
        boolean hasLogsView = cell.getParent().getOptions().showLogs();
        boolean hasExtraView = cell.getParent().getOptions().showExtra();
        this.updateVisibility(hasLogsView);
        this.summaryView.setInput(cell);
        if (hasLogsView) {
            this.logsView.setInput(cell, vModel, force);
        }
        if (hasExtraView) {
            this.customView.setInput(cell);
        }
    }

    public void setInput(VParamVariation cell, boolean showAllLogs, boolean force) {
        this.setInput(cell, null, force);
    }

    public void setTestResultsContentProvider(TestRunResultContentLazyProvider contentProvider) {
        this.summaryView.setTestResultsContentProvider(contentProvider);
    }

    public void setTestResultsFailReasonProvider(ColumnLabelProvider labelProvider) {
        this.summaryView.setTestResultsFailReasonProvider(labelProvider);
    }

    public void setTestResultsRunLabelProvider(ColumnLabelProvider labelProvider) {
        this.summaryView.setTestResultsRunLabelProvider(labelProvider);
    }

    public void setTestResultsElapsedLabelProvider(ColumnLabelProvider labelProvider) {
        this.summaryView.setTestResultsElapsedLabelProvider(labelProvider);
    }

    public void setTestResultsScriptLabelProvider(ColumnLabelProvider labelProvider) {
        this.summaryView.setTestResultsScriptLabelProvider(labelProvider);
    }

    public void setTestResultsSelectionChangeListener(ISelectionChangedListener selChangeListener) {
        this.summaryView.setTestResultsSelectionListener(selChangeListener);
    }

    public void setTestResultsStatusLabelProvider(ColumnLabelProvider labelProvider) {
        this.summaryView.setTestResultsStatusLabelProvider(labelProvider);
    }

    public void setExportLogSelectionListener(SelectionListener listener) {
        this.logsView.setExportLogSelectionListener(listener);
    }

    private void updateVisibility(boolean hasLogsView) {
        if (hasLogsView) {
            if (this.resultLogsTab == null) {
                this.resultLogsTab = new CTabItem(this.resultsTabFolder, 0, 1);
                this.resultLogsTab.setText(Messages.LogsLabel);
                Objects.requireNonNull(this.resultLogsTab).setControl((Control)this.logsView);
            }
        } else if (this.resultLogsTab != null) {
            this.resultLogsTab.dispose();
            this.resultLogsTab = null;
        }
    }
}

