/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.table.params;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scripts.Scripts;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.VParam;
import java.util.ArrayList;
import java.util.List;

public class TestScriptParam
extends VParam {
    protected Scripts scripts;
    protected VScript @Nullable [] optValues;
    protected String @Nullable [] optNames;
    @Nullable
    private List<VScriptConfig> scriptConfigs;

    public TestScriptParam(String _id, String _name, boolean _horizontal, Scripts _scripts) {
        super(_id, _name, _horizontal);
        this.scripts = _scripts;
    }

    public TestScriptParam(TestScriptParam proto) {
        super(proto.id, proto.name, proto.horizontal);
        this.scripts = proto.scripts;
        this.scriptConfigs = proto.scriptConfigs;
        if (proto.optValues != null) {
            this.optValues = (VScript[])proto.optValues.clone();
        }
        if (proto.optNames != null) {
            this.optNames = (String[])proto.optNames.clone();
        }
    }

    public TestScriptParam(String _id, String _name, boolean horizontal, Scripts _scripts, @Nullable List<VScriptConfig> scriptConfigs) {
        this(_id, _name, horizontal, _scripts);
        this.scriptConfigs = scriptConfigs;
    }

    @Override
    public void applyConfiguration(Object value, boolean handleChanges, boolean genCodeEn) {
    }

    @Override
    public VParam createCopy() {
        return new TestScriptParam(this);
    }

    @Override
    public String @Nullable [] getOptNames() {
        return this.optNames != null ? (String[])this.optNames.clone() : null;
    }

    @Override
    public Object @Nullable [] getOptValues() {
        return this.optValues != null ? (Object[])this.optValues.clone() : null;
    }

    @Override
    public void populate(ValidationContext vContext) {
        ArrayList<VScript> visibleScripts = new ArrayList<VScript>();
        block0: for (VScript script : this.scripts.getScripts()) {
            if (this.scriptConfigs != null) {
                block1: for (VScriptConfig scriptConfig : this.scriptConfigs) {
                    Object owner;
                    if (scriptConfig.getScript().equals(script)) {
                        visibleScripts.add(script);
                        continue block0;
                    }
                    if (!script.isUserScript() || !((owner = scriptConfig.getOwner()) instanceof VScenario)) continue;
                    List<VScriptConfig> scenarioSc = ((VScenario)owner).getScriptsConfig();
                    for (VScriptConfig sc : scenarioSc) {
                        if (!sc.getScript().equals(script)) continue;
                        visibleScripts.add(script);
                        continue block1;
                    }
                }
                continue;
            }
            if (script.isSpecific()) continue;
            visibleScripts.add(script);
        }
        VScript[] optValuesLoc = this.optValues = visibleScripts.toArray(new VScript[visibleScripts.size()]);
        String[] optNamesLoc = this.optNames = new String[optValuesLoc.length];
        int i = 0;
        while (i < optValuesLoc.length) {
            optNamesLoc[i] = optValuesLoc[i].getName();
            ++i;
        }
    }

    @Override
    public void update(ValidationContext vContext) {
        this.populate(vContext);
    }
}

