/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.presenter.updaters;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.mem.validation.Messages;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionView;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ExecutionPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.presenter.updaters.AUIRunnable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.ui.CellResultsMainView;
import com.nxp.swtools.mem.validation.ui.ExecutionView;
import com.nxp.swtools.mem.validation.ui.VScenarioOptionsView;
import com.nxp.swtools.mem.validation.ui.VScenarioView;
import com.nxp.swtools.mem.validation.views.VStagesView;
import java.util.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class ScenarioFinishUiUpdater
extends AUIRunnable {
    private static final Logger LOGGER = LogManager.getLogger(ScenarioFinishUiUpdater.class);
    private VPresentationModel data;
    @Nullable
    private VStagesView stagesView;
    @Nullable
    private VScenarioView scenarioView;
    @Nullable
    private VScenarioOptionsView scenarioOptionsView;
    @Nullable
    private ExecutionView execView;
    @Nullable
    private ConnectionView connView;
    @Nullable
    private CellResultsMainView cellsView;
    private boolean showErrorMessage;
    @Nullable
    private String errorMessage;

    private static void trace(String message) {
        LOGGER.warning(message);
    }

    public ScenarioFinishUiUpdater(VPresentationModel _data) {
        this(_data, false, null);
    }

    public ScenarioFinishUiUpdater(VPresentationModel _data, boolean _showErrorMessage, @Nullable String _errorMessage) {
        this.data = _data;
        if (!this.data.isViewDisposed()) {
            this.stagesView = this.data.getView().getStagesView();
            this.scenarioView = this.data.getView().getScenarioView();
            this.scenarioOptionsView = this.data.getView().getScenarioOptionsView();
            this.execView = this.data.getView().getExecutionView();
            this.connView = this.data.getView().getConnView();
            this.cellsView = this.data.getView().getCellResultsMainView();
        }
        this.showErrorMessage = _showErrorMessage;
        this.errorMessage = _errorMessage;
    }

    @Override
    public void run() {
        if (this.data.isViewDisposed()) {
            ScenarioFinishUiUpdater.trace(UtilsText.safeString((String)Messages.ScenarioFinishUiUpdater_0));
            return;
        }
        ScenarioFinishUiUpdater.trace(UtilsText.safeString((String)Messages.ScenarioFinishUiUpdater_1));
        VScenarioView scenarioViewLoc = this.scenarioView;
        if (scenarioViewLoc != null) {
            scenarioViewLoc.redrawScenarioFigure();
            ValidationPresentationModel validationModelLoc = this.data.getValidationModel();
            if (validationModelLoc != null) {
                scenarioViewLoc.setRestorePropertiesEnabled(true);
                scenarioViewLoc.setSelectionToolsEnabled(true);
                scenarioViewLoc.setReportToolsEnabled(true);
                if (this.stagesView != null) {
                    this.stagesView.setInput(validationModelLoc);
                }
                VParamVariation paramVariationLoc = this.data.getSelectedCell();
                if (this.cellsView != null && paramVariationLoc != null) {
                    this.cellsView.setInput(paramVariationLoc, null, true);
                }
                if (this.scenarioOptionsView != null) {
                    this.scenarioOptionsView.enable(true);
                }
                ExecutionPresentationModel executionLoc = this.data.getExecution();
                if (this.execView != null && executionLoc != null) {
                    this.execView.setInput(executionLoc);
                }
                if (this.connView != null && executionLoc != null) {
                    this.connView.setInput(executionLoc);
                }
                if (this.showErrorMessage) {
                    if (this.errorMessage != null) {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        if (window != null) {
                            MessageDialog.openError((Shell)window.getShell(), (String)Messages.ScenarioFinishUiUpdater_validationError, (String)this.errorMessage);
                        }
                    } else {
                        LOGGER.warning(Messages.ScenarioFinishUiUpdater_2);
                    }
                }
                if (executionLoc != null) {
                    executionLoc.setSkipDownload(false);
                }
            }
        }
    }
}

