/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model.scenarios;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.IConfigProvider;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.scenarios.IScenarioElement;
import com.nxp.swtools.mem.validation.model.scenarios.VScenario;
import com.nxp.swtools.mem.validation.model.scenarios.VTableGroup;
import com.nxp.swtools.mem.validation.model.scenarios.VTableOptions;
import com.nxp.swtools.mem.validation.model.scripts.Scripts;
import com.nxp.swtools.mem.validation.model.scripts.VScript;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.table.params.BeanPropertyParam;
import com.nxp.swtools.mem.validation.table.params.RegFieldParam;
import com.nxp.swtools.mem.validation.table.params.TestScriptParam;
import com.nxp.swtools.mem.validation.table.params.VParam;
import com.nxp.swtools.mem.validation.table.params.VParamValue;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.table.params.VPrerequisiteSetting;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.eclipse.swt.graphics.Point;

public class VTable
implements IScenarioElement {
    public static final String DEFAULT_CORNER_TXT = "Pass / Total";
    private static final String MARGINS_CORNER_TXT = "Vref / Steps";
    @Nullable
    protected VTableGroup parent;
    protected VTableOptions options;
    protected boolean selected;
    protected boolean visible;
    protected TableState state = TableState.CLEAN;
    protected VParam[] hParams;
    protected VParam[] vParams;
    protected boolean variationsCreated;
    protected VParamVariation[][] paramVariations;
    @Nullable
    protected VParamVariation goldenVariation;
    @Nullable
    protected VParamVariation userVariation;
    protected ArrayList<String> phyRegisters = new ArrayList();
    protected List<VScriptConfig> scriptsConfig = new ArrayList<VScriptConfig>();
    protected boolean hasCustomDefaults;
    @Nullable
    protected Object customData = null;
    private int columnOffset;
    private VParamVariation[][] initialParamVariations;
    @Nullable
    private ValidationContext vContext;
    private boolean displayPerBitEnable;
    private Map<String, String> initialComponentConfig;
    @Nullable
    private List<VPrerequisiteSetting> prerequisites;

    public VTable(VTable proto, @Nullable VTableGroup _parent, Scripts scripts, ValidationContext vContext) {
        this.parent = _parent;
        this.options = proto.options;
        this.options.params.remove("read_eye_start");
        this.options.params.remove("read_eye_end");
        this.selected = proto.selected;
        this.visible = proto.visible;
        this.state = proto.state;
        this.hasCustomDefaults = proto.hasCustomDefaults;
        this.initialComponentConfig = proto.initialComponentConfig;
        this.prerequisites = proto.prerequisites;
        this.columnOffset = 0;
        this.paramVariations = new VParamVariation[0][0];
        this.setvContext(vContext);
        this.hParams = new VParam[proto.hParams.length];
        int i = 0;
        while (i < this.hParams.length) {
            this.hParams[i] = proto.hParams[i].createCopy();
            ++i;
        }
        this.vParams = new VParam[proto.vParams.length];
        i = 0;
        while (i < this.vParams.length) {
            this.vParams[i] = proto.vParams[i].createCopy();
            ++i;
        }
        this.variationsCreated = proto.variationsCreated;
        HashMap<String, VScriptConfig> scMap = new HashMap<String, VScriptConfig>();
        for (VScriptConfig scriptConfig : proto.scriptsConfig) {
            scMap.put(scriptConfig.getScript().getId(), new VScriptConfig(scriptConfig));
        }
        if (!this.hasCustomDefaults) {
            List<VScriptConfig> defaultScripts = scripts.getDefaultScriptConfigs(vContext);
            for (VScriptConfig vScriptConfig : defaultScripts) {
                scMap.put(vScriptConfig.getScript().getId(), new VScriptConfig(vScriptConfig));
            }
        }
        for (VScriptConfig scriptConfig : proto.scriptsConfig) {
            String id = scriptConfig.getScript().getId();
            VScriptConfig valueScriptConfig = Objects.requireNonNull((VScriptConfig)scMap.get(id));
            this.scriptsConfig.add(valueScriptConfig);
        }
        if (proto.variationsCreated) {
            int numRows = proto.paramVariations.length;
            int n = proto.paramVariations[0].length;
            this.paramVariations = new VParamVariation[proto.paramVariations.length][proto.paramVariations[0].length];
            int i2 = 0;
            while (i2 < numRows) {
                int j = 0;
                while (j < n) {
                    this.paramVariations[i2][j] = new VParamVariation(proto.paramVariations[i2][j], this);
                    ++j;
                }
                ++i2;
            }
            if (proto.goldenVariation != null) {
                this.goldenVariation = new VParamVariation(proto.goldenVariation, this);
            }
            this.userVariation = null;
            if (proto.userVariation != null) {
                this.userVariation = new VParamVariation(proto.userVariation, this);
            }
        }
        this.initialParamVariations = this.paramVariations;
    }

    public VTable(VTableOptions _options, VParam[] _params, @Nullable List<VPrerequisiteSetting> _prerequisites, List<VScriptConfig> _scriptsConfig, boolean _hasCustomDefaults) {
        this.parent = null;
        this.options = _options;
        this.selected = false;
        this.visible = true;
        this.variationsCreated = false;
        this.columnOffset = 0;
        this.hParams = new VParam[0];
        this.vParams = new VParam[0];
        this.paramVariations = new VParamVariation[0][0];
        this.initialParamVariations = new VParamVariation[0][0];
        this.initialComponentConfig = new HashMap<String, String>();
        if (_scriptsConfig != null) {
            this.scriptsConfig.addAll(_scriptsConfig);
        }
        this.hasCustomDefaults = _hasCustomDefaults;
        this.prerequisites = _prerequisites;
        this.setupParams(_params);
    }

    public void addColumnBeginning() {
        VParam[] vParamArray = this.vParams;
        int n = this.vParams.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] optValues;
            VParam vParam = vParamArray[n2];
            if (vParam instanceof RegFieldParam && (optValues = vParam.getOptValues()) != null) {
                int[] values = new int[optValues.length + 1];
                String[] names = new String[values.length];
                values[0] = (Integer)optValues[0] - 1;
                names[0] = String.format("%d", new Integer(values[0]));
                int i = 1;
                while (i < values.length) {
                    values[i] = (Integer)optValues[i - 1];
                    names[i] = (String)optValues[i - 1];
                    ++i;
                }
                ++this.columnOffset;
                ((RegFieldParam)vParam).runtimePopulate(names, values);
                this.addTableRow(true);
                break;
            }
            ++n2;
        }
    }

    public void addColumnEnd() {
        VParam[] vParamArray = this.vParams;
        int n = this.vParams.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] optValues;
            VParam vParam = vParamArray[n2];
            if (vParam instanceof RegFieldParam && (optValues = vParam.getOptValues()) != null) {
                int[] values = new int[optValues.length + 1];
                String[] names = new String[values.length];
                int i = 0;
                while (i < values.length - 1) {
                    values[i] = (Integer)optValues[i];
                    names[i] = (String)optValues[i];
                    ++i;
                }
                values[values.length - 1] = values[values.length - 2] + 1;
                names[values.length - 1] = String.format("%d", new Integer(values[values.length - 1]));
                ((RegFieldParam)vParam).runtimePopulate(names, values);
                this.addTableRow(false);
                break;
            }
            ++n2;
        }
    }

    public void addTableRow(boolean beginning) {
        int newTabOffset;
        int newColumnIdx;
        int j;
        Object[] optValues;
        int numRows = 1;
        int numCols = 1;
        int numValues = -1;
        int[] hIncrements = new int[this.hParams.length];
        Arrays.fill(hIncrements, 1);
        int[] vIncrements = new int[this.vParams.length];
        Arrays.fill(vIncrements, 1);
        int i = this.hParams.length - 1;
        while (i >= 0) {
            optValues = this.hParams[i].getOptValues();
            if (optValues != null) {
                numValues = optValues.length;
                numRows *= numValues;
                j = i - 1;
                while (j >= 0) {
                    int n = j--;
                    hIncrements[n] = hIncrements[n] * numValues;
                }
            }
            --i;
        }
        i = this.vParams.length - 1;
        while (i >= 0) {
            optValues = this.vParams[i].getOptValues();
            if (optValues != null) {
                numValues = optValues.length;
                numCols *= numValues;
                j = i - 1;
                while (j >= 0) {
                    int n = j--;
                    vIncrements[n] = vIncrements[n] * numValues;
                }
            }
            --i;
        }
        VParamVariation[][] newParamVariations = new VParamVariation[numRows][numCols];
        if (beginning) {
            newColumnIdx = 0;
            newTabOffset = 1;
        } else {
            newColumnIdx = numCols - 1;
            newTabOffset = 0;
        }
        int i2 = 0;
        while (i2 < this.paramVariations.length) {
            int j2 = 0;
            while (j2 < this.paramVariations[i2].length) {
                newParamVariations[i2][j2 + newTabOffset] = this.paramVariations[i2][j2];
                newParamVariations[i2][j2 + newTabOffset].setPosition(new Point(i2, j2 + newTabOffset));
                ++j2;
            }
            ++i2;
        }
        ArrayList<VParamValue> hValueList = new ArrayList<VParamValue>();
        ArrayList<VParamValue> vValueList = new ArrayList<VParamValue>();
        int k = 0;
        while (k < this.vParams.length) {
            Object[] vParamsOptValue = this.vParams[k].getOptValues();
            if (vParamsOptValue != null) {
                numValues = vParamsOptValue.length;
                int idx = newColumnIdx / vIncrements[k] % numValues;
                String name = (String)vParamsOptValue[idx];
                Object value = vParamsOptValue[idx];
                vValueList.add(new VParamValue(this.vParams[k], name, value));
            }
            ++k;
        }
        int i3 = 0;
        while (i3 < numRows) {
            int k2 = 0;
            while (k2 < this.hParams.length) {
                Object[] hParamsOptValue = this.vParams[k2].getOptValues();
                if (hParamsOptValue != null) {
                    numValues = hParamsOptValue.length;
                    int idx = i3 / hIncrements[k2] % numValues;
                    String name = (String)hParamsOptValue[idx];
                    Object value = hParamsOptValue[idx];
                    hValueList.add(new VParamValue(this.hParams[k2], name, value));
                }
                ++k2;
            }
            VParamValue[] hValues = hValueList.toArray(new VParamValue[hValueList.size()]);
            VParamValue[] vValues = vValueList.toArray(new VParamValue[vValueList.size()]);
            newParamVariations[i3][newColumnIdx] = new VParamVariation(this, new Point(i3, newColumnIdx), hValues, vValues);
            hValueList.clear();
            ++i3;
        }
        this.paramVariations = newParamVariations;
    }

    @Override
    public IScenarioElement clone(IScenarioElement parent) {
        return parent.clone(parent);
    }

    private void createVariations() {
        int j;
        Object[] optValues;
        int numRows = 1;
        int numCols = 1;
        int numValues = -1;
        int[] hIncrements = new int[this.hParams.length];
        Arrays.fill(hIncrements, 1);
        int[] vIncrements = new int[this.vParams.length];
        Arrays.fill(vIncrements, 1);
        int i = this.hParams.length - 1;
        while (i >= 0) {
            optValues = this.hParams[i].getOptValues();
            if (optValues != null) {
                numValues = optValues.length;
                numRows *= numValues;
                j = i - 1;
                while (j >= 0) {
                    int n = j--;
                    hIncrements[n] = hIncrements[n] * numValues;
                }
            }
            --i;
        }
        i = this.vParams.length - 1;
        while (i >= 0) {
            optValues = this.vParams[i].getOptValues();
            if (optValues != null) {
                numValues = optValues.length;
                numCols *= numValues;
                j = i - 1;
                while (j >= 0) {
                    int n = j--;
                    vIncrements[n] = vIncrements[n] * numValues;
                }
            }
            --i;
        }
        this.paramVariations = new VParamVariation[numRows][numCols];
        ArrayList<VParamValue> hValueList = new ArrayList<VParamValue>();
        ArrayList<VParamValue> vValueList = new ArrayList<VParamValue>();
        int i2 = 0;
        while (i2 < numRows) {
            int j2 = 0;
            while (j2 < numCols) {
                Object value;
                String name;
                String[] optNames;
                int idx;
                int k = 0;
                while (k < this.hParams.length) {
                    Object[] hParamsOptValues = this.hParams[k].getOptValues();
                    if (hParamsOptValues != null) {
                        numValues = hParamsOptValues.length;
                        idx = i2 / hIncrements[k] % numValues;
                        optNames = this.hParams[k].getOptNames();
                        if (optNames != null) {
                            name = optNames[idx];
                            value = hParamsOptValues[idx];
                            hValueList.add(new VParamValue(this.hParams[k], name, value));
                        }
                    }
                    ++k;
                }
                k = 0;
                while (k < this.vParams.length) {
                    Object[] vParamsOptValues = this.vParams[k].getOptValues();
                    if (vParamsOptValues != null) {
                        numValues = vParamsOptValues.length;
                        idx = j2 / vIncrements[k] % numValues;
                        optNames = this.vParams[k].getOptNames();
                        if (optNames != null) {
                            name = optNames[idx];
                            value = vParamsOptValues[idx];
                            vValueList.add(new VParamValue(this.vParams[k], name, value));
                        }
                    }
                    ++k;
                }
                VParamValue[] hValues = hValueList.toArray(new VParamValue[hValueList.size()]);
                VParamValue[] vValues = vValueList.toArray(new VParamValue[vValueList.size()]);
                this.paramVariations[i2][j2] = new VParamVariation(this, new Point(i2, j2), hValues, vValues);
                hValueList.clear();
                vValueList.clear();
                ++j2;
            }
            ++i2;
        }
        this.initialParamVariations = this.paramVariations;
        this.variationsCreated = true;
    }

    @Override
    public IScenarioElement[] getChildren() {
        return new IScenarioElement[0];
    }

    public int getColsNumber() {
        int numRows = 1;
        VParam[] vParamArray = this.vParams;
        int n = this.vParams.length;
        int n2 = 0;
        while (n2 < n) {
            VParam vParam = vParamArray[n2];
            Object[] optValues = vParam.getOptValues();
            if (optValues != null) {
                numRows *= optValues.length;
            }
            ++n2;
        }
        return numRows;
    }

    public int getColumnOffset() {
        return this.columnOffset;
    }

    public @Nullable VScriptConfig getConfigurationForScript(VScript script, boolean selectedOnly) {
        for (VScriptConfig config : this.scriptsConfig) {
            if (selectedOnly && (!selectedOnly || !config.isSelected()) || config.getScript() != script) continue;
            return config;
        }
        return null;
    }

    public String getCornerText() {
        if (this.isReadMargins() || this.isWriteMargins()) {
            return MARGINS_CORNER_TXT;
        }
        return DEFAULT_CORNER_TXT;
    }

    public @Nullable Object getCustomData() {
        return this.customData;
    }

    @Override
    public String getDescription() {
        return this.options.description;
    }

    public boolean getDisplayPerBitEnable() {
        return this.displayPerBitEnable;
    }

    public @Nullable VParamVariation getFirstQueuedCell() {
        VParamVariation[][] vParamVariationArray = this.paramVariations;
        int n = this.paramVariations.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation[] cellRow;
            VParamVariation[] vParamVariationArray2 = cellRow = vParamVariationArray[n2];
            int n3 = cellRow.length;
            int n4 = 0;
            while (n4 < n3) {
                VParamVariation cell = vParamVariationArray2[n4];
                if (cell.isSelected()) {
                    return cell;
                }
                ++n4;
            }
            ++n2;
        }
        return null;
    }

    public @Nullable VParamVariation getGoldenVariation() {
        return this.goldenVariation;
    }

    public VParam[] getHParams() {
        return (VParam[])this.hParams.clone();
    }

    @Override
    public String getId() {
        return this.options.id;
    }

    @Override
    public String getName() {
        return this.options.name;
    }

    public @Nullable VParamVariation getNextQueuedCell(VParamVariation startCell) {
        Point startPos = startCell.getPos();
        Point numCells = this.getNumCells();
        int iStart = startPos.x;
        int jStart = startPos.y + 1;
        int i = iStart;
        while (i < numCells.x) {
            int j = jStart;
            while (j < numCells.y) {
                VParamVariation cell = this.paramVariations[i][j];
                if (cell.isSelected()) {
                    if (this.hasScriptParam()) {
                        VScriptConfig sc = cell.getOperationalScriptConfig();
                        if (sc != null && sc.isSelected() && sc.getNumRuns() > 0) {
                            return cell;
                        }
                    } else {
                        return cell;
                    }
                }
                ++j;
            }
            jStart = 0;
            ++i;
        }
        return null;
    }

    public Point getNumCells() {
        Point size = new Point(0, 0);
        size.x = this.paramVariations.length;
        size.y = this.paramVariations[0].length;
        return size;
    }

    public int getNumFailedRows(int crtRowIndex) {
        int numFails = 0;
        int rowIndex = 0;
        VParamVariation[][] vParamVariationArray = this.paramVariations;
        int n = this.paramVariations.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation[] row = vParamVariationArray[n2];
            int cellsPerRow = row.length;
            int unselectedCells = 0;
            boolean hasPassings = false;
            VParamVariation[] vParamVariationArray2 = row;
            int n3 = row.length;
            int n4 = 0;
            while (n4 < n3) {
                VParamVariation cell = vParamVariationArray2[n4];
                if (cell.hasPassingRuns()) {
                    hasPassings = true;
                    break;
                }
                if (!cell.isSelected()) {
                    ++unselectedCells;
                }
                ++n4;
            }
            if (!hasPassings && unselectedCells < cellsPerRow) {
                ++numFails;
            }
            if (crtRowIndex == rowIndex) {
                return numFails;
            }
            ++rowIndex;
            ++n2;
        }
        return numFails;
    }

    public @Nullable VScriptConfig getOperationalScriptConfig(VParamVariation cell) {
        if (this.hasScriptParam()) {
            return cell.getOperationalScriptConfig();
        }
        return null;
    }

    public VTableOptions getOptions() {
        return this.options;
    }

    public @Nullable VParam getParam(String name) {
        VParam[] vParamArray = this.hParams;
        int n = this.hParams.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hParam = vParamArray[n2];
            if (hParam.getName().equals(name)) {
                return hParam;
            }
            ++n2;
        }
        vParamArray = this.vParams;
        n = this.vParams.length;
        n2 = 0;
        while (n2 < n) {
            VParam vParam = vParamArray[n2];
            if (vParam.getName().equals(name)) {
                return vParam;
            }
            ++n2;
        }
        return null;
    }

    public @Nullable VParam getParamById(String id) {
        VParam[] vParamArray = this.hParams;
        int n = this.hParams.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hParam = vParamArray[n2];
            if (hParam.getId().equals(id)) {
                return hParam;
            }
            ++n2;
        }
        vParamArray = this.vParams;
        n = this.vParams.length;
        n2 = 0;
        while (n2 < n) {
            VParam vParam = vParamArray[n2];
            if (vParam.getId().equals(id)) {
                return vParam;
            }
            ++n2;
        }
        return null;
    }

    public @Nullable VParamVariation getParamVariation(Point pos) {
        if (!this.variationsCreated) {
            return null;
        }
        if (pos.x >= 0 && pos.x < this.paramVariations.length) {
            VParamVariation[] cellRow = this.paramVariations[pos.x];
            if (pos.y >= 0 && pos.y < cellRow.length) {
                return cellRow[pos.y];
            }
        }
        return null;
    }

    public VParamVariation[][] getParamVariations() {
        return (VParamVariation[][])this.paramVariations.clone();
    }

    @Override
    public @Nullable IScenarioElement getParent() {
        return this.parent;
    }

    public ArrayList<String> getPhySymbols() {
        return this.phyRegisters;
    }

    public VScriptConfig[] getPrevSelectedScriptConfigs(VParamVariation cell) {
        if (this.hasScriptParam()) {
            VScriptConfig sc = cell.getOperationalScriptConfig();
            if (sc != null && sc.isSelected() && sc.getNumRuns() > 0) {
                return new VScriptConfig[]{sc};
            }
            return new VScriptConfig[0];
        }
        ArrayList<VScriptConfig> selectedConfigs = new ArrayList<VScriptConfig>();
        for (VScriptConfig config : this.scriptsConfig) {
            if (!config.isPrevSelected()) continue;
            selectedConfigs.add(config);
        }
        return selectedConfigs.toArray(new VScriptConfig[selectedConfigs.size()]);
    }

    @Override
    public String getQualifiedName() {
        if (this.parent != null) {
            VScenario scenario = (VScenario)this.parent.getParent();
            if (scenario != null && scenario.isSingleTableScenario()) {
                return scenario.getQualifiedName();
            }
            if (scenario != null) {
                return String.valueOf(scenario.getQualifiedName()) + ", " + this.options.name;
            }
        }
        return "";
    }

    public List<VScriptConfig> getScriptsConfig() {
        return this.scriptsConfig;
    }

    public VScriptConfig[] getSelectedScriptConfigs() {
        ArrayList<VScriptConfig> selectedConfigs = new ArrayList<VScriptConfig>();
        for (VScriptConfig config : this.scriptsConfig) {
            if (!config.isSelected()) continue;
            selectedConfigs.add(config);
        }
        return selectedConfigs.toArray(new VScriptConfig[selectedConfigs.size()]);
    }

    public VScriptConfig[] getSelectedScriptConfigs(VParamVariation cell) {
        if (!this.hasScriptParam()) {
            ArrayList<VScriptConfig> scList = new ArrayList<VScriptConfig>();
            for (VScriptConfig sc : this.getScriptsConfig()) {
                if (!sc.isSelected() || sc.getNumRuns() <= 0) continue;
                scList.add(sc);
            }
            return scList.toArray(new VScriptConfig[scList.size()]);
        }
        VScriptConfig sc = cell.getOperationalScriptConfig();
        if (sc != null && sc.isSelected() && sc.getNumRuns() > 0) {
            return new VScriptConfig[]{sc};
        }
        return new VScriptConfig[0];
    }

    public TableState getState() {
        return this.state;
    }

    public @Nullable VParamVariation getUserVariation() {
        return this.userVariation;
    }

    public @Nullable ValidationContext getvContext() {
        return this.vContext;
    }

    public VParam[] getVParams() {
        return (VParam[])this.vParams.clone();
    }

    public boolean hasCustomDefaultScripts() {
        return this.hasCustomDefaults;
    }

    public boolean hasPassingCells() {
        return this.findCellWithState(VParamVariation.VState.PASSED);
    }

    public boolean hasFailingCells() {
        return this.findCellWithState(VParamVariation.VState.FAILED);
    }

    private boolean findCellWithState(VParamVariation.VState cellState) {
        VParamVariation[][] vParamVariationArray = this.paramVariations;
        int n = this.paramVariations.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation[] cellRow;
            VParamVariation[] vParamVariationArray2 = cellRow = vParamVariationArray[n2];
            int n3 = cellRow.length;
            int n4 = 0;
            while (n4 < n3) {
                VParamVariation cell = vParamVariationArray2[n4];
                if (cell.getState().equals((Object)cellState)) {
                    return true;
                }
                ++n4;
            }
            ++n2;
        }
        return false;
    }

    public boolean hasPassingCells(int rowIdx) {
        if (rowIdx > 0 && rowIdx < this.paramVariations.length) {
            VParamVariation[] vParamVariationArray = this.paramVariations[rowIdx];
            int n = vParamVariationArray.length;
            int n2 = 0;
            while (n2 < n) {
                VParamVariation cell = vParamVariationArray[n2];
                if (cell.getState() == VParamVariation.VState.PASSED) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public boolean hasScriptParam() {
        VParam[] vParamArray = this.hParams;
        int n = this.hParams.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hParam = vParamArray[n2];
            if (hParam instanceof TestScriptParam) {
                return true;
            }
            ++n2;
        }
        vParamArray = this.vParams;
        n = this.vParams.length;
        n2 = 0;
        while (n2 < n) {
            VParam vParam = vParamArray[n2];
            if (vParam instanceof TestScriptParam) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void invertCellSelection() {
        this.selected = false;
        VParamVariation[][] vParamVariationArray = this.paramVariations;
        int n = this.paramVariations.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation[] cellRow;
            VParamVariation[] vParamVariationArray2 = cellRow = vParamVariationArray[n2];
            int n3 = cellRow.length;
            int n4 = 0;
            while (n4 < n3) {
                VParamVariation cell;
                cell.setSelected(!(cell = vParamVariationArray2[n4]).isSelected());
                this.selected |= cell.isSelected();
                ++n4;
            }
            ++n2;
        }
    }

    public boolean isDynamic() {
        VParam[] vParamArray = this.hParams;
        int n = this.hParams.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hParam = vParamArray[n2];
            if (hParam.isDynamic()) {
                return true;
            }
            ++n2;
        }
        vParamArray = this.vParams;
        n = this.vParams.length;
        n2 = 0;
        while (n2 < n) {
            VParam vParam = vParamArray[n2];
            if (vParam.isDynamic()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public boolean isReadMargins() {
        if (this.parent != null) {
            return this.parent.isReadMargins();
        }
        return false;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public boolean isWriteMargins() {
        if (this.parent != null) {
            return this.parent.isWriteMargins();
        }
        return false;
    }

    public void populate(ValidationContext vContext2) {
        this.populateParams(vContext2);
        this.populateUpdatedRegisters();
        this.createVariations();
    }

    private void populateParams(ValidationContext vContext2) {
        VParam[] vParamArray = this.hParams;
        int n = this.hParams.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hParam = vParamArray[n2];
            hParam.populate(vContext2);
            ++n2;
        }
        vParamArray = this.vParams;
        n = this.vParams.length;
        n2 = 0;
        while (n2 < n) {
            VParam vParam = vParamArray[n2];
            vParam.populate(vContext2);
            ++n2;
        }
    }

    private void populateUpdatedRegisters() {
        String regName;
        int n;
        int n2;
        String[] stringArray;
        BeanPropertyParam.BeanSymbol beanSymbol;
        int n3;
        int n4;
        BeanPropertyParam.BeanSymbol[] beanSymbolArray;
        BeanPropertyParam beanParam;
        BeanPropertyParam.BeanSymbol[] symbols;
        VParam[] vParamArray = this.hParams;
        int n5 = this.hParams.length;
        int n6 = 0;
        while (n6 < n5) {
            VParam hParam = vParamArray[n6];
            if (hParam instanceof BeanPropertyParam && (symbols = (beanParam = (BeanPropertyParam)hParam).getSymbols()) != null) {
                beanSymbolArray = symbols;
                n4 = symbols.length;
                n3 = 0;
                while (n3 < n4) {
                    beanSymbol = beanSymbolArray[n3];
                    stringArray = beanSymbol.getRegNames();
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        regName = stringArray[n];
                        if (regName.startsWith("PHY:")) {
                            this.phyRegisters.add(regName.replaceAll("PHY:", ""));
                        }
                        ++n;
                    }
                    ++n3;
                }
            }
            ++n6;
        }
        vParamArray = this.vParams;
        n5 = this.vParams.length;
        n6 = 0;
        while (n6 < n5) {
            VParam vParam = vParamArray[n6];
            if (vParam instanceof BeanPropertyParam && (symbols = (beanParam = (BeanPropertyParam)vParam).getSymbols()) != null) {
                beanSymbolArray = symbols;
                n4 = symbols.length;
                n3 = 0;
                while (n3 < n4) {
                    beanSymbol = beanSymbolArray[n3];
                    stringArray = beanSymbol.getRegNames();
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        regName = stringArray[n];
                        if (regName.startsWith("PHY:")) {
                            this.phyRegisters.add(regName.replaceAll("PHY:", ""));
                        }
                        ++n;
                    }
                    ++n3;
                }
            }
            ++n6;
        }
    }

    public void reset() {
        this.state = TableState.CLEAN;
        this.paramVariations = this.initialParamVariations;
        int i = 0;
        while (i < this.paramVariations.length) {
            int j = 0;
            while (j < this.paramVariations[i].length) {
                Point pos = this.paramVariations[i][j].getPos();
                this.paramVariations[i][j].setPosition(new Point(pos.x, pos.y - this.columnOffset));
                ++j;
            }
            ++i;
        }
        this.columnOffset = 0;
        VParamVariation[][] vParamVariationArray = this.paramVariations;
        int n = this.paramVariations.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation[] cellRow;
            VParamVariation[] vParamVariationArray2 = cellRow = vParamVariationArray[n2];
            int n3 = cellRow.length;
            int n4 = 0;
            while (n4 < n3) {
                VParamVariation cell = vParamVariationArray2[n4];
                cell.reset();
                ++n4;
            }
            ++n2;
        }
        for (VScriptConfig sc : this.scriptsConfig) {
            sc.applyCurrentSelection();
        }
        this.goldenVariation = null;
        this.userVariation = null;
    }

    public void runtimeUpdate() {
        this.createVariations();
    }

    public void selectAllCells() {
        VParamVariation[][] vParamVariationArray = this.paramVariations;
        int n = this.paramVariations.length;
        int n2 = 0;
        while (n2 < n) {
            VParamVariation[] cellRow;
            VParamVariation[] vParamVariationArray2 = cellRow = vParamVariationArray[n2];
            int n3 = cellRow.length;
            int n4 = 0;
            while (n4 < n3) {
                VParamVariation cell = vParamVariationArray2[n4];
                cell.setSelected(true);
                ++n4;
            }
            ++n2;
        }
        this.selected = true;
    }

    public void setColumnOffset(int columnOffset) {
        this.columnOffset = columnOffset;
    }

    public void setCustomData(Object _customData) {
        this.customData = _customData;
    }

    public void setDisplayPerBitEnable(boolean displayPerBitEnable) {
        this.displayPerBitEnable = displayPerBitEnable;
    }

    public void setGoldenVariation(VParamVariation _goldenVariation) {
        this.goldenVariation = _goldenVariation;
    }

    public void setParent(VTableGroup _parent) {
        this.parent = _parent;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void setState(TableState _state) {
        this.state = _state;
    }

    private void setupParams(VParam[] params) {
        int numH = 0;
        int numV = 0;
        VParam[] vParamArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            VParam param = vParamArray[n2];
            if (param.isHorizontal()) {
                ++numH;
            } else {
                ++numV;
            }
            ++n2;
        }
        this.hParams = new VParam[numH];
        this.vParams = new VParam[numV];
        int crtH = 0;
        int crtV = 0;
        VParam[] vParamArray2 = params;
        int n3 = params.length;
        int n4 = 0;
        while (n4 < n3) {
            VParam param = vParamArray2[n4];
            if (param.isHorizontal()) {
                this.hParams[crtH++] = param;
            } else {
                this.vParams[crtV++] = param;
            }
            ++n4;
        }
    }

    public void setUserVariation(@Nullable VParamVariation _userVariation) {
        this.userVariation = _userVariation;
    }

    public void setvContext(ValidationContext vContext) {
        this.vContext = vContext;
    }

    public void setVisible(boolean _visible) {
        this.visible = _visible;
    }

    public void skipFrom(@Nullable VParamVariation cell) {
        Point num = new Point(0, 0);
        num.x = this.paramVariations.length;
        num.y = this.paramVariations[0].length;
        Point pos = cell == null ? new Point(0, 0) : cell.getPos();
        int startY = pos.y;
        int i = pos.x;
        while (i < num.x) {
            int j = startY;
            while (j < num.y) {
                this.paramVariations[i][j].skipRemainingRuns();
                ++j;
            }
            startY = 0;
            ++i;
        }
    }

    public void update(ValidationContext vContext) {
        boolean updated = false;
        VParam[] vParamArray = this.hParams;
        int n = this.hParams.length;
        int n2 = 0;
        while (n2 < n) {
            VParam hParam = vParamArray[n2];
            if (hParam instanceof TestScriptParam) {
                hParam.update(vContext);
                updated = true;
            }
            ++n2;
        }
        vParamArray = this.vParams;
        n = this.vParams.length;
        n2 = 0;
        while (n2 < n) {
            VParam vParam = vParamArray[n2];
            if (vParam instanceof TestScriptParam) {
                vParam.update(vContext);
                updated = true;
            }
            ++n2;
        }
        if (updated) {
            this.createVariations();
        }
    }

    public void storeInitialComponentConfig() {
        IConfigProvider configController;
        if (this.vContext != null && (configController = this.vContext.getConfigController()) != null) {
            ArrayList<VParam> params = new ArrayList<VParam>(Arrays.asList(this.vParams));
            params.addAll(Arrays.asList(this.hParams));
            for (VParam vParam : params) {
                BeanPropertyParam.BeanSymbol[] paramSymbols;
                if (!(vParam instanceof BeanPropertyParam) || (paramSymbols = ((BeanPropertyParam)vParam).getSymbols()) == null) continue;
                BeanPropertyParam.BeanSymbol[] beanSymbolArray = paramSymbols;
                int n = paramSymbols.length;
                int n2 = 0;
                while (n2 < n) {
                    BeanPropertyParam.BeanSymbol symbol = beanSymbolArray[n2];
                    String paramValue = configController.getPropertyValueId(symbol.getSymbol());
                    if (paramValue != null) {
                        this.initialComponentConfig.put(symbol.getSymbol(), Objects.requireNonNull(paramValue.replace("\"", "")));
                    }
                    ++n2;
                }
            }
            if (this.prerequisites != null) {
                for (VPrerequisiteSetting prereq : this.prerequisites) {
                    String prereqValue = configController.getPropertyValue(configController.getComponentInfo().getComponentId(), prereq.getSymbol());
                    if (prereqValue == null) continue;
                    this.initialComponentConfig.put(prereq.getSymbol(), Objects.requireNonNull(prereqValue.replace("\"", "")));
                }
            }
        }
    }

    public void restoreInitialComponentConfig() {
        IConfigProvider configController;
        if (this.vContext != null && (configController = this.vContext.getConfigController()) != null) {
            for (Map.Entry<String, String> e : this.initialComponentConfig.entrySet()) {
                configController.updatePropertyValue(e.getKey(), e.getValue(), false, this.options.genCodeEn());
            }
        }
    }

    public void applyPrerequisites() {
        IConfigProvider configController;
        if (this.vContext != null && (configController = this.vContext.getConfigController()) != null && this.prerequisites != null) {
            for (VPrerequisiteSetting prereq : this.prerequisites) {
                configController.updatePropertyValue(prereq.getSymbol(), prereq.getValue(), false, this.options.genCodeEn());
            }
        }
    }

    public static enum TableResultsType {
        DEFAULT,
        CUSTOM;

    }

    public static enum TableState {
        CLEAN,
        NOT_QUEUED,
        RUNNING,
        PASSED,
        FAILED,
        CANCELLED,
        PAUSED;

    }
}

