/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.model.scenarios.VTable;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import com.nxp.swtools.mem.validation.utils.FileUtils;
import com.nxp.swtools.mem.validation.utils.StringUtils;
import com.nxp.swtools.mem.validation.utils.TestResultsLogger;
import java.util.logging.Logger;

public class TestResultsParser {
    private static final Logger LOGGER = LogManager.getLogger(TestResultsParser.class);
    public static final String RESULT_PREFIX = "test-prefix : ";
    public static final String RESULT_POSTFIX = "****DONE****";
    public static final String EXECUTING_QUIT = "DEBUG:backend:Executing: quit";
    public static final String CUSTOM_RESULT_PREFIX = "****CUSTOM_RESULT****";
    public static final int INT_HEXDIGITS = 8;
    public static final int NUM_ERR_CAPT_REGS = 10;
    public static final int NUM_DEBUG_REGS = 64;
    public static final int NUM_DATA_SLOTS_PPC = 300;
    public static final int NUM_DATA_SLOTS_LS = 20;
    public static final int RESULT_BYTE_SIZE_PPC = 1508;
    public static final int RESULT_BYTE_SIZE_LS = 380;
    public static final int DMA_CHANNELS_OFFSET = 256;
    public static final int DMA_CHANNEL_SIZE = 128;
    public static final int TABLE_DATA_IDX = 10;
    public static final int ROW_DATA_IDX = 11;
    public static final int COL_DATA_IDX = 12;
    public static final int ITERATION_DATA_IDX = 13;
    public static final int RWM_DATA_FLAGS = 14;
    public static final int TRAINED_VREF_DATA_IDX = 15;
    public static final int NEXT_ROW_DATA_IDX = 16;
    public static final int NEXT_COL_DATA_IDX = 17;
    public static final int NEXT_ITERATION_DATA_IDX = 18;
    public static final long SPECIAL_TEST_GROUP_ID = 0xFFFFFFFFL;
    public static final int ADVANCED_LOGGING_START_IDX = 1;
    public static final int ERR_CAPTURE_REGS_DATA_IDX_LS = 4;
    public static final int ERR_CAPTURE_REGS_DATA_IDX_PPC = 12;
    public static final long RWM_FLAG_LAST_RESULT = 1L;
    public static final long RWM_FLAG_TABLE_FINISH = 2L;
    public static final String ERR_CAPT_REGS_HEADER = "Err. capture registers:";
    public static final String MEM_DUMP_HEADER = "Dump:";
    public static final String SPECIFIC_DATA_HEADER = "Data:";
    public static final String CONFIG_REG_UPDATES_HEADER = "Configuration register interactions: ";

    public static long decode4bytes(int[] bytes, int startPos) {
        return TestResultsParser.decode4bytes(bytes, startPos, true);
    }

    public static long decode4bytes(int[] bytes, int startPos, boolean littleEndian) {
        assert (bytes != null && bytes.length >= startPos + 4) : "Invalid byte array!";
        long res = 0L;
        res = littleEndian ? ((long)bytes[startPos] << 24) + ((long)bytes[startPos + 1] << 16) + ((long)bytes[startPos + 2] << 8) + (long)bytes[startPos + 3] : ((long)bytes[startPos + 3] << 24) + ((long)bytes[startPos + 2] << 16) + ((long)bytes[startPos + 1] << 8) + (long)bytes[startPos];
        return res;
    }

    public static int getTestResultSize() {
        return 380;
    }

    public static int getTestResultErrorCaptureRegisterDataStartIndex() {
        return 4;
    }

    public static int getTestResultDataSlots() {
        return 20;
    }

    public static void decodeDataRegion(StringBuilder buff, long[] dataSlots) {
        String lineSep = System.getProperty("line.separator");
        buff.append(lineSep).append(lineSep).append(CONFIG_REG_UPDATES_HEADER).append(lineSep);
        int i = 1;
        boolean finish = false;
        while (!finish) {
            long slotHeader = dataSlots[i];
            int stageId = (int)((slotHeader & 0xFFFFFFFFF0000000L) >> 28);
            int moduleId = (int)((slotHeader & 0xF000000L) >> 24);
            int moduleTypeId = (int)((slotHeader & 0xF00000L) >> 20);
            int slotTypeId = (int)((slotHeader & 0xF0000L) >> 16);
            int addrOffset = (int)(slotHeader & 0xFFFFL);
            DataSlotType slotType = DataSlotType.getById(slotTypeId);
            ModuleType moduleType = ModuleType.getById(moduleTypeId);
            TestStage stage = TestStage.getById(stageId);
            if (moduleType == ModuleType.DMA && slotType != DataSlotType.DMA_TRANSFERS) {
                addrOffset += 256 + moduleId * 128;
            }
            switch (slotType) {
                case READ_REGISTER: {
                    long regValue = dataSlots[i + 1];
                    buff.append(stage.prefix).append(" Read ").append(moduleType.name()).append(" register ");
                    buff.append(StringUtils.toPrettyHex(addrOffset, 4)).append(": ").append(StringUtils.toPrettyHex(regValue, 8));
                    buff.append(".").append(lineSep);
                    break;
                }
                case WRITE_REGISTER: {
                    long regValue = dataSlots[i + 1];
                    buff.append(stage.prefix).append(" Write ").append(moduleType.name()).append(" register ");
                    buff.append(StringUtils.toPrettyHex(addrOffset, 4)).append(": ").append(StringUtils.toPrettyHex(regValue, 8));
                    buff.append(".").append(lineSep);
                    break;
                }
                case UPDATE_REGISTER: {
                    long regValue = dataSlots[i + 1];
                    long regValue2 = dataSlots[i + 2];
                    buff.append(stage.prefix).append(" Updating ").append(moduleType.name()).append(" register ");
                    buff.append(StringUtils.toPrettyHex(addrOffset, 4)).append(" from ");
                    buff.append(StringUtils.toPrettyHex(regValue, 8)).append(" to ").append(StringUtils.toPrettyHex(regValue2, 8));
                    buff.append(".").append(lineSep);
                    break;
                }
                case POLL_REGISTER: {
                    long regValue = dataSlots[i + 1];
                    long regValue2 = dataSlots[i + 2];
                    long regValue3 = dataSlots[i + 3];
                    buff.append(stage.prefix).append(" Polled ").append(moduleType.name()).append(" register ");
                    buff.append(StringUtils.toPrettyHex(addrOffset, 4)).append(" ").append(regValue3).append(" times.");
                    buff.append(". First value: ").append(StringUtils.toPrettyHex(regValue, 8)).append(". Last value: ").append(StringUtils.toPrettyHex(regValue2, 8));
                    buff.append(".").append(lineSep);
                    break;
                }
                case READ_DDR_DEBUG_REGISTERS: {
                    buff.append(stage.prefix).append(" Reading all DDR debug registers.").append(lineSep);
                    break;
                }
                case READ_DDR_ERR_CAPT_REGISTERS: {
                    buff.append(stage.prefix).append(" Reading all DDR error capture registers.").append(lineSep);
                    break;
                }
                case DMA_TRANSFERS: {
                    buff.append(stage.prefix).append(" Executing ").append(addrOffset);
                    buff.append(" DMA transfers (logging only the 1st and the last one).").append(lineSep);
                    break;
                }
                case RESET_DDR_ERR_CAPT_REGISTERS: {
                    buff.append(stage.prefix).append(" Reseting to 0 all DDR error capture registers.").append(lineSep);
                    break;
                }
                case LAST_SLOT: {
                    finish = true;
                }
            }
            i += slotType.size;
        }
    }

    public static void trace(String message) {
        LOGGER.info(message);
    }

    public static String getCustomResultFromLog(VTable table, VParamVariation cell) {
        String logFilePath = TestResultsLogger.getLogFilePath(table, cell);
        String[] stringArray = FileUtils.readTextFile(logFilePath).split(System.lineSeparator());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            if (line.contains(CUSTOM_RESULT_PREFIX)) {
                String customResult = line.substring(line.lastIndexOf(":") + 1);
                return customResult != null ? customResult : "";
            }
            ++n2;
        }
        return "";
    }

    public static enum DataSlotType {
        READ_REGISTER(0, 2),
        WRITE_REGISTER(1, 2),
        POLL_REGISTER(2, 4),
        DMA_TRANSFERS(3, 1),
        READ_DDR_ERR_CAPT_REGISTERS(4, 1),
        READ_DDR_DEBUG_REGISTERS(5, 1),
        UPDATE_REGISTER(6, 3),
        RESET_DDR_ERR_CAPT_REGISTERS(8, 1),
        LAST_SLOT(9, 1);

        public final int id;
        public final int size;

        private DataSlotType(int id, int size) {
            this.id = id;
            this.size = size;
        }

        public static DataSlotType getById(int id) {
            DataSlotType[] dataSlotTypeArray = DataSlotType.values();
            int n = dataSlotTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataSlotType type = dataSlotTypeArray[n2];
                if (type.id == id) {
                    return type;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unexpected id for the DataSlotType: " + id);
        }
    }

    public static enum ModuleType {
        DDR(0),
        DMA(1);

        public final int id;

        private ModuleType(int id) {
            this.id = id;
        }

        public static ModuleType getById(int id) {
            ModuleType[] moduleTypeArray = ModuleType.values();
            int n = moduleTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                ModuleType type = moduleTypeArray[n2];
                if (type.id == id) {
                    return type;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unexpected id for the ModuleType: " + id);
        }
    }

    public static enum TestStage {
        INIT(0, "(Pre-testing)"),
        MIDDLE(1, "(Mid-testing)"),
        FINISH(15, "(Post-testing)");

        public final int id;
        public final String prefix;

        private TestStage(int id, String prefix) {
            this.id = id;
            this.prefix = prefix;
        }

        public static TestStage getById(int id) {
            TestStage[] testStageArray = TestStage.values();
            int n = testStageArray.length;
            int n2 = 0;
            while (n2 < n) {
                TestStage stage = testStageArray[n2];
                if (stage.id == id) {
                    return stage;
                }
                ++n2;
            }
            throw new IllegalArgumentException("Unexpected id for the TestStage: " + id);
        }
    }
}

