/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.model;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.model.ITableSelector;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;

public class TableSelector
implements ITableSelector {
    private HashMap<String, ITableSelector.SelectorOptions> selectOptions = new HashMap();

    private static boolean checkParams(VParamVariation[][] cells, int rowIdx, int colIdx) {
        if (cells.length == 0 || cells[0].length == 0) {
            return false;
        }
        if (rowIdx < 0 || rowIdx >= cells.length) {
            return false;
        }
        if (cells.length > 1) {
            int i = 0;
            while (i < cells.length - 1) {
                if (cells[i].length != cells[i + 1].length) {
                    return false;
                }
                ++i;
            }
        }
        return colIdx >= 0 && colIdx < cells[0].length;
    }

    private static int[] getBestClusterBB(VParamVariation[][] cells, int[][] clusters) {
        int numRows = cells.length;
        int numCols = cells[0].length;
        int[] clustDim = new int[]{numRows, numRows, -1, -1};
        ClustSize[] clustSizes = TableSelector.getSortedClusterSizes(cells, clusters);
        int bestClusterLeader = clustSizes[0].clustId;
        int i = 0;
        while (i < numRows) {
            int j = 0;
            while (j < numCols) {
                if (cells[i][j].allTestsPassed() && clusters[i][j] == bestClusterLeader) {
                    if (i < clustDim[0]) {
                        clustDim[0] = i;
                    }
                    if (i > clustDim[2]) {
                        clustDim[2] = i;
                    }
                    if (j < clustDim[1]) {
                        clustDim[1] = j;
                    }
                    if (j > clustDim[3]) {
                        clustDim[3] = j;
                    }
                }
                ++j;
            }
            ++i;
        }
        return clustDim;
    }

    private static int getBestClusterLeader(VParamVariation[][] cells, int[][] clusters) {
        ClustSize[] clustSizes = TableSelector.getSortedClusterSizes(cells, clusters);
        return clustSizes[0].clustId;
    }

    public static ITableSelector.ColumnPass getColumnPass(VParamVariation[][] cells, int columnIdx) {
        ITableSelector.ColumnPass cp = new ITableSelector.ColumnPass();
        int @Nullable [] passGridLoc = cp.passGrid = new int[cells.length];
        int i = 0;
        while (i < cells.length) {
            if (cells[i][columnIdx].allTestsPassed()) {
                int n = passGridLoc[i] = i == 0 ? 1 : passGridLoc[i - 1] + 1;
                if (cp.maxPassSize < passGridLoc[i]) {
                    cp.maxPassSize = passGridLoc[i];
                }
            } else {
                passGridLoc[i] = 0;
            }
            ++i;
        }
        return cp;
    }

    private static int[] getDimPassingCellsRegion(VParamVariation[][] cells, ITableSelector.TableDimension dim, int dimIdx, int[][] clusters, int clustId) {
        int[] region = new int[]{-1, -1};
        int numRows = cells.length;
        int numCols = cells[0].length;
        block0 : switch (dim) {
            case ROW: {
                int sColIdx = 0;
                int eColIdx = numCols - 1;
                while (sColIdx < numCols && eColIdx >= 0) {
                    if (clusters[dimIdx][sColIdx] == clustId && region[0] == -1) {
                        region[0] = sColIdx;
                    }
                    if (clusters[dimIdx][eColIdx] == clustId && region[1] == -1) {
                        region[1] = eColIdx;
                    }
                    if (region[0] != -1 && region[1] != -1) break block0;
                    ++sColIdx;
                    --eColIdx;
                }
                break;
            }
            case COLUMN: {
                int sRowIdx = 0;
                int eRowIdx = numRows - 1;
                while (sRowIdx < numRows && eRowIdx >= 0) {
                    if (clusters[sRowIdx][dimIdx] == clustId && region[0] == -1) {
                        region[0] = sRowIdx;
                    }
                    if (clusters[eRowIdx][dimIdx] == clustId && region[1] == -1) {
                        region[1] = eRowIdx;
                    }
                    if (region[0] != -1 && region[1] != -1) break block0;
                    ++sRowIdx;
                    --eRowIdx;
                }
                break;
            }
        }
        return region;
    }

    private static int getNumPassingCells(VParamVariation[][] cells, ITableSelector.TableDimension dim, int dimIdx) {
        int passingCells = 0;
        int numRows = cells.length;
        int numCols = cells[0].length;
        switch (dim) {
            case ROW: {
                int colIdx = 0;
                while (colIdx < numCols) {
                    passingCells += cells[dimIdx][colIdx].allTestsPassed() ? 1 : 0;
                    ++colIdx;
                }
                break;
            }
            case COLUMN: {
                int rowIdx = 0;
                while (rowIdx < numRows) {
                    passingCells += cells[rowIdx][dimIdx].allTestsPassed() ? 1 : 0;
                    ++rowIdx;
                }
                break;
            }
        }
        return passingCells;
    }

    private static ClustSize[] getSortedClusterSizes(VParamVariation[][] cells, int[][] clusters) {
        ArrayList<ClustSize> sizes = new ArrayList<ClustSize>();
        int leader = -1;
        boolean csFound = false;
        int i = 0;
        while (i < clusters.length) {
            int j = 0;
            while (j < clusters[0].length) {
                if (cells[i][j].allTestsPassed()) {
                    leader = clusters[i][j];
                    csFound = false;
                    for (ClustSize cs : sizes) {
                        if (cs.clustId != leader) continue;
                        ++cs.size;
                        csFound = true;
                        break;
                    }
                    if (!csFound) {
                        ClustSize cs;
                        cs = new ClustSize(leader, 1);
                        sizes.add(cs);
                    }
                }
                ++j;
            }
            ++i;
        }
        Collections.sort(sizes);
        return sizes.toArray(new ClustSize[sizes.size()]);
    }

    private static boolean hasPassingCells(VParamVariation[][] cells) {
        int dimX = cells.length;
        int dimY = cells[0].length;
        int i = 0;
        while (i < dimX) {
            int j = 0;
            while (j < dimY) {
                if (cells[i][j].allTestsPassed()) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    private static int selectCenterDim(ITableSelector.CenterPriority centerPr, ITableSelector.CellOrdering ord, int minDimIdx, int maxDimIdx) {
        int numCandidates = maxDimIdx - minDimIdx + 1;
        if (numCandidates == 0) {
            return -1;
        }
        if (numCandidates == 1) {
            return minDimIdx;
        }
        int centerDim = -1;
        centerDim = numCandidates % 2 == 0 ? (centerPr == ITableSelector.CenterPriority.HIGHER_VALUE && ord == ITableSelector.CellOrdering.INCREASING_VALUES || centerPr == ITableSelector.CenterPriority.LOWER_VALUE && ord == ITableSelector.CellOrdering.DECREASING_VALUES ? minDimIdx + numCandidates / 2 : minDimIdx + numCandidates / 2 - 1) : minDimIdx + numCandidates / 2;
        return centerDim;
    }

    private static int selectCenterDim(ITableSelector.CenterPriority centerPr, ITableSelector.CellOrdering ord, int[] dimCandidates) {
        int numCandidates = dimCandidates.length;
        if (numCandidates == 0) {
            return -1;
        }
        if (numCandidates == 1) {
            return dimCandidates[0];
        }
        int centerDim = -1;
        centerDim = numCandidates % 2 == 0 ? (centerPr == ITableSelector.CenterPriority.HIGHER_VALUE && ord == ITableSelector.CellOrdering.INCREASING_VALUES || centerPr == ITableSelector.CenterPriority.LOWER_VALUE && ord == ITableSelector.CellOrdering.DECREASING_VALUES ? dimCandidates[numCandidates / 2] : dimCandidates[numCandidates / 2 - 1]) : dimCandidates[numCandidates / 2];
        return centerDim;
    }

    private static int[] selectPriorityDim(VParamVariation[][] cells, ITableSelector.TableDimension dim, ITableSelector.GoldenDimensionSelectionMode selMode, int startDim, int endDim) {
        int psmDimSize = endDim - startDim + 1;
        int[] selCells = new int[]{};
        switch (selMode) {
            case LARGEST_PASSING_RANGE: {
                class CellPassings {
                    public int dimIdx = 0;
                    public int numPasses = 0;

                    public CellPassings(int dimIdx, int numPasses) {
                        this.dimIdx = dimIdx;
                        this.numPasses = numPasses;
                    }
                }
                CellPassings[] cps = new CellPassings[psmDimSize];
                int i = 0;
                while (i < psmDimSize) {
                    cps[i] = new CellPassings(i + startDim, TableSelector.getNumPassingCells(cells, dim, i));
                    ++i;
                }
                class CellPassingComparator
                implements Comparator<CellPassings> {
                    CellPassingComparator() {
                    }

                    @Override
                    public int compare(CellPassings arg0, CellPassings arg1) {
                        if (arg0 == null && arg1 == null) {
                            return 0;
                        }
                        if (arg0 == null) {
                            return 1;
                        }
                        if (arg1 == null) {
                            return -1;
                        }
                        if (arg0.numPasses > arg1.numPasses) {
                            return -1;
                        }
                        if (arg0.numPasses < arg1.numPasses) {
                            return 1;
                        }
                        return 0;
                    }
                }
                Arrays.sort(cps, new CellPassingComparator());
                int numMaxPasses = 0;
                int i2 = 0;
                while (i2 < psmDimSize) {
                    if (cps[i2].numPasses != cps[0].numPasses) break;
                    ++numMaxPasses;
                    ++i2;
                }
                selCells = new int[numMaxPasses];
                i2 = 0;
                while (i2 < numMaxPasses) {
                    selCells[i2] = cps[i2].dimIdx;
                    ++i2;
                }
                Arrays.sort(selCells);
                break;
            }
            case CENTER_PASSING: {
                selCells = psmDimSize % 2 == 0 ? new int[]{startDim + psmDimSize / 2 - 1, startDim + psmDimSize / 2} : new int[]{startDim + psmDimSize / 2};
            }
        }
        return selCells;
    }

    private void dfs(VParamVariation[][] cells, int[][] clusters, int x, int y, int leader) {
        if (clusters[x][y] != 0) {
            return;
        }
        if (leader == -1) {
            clusters[x][y] = 1 + x * clusters[0].length + y;
            leader = clusters[x][y];
        } else {
            clusters[x][y] = leader;
        }
        if (cells[x][y].allTestsPassed()) {
            int xDim = cells.length;
            int yDim = cells[0].length;
            int[][] nbs = new int[][]{{x - 1, y - 1}, {x - 1, y}, {x - 1, y + 1}, {x, y - 1}, {x, y + 1}, {x + 1, y - 1}, {x + 1, y}, {x + 1, y + 1}};
            int k = 0;
            while (k < nbs.length) {
                int nY;
                int nX;
                boolean isNode;
                boolean bl = isNode = nbs[k][0] >= 0 && nbs[k][0] < xDim && nbs[k][1] >= 0 && nbs[k][1] < yDim;
                if (isNode && cells[nX = nbs[k][0]][nY = nbs[k][1]].allTestsPassed() && clusters[nX][nY] == 0) {
                    this.dfs(cells, clusters, nX, nY, leader);
                }
                ++k;
            }
        }
    }

    public ArrayList<CellPos> getCenteredRect(int cX, int cY, int centerDist) {
        ArrayList<CellPos> cellsPos = new ArrayList<CellPos>();
        int[] dims = new int[]{2 * centerDist + 1, 2 * centerDist, 2 * centerDist, 2 * centerDist - 1};
        Dir[] dir = new Dir[]{Dir.LEFT, Dir.UP, Dir.RIGHT, Dir.DOWN};
        int[] startDyn = new int[]{cY + centerDist, cX + centerDist - 1, cY - centerDist + 1, cX - centerDist + 1};
        int[] stDim = new int[]{cX + centerDist, cY - centerDist, cX - centerDist, cY + centerDist};
        int i = 0;
        while (i < 4) {
            int j = 0;
            while (j < dims[i]) {
                switch (dir[i]) {
                    case LEFT: {
                        cellsPos.add(new CellPos(stDim[i], startDyn[i] - j));
                        break;
                    }
                    case UP: {
                        cellsPos.add(new CellPos(startDyn[i] - j, stDim[i]));
                        break;
                    }
                    case RIGHT: {
                        cellsPos.add(new CellPos(stDim[i], startDyn[i] + j));
                        break;
                    }
                    case DOWN: {
                        cellsPos.add(new CellPos(startDyn[i] + j, stDim[i]));
                    }
                }
                ++j;
            }
            ++i;
        }
        return cellsPos;
    }

    private int[][] getClusters(VParamVariation[][] cells) {
        int[][] clust = new int[cells.length][cells[0].length];
        int i = 0;
        while (i < cells.length) {
            int j = 0;
            while (j < cells[0].length) {
                this.dfs(cells, clust, i, j, -1);
                ++j;
            }
            ++i;
        }
        return clust;
    }

    @Override
    public @Nullable VParamVariation selectBestOption(VParamVariation[][] cells) {
        return this.selectBestOption(cells, new ITableSelector.SelectorOptions());
    }

    @Override
    public @Nullable VParamVariation selectBestOption(VParamVariation[][] cells, ITableSelector.SelectorOptions opt) {
        if (!TableSelector.checkParams(cells, 0, 0)) {
            return null;
        }
        if (!TableSelector.hasPassingCells(cells)) {
            return null;
        }
        int masterCenterDimIdx = -1;
        int slaveCenterDimIdx = -1;
        int[][] clusters = this.getClusters(cells);
        int bestLeader = TableSelector.getBestClusterLeader(cells, clusters);
        int[] bestClustBB = TableSelector.getBestClusterBB(cells, clusters);
        int[] psmDimLimits = null;
        switch (opt.masterDim) {
            case COLUMN: {
                psmDimLimits = new int[]{bestClustBB[1], bestClustBB[3]};
                break;
            }
            case ROW: {
                psmDimLimits = new int[]{bestClustBB[0], bestClustBB[2]};
            }
        }
        if (psmDimLimits == null || psmDimLimits[0] == -1 || psmDimLimits[1] == -1) {
            return null;
        }
        int[] masterDimCandidates = TableSelector.selectPriorityDim(cells, opt.masterDim, opt.masterDimSelMode, psmDimLimits[0], psmDimLimits[1]);
        masterCenterDimIdx = TableSelector.selectCenterDim(opt.masterDimCenterMode, opt.masterDimOrder, masterDimCandidates);
        int[] slaveDimRegion = TableSelector.getDimPassingCellsRegion(cells, opt.masterDim, masterCenterDimIdx, clusters, bestLeader);
        slaveCenterDimIdx = TableSelector.selectCenterDim(opt.slaveDimCenterMode, opt.slaveDimOrder, slaveDimRegion[0], slaveDimRegion[1]);
        if (masterCenterDimIdx != -1 && slaveCenterDimIdx != -1) {
            VParamVariation goldenCell = null;
            switch (opt.masterDim) {
                case ROW: {
                    goldenCell = cells[masterCenterDimIdx][slaveCenterDimIdx];
                    break;
                }
                case COLUMN: {
                    goldenCell = cells[slaveCenterDimIdx][masterCenterDimIdx];
                }
            }
            if (goldenCell != null && goldenCell.allTestsPassed()) {
                return goldenCell;
            }
            return this.selectSubOptimalCell(cells, opt, goldenCell);
        }
        return null;
    }

    @Override
    public @Nullable VParamVariation selectBestOption(VParamVariation[][] cells, String tableName) {
        ITableSelector.SelectorOptions tableOpt = this.selectOptions.get(tableName);
        if (tableOpt == null) {
            tableOpt = new ITableSelector.SelectorOptions();
        }
        return this.selectBestOption(cells, tableOpt);
    }

    private @Nullable VParamVariation selectSubOptimalCell(VParamVariation[][] cells, ITableSelector.SelectorOptions opt, @Nullable VParamVariation centerCell) {
        int maxDist;
        int dimX = cells.length;
        int dimY = cells[0].length;
        int cX = centerCell != null ? centerCell.getPos().x : 0;
        int cY = centerCell != null ? centerCell.getPos().y : 0;
        int centerDist = 1;
        int n = maxDist = cX >= cY ? cX : cY;
        if (maxDist < dimX - cX) {
            maxDist = dimX - cX;
        }
        if (maxDist < dimY - cY) {
            maxDist = dimY - cY;
        }
        while (centerDist <= maxDist) {
            ArrayList<CellPos> cellsPos = this.getCenteredRect(cX, cY, centerDist);
            for (CellPos cellPos : cellsPos) {
                if (cellPos.x < 0 || cellPos.x >= dimX || cellPos.y < 0 || cellPos.y >= dimY || !cells[cellPos.x][cellPos.y].allTestsPassed()) continue;
                return cells[cellPos.x][cellPos.y];
            }
            ++centerDist;
        }
        return null;
    }

    private static class CellPos {
        public int x;
        public int y;

        public CellPos(int _x, int _y) {
            this.x = _x;
            this.y = _y;
        }
    }

    private static class ClustSize
    implements Comparable<ClustSize> {
        int clustId;
        int size;

        public ClustSize(int id, int _size) {
            this.clustId = id;
            this.size = _size;
        }

        @Override
        public int compareTo(ClustSize arg0) {
            if (this.size > arg0.size) {
                return -1;
            }
            if (this.size < arg0.size) {
                return 1;
            }
            return 0;
        }

        public boolean equals(@Nullable Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            return this.compareTo((ClustSize)obj) == 0;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + this.size;
            return result;
        }
    }

    private static enum Dir {
        UP,
        DOWN,
        LEFT,
        RIGHT;

    }
}

