/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.listeners;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.jobs.JobName;
import com.nxp.swtools.mem.validation.listeners.TestCountFocusListener;
import com.nxp.swtools.mem.validation.listeners.TestCountVerifyListener;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.presenter.VStagePresentation;
import com.nxp.swtools.mem.validation.model.presenter.ValidationPresentationModel;
import com.nxp.swtools.mem.validation.model.scripts.VScriptConfig;
import com.nxp.swtools.mem.validation.presenter.updaters.ScenarioOptionsUiUpdater;
import java.util.Objects;
import java.util.logging.Logger;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class ScriptConfigCountEditingSupport
extends EditingSupport {
    protected static final Logger LOGGER = LogManager.getLogger(ScriptConfigCountEditingSupport.class);
    public static final int MAX_NUM_RUNS = 100000;
    private VPresentationModel data;
    private static final String WIDGET_KEY_CELL_EDITOR = "qcvs.countEditor";

    public ScriptConfigCountEditingSupport(VPresentationModel data, ColumnViewer viewer) {
        super(viewer);
        this.data = data;
    }

    protected boolean canEdit(@Nullable Object element) {
        VScriptConfig sc = Objects.requireNonNull((VScriptConfig)element);
        return sc.isSelected() && !sc.getScript().isSpecific();
    }

    protected @Nullable CellEditor getCellEditor(@Nullable Object element) {
        ValidationPresentationModel vData = this.data.getValidationModel();
        if (vData == null) {
            return null;
        }
        boolean changeEnabled = vData.isChangedEnabled();
        if (!changeEnabled) {
            return null;
        }
        VStagePresentation stage = this.data.getSelectedStage();
        if (stage != null) {
            stage.setCountEditing(true);
        }
        ColumnViewer viewer = this.getViewer();
        TextCellEditor tcEditor = new TextCellEditor((Composite)((TableViewer)viewer).getTable());
        viewer.setData(WIDGET_KEY_CELL_EDITOR, (Object)tcEditor);
        ((Text)tcEditor.getControl()).addVerifyListener((VerifyListener)new TestCountVerifyListener());
        ((Text)tcEditor.getControl()).addFocusListener((FocusListener)new TestCountFocusListener());
        return tcEditor;
    }

    protected @NonNull Object getValue(@Nullable Object element) {
        VScriptConfig sc = Objects.requireNonNull((VScriptConfig)element);
        return "" + sc.getNumRuns();
    }

    protected void setValue(@Nullable Object element, @Nullable Object value) {
        block10: {
            VStagePresentation stage = this.data.getSelectedStage();
            if (stage == null) {
                return;
            }
            VScriptConfig sc = Objects.requireNonNull((VScriptConfig)element);
            try {
                try {
                    String strValue = Objects.requireNonNull((String)value);
                    int newCount = 1;
                    if (strValue.length() != 0) {
                        newCount = Integer.parseInt(value.toString());
                        if (newCount <= 0) {
                            newCount = 1;
                        }
                        if (newCount >= 100000) {
                            newCount = 100000;
                        }
                    }
                    if (sc.getNumRuns() != newCount) {
                        stage.updateScriptConfig(sc, newCount);
                    }
                }
                catch (Exception e) {
                    LOGGER.info(e.getMessage());
                    stage.setCountEditing(false);
                    break block10;
                }
            }
            catch (Throwable throwable) {
                stage.setCountEditing(false);
                throw throwable;
            }
            stage.setCountEditing(false);
        }
        this.data.updateUI(new ScenarioOptionsUiUpdater(this.data), JobName.UPDATE_MODEL_ON_SCRIPT_COUNT_CHANGE.name);
    }
}

