/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.cproviders;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.model.VModel;
import com.nxp.swtools.mem.validation.model.VPresentationModel;
import com.nxp.swtools.mem.validation.model.VRunResult;
import com.nxp.swtools.mem.validation.table.params.VParamVariation;
import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class TestRunResultContentProvider
implements IStructuredContentProvider {
    private static final int MAX_RESULT_NUM = 100;
    private static final int RESULT_SIZE_LIMIT = 100000;
    private ArrayList<@NonNull VRunResult> resultsCache = new ArrayList();
    int lastIndex;
    @Nullable
    private VParamVariation currentCell = null;

    public void dispose() {
    }

    public @NonNull Object @Nullable [] getElements(@Nullable Object inputElement) {
        if (inputElement instanceof VParamVariation) {
            VRunResult runResult;
            String option;
            VModel vModel;
            VParamVariation cell = (VParamVariation)inputElement;
            VRunResult[] results = Objects.requireNonNull(cell.getResults());
            if (results.length == 0 || results[0].getType() == VRunResult.ResultType.QUEUED || !cell.equals(this.currentCell)) {
                this.currentCell = cell;
                this.resultsCache.clear();
                this.lastIndex = 0;
            }
            boolean filterPhyLog = false;
            VPresentationModel presentationModel = ValidationContext.getInstance().getData();
            if (presentationModel != null && (vModel = presentationModel.getModel()) != null && (option = vModel.getCustomOption("filterPhyLog")) != null) {
                filterPhyLog = Boolean.parseBoolean(option);
            }
            int i = this.lastIndex;
            while (i < 100) {
                if (i >= results.length) break;
                runResult = results[i];
                if (runResult.getType() != VRunResult.ResultType.SKIPPED) {
                    this.resultsCache.add(runResult);
                    if (filterPhyLog) {
                        VRunResult phyResult = new VRunResult(runResult.getParamVariation(), runResult.getScriptConfig(), runResult.getNumRun());
                        phyResult.setType(VRunResult.ResultType.PHY);
                        this.resultsCache.add(phyResult);
                    }
                }
                this.lastIndex = filterPhyLog ? this.lastIndex + 2 : this.lastIndex + 1;
                ++i;
            }
            i = this.lastIndex;
            while (i < results.length) {
                runResult = results[i];
                if (this.resultsCache.size() >= 100000) break;
                if (runResult.getType() == VRunResult.ResultType.FAILED) {
                    this.resultsCache.add(runResult);
                    ++this.lastIndex;
                } else {
                    if (runResult.getType() == VRunResult.ResultType.QUEUED) break;
                    ++this.lastIndex;
                }
                ++i;
            }
            return this.resultsCache.toArray(new VRunResult[this.resultsCache.size()]);
        }
        return new Object[0];
    }

    public void inputChanged(@Nullable Viewer viewer, @Nullable Object oldInput, @Nullable Object newInput) {
        if (viewer != null && !viewer.getControl().isDisposed()) {
            viewer.refresh();
        }
    }
}

