/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections.ui;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.Activator;
import com.nxp.swtools.mem.validation.config.ValidationContext;
import com.nxp.swtools.mem.validation.connections.JTAGConnection;
import com.nxp.swtools.mem.validation.connections.S32ProbeConnection;
import com.nxp.swtools.mem.validation.connections.TargetConnectionsSetting;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionParamView;
import com.nxp.swtools.mem.validation.connections.ui.ConnectionView;
import com.nxp.swtools.mem.validation.connections.ui.Messages;
import com.nxp.swtools.mem.validation.utils.ConnectionUtils;
import com.nxp.swtools.utils.resources.ToolsColors;
import java.util.Objects;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class JtagConnectionParamView
extends ConnectionParamView {
    protected static final Logger LOGGER = LogManager.getLogger(JtagConnectionParamView.class);
    private static final String HOST_IP_PLACEHOLDER = "0.0.0.0";
    private static final String MAC_PATTERN = "^([0-9A-Fa-f]{2}[\\.:-]){5}([0-9A-Fa-f]{2})$";
    private ConnectionView connView;
    Composite usbEthComp;
    StackLayout usbEthStackLayout;
    Composite ethernetComp;
    Text hostIpText;
    Composite usbComp;
    Composite clockComp;
    Button ethernetBtn;
    Button usbBtn;
    CCombo usbAddress;
    Button btnScanProbe;
    Button btnTestConnection;
    private transient ControlDecoration ctrlDecorator;

    public JtagConnectionParamView(ConnectionView connectionView, Composite parentView) {
        super(parentView);
        this.connView = connectionView;
        this.setLayout((Layout)new GridLayout(1, true));
        this.setLayoutData(new GridData(4, 0x1000000, true, false, 1, 1));
        this.usbEthStackLayout = new StackLayout();
        Group typeGroup = new Group((Composite)this, 0);
        typeGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        typeGroup.setLayout((Layout)new GridLayout(1, false));
        Composite btnComp = new Composite((Composite)typeGroup, 0);
        btnComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        btnComp.setLayout((Layout)new GridLayout(2, true));
        this.usbBtn = new Button(btnComp, 16);
        this.usbBtn.setText(Messages.UsbConnLabel);
        this.ethernetBtn = new Button(btnComp, 16);
        this.ethernetBtn.setText(Messages.EthernetConnLabel);
        this.usbEthComp = new Composite((Composite)typeGroup, 0);
        this.usbEthComp.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.usbEthComp.setLayout((Layout)this.usbEthStackLayout);
        this.ethernetComp = new Composite(this.usbEthComp, 0);
        this.ethernetComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.ethernetComp.setLayout((Layout)new GridLayout(2, true));
        Label hostIpLabel = new Label(this.ethernetComp, 0);
        hostIpLabel.setText(Messages.HostIPLabel);
        this.hostIpText = new Text(this.ethernetComp, 2048);
        this.hostIpText.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        this.hostIpText.setMessage(HOST_IP_PLACEHOLDER);
        this.hostIpText.addModifyListener(e -> this.updateJtagHostname());
        this.usbComp = new Composite(this.usbEthComp, 0);
        this.usbComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.usbComp.setLayout((Layout)new GridLayout(4, false));
        Label usbLabel = new Label(this.usbComp, 0);
        usbLabel.setText(Messages.UsbSerialLabel);
        this.usbAddress = new CCombo(this.usbComp, 2048);
        GridData gridData = new GridData(4, 0x1000000, true, true);
        gridData.horizontalIndent = 10;
        this.usbAddress.setLayoutData((Object)gridData);
        this.usbAddress.setEditable(true);
        this.usbAddress.addModifyListener(e -> this.updateJtagUsbAddress());
        this.btnTestConnection = new Button(this.usbComp, 8);
        this.btnTestConnection.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.btnTestConnection.setText(Messages.ConnectionTest);
        this.btnTestConnection.setEnabled(true);
        this.btnScanProbe = new Button(this.usbComp, 8);
        this.btnScanProbe.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.btnScanProbe.setImage(Activator.getDefault().getImage("platform:/plugin/org.eclipse.ui.ide/icons/full/etool16/search_src.png"));
        this.btnScanProbe.setToolTipText(Messages.ScanAvailableUSB);
        this.btnScanProbe.setEnabled(true);
        this.btnScanProbe.addListener(13, e -> this.updateUSBAddressList());
        this.ctrlDecorator = new ControlDecoration((Control)this.usbAddress, 16512);
        this.ctrlDecorator.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_ERROR").getImage());
        this.ctrlDecorator.setDescriptionText(Messages.InvalidMACAddress);
        this.updateUSBAddressList();
        this.ethernetBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    JtagConnectionParamView.this.setJtagConnectionType(Messages.EthernetConnLabel);
                    JtagConnectionParamView.this.usbEthStackLayout.topControl = JtagConnectionParamView.this.ethernetComp;
                    JtagConnectionParamView.this.usbEthComp.layout();
                }
            }
        });
        this.usbBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button source = (Button)e.getSource();
                if (source.getSelection()) {
                    JtagConnectionParamView.this.setJtagConnectionType(Messages.UsbConnLabel);
                    JtagConnectionParamView.this.usbEthStackLayout.topControl = JtagConnectionParamView.this.usbComp;
                    JtagConnectionParamView.this.usbEthComp.layout();
                }
            }
        });
        this.btnTestConnection.addListener(13, event -> {
            String selection = this.usbAddress.getText();
            if (selection != null) {
                ConnectionUtils.testConnection(selection);
            }
        });
        JTAGConnection jtagConnection = this.getCurrentConnection();
        if (jtagConnection != null && !jtagConnection.isUsbConnection()) {
            this.ethernetBtn.setSelection(true);
            this.ethernetBtn.notifyListeners(13, new Event());
        } else {
            this.usbBtn.setSelection(true);
            this.usbBtn.notifyListeners(13, new Event());
        }
        this.clockComp = new Composite((Composite)this, 0);
        this.clockComp.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.clockComp.setLayout((Layout)new GridLayout(2, true));
        this.clockSourceLabel = new Label(this.clockComp, 0);
        this.clockSourceLabel.setText(Messages.ClockFrequency);
        this.clockComposite = new Composite(this.clockComp, 0);
        this.clockCompositeGridData = new GridData(4, 0x1000000, true, false);
        Composite clockCompositeLocal = Objects.requireNonNull(this.clockComposite);
        clockCompositeLocal.setLayoutData((Object)this.clockCompositeGridData);
        clockCompositeLocal.setLayout((Layout)new GridLayout(2, false));
        TargetConnectionsSetting targetConnections = this.connView.getTargetConnections();
        int minFreq = 20;
        int maxFreq = 40;
        int defaultFreq = 40;
        if (targetConnections != null) {
            minFreq = targetConnections.getMinClockFreq();
            maxFreq = targetConnections.getMaxClockFreq();
            defaultFreq = targetConnections.getDefaultClockFreq();
        }
        this.clockSourceSpinner = new Spinner(this.clockComposite, 2048);
        Spinner clockSourceSpinnerLocal = Objects.requireNonNull(this.clockSourceSpinner);
        clockSourceSpinnerLocal.setLayoutData((Object)new GridData(4, 0x1000000, true, true));
        clockSourceSpinnerLocal.setMinimum(minFreq);
        clockSourceSpinnerLocal.setMaximum(maxFreq);
        clockSourceSpinnerLocal.setSelection(defaultFreq);
        this.mhzLabel = new Label(this.clockComposite, 0);
        this.mhzLabel.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        Objects.requireNonNull(this.mhzLabel).setText(Messages.MHzLabel);
        clockSourceSpinnerLocal.addListener(13, e -> this.updateClockSource());
        this.updateClockSource();
        Objects.requireNonNull(this.clockSourceLabel).setVisible(false);
        clockSourceSpinnerLocal.setVisible(false);
    }

    protected void updateClockSource() {
        JTAGConnection jtagConnection = this.getCurrentConnection();
        if (jtagConnection != null && this.clockSourceSpinner != null) {
            jtagConnection.setClockSource(this.clockSourceSpinner.getSelection());
        }
    }

    protected void setJtagConnectionType(String type) {
        JTAGConnection jtagConnection = this.getCurrentConnection();
        if (jtagConnection != null) {
            jtagConnection.setUsbConnection(type.equals(Messages.UsbConnLabel));
        }
        this.connView.setConnectionInModel();
    }

    private void updateJtagHostname() {
        JTAGConnection jtagConnection = this.getCurrentConnection();
        if (jtagConnection != null) {
            jtagConnection.setHostname(this.hostIpText.getText());
            ValidationContext.getInstance().setCurrentConnection(jtagConnection);
        }
    }

    private void updateJtagUsbAddress() {
        JTAGConnection jtagConnection = this.getCurrentConnection();
        String selection = this.usbAddress.getText();
        if (jtagConnection != null && !selection.isEmpty()) {
            this.validateMACAddress(jtagConnection);
            jtagConnection.setUsbSerialNumber(selection);
            ValidationContext.getInstance().setCurrentConnection(jtagConnection);
        }
        this.connView.setConnectionInModel();
    }

    private void validateMACAddress(JTAGConnection jtagConnection) {
        String address = this.usbAddress.getText();
        Pattern pattern = Pattern.compile(MAC_PATTERN);
        Matcher matcher = pattern.matcher(address);
        if (matcher.matches()) {
            this.ctrlDecorator.hide();
            this.usbAddress.setBackground(null);
            jtagConnection.setValidMACAddress(true);
            this.btnTestConnection.setEnabled(true);
        } else {
            this.ctrlDecorator.show();
            this.usbAddress.setBackground(ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG"));
            jtagConnection.setValidMACAddress(false);
            this.btnTestConnection.setEnabled(false);
        }
    }

    private void updateUSBAddressList() {
        String[] availableProbe = ConnectionUtils.getAvailableProbe();
        String selection = this.usbAddress.getText();
        this.usbAddress.setItems(availableProbe);
        if (selection.isEmpty()) {
            this.usbAddress.select(0);
        }
    }

    public @Nullable JTAGConnection getCurrentConnection() {
        String currentConnection = this.connView.getConnectionCombo().getText();
        if (currentConnection == null || currentConnection.isEmpty()) {
            return null;
        }
        Object data = this.connView.getConnectionCombo().getData(currentConnection);
        if (!(data instanceof JTAGConnection) && !(data instanceof S32ProbeConnection)) {
            LOGGER.severe("Connection UI creation error - currentConnection should be of type JTAG Connection at this point");
            return null;
        }
        return (JTAGConnection)data;
    }

    public void setInput(JTAGConnection connection) {
        String ip = connection.isUsbConnection() ? connection.getUsbSerialNumber() : connection.getHostname();
        boolean isUsb = !connection.isUsbConnection();
        this.usbBtn.setSelection(!isUsb);
        this.ethernetBtn.setSelection(isUsb);
        if (isUsb) {
            this.hostIpText.setText(ip);
        } else {
            this.usbAddress.setText(ip);
        }
        this.ethernetBtn.notifyListeners(13, new Event());
    }

    public void setEnabled(boolean enabled) {
        this.hostIpText.setEnabled(enabled);
        this.ethernetBtn.setEnabled(enabled);
        this.usbAddress.setEnabled(enabled);
        this.usbBtn.setEnabled(enabled);
        this.btnTestConnection.setEnabled(enabled);
        this.btnScanProbe.setEnabled(enabled);
    }

    public void dispose() {
        super.dispose();
        this.usbEthComp.dispose();
        this.ethernetComp.dispose();
        this.hostIpText.dispose();
        this.usbComp.dispose();
        this.usbAddress.dispose();
        this.ethernetBtn.dispose();
        this.usbBtn.dispose();
        this.btnScanProbe.dispose();
        this.btnTestConnection.dispose();
    }
}

