/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.mem.validation.connections;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.files.UtilsDecryption;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.mem.validation.connections.ConnectionSetting;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.simpleframework.xml.Attribute;
import org.simpleframework.xml.ElementList;
import org.simpleframework.xml.Root;
import org.simpleframework.xml.core.Persister;

@Root(name="target_connections", strict=false)
public class TargetConnectionsSetting {
    private static final Logger LOGGER = LogManager.getLogger(TargetConnectionsSetting.class);
    @ElementList(inline=true, required=false)
    private ArrayList<ConnectionSetting> supportedConnections = new ArrayList();
    @Attribute(name="minClockFreq", required=false)
    private String minClockFreq = String.valueOf(20);
    @Attribute(name="maxClockFreq", required=false)
    private String maxClockFreq = String.valueOf(40);
    @Attribute(name="defaultClockFreq", required=false)
    private String defaultClockFreq = String.valueOf(40);

    public int getDefaultClockFreq() {
        return Integer.valueOf(this.defaultClockFreq);
    }

    public void setDefaultClockFreq(String defaultClockFreq) {
        this.defaultClockFreq = defaultClockFreq;
    }

    public int getMinClockFreq() {
        return Integer.valueOf(this.minClockFreq);
    }

    public void setMinClockFreq(int minClockFreq) {
        this.minClockFreq = String.valueOf(minClockFreq);
    }

    public int getMaxClockFreq() {
        return Integer.valueOf(this.maxClockFreq);
    }

    public void setMaxClockFreq(int maxClockFreq) {
        this.maxClockFreq = String.valueOf(maxClockFreq);
    }

    public List<ConnectionSetting> getSupportedConnections() {
        return this.supportedConnections;
    }

    public static @Nullable TargetConnectionsSetting loadConnectionsXml(String connXmlPath) {
        File connConfigFile = new File(connXmlPath);
        if (!connConfigFile.exists()) {
            return null;
        }
        try {
            Throwable throwable = null;
            Object var3_6 = null;
            try (InputStream connXmlInStr = UtilsDecryption.getFileInputStream((File)connConfigFile);){
                Persister serializer = new Persister();
                @Nullable TargetConnectionsSetting connections = (TargetConnectionsSetting)serializer.read(TargetConnectionsSetting.class, connXmlInStr);
                return connections;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Cannot read connections definition file. ", e);
            return null;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error loading the target_connections.xml. ", ex);
            return null;
        }
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof TargetConnectionsSetting) || !super.equals(obj)) {
            return false;
        }
        TargetConnectionsSetting other = (TargetConnectionsSetting)obj;
        return this.supportedConnections.equals(other.supportedConnections);
    }

    public int hashCode() {
        return Objects.hashCode(this.supportedConnections);
    }
}

