/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.EScaleType;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class GeometricTimingScale
extends TimingScale {
    @NonNull
    private static final BigInteger MAX_EXPONENT = BigRational.NewBigInteger((int)256);
    @NonNull
    protected BigRational mul;
    @NonNull
    protected TimingScale.INextVal prev;

    protected static final @NonNull BigInteger powBI(@NonNull BigInteger n, int k) {
        @NonNull BigInteger tmpc = ONE;
        int texp = k;
        while (texp > 0) {
            BigInteger x = n;
            int i = 1;
            while (i * 2 < texp) {
                x = GeometricTimingScale.mulNN(x, x);
                i *= 2;
            }
            if (i * 2 == texp) {
                i *= 2;
                x = GeometricTimingScale.mulNN(x, x);
            }
            tmpc = GeometricTimingScale.mulNN(tmpc, x);
            texp -= i;
        }
        return tmpc;
    }

    protected static final @NonNull BigInteger sqrtRoundLow(@NonNull BigInteger x, @NonNull BigInteger base) {
        switch (ONE.compareTo(x)) {
            case 1: {
                assert (false) : "Negative input for sqrtRoundLow x";
                break;
            }
            case 0: {
                return ONE;
            }
            case -1: {
                break;
            }
            default: {
                assert (false) : "Method compareTo returned other value than expected -1,0,1";
                break;
            }
        }
        if (base.compareTo(x) >= 0) {
            return ONE;
        }
        @NonNull BigInteger res = ONE;
        @NonNull BigInteger storedBase = ONE;
        BigInteger actualBase = base;
        @NonNull BigInteger oldStoredBase = ONE;
        BigInteger xModified = x;
        while (true) {
            if (actualBase.compareTo(xModified) < 0) {
                oldStoredBase = storedBase;
                storedBase = actualBase;
                actualBase = GeometricTimingScale.mulNN(actualBase, actualBase);
                continue;
            }
            if (actualBase.equals(xModified)) break;
            res = GeometricTimingScale.mulNN(res, oldStoredBase);
            xModified = GeometricTimingScale.divNN(xModified, storedBase);
            storedBase = ONE;
            oldStoredBase = ONE;
            actualBase = base;
        }
        res = GeometricTimingScale.mulNN(res, storedBase);
        return res;
    }

    protected static final @NonNull BigRational sqrtRoundLow(@NonNull BigRational x, @NonNull BigRational base) {
        switch (BigRational.ONE.compareTo(x)) {
            case 1: {
                assert (false) : "Negative input for sqrtRoundLow x";
                break;
            }
            case 0: {
                return BigRational.ONE;
            }
            case -1: {
                break;
            }
            default: {
                assert (false) : "Method compareTo returned other value than expected -1,0,1";
                break;
            }
        }
        if (base.compareTo(x) >= 0) {
            return BigRational.ONE;
        }
        @NonNull BigRational res = BigRational.ONE;
        @NonNull BigRational storedBase = BigRational.ONE;
        BigRational actualBase = base;
        @NonNull BigRational oldStoredBase = BigRational.ONE;
        BigRational xModified = x;
        while (true) {
            if (actualBase.compareTo(xModified) < 0) {
                oldStoredBase = storedBase;
                storedBase = actualBase;
                actualBase = actualBase.multiply(actualBase);
                continue;
            }
            if (actualBase.equals((Object)xModified)) break;
            res = res.multiply(oldStoredBase);
            xModified = xModified.divide(storedBase);
            storedBase = BigRational.ONE;
            oldStoredBase = BigRational.ONE;
            actualBase = base;
        }
        res = res.multiply(storedBase);
        return res;
    }

    public GeometricTimingScale(@NonNull BigInteger fromScale, @NonNull BigInteger toScale, @NonNull BigInteger mulFactor) {
        this(new BigRational(fromScale), new BigRational(toScale), new BigRational(mulFactor));
        this.nxt = p -> p.multiply(mulFactor);
        this.prev = q -> q.divide(mulFactor);
    }

    public GeometricTimingScale(@NonNull BigRational fromScale, @NonNull BigRational toScale, @NonNull BigRational mulFactor) {
        this.from = fromScale;
        this.nxt = p -> p.multiply(mulFactor);
        this.prev = q -> q.divide(mulFactor);
        this.to = toScale;
        this.mul = mulFactor;
        this.type = EScaleType.GeometricSmall;
        if (toScale.equals((Object)fromScale)) {
            this.numOfScales = ONE;
        } else {
            int partialExp;
            @NonNull BigRational actRatio = toScale.divide(fromScale);
            int exp = 0;
            while (true) {
                BigRational actMulFactor;
                if (actRatio.compareTo(mulFactor) < 0) {
                    throw new ArithmeticException("Not a propper geometric scaling! (scale range not a power of multiplying factor)");
                }
                @NonNull BigRational oldMulFactor = actMulFactor = mulFactor;
                partialExp = 1;
                while (actMulFactor.compareTo(actRatio) < 0) {
                    oldMulFactor = actMulFactor;
                    actMulFactor = actMulFactor.multiply(actMulFactor);
                    partialExp *= 2;
                }
                if (actMulFactor.compareTo(actRatio) == 0) break;
                actRatio = actRatio.divide(oldMulFactor);
                exp += partialExp / 2;
            }
            actRatio = toScale.divide(fromScale);
            @NonNull BigRational tmpc = GeometricTimingScale.powBI(mulFactor, exp += partialExp);
            if (!tmpc.equals((Object)actRatio)) {
                throw new ArithmeticException("Not a propper geometric scaling! (scale range not a power of multiplying factor)");
            }
            byte[] arr = new byte[4];
            arr[3] = (byte)(exp & 0xFF);
            arr[2] = (byte)((exp >>= 8) & 0xFF);
            arr[1] = (byte)((exp >>= 8) & 0xFF);
            arr[0] = (byte)((exp >>= 8) & 0xFF);
            this.numOfScales = GeometricTimingScale.addNN(ONE, new BigInteger(arr));
        }
    }

    @Override
    public int hashCode() {
        return this.from.getNumerator().intValue() ^ this.to.getNumerator().intValue() ^ this.numOfScales.intValue() ^ this.mul.getNumerator().intValue() ^ this.type.ordinal();
    }

    @Override
    public boolean equals(Object arg) {
        if (arg == this) {
            return true;
        }
        if (arg == null) {
            return false;
        }
        if (arg.getClass() != this.getClass()) {
            return false;
        }
        GeometricTimingScale as = (GeometricTimingScale)arg;
        if (this.type != as.type) {
            return false;
        }
        if (!this.from.equals((Object)as.from)) {
            return false;
        }
        if (!this.to.equals((Object)as.to)) {
            return false;
        }
        if (!this.numOfScales.equals(as.numOfScales)) {
            return false;
        }
        return this.mul.equals((Object)as.mul);
    }

    @Override
    public boolean inRange(@Nullable BigRational value) {
        if (value == null) {
            return false;
        }
        return value.compareTo(this.from) >= 0 && value.compareTo(this.to) <= 0;
    }

    @Override
    public Iterator<BigRational> iterator() {
        Iterator<BigRational> it = new Iterator<BigRational>(){
            @NonNull
            private BigRational p;
            {
                this.p = GeometricTimingScale.this.from;
            }

            @Override
            public boolean hasNext() {
                return this.p.compareTo(GeometricTimingScale.this.to) <= 0;
            }

            @Override
            public BigRational next() {
                if (this.p.compareTo(GeometricTimingScale.this.to) > 0) {
                    throw new NoSuchElementException();
                }
                @NonNull BigRational ret = this.p;
                this.p = this.p.multiply(GeometricTimingScale.this.mul);
                return ret;
            }
        };
        return it;
    }

    @Override
    public @NonNull TimingScale.IntervalNarrowingContext getInitialMiddle() {
        if (this.numOfScales.compareTo(MAX_EXPONENT) > 0) {
            throw new ArithmeticException("Exponent out of range");
        }
        int numOfValsLong = this.numOfScales.intValue();
        int ncount = numOfValsLong / 2;
        int numsMid = ncount + 1;
        @NonNull BigRational midVal = this.from.multiply(GeometricTimingScale.powBI(this.mul, ncount));
        return new TimingScale.IntIntervalNarrowingContext(this.from, midVal, this.to, numOfValsLong, numsMid, this.mul, true);
    }

    @Override
    @NonNull TimingScale.IntervalNarrowingContext getValInMiddleR(@NonNull TimingScale.IntervalNarrowingContext interval) {
        interval.halfMidVal();
        interval.newMidVal();
        return interval;
    }

    @Override
    public @NonNull TimingScale.INextVal getPrevValFun() {
        return this.prev;
    }
}

