/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.NodeSimpleCon;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.util.List;

public class Gate
extends NodeSimpleCon {
    @Nullable
    protected BigRational inputClock = null;

    public Gate(@NonNull String id) {
        super(id, ENodeType.Gate);
    }

    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        String ps = null;
        ps = this.pred != null ? this.pred.id : "";
        String cs = null;
        cs = this.inputClock == null ? "" : "@" + this.inputClock;
        System.out.println(String.valueOf(pref) + "+--" + this.id + "(" + ps + ")" + cs);
        if (this.child != null) {
            if ("".equals(prefLast)) {
                this.child.printT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    ");
            } else {
                this.child.printT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     ");
            }
        }
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        StringBuffer ps = new StringBuffer();
        if (this.pred != null) {
            ps.append(this.pred.id);
        }
        StringBuffer cs = new StringBuffer();
        if (this.inputClock != null) {
            cs.append('@');
            cs.append(this.inputClock);
        }
        StringBuffer res = new StringBuffer(pref);
        res.append("+--");
        res.append(this.id);
        res.append('(');
        res.append(ps);
        res.append(')');
        res.append(cs);
        res.append('\n');
        if (this.child != null) {
            if ("".equals(prefLast)) {
                res.append(this.child.stringT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    "));
            } else {
                res.append(this.child.stringT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     "));
            }
        }
        return res;
    }

    @Override
    public boolean isSet(@NonNull List<@NonNull Node> unset) {
        return true;
    }

    @Override
    public boolean isSetOrDefault(@NonNull List<@NonNull Node> unset) {
        return true;
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return true;
        }
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        boolean res = true;
        this.inputClock = clock;
        if (!this.checkInputFreq(this.inputClock)) {
            res = false;
        }
        if (!this.checkOutputFreq(clock)) {
            res = false;
        }
        if (this.child.compute(this, clock)) {
            return res;
        }
        return false;
    }

    @Override
    public BigRational[] prepareAuto(@NonNull Node callee, boolean sendFreq) {
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        return this.child.prepareAuto(this, sendFreq && this.enabled);
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        this.wasComputed = true;
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        assert (this.child != null) : "Null child in gate " + this.id;
        EErrorType sbr = this.testInputFreq(clock);
        if (sbr != EErrorType.None) {
            return sbr;
        }
        sbr = this.testOutputFreq(clock);
        if (sbr != EErrorType.None) {
            return sbr;
        }
        this.inputClock = clock;
        this.lastComp = ECompState.OnceSatisfied;
        EErrorType nres = this.child.computeAutoWR(this, clock);
        if (nres == EErrorType.None || nres == EErrorType.NotEnabled) {
            this.lastComp = ECompState.OnceSubtreeOK;
            return EErrorType.None;
        }
        return nres;
    }

    @Override
    public @Nullable BigRational getOutputClock() {
        return this.inputClock;
    }

    @Override
    public @Nullable BigRational getInputClock() {
        return this.inputClock;
    }

    @Override
    public @NonNull List<@NonNull Node> getDirectlyConnectedTo(@NonNull Node callee, @NonNull Node node) {
        assert (this.child != null) : "Null child in gate " + this.id;
        @NonNull List<@NonNull Node> res = this.child.getDirectlyConnectedTo(this, node);
        if (this == node) {
            res.add(this);
        }
        return res;
    }

    @Override
    public void resetInputOutputClock() {
        this.inputClock = null;
    }
}

