/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.model;

import com.nxp.swtools.clocks.model.Clock;
import com.nxp.swtools.clocks.model.ECompState;
import com.nxp.swtools.clocks.model.EErrorType;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.model.FreqLimitErrorI;
import com.nxp.swtools.clocks.model.Node;
import com.nxp.swtools.clocks.model.TimingScale;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.rational.BigRatComparator;
import com.nxp.swtools.common.utils.rational.BigRational;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.Comparator;
import java.util.List;

public class ClockGeneratorRational
extends Clock {
    @NonNull
    private BigInteger multiplierMin;
    @NonNull
    private BigInteger multiplierMax;
    @NonNull
    private BigInteger mul;
    @NonNull
    private BigInteger numeratorMin;
    @NonNull
    private BigInteger numeratorMax;
    @NonNull
    private BigInteger numerator;
    @NonNull
    private BigInteger denominatorMin;
    @NonNull
    private BigInteger denominatorMax;
    @NonNull
    private BigInteger denominator;
    @NonNull
    private BigInteger fractionMin;
    @NonNull
    private BigInteger fractionMax;
    private boolean fractionMinEq;
    private boolean fractionMaxEq;
    @Nullable
    private List<@NonNull BigRational> suitableFrequencies;
    @Nullable
    private BigRational inputFreq;

    public ClockGeneratorRational(@NonNull String id) {
        super(id, ENodeType.ClockGeneratorRat);
        this.multiplierMin = this.multiplierMax = TimingScale.ZERO;
        this.mul = this.multiplierMax;
        this.numeratorMax = this.numeratorMin = TimingScale.ZERO;
        this.numerator = this.numeratorMin;
        this.denominatorMax = this.denominatorMin = TimingScale.ONE;
        this.denominator = this.denominatorMin;
        this.fractionMin = this.fractionMax = TimingScale.ONE;
        this.fractionMaxEq = true;
        this.fractionMinEq = true;
        this.suitableFrequencies = null;
        this.inputFreq = BigRational.ONE;
    }

    @Override
    public boolean setOutputFrequency(@NonNull BigRational freq) {
        boolean res = super.setOutputFrequency(freq);
        if (!res) {
            return false;
        }
        EErrorType qualRes = this.reverseCompute(freq);
        if (qualRes != EErrorType.None) {
            FreqLimitErrorI xxLogFLE = this.logFLE;
            if (xxLogFLE != null && this.enabled) {
                xxLogFLE.logFreqLimitError(false, this);
            }
            return false;
        }
        return true;
    }

    @Override
    public void printT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        String ps = null;
        ps = this.pred != null ? this.pred.id : "";
        String fs = null;
        fs = this.freq != null ? "&" + this.freq + "M:" + this.mul + "N:" + this.numerator + "D:" + this.denominator : "";
        System.out.println(String.valueOf(pref) + "+--" + this.id + "(" + ps + ")" + fs);
        if (this.child != null) {
            if ("".equals(prefLast)) {
                this.child.printT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    ");
            } else {
                this.child.printT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     ");
            }
        }
    }

    @Override
    public @NonNull StringBuffer stringT(@NonNull Node callee, @NonNull String pref, @NonNull String prefLast) {
        StringBuffer ps = new StringBuffer();
        if (this.pred != null) {
            ps.append(this.pred.id);
        }
        StringBuffer fs = new StringBuffer();
        if (this.freq != null) {
            fs.append('&');
            fs.append(this.freq);
            fs.append("M:");
            fs.append(this.mul);
            fs.append("N:");
            fs.append(this.numerator);
            fs.append("D:");
            fs.append(this.denominator);
        }
        StringBuffer res = new StringBuffer(pref);
        res.append("+--");
        res.append(this.id);
        res.append('(');
        res.append(ps);
        res.append(')');
        res.append(fs);
        res.append('\n');
        if (this.child != null) {
            if ("".equals(prefLast)) {
                res.append(this.child.stringT(this, String.valueOf(pref) + "|    ", String.valueOf(pref) + "|    "));
            } else {
                res.append(this.child.stringT(this, String.valueOf(prefLast) + "     ", String.valueOf(prefLast) + "     "));
            }
        }
        return res;
    }

    public void setInputFreq(@Nullable BigRational inputFreq) {
        if (inputFreq == null) {
            throw new UnsupportedOperationException("Method setInputFreq requires non-null input for this class");
        }
        this.inputFreq = inputFreq;
    }

    @Override
    public void setMinInputFreq(@Nullable BigRational minInputFreq) {
        if (minInputFreq == null) {
            throw new UnsupportedOperationException("Method setMinInputFreq requires non-null input for this class");
        }
        this.minInputFreq = minInputFreq;
        this.inputFrequencyRanges = null;
    }

    @Override
    public void setMaxInputFreq(@Nullable BigRational maxInputFreq) {
        if (maxInputFreq == null) {
            throw new UnsupportedOperationException("Method setMaxInputFreq requires non-null input for this class");
        }
        this.maxInputFreq = maxInputFreq;
        this.inputFrequencyRanges = null;
    }

    private boolean evalNewValues() {
        BigRational inputFreqLoc = this.inputFreq;
        assert (inputFreqLoc != null);
        BigRational res = inputFreqLoc.multiply(this.mul);
        BigRational fres = inputFreqLoc.multiply(this.numerator).divide(this.denominator);
        if (this.testOutputFreq(res = res.add(fres)) != EErrorType.None) {
            return false;
        }
        this.setOutputFrequency(res);
        return true;
    }

    @Override
    public void setAllowedLimits(@NonNull BigInteger mulLow, @NonNull BigInteger mulMax, @NonNull BigInteger numMax, @NonNull BigInteger denMax, @NonNull BigInteger numMin, @NonNull BigInteger denMin, @NonNull BigInteger fractionMin, @NonNull BigInteger fractionMax, boolean fractionMinEq, boolean fractionMaxEq) {
        this.multiplierMin = mulLow;
        this.multiplierMax = mulMax;
        this.numeratorMax = numMax;
        this.denominatorMax = denMax;
        this.numeratorMin = numMin;
        this.denominatorMin = denMin;
        this.fractionMin = fractionMin;
        this.fractionMax = fractionMax;
        this.fractionMinEq = fractionMinEq;
        this.fractionMaxEq = fractionMaxEq;
        if (this.denominatorMin.compareTo(TimingScale.ONE) < 0) {
            this.denominatorMin = TimingScale.ONE;
        }
        boolean recompute = false;
        if (this.denominator.compareTo(this.denominatorMax) > 0) {
            recompute = true;
            this.denominator = this.denominatorMax;
        } else if (this.denominator.compareTo(this.denominatorMin) < 0) {
            recompute = true;
            this.denominator = this.denominatorMin;
        }
        if (this.numerator.compareTo(this.numeratorMax) > 0) {
            recompute = true;
            this.numerator = this.numeratorMax;
        } else if (this.numerator.compareTo(this.numeratorMin) < 0) {
            recompute = true;
            this.numerator = this.numeratorMin;
        }
        if (this.numerator.compareTo(this.denominator) > 0) {
            recompute = true;
            this.numerator = this.denominator;
        }
        if (this.mul.compareTo(this.multiplierMax) > 0) {
            recompute = true;
            this.mul = this.multiplierMax;
        } else if (this.mul.compareTo(this.multiplierMin) < 0) {
            recompute = true;
            this.mul = this.multiplierMin;
        }
        if (recompute) {
            if (this.evalNewValues()) {
                return;
            }
            BigRational actFreq = this.freq;
            if (actFreq == null || this.reverseCompute(actFreq) != EErrorType.None) {
                this.mul = TimingScale.ZERO;
                this.numerator = TimingScale.ZERO;
                this.denominator = TimingScale.ONE;
                this.freq = null;
            }
        }
    }

    @Override
    public void setAccuracy(@NonNull BigRational acc) {
        this.accuracy = acc;
        assert (this.accuracy.compareTo(BigRational.ZERO) >= 0);
    }

    @Override
    public boolean setGeneratorValues(@NonNull BigInteger mulFactor, @NonNull BigInteger numerator, @NonNull BigInteger denominator) {
        if (mulFactor.compareTo(this.multiplierMin) < 0 || mulFactor.compareTo(this.multiplierMax) > 0) {
            return false;
        }
        if (numerator.compareTo(this.numeratorMin) < 0 || numerator.compareTo(this.numeratorMax) > 0) {
            return false;
        }
        if (denominator.compareTo(this.denominatorMin) < 0 || denominator.compareTo(this.denominatorMax) > 0) {
            return false;
        }
        if (!this.isFnRangeAllowed(numerator, denominator)) {
            return false;
        }
        BigRational inputFreqLoc = this.inputFreq;
        assert (inputFreqLoc != null);
        BigRational res = inputFreqLoc.multiply(mulFactor);
        BigRational fres = inputFreqLoc.multiply(numerator).divide(denominator);
        this.freq = res = res.add(fres);
        this.reverseCompute(res);
        this.mul = mulFactor;
        this.numerator = numerator;
        this.denominator = denominator;
        return this.testOutputFreq(res) == EErrorType.None;
    }

    private boolean isFnRangeAllowed(@NonNull BigInteger num, @NonNull BigInteger denom) {
        boolean isBellowMax;
        boolean isAboveMin;
        BigRational fraction = new BigRational(num, denom);
        int fnMin = fraction.compareTo(this.fractionMin);
        int fnMax = fraction.compareTo(this.fractionMax);
        boolean bl = this.fractionMinEq ? fnMin >= 0 : (isAboveMin = fnMin > 0);
        boolean bl2 = this.fractionMaxEq ? fnMax <= 0 : (isBellowMax = fnMax < 0);
        return isAboveMin && isBellowMax;
    }

    @Override
    public boolean compute(@NonNull Node callee, @NonNull BigRational clock) {
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.wasComputed = true;
        this.setInputFreq(clock);
        this.computeForInput();
        BigRational locFreq = this.freq;
        assert (locFreq != null) : "Clock " + this.id + "not initialized properly";
        boolean res = true;
        res &= this.checkInputFreq(clock);
        res &= this.checkOutputFreq(this.freq);
        return res &= this.child.compute(this, locFreq);
    }

    private @NonNull EErrorType computeForInput() {
        BigRational inputFreqLoc = this.inputFreq;
        assert (inputFreqLoc != null) : "The input frequency must be set, it is the only required value!";
        BigRational locMaxOutputFreq = this.maxOutputFreq;
        BigRational locMinOutputFreq = this.minOutputFreq;
        BigRational resultingFreq = inputFreqLoc.multiply(this.mul);
        BigRational rationalTmpFreq = inputFreqLoc.multiply(new BigRational(this.numerator, this.denominator));
        resultingFreq = resultingFreq.add(rationalTmpFreq);
        BigRational ac = BigRational.ZERO;
        EErrorType res = EErrorType.None;
        if (locMaxOutputFreq != null && resultingFreq.compareTo(locMaxOutputFreq) > 0) {
            ac = resultingFreq.divide(locMaxOutputFreq).subtract(BigRational.ONE);
            res = EErrorType.TooFast;
        } else if (locMinOutputFreq != null && resultingFreq.compareTo(locMinOutputFreq) < 0) {
            ac = locMinOutputFreq.divide(resultingFreq).subtract(BigRational.ONE);
            res = EErrorType.TooSlow;
        }
        this.freq = resultingFreq;
        if (ac.compareTo(this.accuracy) > 0) {
            return res;
        }
        return EErrorType.None;
    }

    @Override
    public BigRational[] prepareAuto(@NonNull Node callee, boolean sendFreq) {
        assert (!this.called) : "Node " + this.id + " called 2nd times, now from " + callee.id;
        this.called = true;
        this.child.prepareAuto(this, false);
        return null;
    }

    @Override
    public void closeAuto() {
    }

    @Override
    public @NonNull EErrorType computeAutoWR(@NonNull Node callee, @NonNull BigRational clock) {
        EErrorType actRes;
        if (!this.enabled) {
            return EErrorType.NotEnabled;
        }
        if (this.lastComp == ECompState.NoComp) {
            this.lastComp = ECompState.AlwaysFailes;
        }
        assert (this.child != null) : "Null child in clock source " + this.id;
        BigRational locFreq = this.freq;
        if (locFreq != null) {
            EErrorType res = this.testInputFreq(clock);
            this.wasComputed = true;
            this.lastComp = ECompState.OnceSatisfied;
            EErrorType childRes = this.child.computeAutoWR(this, locFreq);
            if (childRes == EErrorType.None || childRes == EErrorType.NotEnabled) {
                this.lastComp = ECompState.OnceSubtreeOK;
                return res;
            }
            return childRes;
        }
        List<@NonNull BigRational> tmpSuitableFreqs = this.suitableFrequencies;
        if (tmpSuitableFreqs == null) {
            return EErrorType.ClockNotSet;
        }
        int low = 0;
        int high = tmpSuitableFreqs.size() - 1;
        int mid = high / 2;
        EErrorType res = this.testInputFreq(clock);
        this.setInputFreq(clock);
        this.wasComputed = true;
        if (!(this.mul.equals(BigInteger.ZERO) || this.numerator.equals(BigInteger.ZERO) || this.denominator.equals(BigInteger.ZERO))) {
            this.computeForInput();
        }
        if ((locFreq = this.freq) != null && this.checkOutputFreq(locFreq) && ((actRes = this.child.computeAutoWR(this, locFreq)) == EErrorType.None || actRes == EErrorType.NotEnabled)) {
            this.lastComp = ECompState.OnceSubtreeOK;
            return res;
        }
        do {
            if ((actRes = this.testOutputFreq(locFreq = tmpSuitableFreqs.get(mid))) == EErrorType.None && (actRes = this.reverseCompute(locFreq)) == EErrorType.None) {
                this.lastComp = ECompState.OnceSatisfied;
                actRes = this.child.computeAutoWR(this, locFreq);
                if (actRes == EErrorType.None || actRes == EErrorType.NotEnabled) {
                    this.lastComp = ECompState.OnceSubtreeOK;
                    return res;
                }
            }
            if (actRes == EErrorType.TooSlow) {
                low = mid + 1;
            } else {
                if (actRes != EErrorType.TooFast) break;
                high = mid - 1;
            }
            mid = (high + low) / 2;
        } while (low <= high);
        if (actRes == EErrorType.BothFastSlow) {
            int i = 0;
            while (i < tmpSuitableFreqs.size()) {
                locFreq = tmpSuitableFreqs.get(i);
                actRes = this.testOutputFreq(locFreq);
                if (actRes == EErrorType.None && (actRes = this.reverseCompute(locFreq)) == EErrorType.None) {
                    this.lastComp = ECompState.OnceSatisfied;
                    actRes = this.child.computeAutoWR(this, locFreq);
                    if (actRes == EErrorType.None || actRes == EErrorType.NotEnabled) {
                        this.lastComp = ECompState.OnceSubtreeOK;
                        return res;
                    }
                }
                ++i;
            }
        }
        return EErrorType.CannotSetup;
    }

    @Override
    public EErrorType reverseCompute(@NonNull BigRational requiredFreq) {
        EErrorType res;
        BigRational ac;
        BigInteger tmpNum;
        BigInteger tmpDen;
        BigRational ac2;
        BigRational inputFreqLoc = this.inputFreq;
        assert (inputFreqLoc != null) : "The input frequency limit must be set, it is the required only possible value!";
        BigRational locMaxOutputFreq = this.maxOutputFreq;
        BigRational locMinOutputFreq = this.minOutputFreq;
        if (locMaxOutputFreq != null && requiredFreq.compareTo(locMaxOutputFreq) > 0) {
            ac2 = requiredFreq.divide(locMaxOutputFreq);
            if ((ac2 = ac2.subtract(BigRational.ONE)).compareTo(this.accuracy) > 0) {
                return EErrorType.TooFast;
            }
            requiredFreq = locMaxOutputFreq;
        } else if (locMinOutputFreq != null && requiredFreq.compareTo(this.minOutputFreq) < 0) {
            ac2 = locMinOutputFreq.divide(requiredFreq);
            if ((ac2 = ac2.subtract(BigRational.ONE)).compareTo(this.accuracy) > 0) {
                return EErrorType.TooSlow;
            }
            requiredFreq = locMinOutputFreq;
        }
        BigRational requiredRatio = requiredFreq.divide(inputFreqLoc);
        BigInteger intPart = requiredRatio.getNumerator().divide(requiredRatio.getDenominator());
        assert (intPart != null);
        if (intPart.compareTo(this.multiplierMin) < 0) {
            return EErrorType.TooSlow;
        }
        if (intPart.compareTo(this.multiplierMax) > 0) {
            return EErrorType.TooFast;
        }
        BigRational rationalPart = requiredRatio.subtract(intPart);
        assert (rationalPart.compareTo(BigRational.ONE) <= 0);
        if (rationalPart.getNumerator().compareTo(this.numeratorMax) > 0) {
            tmpDen = rationalPart.getDenominator().multiply(this.numeratorMax);
            assert (tmpDen != null);
            tmpDen = tmpDen.divide(rationalPart.getNumerator());
            assert (tmpDen != null);
            rationalPart = new BigRational(this.numeratorMax, tmpDen, true);
        } else if (rationalPart.getNumerator().compareTo(this.numeratorMin) < 0) {
            tmpDen = rationalPart.getDenominator().multiply(this.numeratorMin);
            assert (tmpDen != null);
            tmpDen = tmpDen.divide(rationalPart.getNumerator());
            assert (tmpDen != null);
            rationalPart = new BigRational(this.numeratorMin, tmpDen, true);
        }
        if (rationalPart.getDenominator().compareTo(this.denominatorMax) > 0) {
            tmpNum = rationalPart.getNumerator().multiply(this.denominatorMax);
            assert (tmpNum != null);
            tmpNum = tmpNum.divide(rationalPart.getDenominator());
            assert (tmpNum != null);
            if (tmpNum.compareTo(this.numeratorMin) < 0) {
                tmpNum = this.numeratorMin;
            } else if (tmpNum.compareTo(this.numeratorMax) > 0) {
                tmpNum = this.numeratorMax;
            }
            rationalPart = new BigRational(tmpNum, this.denominatorMax, true);
        } else if (rationalPart.getDenominator().compareTo(this.denominatorMin) < 0) {
            tmpNum = rationalPart.getNumerator().multiply(this.denominatorMin);
            assert (tmpNum != null);
            tmpNum = tmpNum.divide(rationalPart.getDenominator());
            assert (tmpNum != null);
            if (tmpNum.compareTo(this.numeratorMin) < 0) {
                tmpNum = this.numeratorMin;
            } else if (tmpNum.compareTo(this.numeratorMax) > 0) {
                tmpNum = this.numeratorMax;
            }
            rationalPart = new BigRational(tmpNum, this.denominatorMin, true);
        }
        BigRational resultingFreq = inputFreqLoc.multiply(intPart);
        BigRational rationalTmpRes = inputFreqLoc.multiply(rationalPart);
        resultingFreq = resultingFreq.add(rationalTmpRes);
        if (resultingFreq.compareTo(requiredFreq) > 0) {
            ac = resultingFreq.divide(requiredFreq);
            res = EErrorType.TooSlow;
        } else {
            ac = requiredFreq.divide(resultingFreq);
            res = EErrorType.TooFast;
        }
        ac = ac.subtract(BigRational.ONE);
        if (ac.compareTo(this.accuracy) > 0) {
            return res;
        }
        this.mul = intPart;
        if (new BigRational(this.numerator, this.denominator).compareTo(rationalPart) != 0) {
            this.numerator = rationalPart.getNumerator();
            this.denominator = rationalPart.getDenominator();
        }
        this.freq = resultingFreq;
        return EErrorType.None;
    }

    @Override
    public @NonNull BigInteger getMul() {
        return this.mul;
    }

    @Override
    public @NonNull BigInteger getNumerator() {
        return this.numerator;
    }

    @Override
    public @NonNull BigInteger getDenominator() {
        return this.denominator;
    }

    @Override
    public void setSuitableFrequencies(@Nullable List<@NonNull BigRational> suitableFrequencies) {
        List<@NonNull BigRational> tmpSuitableFreqs = suitableFrequencies;
        if (tmpSuitableFreqs != null) {
            tmpSuitableFreqs.sort((Comparator<BigRational>)new BigRatComparator());
        }
        this.suitableFrequencies = tmpSuitableFreqs;
    }

    @Override
    public void clean() {
        this.freq = null;
    }

    @Override
    public @Nullable BigRational getOutputClock() {
        return this.freq;
    }

    public @NonNull BigRational findNearFrequency(@NonNull BigRational requiredFreq, boolean mulLocked, boolean numLocked, boolean denomLocked) {
        BigRational lowestAndRequiredDiff;
        BigInteger minimalDenominator;
        BigInteger maximalNumerator;
        BigInteger tmpNum;
        BigInteger tmpDen;
        BigRational inputFreqLoc = this.inputFreq;
        assert (inputFreqLoc != null) : "The input frequency limit must be set, it is the required only possible value!";
        if (mulLocked && numLocked && denomLocked) {
            return this.freq != null ? this.freq : inputFreqLoc.multiply(new BigRational(this.numerator, this.denominator).add(this.mul));
        }
        BigRational locMaxOutputFreq = this.maxOutputFreq;
        BigRational locMinOutputFreq = this.minOutputFreq;
        if (locMaxOutputFreq != null && requiredFreq.compareTo(locMaxOutputFreq) > 0) {
            requiredFreq = locMaxOutputFreq;
        } else if (locMinOutputFreq != null && requiredFreq.compareTo(this.minOutputFreq) < 0) {
            requiredFreq = locMinOutputFreq;
        }
        BigRational requiredRatio = requiredFreq.divide(inputFreqLoc);
        BigInteger intPart = requiredRatio.getNumerator().divide(requiredRatio.getDenominator());
        BigRational rationalPart = requiredRatio.subtract(intPart);
        assert (rationalPart.compareTo(BigRational.ONE) <= 0);
        if (intPart.compareTo(this.multiplierMin) < 0) {
            intPart = this.multiplierMin;
            rationalPart = BigRational.ZERO;
        } else if (intPart.compareTo(this.multiplierMax) > 0) {
            intPart = this.multiplierMax;
            rationalPart = new BigRational(this.denominatorMax.subtract(BigInteger.ONE), this.denominatorMax);
        }
        if (rationalPart.getNumerator().compareTo(this.numeratorMax) > 0) {
            tmpDen = rationalPart.getDenominator().multiply(this.numeratorMax);
            tmpDen = tmpDen.divide(rationalPart.getNumerator());
            rationalPart = new BigRational(this.numeratorMax, tmpDen, true);
        } else if (rationalPart.getNumerator().compareTo(this.numeratorMin) < 0) {
            tmpDen = rationalPart.getDenominator().multiply(this.numeratorMin);
            tmpDen = tmpDen.divide(rationalPart.getNumerator());
            rationalPart = new BigRational(this.numeratorMin, tmpDen, true);
        }
        if (rationalPart.getDenominator().compareTo(this.denominatorMax) > 0) {
            tmpNum = rationalPart.getNumerator().multiply(this.denominatorMax);
            if ((tmpNum = tmpNum.divide(rationalPart.getDenominator())).compareTo(this.numeratorMin) < 0) {
                tmpNum = this.numeratorMin;
            } else if (tmpNum.compareTo(this.numeratorMax) > 0) {
                tmpNum = this.numeratorMax;
            }
            rationalPart = new BigRational(tmpNum, this.denominatorMax, true);
        } else if (rationalPart.getDenominator().compareTo(this.denominatorMin) < 0) {
            tmpNum = rationalPart.getNumerator().multiply(this.denominatorMin);
            if ((tmpNum = tmpNum.divide(rationalPart.getDenominator())).compareTo(this.numeratorMin) < 0) {
                tmpNum = this.numeratorMin;
            } else if (tmpNum.compareTo(this.numeratorMax) > 0) {
                tmpNum = this.numeratorMax;
            }
            rationalPart = new BigRational(tmpNum, this.denominatorMin, true);
        }
        if (!mulLocked) {
            BigRational lowestAndRequiredDiff2;
            if (numLocked && denomLocked) {
                BigRational lockedRational = new BigRational(this.numerator, this.denominator);
                BigInteger addition = rationalPart.subtract(lockedRational).toBigIntegerRounded(RoundingMode.HALF_UP);
                if ((intPart = intPart.add(addition)).compareTo(this.multiplierMin) < 0) {
                    intPart = this.multiplierMin;
                } else if (intPart.compareTo(this.multiplierMax) > 0) {
                    intPart = this.multiplierMax;
                }
                return inputFreqLoc.multiply(lockedRational.add(intPart));
            }
            if (!numLocked && !denomLocked) {
                return inputFreqLoc.multiply(rationalPart.add(intPart));
            }
            if (!numLocked && denomLocked) {
                BigRational lowestAndRequiredDiff3;
                maximalNumerator = this.numeratorMax.compareTo(this.denominator) < 0 ? this.numeratorMax : this.denominator.subtract(BigInteger.ONE);
                BigRational highest = inputFreqLoc.multiply(new BigRational(maximalNumerator, this.denominator).add(intPart));
                BigRational lowest = inputFreqLoc.multiply(new BigRational(this.numeratorMin, this.denominator).add(intPart));
                BigRational highestAndRequiredDiff = highest.subtract(requiredFreq);
                if (highestAndRequiredDiff.multiply(lowestAndRequiredDiff3 = lowest.subtract(requiredFreq)).compareTo(BigRational.ZERO) < 0) {
                    BigInteger tmpNum2 = rationalPart.getNumerator().multiply(this.denominator);
                    if ((tmpNum2 = tmpNum2.divide(rationalPart.getDenominator())).compareTo(this.numeratorMin) < 0) {
                        tmpNum2 = this.numeratorMin;
                    } else if (tmpNum2.compareTo(this.numeratorMax) > 0) {
                        tmpNum2 = this.numeratorMax;
                    }
                    rationalPart = new BigRational(tmpNum2, this.denominator, true);
                    this.numerator = tmpNum2;
                    this.mul = intPart;
                    return inputFreqLoc.multiply(rationalPart.add(intPart));
                }
                if (highestAndRequiredDiff.abs().compareTo(lowestAndRequiredDiff3.abs()) < 0) {
                    return highest;
                }
                return lowest;
            }
            minimalDenominator = this.denominatorMin.compareTo(this.numerator) > 0 ? this.denominatorMin : this.numerator.add(BigInteger.ONE);
            BigRational upper = inputFreqLoc.multiply(new BigRational(this.numerator, this.denominatorMax).add(intPart.add(BigInteger.ONE)));
            BigRational highest = inputFreqLoc.multiply(new BigRational(this.numerator, minimalDenominator).add(intPart));
            BigRational lowest = inputFreqLoc.multiply(new BigRational(this.numerator, this.denominatorMax).add(intPart));
            BigRational highestAndRequiredDiff = highest.subtract(requiredFreq);
            if (highestAndRequiredDiff.multiply(lowestAndRequiredDiff2 = lowest.subtract(requiredFreq)).compareTo(BigRational.ZERO) < 0) {
                BigInteger tmpDen2 = rationalPart.getDenominator().multiply(this.numerator);
                if ((tmpDen2 = tmpDen2.divide(rationalPart.getNumerator())).compareTo(this.denominatorMin) < 0) {
                    tmpDen2 = this.denominatorMin;
                } else if (tmpDen2.compareTo(this.denominatorMax) > 0) {
                    tmpDen2 = this.denominatorMax;
                }
                rationalPart = new BigRational(this.numerator, tmpDen2, true);
                this.denominator = tmpDen2;
                this.mul = intPart;
                return inputFreqLoc.multiply(rationalPart.add(intPart));
            }
            if (highestAndRequiredDiff.abs().compareTo(lowestAndRequiredDiff2.abs()) < 0) {
                if (upper.subtract(requiredFreq).abs().compareTo(highestAndRequiredDiff.abs()) < 0) {
                    return upper;
                }
                return highest;
            }
            return lowest;
        }
        if (!numLocked && !denomLocked) {
            int comparison = intPart.compareTo(this.mul);
            if (comparison == 0) {
                return inputFreqLoc.multiply(rationalPart.add(this.mul));
            }
            if (comparison < 0) {
                return inputFreqLoc.multiply(this.mul);
            }
            rationalPart = this.denominatorMax.compareTo(this.numeratorMax) > 0 ? new BigRational(this.numeratorMax.subtract(BigInteger.ONE), this.numeratorMax) : new BigRational(this.denominatorMax.subtract(BigInteger.ONE), this.denominatorMax);
            return inputFreqLoc.multiply(rationalPart.add(this.mul));
        }
        if (!numLocked && denomLocked) {
            BigRational lowestAndRequiredDiff4;
            maximalNumerator = this.numeratorMax.compareTo(this.denominator) < 0 ? this.numeratorMax : this.denominator.subtract(BigInteger.ONE);
            BigRational highest = inputFreqLoc.multiply(new BigRational(maximalNumerator, this.denominator).add(this.mul));
            BigRational lowest = inputFreqLoc.multiply(new BigRational(this.numeratorMin, this.denominator).add(this.mul));
            BigRational highestAndRequiredDiff = highest.subtract(requiredFreq);
            if (highestAndRequiredDiff.multiply(lowestAndRequiredDiff4 = lowest.subtract(requiredFreq)).compareTo(BigRational.ZERO) < 0) {
                BigInteger tmpNum3 = rationalPart.getNumerator().multiply(this.denominator);
                if ((tmpNum3 = tmpNum3.divide(rationalPart.getDenominator())).compareTo(this.numeratorMin) < 0) {
                    tmpNum3 = this.numeratorMin;
                } else if (tmpNum3.compareTo(this.numeratorMax) > 0) {
                    tmpNum3 = this.numeratorMax;
                }
                rationalPart = new BigRational(tmpNum3, this.denominator, true);
                this.numerator = tmpNum3;
                return inputFreqLoc.multiply(rationalPart.add(this.mul));
            }
            if (highestAndRequiredDiff.abs().compareTo(lowestAndRequiredDiff4.abs()) < 0) {
                return highest;
            }
            return lowest;
        }
        minimalDenominator = this.denominatorMin.compareTo(this.numerator) > 0 ? this.denominatorMin : this.numerator.add(BigInteger.ONE);
        BigRational highest = inputFreqLoc.multiply(new BigRational(this.numerator, minimalDenominator).add(this.mul));
        BigRational lowest = inputFreqLoc.multiply(new BigRational(this.numerator, this.denominatorMax).add(this.mul));
        BigRational highestAndRequiredDiff = highest.subtract(requiredFreq);
        if (highestAndRequiredDiff.multiply(lowestAndRequiredDiff = lowest.subtract(requiredFreq)).compareTo(BigRational.ZERO) < 0) {
            BigInteger tmpDen3 = rationalPart.getDenominator().multiply(this.numerator);
            if ((tmpDen3 = tmpDen3.divide(rationalPart.getNumerator())).compareTo(this.denominatorMin) < 0) {
                tmpDen3 = this.denominatorMin;
            } else if (tmpDen3.compareTo(this.denominatorMax) > 0) {
                tmpDen3 = this.denominatorMax;
            }
            rationalPart = new BigRational(this.numerator, tmpDen3, true);
            this.denominator = tmpDen3;
            return inputFreqLoc.multiply(rationalPart.add(this.mul));
        }
        if (highestAndRequiredDiff.abs().compareTo(lowestAndRequiredDiff.abs()) < 0) {
            return highest;
        }
        return lowest;
    }
}

