/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core.ui.intrinsics;

import com.freescale.s32ds.cross.core.ui.intrinsics.IIntrinsicsGroup;
import com.freescale.s32ds.cross.core.ui.intrinsics.IntrinsicDeclaration;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.eclipse.cdt.managedbuilder.core.IOption;
import org.eclipse.cdt.managedbuilder.core.IToolChain;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;

public class IntrinsicsGroup
implements IIntrinsicsGroup,
Comparable<IIntrinsicsGroup> {
    private String name;
    private Set<IntrinsicDeclaration> intrinsics;
    private String include;
    private GroupValidator gv;

    IntrinsicsGroup(String name) {
        this.name = name;
        this.intrinsics = new TreeSet<IntrinsicDeclaration>();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Set<IntrinsicDeclaration> getIntrinsicsDeclarations() {
        return this.intrinsics;
    }

    @Override
    public void addIntrinsicDeclaration(IntrinsicDeclaration bifd) {
        this.intrinsics.add(bifd);
    }

    @Override
    public int compareTo(IIntrinsicsGroup ig) {
        return this.name.compareTo(ig.getName());
    }

    public String getInclude() {
        return this.include;
    }

    public void setInclude(String include) {
        this.include = include;
    }

    boolean check(IProject project) {
        return this.gv == null ? true : this.gv.isValid(project);
    }

    void setGroupValidator(GroupValidator gv) {
        this.gv = gv;
    }

    public int hashCode() {
        return Objects.hash(this.gv, this.include, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntrinsicsGroup other = (IntrinsicsGroup)obj;
        return Objects.equals(this.gv, other.gv) && Objects.equals(this.include, other.include) && this.isSetsEquals(this.intrinsics, other.intrinsics) && Objects.equals(this.name, other.name);
    }

    private boolean isSetsEquals(Set<IntrinsicDeclaration> s1, Set<IntrinsicDeclaration> s2) {
        if (s1.size() != s2.size()) {
            return false;
        }
        for (IntrinsicDeclaration el : s1) {
            if (s2.contains(el)) continue;
            return false;
        }
        return true;
    }

    class GroupValidator {
        protected String param;
        protected String value;

        GroupValidator(String param, String value) {
            this.param = param;
            this.value = value;
        }

        boolean isValid(IProject project) {
            return project != null;
        }
    }

    class SPGroupValidator
    extends GroupValidator {
        SPGroupValidator(String param, String value) {
            super(param, value);
        }

        @Override
        boolean isValid(IProject project) {
            if (!super.isValid(project)) {
                return false;
            }
            IToolChain toolchain = ManagedBuildManager.getBuildInfo((IResource)project.getProject()).getDefaultConfiguration().getToolChain();
            if (this.param == null || this.value == null) {
                return true;
            }
            if (toolchain == null) {
                return false;
            }
            IOption option = toolchain.getOptionBySuperClassId(this.param);
            if (option == null) {
                return false;
            }
            return this.value.equals(option.getValue());
        }
    }
}

