/*
 * Decompiled with CFR 0.152.
 */
package com.freescale.s32ds.cross.core;

import com.freescale.s32ds.cross.core.Activator;
import com.freescale.s32ds.cross.core.model.HWModel;
import com.freescale.s32ds.cross.core.model.Hardware;
import com.freescale.s32ds.cross.core.model.data.CoreNatureData;
import com.freescale.s32ds.cross.core.model.data.ProcessorData;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;

@Deprecated
public class ProjectSettings {
    public static final String QUALIFIER = "com.freescale.s32ds.cross.wizard";
    public static final String GROUP_NAME_KEY = "groupName";
    public static final String PROCESSOR_KEY = "processor";
    public static final String CORE_KEY = "core";
    public static final String CORE_TYPE_KEY = "coreType";
    public static final String LIBRARY_KEY = "library";
    public static final String LANGUAGE_KEY = "language";
    public static final String IO_KEY = "io";
    public static final String FPU_KEY = "fpu";
    public static final String INSTRMODE_KEY = "instrmode";
    public static final String OPMODE_KEY = "opmode";
    public static final String FLASH_START_KEY = "flashStart";
    public static final String FLASH_SIZE_KEY = "flashSize";
    public static final String RAM_START_KEY = "ramStart";
    public static final String RAM_SIZE_KEY = "ramSize";
    public static final String PIN_SET_KEY = "pinSet";
    public static final String PRODUCT_VERSION_KEY = "productVersion";
    public static final String TOOLCHAIN_VERSION_KEY = "toolchainVersion";
    public static final String WIZARD_VERSION_KEY = "wizardVersion";
    public static final String LSP_KEY = "lsp";
    private final IProject project;
    private final String qualifier;
    private String defaultValue = "";
    private final IEclipsePreferences prefs;
    private final IPreferencesService ps = Platform.getPreferencesService();

    public ProjectSettings(IProject project, String qualifier) {
        this.project = project;
        this.qualifier = qualifier;
        this.prefs = new ProjectScope(project).getNode(qualifier);
    }

    public ProjectSettings defaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
        return this;
    }

    public ProjectSettings append(String key, String value) {
        this.prefs.put(key, value);
        return this;
    }

    public void store() {
        try {
            if (this.project.isOpen()) {
                this.prefs.flush();
            }
        }
        catch (BackingStoreException e) {
            Activator.log(e);
        }
    }

    public void store(String key, String value) {
        this.append(key, value).store();
    }

    public String load(String key) {
        return this.ps.getString(this.qualifier, key, this.defaultValue, new IScopeContext[]{new ProjectScope(this.project)});
    }

    public static void createHWPrefs(IProject project, String proc, String coreId) {
        for (HWModel model : Hardware.instance().getModels()) {
            for (ProcessorData p : model.getProcessors()) {
                if (!p.getId().equals(proc) && !p.getName().equals(proc)) continue;
                String type = String.valueOf(proc) + '_' + ProjectSettings.checkCoreKind(coreId, p);
                new ProjectSettings(project, QUALIFIER).append(CORE_KEY, String.valueOf(type) + "_1").append(CORE_TYPE_KEY, type).append(PROCESSOR_KEY, proc).append(LANGUAGE_KEY, "c").store();
                return;
            }
        }
    }

    private static String checkCoreKind(String coreId, ProcessorData p) {
        if (coreId == null || coreId.trim().isEmpty()) {
            return p.getCoreTypes().stream().map(CoreNatureData::getCoreKindId).findAny().orElse(coreId);
        }
        return coreId;
    }
}

