/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.ext.rcp.p2.core.utils;

import com.nxp.s32ds.ext.rcp.p2.core.utils.StreamGobbler;
import com.nxp.s32ds.ext.rcp.p2.core.utils.Util;
import com.nxp.s32ds.ext.rcp.p2.internal.core.Messages;
import java.io.File;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;

public class ExecuteUtil {
    public static int executeCommand(String args, String workingDir, String cmdInterpreter, boolean isScript, boolean isSh) {
        Object[] cmd;
        block12: {
            block11: {
                String osName;
                block10: {
                    try {
                        osName = Platform.getOS();
                        Util.log(1, NLS.bind((String)Messages.ExecuteUtil_os_name, (Object)osName));
                        cmd = null;
                        if (!"win32".equals(osName)) break block10;
                        cmd = new String[]{cmdInterpreter, "/C", args};
                        Util.log(1, NLS.bind((String)Messages.ExecuteUtil_execute_3_args, (Object[])cmd));
                        if (cmdInterpreter.equals("sh")) {
                            Util.logWarning(Messages.ExecuteUtil_sh_command_is_ignored_on_windows);
                            return 1;
                        }
                        break block11;
                    }
                    catch (Throwable t) {
                        Util.logError(t.getMessage(), t);
                        return 0;
                    }
                }
                if ("linux".equals(osName)) {
                    if (isScript) {
                        cmd = new String[]{cmdInterpreter, args};
                        Util.log(1, NLS.bind((String)Messages.ExecuteUtil_execute_2_args, (Object[])cmd));
                    } else {
                        cmd = new String[]{cmdInterpreter, "-c", isSh ? ExecuteUtil.preprocessPath(args) : args};
                        Util.log(1, NLS.bind((String)Messages.ExecuteUtil_execute_3_args, (Object[])cmd));
                    }
                    break block11;
                }
                if (!"unknown".equals(osName)) break block11;
                Util.logError(Messages.ExecuteUtil_unknown_os_platform);
                return 0;
            }
            if (cmd != null) break block12;
            Util.logError(Messages.ExecuteUtil_command_is_null);
            return 0;
        }
        Runtime rt = Runtime.getRuntime();
        File workingDirPath = new File(workingDir);
        Process proc = rt.exec((String[])cmd, null, workingDirPath);
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), StreamGobbler.TYPE.ERROR);
        StreamGobbler outputGobbler = new StreamGobbler(proc.getInputStream(), StreamGobbler.TYPE.OUTPUT);
        errorGobbler.start();
        outputGobbler.start();
        int exitVal = proc.waitFor();
        errorGobbler.join();
        outputGobbler.join();
        Util.log(exitVal == 0 ? 1 : 4, "ExitValue: " + exitVal);
        if (exitVal != 0) {
            return 0;
        }
        return 1;
    }

    public static String preprocessPath(String str) {
        String res = str;
        if (str.contains(" ")) {
            String escaped = str.replaceAll(" ", "\\\\ ");
            res = "\"" + escaped + "\"";
            Util.log(1, NLS.bind((String)Messages.ExecuteUtil_preprocess_path_with_spaces, (Object)res));
        }
        return res;
    }
}

