/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.view.action;

import com.nxp.s32ds.tad.common.messages.Messages;
import com.nxp.s32ds.tad.common.messages.Separator;
import com.nxp.s32ds.tad.common.model.TadModel;
import com.nxp.s32ds.tad.common.model.Time;
import com.nxp.s32ds.tad.common.view.TadViewViewerType;
import com.nxp.s32ds.tad.common.view.items.TadItem;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.regex.Matcher;
import javax.swing.JFileChooser;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public class SaveToFileAction
extends Action {
    private static final String ACTIVE = "*";
    private static final String CSV_EXTENSION = ".csv";
    private static final String TXT_EXTENSION = ".txt";
    private final String CSV_SEPARATOR = "sep=" + Separator.SEMICOLON.toString();
    private final String EOL = System.getProperty("line.separator");
    private final String[] FILTER_NAMES = new String[]{"CSV", "Plain text"};
    private final String[] FILTER_EXTENSIONS = new String[]{"*.csv", "*.txt"};
    private TadModel tadModel;
    private String viewName;
    private FileDialog dialog;
    private Map<TadViewViewerType, TreeViewer> viewers;

    private static String addExtensionToFile(String filename, String extension) {
        String[] splittedPath;
        String[] splittedName;
        if (filename != null && (splittedName = (splittedPath = filename.split(Matcher.quoteReplacement(System.getProperty("file.separator"))))[splittedPath.length - 1].split("\\.")).length == 1) {
            filename = filename.concat(extension);
        }
        return filename;
    }

    public SaveToFileAction(TadModel tadModel, Shell parentShell, String viewName, Map<TadViewViewerType, TreeViewer> viewers) {
        this.tadModel = tadModel;
        this.viewName = viewName != null ? viewName : Messages.General_TadShort;
        this.viewers = viewers;
        this.dialog = new FileDialog(parentShell, 8192);
        this.dialog.setText(String.format(Messages.Label_SaveToFile, viewName));
        this.dialog.setFilterPath(new JFileChooser().getFileSystemView().getDefaultDirectory().toString());
        this.dialog.setFilterNames(this.FILTER_NAMES);
        this.dialog.setFilterExtensions(this.FILTER_EXTENSIONS);
    }

    public void run() {
        this.dialog.setFileName(String.valueOf(this.viewName.replace(" ", "_")) + "_" + Time.SAVE_FORMAT.toString());
        String path = this.dialog.open();
        if (path != null) {
            Separator separator = Separator.SEMICOLON;
            if (this.dialog.getFilterIndex() == 0) {
                path = SaveToFileAction.addExtensionToFile(path, CSV_EXTENSION);
                separator = Separator.SEMICOLON;
            } else {
                path = SaveToFileAction.addExtensionToFile(path, TXT_EXTENSION);
                separator = Separator.TAB;
            }
            try {
                Throwable throwable = null;
                Object var4_6 = null;
                try (OutputStreamWriter csv = new OutputStreamWriter((OutputStream)new FileOutputStream(path), StandardCharsets.UTF_8);){
                    if (separator == Separator.SEMICOLON) {
                        ((Writer)csv).append(this.CSV_SEPARATOR);
                        ((Writer)csv).append(this.EOL);
                    }
                    for (TreeViewer viewer : this.viewers.values()) {
                        Tree tree = viewer.getTree();
                        TreeItem selectedItem = null;
                        if (viewer.getTree().getSelection().length > 0) {
                            selectedItem = viewer.getTree().getSelection()[0];
                        }
                        TreeColumn[] treeColumnArray = tree.getColumns();
                        int n = treeColumnArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            TreeColumn column = treeColumnArray[n2];
                            ((Writer)csv).append(column.getText());
                            ((Writer)csv).append(separator.toString());
                            ++n2;
                        }
                        ((Writer)csv).append(this.EOL);
                        treeColumnArray = tree.getItems();
                        n = treeColumnArray.length;
                        n2 = 0;
                        while (n2 < n) {
                            TreeColumn treeItem = treeColumnArray[n2];
                            if (treeItem.getData() instanceof TadItem) {
                                TadItem item = (TadItem)treeItem.getData();
                                ((Writer)csv).append(item.toString(separator));
                                if (treeItem.equals(selectedItem)) {
                                    ((Writer)csv).append(ACTIVE);
                                }
                                if (item.hasTreeChildren()) {
                                    for (TadItem tadItem : item.getTreeChildren()) {
                                        ((Writer)csv).append(this.EOL);
                                        ((Writer)csv).append(separator.toString());
                                        ((Writer)csv).append(tadItem.toString(separator));
                                    }
                                }
                                ((Writer)csv).append(this.EOL);
                            }
                            ++n2;
                        }
                        ((Writer)csv).append(this.EOL);
                    }
                    ((Writer)csv).close();
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException e) {
                this.tadModel.getLogger().exception(e, String.format(Messages.Exception_WhileSavingView, this.viewName));
            }
        } else {
            this.tadModel.getLogger().error(Messages.Error_SavePathInvalid);
        }
    }

    public String getText() {
        return String.format(Messages.Label_SaveToFile, this.viewName);
    }

    public String getToolTipText() {
        return String.format(Messages.Label_SaveToFile, this.viewName);
    }

    public ImageDescriptor getImageDescriptor() {
        return TadModel.SAVE_IMG_DESC;
    }
}

