/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.model.view.queues;

import com.nxp.s32ds.tad.common.model.Auxiliary;
import com.nxp.s32ds.tad.common.model.view.queues.GenericQueueDataType;
import java.math.BigInteger;
import java.util.List;

public class GenericQueueData {
    public static final int BYTES_TO_READ = 4;
    private final int id;
    private final long address;
    private final List<Long> listData;
    private final int size;
    private final BigInteger rawData;

    public GenericQueueData(int id, long address, int size, List<Long> data) {
        this.id = id;
        this.address = address;
        this.size = size;
        this.listData = data;
        BigInteger _rawData = new BigInteger("0");
        int i = 0;
        while (i < data.size()) {
            String itemStrVal = Long.toString(data.get(i));
            _rawData = _rawData.shiftLeft(size * 8).or(new BigInteger(itemStrVal));
            ++i;
        }
        this.rawData = _rawData;
    }

    public int getId() {
        return this.id;
    }

    public long getAddress() {
        return this.address;
    }

    public int getSize() {
        return this.size;
    }

    public boolean hasData() {
        return this.listData != null && !this.listData.isEmpty();
    }

    public List<Long> getData() {
        return this.listData;
    }

    public String toString(GenericQueueDataType type) {
        StringBuilder builder = new StringBuilder();
        switch (type) {
            case DECIMAL: {
                builder.append(String.format("%d", this.rawData));
                break;
            }
            case BINARY: {
                builder.append(this.rawData.toString(2));
                break;
            }
            case ASCII: {
                for (long number : this.listData) {
                    builder.append(Auxiliary.toASCII(number, this.getSize()));
                }
                break;
            }
            default: {
                String formatStr = "0x%0" + 2 * this.listData.size() * this.size + 'x';
                builder.append(String.format(formatStr, this.rawData));
            }
        }
        return builder.toString();
    }
}

