/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.model.readers;

import com.nxp.s32ds.tad.common.TadCommonActivator;
import java.util.Arrays;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.cdt.dsf.concurrent.DataRequestMonitor;
import org.eclipse.cdt.dsf.concurrent.DsfExecutor;
import org.eclipse.cdt.dsf.concurrent.RequestMonitor;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.debug.service.command.ICommand;
import org.eclipse.cdt.dsf.gdb.service.command.IGDBControl;
import org.eclipse.cdt.dsf.mi.service.command.commands.CLICommand;
import org.eclipse.cdt.dsf.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.cdt.dsf.mi.service.command.output.MIInfo;
import org.eclipse.cdt.dsf.service.DsfServicesTracker;
import org.osgi.framework.BundleContext;

public class GdbServerCommandManager {
    private final DsfServicesTracker tracker;
    private final DsfExecutor executor;
    private final CyclicBarrier barrier;

    public GdbServerCommandManager(BundleContext context, String sessionId, DsfExecutor executor) {
        this.tracker = new DsfServicesTracker(context, sessionId);
        this.executor = executor;
        this.barrier = new CyclicBarrier(2);
    }

    public void queueCommand(String command, DataRequestMonitor<MIInfo> drm) {
        IGDBControl commandControl = (IGDBControl)this.tracker.getService(IGDBControl.class);
        if (!command.isEmpty()) {
            commandControl.queueCommand((ICommand)new CLICommand((IDMContext)commandControl.getContext(), command), drm);
        }
    }

    public MIConsoleStreamOutput filteredSyncQueueCommand(String command, String regex) {
        Pattern pattern = Pattern.compile(regex);
        MIConsoleStreamOutput[] outputArray = this.syncQueueCommand(command);
        MIConsoleStreamOutput output = null;
        MIConsoleStreamOutput[] mIConsoleStreamOutputArray = outputArray;
        int n = outputArray.length;
        int n2 = 0;
        while (n2 < n) {
            MIConsoleStreamOutput outputStream = mIConsoleStreamOutputArray[n2];
            Matcher matcher = pattern.matcher(outputStream.getCString());
            if (matcher != null && matcher.matches()) {
                output = outputStream;
                break;
            }
            ++n2;
        }
        return output;
    }

    public synchronized MIConsoleStreamOutput[] syncQueueCommand(String command) {
        DataRequest dataRequest = new DataRequest((Executor)this.executor, null);
        this.queueCommand(command, dataRequest);
        try {
            this.barrier.await();
        }
        catch (InterruptedException | BrokenBarrierException e) {
            TadCommonActivator.getDefault().log(e);
            return new MIConsoleStreamOutput[0];
        }
        return dataRequest.outputStream;
    }

    public DsfExecutor getExecutor() {
        return this.executor;
    }

    private class DataRequest
    extends DataRequestMonitor<MIInfo> {
        private MIConsoleStreamOutput[] outputStream;

        public DataRequest(Executor executor, RequestMonitor parentRequestMonitor) {
            super(executor, parentRequestMonitor);
            this.outputStream = new MIConsoleStreamOutput[0];
        }

        protected void handleCompleted() {
            Object data = this.getData();
            this.outputStream = (MIConsoleStreamOutput[])Arrays.stream(((MIInfo)data).getMIOutput().getMIOOBRecords()).filter(MIConsoleStreamOutput.class::isInstance).toArray(MIConsoleStreamOutput[]::new);
            try {
                GdbServerCommandManager.this.barrier.await();
            }
            catch (InterruptedException | BrokenBarrierException e) {
                TadCommonActivator.getDefault().log(e);
            }
        }
    }
}

