/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.tad.common.model;

import com.nxp.s32ds.tad.common.TadCommonActivator;
import com.nxp.s32ds.tad.common.controller.TadFactory;
import com.nxp.s32ds.tad.common.controller.TadFactoryData;
import com.nxp.s32ds.tad.common.controller.TadFactoryDataStatus;
import com.nxp.s32ds.tad.common.logger.Logger;
import com.nxp.s32ds.tad.common.messages.Messages;
import com.nxp.s32ds.tad.common.model.DataRequest;
import com.nxp.s32ds.tad.common.model.IDataListener;
import com.nxp.s32ds.tad.common.model.ITadModelListener;
import com.nxp.s32ds.tad.common.model.readers.GdbServerCommandManager;
import com.nxp.s32ds.tad.common.model.readers.MemoryReader;
import com.nxp.s32ds.tad.common.model.readers.VariableReader;
import com.nxp.s32ds.tad.common.model.state.DMEvent;
import com.nxp.s32ds.tad.common.model.state.TadState;
import com.nxp.s32ds.tad.common.model.view.generic.TadDataCache;
import com.nxp.s32ds.tad.common.rtos.Rtos;
import com.nxp.s32ds.tad.common.rtos.RtosAvailability;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.console.MessageConsole;

public abstract class TadModel
implements DsfSession.SessionStartedListener,
DsfSession.SessionEndedListener {
    public static final Image WARNING_BIG_IMG = TadCommonActivator.getDefault().getImage("warning_bigger");
    public static final Image WARNING_IMG = TadCommonActivator.getDefault().getImage("warning");
    public static final Image ERROR_IMG = TadCommonActivator.getDefault().getImage("error");
    public static final ImageDescriptor INFORMATION_IMG_DESC = TadCommonActivator.getDefault().getImageDescriptor("information");
    public static final ImageDescriptor SAVE_IMG_DESC = TadCommonActivator.getDefault().getImageDescriptor("save");
    protected static final DataRequest POISON_DATA_REQUEST = new DataRequest(0){

        @Override
        public void execute() {
        }
    };
    protected BlockingQueue<DataRequest> requestQueue;
    protected List<ITadModelListener> listeners;
    protected Map<String, TadFactory> factories;
    protected TadDataCache dataCache;
    protected TadState tadState;
    protected Thread workerThread;
    protected AtomicInteger ticket;
    protected Logger tadLogger = null;
    protected MessageConsole tadConsole = null;
    protected final VariableReader variableReader;
    protected final MemoryReader memoryReader;
    private GdbServerCommandManager gdbManager;
    protected Map<ILaunchConfiguration, DsfSession> startedDebugLaunchConfigs = new HashMap<ILaunchConfiguration, DsfSession>();

    public TadModel() {
        this.ticket = new AtomicInteger(1);
        this.dataCache = new TadDataCache();
        this.variableReader = new VariableReader(this);
        this.memoryReader = new MemoryReader(this);
        this.requestQueue = new LinkedBlockingQueue<DataRequest>();
        this.listeners = new LinkedList<ITadModelListener>();
        this.tadState = new TadState(this);
        DsfSession.addSessionStartedListener((DsfSession.SessionStartedListener)this);
        DsfSession.addSessionEndedListener((DsfSession.SessionEndedListener)this);
    }

    public synchronized void requestViewData(final IDataListener listener, final String viewName) {
        DataRequest req = new DataRequest(this.ticket.get()){

            @Override
            public void execute() {
                if (TadModel.this.getRTOS().getAvailability() == RtosAvailability.UNKNOWN) {
                    TadModel.this.getRTOS().setAvailability(TadModel.this.isRTOSAvailable());
                    if (TadModel.this.getRTOS().getAvailability() == RtosAvailability.UNKNOWN) {
                        listener.dataEmpty(new TadFactoryData(TadModel.this, null, TadFactoryDataStatus.INFORMATION, String.format(Messages.Info_RTOSCannotBeDetectedRefreshTheView, viewName)));
                        return;
                    }
                }
                if (TadModel.this.getRTOS().getAvailability() != RtosAvailability.AVAILABLE) {
                    listener.dataEmpty(new TadFactoryData(TadModel.this, null, TadFactoryDataStatus.INFORMATION, String.format(Messages.Info_RTOSNotUsed, viewName)));
                    return;
                }
                if (!TadModel.this.isTadReady()) {
                    listener.dataCorrupted();
                    TadModel.this.getLogger().error(String.format(Messages.Error_DataRequestFailed, viewName));
                    return;
                }
                try {
                    if (TadModel.this.factories.containsKey(viewName)) {
                        TadFactory factory = TadModel.this.factories.get(viewName);
                        TadModel.this.cachePreRequisiteData(viewName);
                        TadFactoryData data = TadModel.this.dataCache.getViewData(viewName);
                        if (data == null) {
                            data = factory.getData();
                        }
                        if (this.isTicketValid(TadModel.this.ticket.get())) {
                            if (data.isValid()) {
                                listener.dataReady(data);
                            } else {
                                if (!data.hasMessage()) {
                                    data.setStatus(TadFactoryDataStatus.INFORMATION);
                                    data.setMessage(String.format(Messages.Info_ViewDataEmpty, viewName));
                                }
                                listener.dataEmpty(data);
                            }
                            TadModel.this.dataCache.setViewData(viewName, data);
                        } else {
                            listener.dataCorrupted();
                        }
                    } else {
                        TadModel.this.getLogger().error(String.format(Messages.Error_FactoryNotFound, viewName));
                        listener.dataCorrupted();
                    }
                }
                catch (NullPointerException e) {
                    e.printStackTrace();
                    TadModel.this.getLogger().exception(e, String.format(Messages.Exception_WhileDataLoad, viewName));
                    listener.dataCorrupted();
                }
            }
        };
        try {
            this.requestQueue.put(req);
        }
        catch (InterruptedException e) {
            listener.dataCorrupted();
            this.getLogger().exception(e);
        }
    }

    protected void cachePreRequisiteData(String viewName) {
    }

    protected abstract RtosAvailability isRTOSAvailable();

    protected abstract double getRTOSVersion();

    public boolean isTadReady() {
        return this.tadState.isReady();
    }

    public TadDataCache getDataCache() {
        return this.dataCache;
    }

    public MessageConsole getTadConsole() {
        return this.tadConsole;
    }

    public Logger getLogger() {
        return this.tadLogger;
    }

    public abstract Rtos getRTOS();

    public void addListener(ITadModelListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ITadModelListener listener) {
        this.listeners.remove(listener);
    }

    public GdbServerCommandManager getGdbManager() {
        return this.gdbManager;
    }

    private void startWorkerThread() {
        this.workerThread = new Thread(){

            @Override
            public void run() {
                while (TadModel.this.tadState.isDebugRunning()) {
                    try {
                        DataRequest request = TadModel.this.requestQueue.take();
                        if (request == POISON_DATA_REQUEST || !TadModel.this.tadState.isDebugRunning()) break;
                        if (!request.isTicketValid(TadModel.this.ticket.get())) continue;
                        request.execute();
                    }
                    catch (InterruptedException interruptedException) {
                        break;
                    }
                }
            }
        };
        this.workerThread.start();
    }

    private void stopWorkerThread() {
        try {
            this.requestQueue.put(POISON_DATA_REQUEST);
        }
        catch (InterruptedException e) {
            this.getLogger().exception(e, Messages.Exception_CouldNotStopWorkerThread);
        }
    }

    private void increaseTicket() {
        this.ticket.incrementAndGet();
    }

    protected abstract void initRTOS(DsfSession var1);

    public void sessionStarted(DsfSession session) {
        this.ensureNonNullLaunchConfig(session);
        ILaunchConfiguration launchConfig = TadModel.getLaunchConfigForSession(session);
        if (launchConfig != null) {
            this.gdbManager = new GdbServerCommandManager(TadCommonActivator.getDefault().getBundle().getBundleContext(), session.getId(), session.getExecutor());
            if (this.startedDebugLaunchConfigs.containsKey(launchConfig)) {
                return;
            }
            this.startedDebugLaunchConfigs.put(launchConfig, session);
        }
        session.addServiceEventListener((Object)this, null);
        this.increaseTicket();
        this.dataCache.clear();
        this.configureFromPreferences();
        this.tadState.debugStarted(true);
        this.initRTOS(session);
        this.requestQueue.clear();
        this.startWorkerThread();
        for (ITadModelListener l : this.listeners) {
            l.debuggerSessionCreated();
        }
        this.getLogger().info(String.format(Messages.Info_DSFStarted, session.getId()));
    }

    public void sessionEnded(DsfSession session) {
        if (!this.startedDebugLaunchConfigs.containsValue(session)) {
            return;
        }
        Optional.ofNullable(TadModel.getLaunchConfigForSession(session)).ifPresent(launchConfig -> {
            DsfSession dsfSession = this.startedDebugLaunchConfigs.remove(launchConfig);
        });
        this.getLogger().info(String.format(Messages.Info_DSFEnded, session.getId()));
        session.removeServiceEventListener((Object)this);
        this.increaseTicket();
        this.dataCache.clear();
        this.setContextInFactories(null);
        this.tadState.debugStarted(false);
        this.stopWorkerThread();
        for (ITadModelListener l : this.listeners) {
            l.debuggerTerminated();
        }
        this.getLogger().saveLogFile();
        this.getLogger().clear();
        this.sessionTerminated();
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.ISuspendedDMEvent event) {
        this.increaseTicket();
        this.dataCache.clear();
        this.setContextInFactories((IRunControl.IExecutionDMContext)event.getDMContext());
        this.tadState.shiftState(DMEvent.SUSPENDED, event.getReason());
        if (this.isTadReady()) {
            this.variableReader.init();
            for (ITadModelListener l : this.listeners) {
                l.debuggerSuspended();
            }
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.IResumedDMEvent event) {
        this.increaseTicket();
        this.dataCache.clear();
        this.tadState.shiftState(DMEvent.RESUMED, event.getReason());
        for (ITadModelListener l : this.listeners) {
            l.debuggerResumed();
        }
    }

    private void setContextInFactories(IRunControl.IExecutionDMContext context) {
        for (TadFactory factory : this.factories.values()) {
            factory.setContext(context);
        }
    }

    protected static ILaunchConfiguration getLaunchConfigForSession(DsfSession session) {
        return Optional.ofNullable(session).map(dsfSession -> (ILaunch)dsfSession.getModelAdapter(ILaunch.class)).map(ILaunch::getLaunchConfiguration).orElse(null);
    }

    protected void ensureNonNullLaunchConfig(DsfSession session) {
        CountDownLatch waitForNonNullLaunch = new CountDownLatch(1);
        new Thread(() -> {
            int numTry = 0;
            while (numTry < 10 && TadModel.getLaunchConfigForSession(session) == null) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
                ++numTry;
            }
            waitForNonNullLaunch.countDown();
        }).start();
        try {
            waitForNonNullLaunch.await(1000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.getLogger().exception(e, Messages.Error_Unknown);
        }
    }

    protected abstract void configureFromPreferences();

    protected abstract void sessionTerminated();
}

