/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui.diagramsymbols;

import com.nxp.swtools.clocks.ui.diagram.DiagramStyleProvider;
import com.nxp.swtools.clocks.ui.diagramsymbols.DrawState;
import com.nxp.swtools.clocks.ui.diagramsymbols.GraphicalElement;
import com.nxp.swtools.clocks.ui.diagramsymbols.LineStyle;
import com.nxp.swtools.common.utils.NonNull;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import org.eclipse.swt.events.PaintEvent;

public class Wire
extends GraphicalElement {
    @NonNull
    protected Point2D mStartDS;
    @NonNull
    protected Point2D mEndDS;

    public Wire(@NonNull Point2D start, @NonNull Point2D end) {
        this.mStartDS = start;
        this.mEndDS = end;
    }

    @Override
    public void draw(AffineTransform transform, PaintEvent e, DiagramStyleProvider styleProvider) {
        Point2D startCS = transform.transform(this.mStartDS, null);
        Point2D endCS = transform.transform(this.mEndDS, null);
        LineStyle style = styleProvider.getStyle((GraphicalElement)this, (DrawState)this.mDrawState).LineStyle;
        style.set(e);
        e.gc.drawLine((int)startCS.getX(), (int)startCS.getY(), (int)endCS.getX(), (int)endCS.getY());
        style.unset(e);
    }

    @Override
    protected Wire makeCopy() {
        Point2D.Double s = new Point2D.Double(this.mStartDS.getX(), this.mStartDS.getY());
        Point2D.Double e = new Point2D.Double(this.mEndDS.getX(), this.mEndDS.getY());
        return new Wire(s, e);
    }

    @Override
    public boolean isHitBy(Point2D p) {
        return false;
    }

    @Override
    public void applyTransform(AffineTransform transformDS) {
        transformDS.transform(this.mStartDS, this.mStartDS);
        transformDS.transform(this.mEndDS, this.mEndDS);
    }

    public @NonNull Point2D getStartDS() {
        return this.mStartDS;
    }

    public @NonNull Point2D getEndDS() {
        return this.mEndDS;
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + "[" + this.mStartDS + ", " + this.mEndDS + "]";
    }
}

