/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.ui;

import com.nxp.swtools.clocks.data.elements.CategoryConfigElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.ValueConfigElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.SettingsDB;
import com.nxp.swtools.clocks.data.settings.AGlobalSetting;
import com.nxp.swtools.clocks.data.settings.ASetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.PowerModeSetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.platform.Rap;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.SettingValueChangeListener;
import com.nxp.swtools.common.ui.utils.swt.SWTFactoryProxy;
import com.nxp.swtools.common.ui.utils.swt.widgets.InstantSearchList;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.utils.events.IEventListener;
import com.nxp.swtools.utils.events.ToolEvent;
import com.nxp.swtools.utils.resources.ToolsColors;
import com.nxp.swtools.utils.resources.ToolsImages;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class GlobalSettingsConfiguration {
    @NonNull
    GuiController guiController = GuiController.getInstance();
    @NonNull
    @NonNull Map<@NonNull AGlobalSetting, @NonNull Button> categories = new HashMap<AGlobalSetting, Button>();
    @NonNull
    @NonNull Map<@NonNull AGlobalSetting, @NonNull InstantSearchList> combos = new HashMap<AGlobalSetting, InstantSearchList>();
    @NonNull
    @NonNull Map<@NonNull AGlobalSetting, @NonNull Text> textFields = new HashMap<AGlobalSetting, Text>();
    @NonNull
    @NonNull Set<@NonNull IEventListener> listeners = new HashSet<IEventListener>();
    @NonNull
    protected Composite combosComposite;
    private static final int CATEGORY_BUTTON_SIZE = 20;

    public GlobalSettingsConfiguration(@NonNull Composite parent) {
        parent.setLayout((Layout)new RowLayout());
        this.combosComposite = parent;
        SWTFactoryProxy.INSTANCE.setTestId((Widget)this.combosComposite, "clocksGlobalSettings");
        this.fillComposite(parent);
        this.resetFieldsContent();
        this.addCombosChangeListener();
        this.addTextFieldsChangeListener();
        this.registerValueChangeListeners();
        this.registerDisposeListener();
    }

    void fillComposite(@NonNull Composite parent) {
        Control[] controlArray = parent.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control control = controlArray[n2];
            control.dispose();
            ++n2;
        }
        this.combos.clear();
        this.textFields.clear();
        SettingsDB settingsDb = GuiController.getInstance().getProfile().getMcu().getSettings();
        IClocksConfig config = GuiController.getInstance().getProfile().getActiveConfig();
        ArrayList<@NonNull AGlobalSetting> globalSettings = new ArrayList<AGlobalSetting>(settingsDb.getGlobalSettings());
        int numOfProcessed = 0;
        for (AGlobalSetting setting : globalSettings) {
            IElement element = setting.getElement();
            if (!setting.isVisible(config) || !GlobalSettingsConfiguration.isSettingGlobalyVisible(setting)) continue;
            if (numOfProcessed++ != 0) {
                Label separator = new Label(parent, 0);
                separator.setText("|");
            }
            Label title = new Label(parent, 0);
            title.setText(setting.getName());
            if (element instanceof ValueConfigElement) {
                Text textField = new Text(parent, 2048);
                textField.setTextLimit(250);
                this.textFields.put(setting, textField);
                if (config != null) {
                    SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)textField, setting.getToolTipText(config));
                }
            } else if (element instanceof CategoryConfigElement) {
                Button button = new Button(parent, 8);
                button.setImage(ToolsImages.getImage((String)"icons/three_dots_center.png"));
                button.setLayoutData((Object)new RowData(20, 20));
                SWTFactoryProxy.INSTANCE.setTestId((Widget)button, "category_" + setting.getId());
                SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)button, MessageFormat.format(Messages.get().GlobalSettingsConfiguration_CategoryRedirectToolTip, element.getName()));
                button.addSelectionListener((SelectionListener)this.createCategoryBtnListener(element));
                this.categories.put(setting, button);
            } else {
                InstantSearchList combo = new InstantSearchList(parent, 133124);
                SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "comboBox_" + setting.getId());
                this.combos.put(setting, combo);
            }
            title.setLayoutData((Object)new RowData());
        }
        this.addCombosChangeListener();
        this.addTextFieldsChangeListener();
        this.resetFieldsContent();
    }

    private SelectionAdapter createCategoryBtnListener(final IElement element) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GuiController.showDetailsView();
                GlobalSettingsConfiguration.this.guiController.setSelectedElement(element.getID(), GlobalSettingsConfiguration.this);
            }
        };
    }

    private static boolean isSettingGlobalyVisible(AGlobalSetting setting) {
        if (setting instanceof PowerModeSetting) {
            return true;
        }
        IElement element = setting.getElement();
        if (element instanceof IConfigElement) {
            IConfigElement configElement = (IConfigElement)element;
            return configElement.getParent() == null && !configElement.isComponentOnly();
        }
        return false;
    }

    void updateComboState(@NonNull ISetting setting) {
        IClocksConfig activeConfig = GuiController.getInstance().getProfile().getActiveConfig();
        if (this.combos.containsKey(setting) && activeConfig != null) {
            SettingValue value = activeConfig.getSettingsConfig().getSettingValue(setting);
            @Nullable InstantSearchList combo = this.combos.get(setting);
            assert (combo != null);
            combo.select(value.getUiValue());
            SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)combo, setting.getToolTipText(activeConfig));
            combo.setEnabled(setting.isEnabled(activeConfig) && setting.isEditable(activeConfig));
            this.setControlColor((Control)combo, activeConfig, setting, value);
        }
    }

    void resetFieldsContent() {
        this.resetComobosContent();
        this.resetTextFieldsContent();
    }

    void resetTextFieldsContent() {
        IClocksConfig clocksConfig = GuiController.getInstance().getProfile().getActiveConfig();
        if (clocksConfig != null && !this.textFields.isEmpty()) {
            for (Map.Entry<AGlobalSetting, Text> entry : this.textFields.entrySet()) {
                Text textField = entry.getValue();
                AGlobalSetting setting = entry.getKey();
                SettingValue value = clocksConfig.getSettingsConfig().getSettingValue(setting);
                textField.setText(value.getUiValue());
                SWTFactoryProxy.INSTANCE.setHtmlTooltip((Control)textField, setting.getToolTipText(clocksConfig));
                boolean editable = setting.isEnabled(clocksConfig) && setting.isEditable(clocksConfig);
                textField.setEditable(editable);
                textField.setEnabled(editable);
                this.setControlColor((Control)textField, clocksConfig, setting, value);
            }
            this.layout();
        }
    }

    void resetComobosContent() {
        for (Map.Entry<AGlobalSetting, InstantSearchList> settingCombo : this.combos.entrySet()) {
            InstantSearchList combo = settingCombo.getValue();
            AGlobalSetting setting = settingCombo.getKey();
            SWTFactoryProxy.INSTANCE.setTestId((Widget)combo, "comboBox_" + setting.toString());
            IClocksConfig clocksConfig = GuiController.getInstance().getProfile().getActiveConfig();
            if (clocksConfig == null) continue;
            List<SettingValue> settingValues = setting.getValues(clocksConfig);
            int size = settingValues == null ? 0 : settingValues.size();
            String[] values = new String[size];
            HashSet<@NonNull String> errorItems = new HashSet<String>();
            HashMap<String, String> itemToolTips = new HashMap<String, String>();
            int i = 0;
            while (i < size) {
                String value;
                assert (settingValues != null);
                SettingValue settingValue = settingValues.get(i);
                values[i] = value = settingValue.getUiValue();
                if (setting.hasConflicts(settingValue, clocksConfig)) {
                    errorItems.add(value);
                }
                String itemTooltip = setting.getToolTipText(settingValue, clocksConfig);
                itemToolTips.put(value, com.nxp.swtools.clocks.utils.Text.replaceNewLinesWithSpace(itemTooltip));
                ++i;
            }
            combo.setItems(values);
            Image errorImage = ToolsImages.getStatusIcon((int)2);
            combo.setStatusItemProvider(item -> errorItems.contains(item) ? errorImage : null);
            itemToolTips.entrySet().forEach(x -> combo.addItemToolTip(UtilsText.safeString((String)((String)x.getKey())), (String)x.getValue()));
            this.updateComboState(setting);
        }
    }

    private void addCombosChangeListener() {
        for (final Map.Entry<AGlobalSetting, InstantSearchList> settingCombo : this.combos.entrySet()) {
            final @NonNull InstantSearchList combo = settingCombo.getValue();
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (combo.isDisposed()) {
                        return;
                    }
                    ISetting setting = (ISetting)settingCombo.getKey();
                    SettingEditorHelper.setValue(setting, combo.getText(), new SettingValueChangeListener(GlobalSettingsConfiguration.this.combos));
                    if (Rap.isActive()) {
                        combo.getDisplay().asyncExec(() -> GlobalSettingsConfiguration.this.resetFieldsContent());
                    } else {
                        GlobalSettingsConfiguration.this.resetFieldsContent();
                    }
                }
            });
        }
    }

    private void addTextFieldsChangeListener() {
        for (Map.Entry<AGlobalSetting, Text> entry : this.textFields.entrySet()) {
            final Text textField = entry.getValue();
            final ASetting configElement = entry.getKey();
            textField.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetDefaultSelected(SelectionEvent e) {
                    GlobalSettingsConfiguration.this.loadValueFromTextField(textField, configElement);
                }
            });
            textField.addFocusListener((FocusListener)new FocusAdapter(){

                public void focusLost(FocusEvent e) {
                    GlobalSettingsConfiguration.this.loadValueFromTextField(textField, configElement);
                }
            });
        }
    }

    void loadValueFromTextField(@NonNull Text textField, @NonNull ASetting configElement) {
        if (textField.isDisposed()) {
            return;
        }
        String value = textField.getText();
        SettingEditorHelper.setValue(configElement, value, new SettingValueChangeListener(this.textFields));
        if (Rap.isActive()) {
            textField.getDisplay().asyncExec(() -> this.resetFieldsContent());
        } else {
            this.resetFieldsContent();
        }
    }

    private void registerValueChangeListeners() {
        GuiController controller = GuiController.getInstance();
        IEventListener settingChangeListener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (event.originator != GlobalSettingsConfiguration.this.combos && event.originator != GlobalSettingsConfiguration.this.textFields) {
                    GlobalSettingsConfiguration.this.resetFieldsContent();
                }
            }
        };
        controller.addListener(34, settingChangeListener);
        this.listeners.add(settingChangeListener);
        IEventListener profileChangeListener = new IEventListener(){

            public void handle(@NonNull ToolEvent event) {
                if (event.originator != GlobalSettingsConfiguration.this.combos && event.originator != GlobalSettingsConfiguration.this.textFields) {
                    GlobalSettingsConfiguration.this.fillComposite(GlobalSettingsConfiguration.this.combosComposite);
                    GlobalSettingsConfiguration.this.layout();
                }
            }
        };
        controller.addListener(64, profileChangeListener);
        this.listeners.add(profileChangeListener);
    }

    private void registerDisposeListener() {
        Composite combosCompositeLoc = this.combosComposite;
        if (!combosCompositeLoc.isDisposed()) {
            combosCompositeLoc.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    GlobalSettingsConfiguration.this.dispose();
                }
            });
        }
    }

    public void dispose() {
        this.combos.clear();
        this.textFields.clear();
        this.listeners.forEach(x -> this.guiController.removeModelListener((IEventListener)x));
    }

    void layout() {
        this.combosComposite.layout();
        this.combosComposite.pack();
        Composite parent = this.combosComposite.getParent();
        if (parent != null) {
            parent.layout();
        }
    }

    void setControlColor(@NonNull Control control, @NonNull IClocksConfig clocksConfig, @NonNull ISetting setting, @NonNull SettingValue value) {
        Color highlight = clocksConfig.getSettingsConfig().isLastlyChanged(setting) ? ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.highlight_change_BG") : null;
        Color comboBg = setting.isValid(value, clocksConfig) ? highlight : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_BG");
        control.setBackground(comboBg);
        control.setForeground(setting.isValid(value, clocksConfig) ? ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.default_FG") : ToolsColors.SwToolsColors.getColor((String)"com.nxp.swtools.utils.error_FG"));
    }
}

