/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.dependencies;

import com.nxp.swtools.clocks.data.elements.ClockSource;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.ClocksConfig;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.dependencies.SimpleExternalSourceResolverHelper;
import com.nxp.swtools.clocks.main.Messages;
import com.nxp.swtools.clocks.ui.SettingEditorHelper;
import com.nxp.swtools.clocks.ui.UiController;
import com.nxp.swtools.clocks.ui.events.GuiController;
import com.nxp.swtools.clocks.ui.table.SettingValueChangeListener;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.NonNullByDefault;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.provider.configuration.dependencies.IFeatureData;
import com.nxp.swtools.provider.configuration.storage.clock.StorageClocksConfiguration;
import com.nxp.swtools.validation.engine.IBaseProblem;
import com.nxp.swtools.validation.engine.IProblemResolveHandler;
import com.nxp.swtools.validation.engine.IValidationProblem;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@NonNullByDefault
public class QuickFixResolveHandler
implements IProblemResolveHandler {
    @Nullable
    ClocksConfig config;
    @Nullable
    IClockElement clockElement;

    public QuickFixResolveHandler(IValidationProblem problem) {
        this.config = QuickFixResolveHandler.getConfig(problem);
        this.clockElement = this.config != null ? QuickFixResolveHandler.getElement(problem, this.config) : null;
    }

    private static @Nullable ClocksConfig getConfig(IValidationProblem problem) {
        List<@NonNull IClocksConfig> configs = UiController.getInstance().getProfile().getConfigs();
        if (problem.getConfiguration() instanceof StorageClocksConfiguration) {
            StorageClocksConfiguration storageConfig = (StorageClocksConfiguration)problem.getConfiguration();
            IClocksConfig clocksConfig = configs.stream().filter(c -> c.getStorageConfig().equals((Object)storageConfig)).findFirst().orElse(null);
            if (clocksConfig instanceof ClocksConfig) {
                return (ClocksConfig)clocksConfig;
            }
        }
        return null;
    }

    private static @Nullable IClockElement getElement(IValidationProblem problem, ClocksConfig config) {
        String outputId = problem.getDependency().getResourceId();
        return config.getMcu().getClockElement(outputId);
    }

    public boolean resolveProblem(@NonNull IBaseProblem baseProblem) {
        boolean isAdvancedResolver = false;
        ClocksConfig clocksConfig = this.config;
        SettingValueChangeListener changeListener = new SettingValueChangeListener(baseProblem);
        ISetting setting = null;
        IClockElement clockElementLoc = this.clockElement;
        if (clockElementLoc != null && (setting = clockElementLoc.getMainSetting()) != null && clocksConfig != null) {
            IValidationProblem problem;
            if (baseProblem instanceof IValidationProblem && (problem = (IValidationProblem)baseProblem).getFeature().getEvaluation().equals("equal")) {
                isAdvancedResolver = true;
                this.setFrequency(problem, setting);
            }
            ClockSource simpleExternalSource = SimpleExternalSourceResolverHelper.getSimpleExternalSource(clocksConfig, clockElementLoc);
            SimpleExternalSourceResolverHelper.States state = SimpleExternalSourceResolverHelper.States.DISABLED;
            Map<ISetting, SettingValue> originalSettings = null;
            if (simpleExternalSource != null) {
                originalSettings = SimpleExternalSourceResolverHelper.getOriginalSettings(clocksConfig, simpleExternalSource);
                state = SimpleExternalSourceResolverHelper.resolveSimpleExternalSource(clocksConfig, clockElementLoc, simpleExternalSource);
            }
            switch (state) {
                case OK: {
                    GuiController.getInstance().refresh();
                    break;
                }
                case DISABLED: {
                    SettingEditorHelper.tryEnableOutput(setting, clocksConfig, changeListener, isAdvancedResolver);
                    break;
                }
                case PROBLEMATIC: {
                    if (originalSettings != null) {
                        SimpleExternalSourceResolverHelper.rollBackSettings(clocksConfig, originalSettings, baseProblem);
                    }
                    SimpleExternalSourceResolverHelper.showErrorMessageDialog(clockElementLoc);
                    break;
                }
            }
            return true;
        }
        return false;
    }

    public @NonNull String getResolveProblemLabel(@NonNull IBaseProblem baseProblem) {
        IValidationProblem problem;
        IClockElement clockElementLoc;
        String clockElementName;
        ClockSource simpleExternalSource;
        String message = Messages.get().DiagramView_EnableOutput;
        if (this.config != null && this.clockElement != null && (simpleExternalSource = SimpleExternalSourceResolverHelper.getSimpleExternalSource(this.config, this.clockElement)) != null) {
            message = Messages.get().DiagramView_ExternalSourceResolver;
        }
        String string = clockElementName = (clockElementLoc = this.clockElement) != null ? clockElementLoc.getName() : "";
        if (this.config != null && clockElementLoc != null && clockElementLoc.isEnabled(this.config) && baseProblem instanceof IValidationProblem && (problem = (IValidationProblem)baseProblem).getFeature().getEvaluation().equals("equal")) {
            message = Messages.get().DiagramView_AdvancedResolver;
        }
        return UtilsText.safeString((String)MessageFormat.format(message, clockElementName));
    }

    private void setFrequency(IValidationProblem problem, ISetting setting) {
        Frequency frequency;
        SettingValueChangeListener changeListener = new SettingValueChangeListener(problem);
        IFeatureData data = (IFeatureData)CollectionsUtils.firstOrNull((Collection)problem.getFeature().getData());
        ClocksConfig clocksConfig = this.config;
        if (data != null && (frequency = Frequency.parse((String)(String.valueOf(data.getValue()) + " " + data.getUnit()))) != null && clocksConfig != null) {
            SettingEditorHelper.setValue(setting, clocksConfig, frequency.toString(), changeListener);
        }
    }
}

