/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.settings;

import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.clocks.data.model.LockState;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.settings.SettingType;
import com.nxp.swtools.clocks.data.settings.SettingValue;
import com.nxp.swtools.clocks.utils.ToolTipBuilder;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;

public abstract class ASetting
implements ISetting {
    @Nullable
    protected Collection<@NonNull ISetting> coLockers = null;
    @NonNull
    protected final IElement element;
    @NonNull
    private static final String NOT_IMPLEMENTED = "Not implemented here.";
    @Nullable
    protected String powerMode = null;
    @NonNull
    protected static final Logger LOGGER = LogManager.getLogger(ASetting.class);

    ASetting(@NonNull IElement element) {
        this.element = element;
    }

    @Override
    public boolean isEnabled(IClocksConfig clocksConfig) {
        LOGGER.info(NOT_IMPLEMENTED);
        return false;
    }

    @Override
    public boolean isEditable(IClocksConfig clocksConfig) {
        LOGGER.info(NOT_IMPLEMENTED);
        return false;
    }

    @Override
    public @Nullable String getDescription() {
        return this.element.getDescription();
    }

    @Override
    public SettingValue parseUiValue(String uiValue, IClocksConfig clocksConfig) {
        return new SettingValue(uiValue);
    }

    @Override
    public @Nullable SettingValue parseBfValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        LOGGER.info(NOT_IMPLEMENTED);
        return null;
    }

    @Override
    public String getAllowedValueDescription(IClocksConfig clocksConfig) {
        return null;
    }

    @Override
    public boolean isVisible(@Nullable IClocksConfig config) {
        return true;
    }

    @Override
    public SettingValue getDefaultValue(IClocksConfig clockConfig) {
        LOGGER.info(NOT_IMPLEMENTED);
        return null;
    }

    @Override
    public @NonNull SettingType getType() {
        return SettingType.OTHER;
    }

    @Override
    public boolean isUserLockable() {
        return true;
    }

    @Override
    public boolean isLockedByDefault() {
        return false;
    }

    @Override
    public @Nullable SettingValue parseValue(@NonNull Object value, @NonNull IClocksConfig clocksConfig) {
        return this.parseUiValue(value.toString(), clocksConfig);
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public boolean isEditableByDefault() {
        LOGGER.info(NOT_IMPLEMENTED);
        return false;
    }

    @Override
    public @NonNull String toString(@NonNull SettingValue settingValue) {
        return UtilsText.safeString((String)settingValue.getValue().toString());
    }

    @Override
    public @Nullable SettingValue fromString(@NonNull String string, @NonNull IClocksConfig clocksConfig) {
        SettingValue result = this.parseValue(string, clocksConfig);
        if (result == null) {
            result = SettingValue.N_A;
        }
        return result;
    }

    @Override
    public boolean isFindNearValueSupported() {
        return false;
    }

    @Override
    public @Nullable String getToolTipText(@NonNull IClocksConfig clocksConfig) {
        return ToolTipBuilder.create(this, clocksConfig);
    }

    @Override
    public @NonNull IElement getElement() {
        return this.element;
    }

    @Override
    public @NonNull Collection<@NonNull ISetting> getSynchronousLockers() {
        return this.coLockers != null ? this.coLockers : CollectionsUtils.emptyList();
    }

    @Override
    public void setSynchronousLockers(@NonNull Collection<@NonNull ISetting> coLockers) throws IllegalStateException {
        if (this.coLockers != null) {
            throw new IllegalStateException("Synchronous lockers already set.");
        }
        this.coLockers = coLockers;
    }

    @Override
    public boolean isUserEnableable() {
        return false;
    }

    @Override
    public boolean isUserEnabled(@NonNull IClocksConfig config) {
        return config.getSettingsConfig().isUserEnabled(this);
    }

    @Override
    public @NonNull Collection<@NonNull String> getUsedBitFields() {
        return CollectionsUtils.emptyList();
    }

    @Override
    public @NonNull Collection<@NonNull String> getDependencies(@NonNull IMcu mcu) {
        return CollectionsUtils.emptyList();
    }

    @Override
    public @NonNull Collection<@NonNull String> getInfluencedSettings(@NonNull IMcu mcu) {
        return CollectionsUtils.emptyList();
    }

    @Override
    public boolean canRead(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) {
        return true;
    }

    @Override
    public boolean isWritable() {
        return false;
    }

    @Override
    public boolean canWrite(@NonNull IClocksConfig config, @NonNull Collection<@NonNull String> resolvedSettingIds) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull SettingValue createCurrentValue(@NonNull IClocksConfig config) {
        return config.getSettingsConfig().getSettingValue(this);
    }

    @Override
    public @NonNull Map<@NonNull ISetting, @NonNull SettingValue> getBitFieldsToWrite(@NonNull IClocksConfig config, @NonNull SettingValue value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull Collection<@NonNull ISetting> getReadOnlySettings(@NonNull IClocksConfig config) {
        return CollectionsUtils.emptyList();
    }

    @Override
    public boolean shouldBeSaved(@NonNull IClocksConfig currentConfig) {
        return this.settingShouldBeSaved(currentConfig);
    }

    public boolean settingShouldBeSaved(@NonNull IClocksConfig currentConfig) {
        if (this.isVisible(currentConfig)) {
            IClocksConfig defaultConfig = currentConfig.getMcu().getDefaultConfig();
            boolean differs = this.isUserLockable() && (currentConfig.isLocked(this) || defaultConfig.isLocked(this)) ? this.isLockDifferent(currentConfig, defaultConfig) : this.isValueDifferent(currentConfig, defaultConfig);
            return differs || this.isUserEnableable() && this.isUserEnableDifferent(currentConfig, defaultConfig);
        }
        return false;
    }

    protected boolean isLockDifferent(@NonNull IClocksConfig clocksConfig, @NonNull IClocksConfig otherConfig) {
        LockState lockState = clocksConfig.getSettingsConfig().getLockState(this);
        LockState otherLockState = otherConfig.getSettingsConfig().getLockState(this);
        if (lockState != null && otherLockState != null) {
            if (this.isAccuracyDifferent(lockState, otherLockState)) {
                return false;
            }
            return this.isValueDifferent(lockState.getValue(), otherLockState.getValue());
        }
        return lockState == null ^ otherLockState == null;
    }

    protected boolean isValueDifferent(@NonNull IClocksConfig clocksConfig, @NonNull IClocksConfig otherConfig) {
        return this.isValueDifferent(clocksConfig.getSettingsConfig().getSettingValue(this), otherConfig.getSettingsConfig().getSettingValue(this));
    }

    protected boolean isValueDifferent(@NonNull SettingValue value, @NonNull SettingValue otherValue) {
        return !value.equals(otherValue);
    }

    protected boolean isAccuracyDifferent(@NonNull LockState lockState, @NonNull LockState otherLockState) {
        BigRational accuracy = lockState.getAccuracy();
        BigRational otherAccuracy = otherLockState.getAccuracy();
        if (accuracy != null && otherAccuracy != null) {
            return accuracy.compareTo(otherAccuracy) != 0;
        }
        return accuracy == null ^ otherAccuracy == null;
    }

    protected boolean isUserEnableDifferent(@NonNull IClocksConfig clocksConfig, @NonNull IClocksConfig otherConfig) {
        return clocksConfig.getSettingsConfig().isUserEnabled(this) ^ otherConfig.getSettingsConfig().isUserEnabled(this);
    }

    @Override
    public boolean isComboSuppressionAllowed() {
        return false;
    }

    @Override
    public @Nullable Range getRangeOfValues(@NonNull IClocksConfig config) {
        return null;
    }

    @Override
    public SettingValue findNearestUiValue(@NonNull String uiValue, @NonNull IClocksConfig clocksConfig) {
        return null;
    }

    @Override
    public boolean isPrioritized() {
        return false;
    }

    @Override
    public void setPowerMode(@NonNull String powerModeID) {
        this.powerMode = powerModeID;
    }

    @Override
    public @Nullable String getPowerMode() {
        return this.powerMode;
    }
}

