/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data.parser;

import com.nxp.swtools.clocks.data.BitFieldsCache;
import com.nxp.swtools.clocks.data.ClockComponent;
import com.nxp.swtools.clocks.data.ClockSlice;
import com.nxp.swtools.clocks.data.Constraint;
import com.nxp.swtools.clocks.data.DiagramData;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.elements.BitFieldAssign;
import com.nxp.swtools.clocks.data.elements.CategoryConfigElement;
import com.nxp.swtools.clocks.data.elements.ClockElementData;
import com.nxp.swtools.clocks.data.elements.ClockGate;
import com.nxp.swtools.clocks.data.elements.ClockOutput;
import com.nxp.swtools.clocks.data.elements.ClockSelect;
import com.nxp.swtools.clocks.data.elements.ClockSource;
import com.nxp.swtools.clocks.data.elements.ClocksBitFieldProvider;
import com.nxp.swtools.clocks.data.elements.ComponentOutput;
import com.nxp.swtools.clocks.data.elements.ConfigElement;
import com.nxp.swtools.clocks.data.elements.ConfigElementItem;
import com.nxp.swtools.clocks.data.elements.DFSPrescaler;
import com.nxp.swtools.clocks.data.elements.EnableDisableCondition;
import com.nxp.swtools.clocks.data.elements.Fll;
import com.nxp.swtools.clocks.data.elements.FnPll;
import com.nxp.swtools.clocks.data.elements.FnPllConfigElement;
import com.nxp.swtools.clocks.data.elements.FnPllRange;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.elements.IConfigElement;
import com.nxp.swtools.clocks.data.elements.IConfigElementItem;
import com.nxp.swtools.clocks.data.elements.IElement;
import com.nxp.swtools.clocks.data.elements.ISignalReference;
import com.nxp.swtools.clocks.data.elements.Pin;
import com.nxp.swtools.clocks.data.elements.PinSignalRef;
import com.nxp.swtools.clocks.data.elements.Pll;
import com.nxp.swtools.clocks.data.elements.Prescaler;
import com.nxp.swtools.clocks.data.elements.UnifiedSignalRef;
import com.nxp.swtools.clocks.data.elements.ValueConfigElement;
import com.nxp.swtools.clocks.data.model.BitFieldElement;
import com.nxp.swtools.clocks.data.model.Range;
import com.nxp.swtools.clocks.data.parser.ClockSignalInterface;
import com.nxp.swtools.clocks.data.parser.ParserException;
import com.nxp.swtools.clocks.data.parser.XsdValidationHandler;
import com.nxp.swtools.clocks.data.settings.EnableSetting;
import com.nxp.swtools.clocks.data.settings.ISetting;
import com.nxp.swtools.clocks.data.valueMaps.IValueMapBuilder;
import com.nxp.swtools.clocks.data.valueMaps.ValueMap;
import com.nxp.swtools.clocks.expression.ComponentContext;
import com.nxp.swtools.clocks.expression.DefaultContext;
import com.nxp.swtools.clocks.expression.Expression;
import com.nxp.swtools.clocks.expression.IRegistersContext;
import com.nxp.swtools.clocks.expression.RegistersContext;
import com.nxp.swtools.clocks.model.ENodeType;
import com.nxp.swtools.clocks.ui.diagram.DiagramLoader;
import com.nxp.swtools.clocks.ui.diagram.XmlUtil;
import com.nxp.swtools.clocks.ui.diagramsymbols.DiagramSymbol;
import com.nxp.swtools.clocks.utils.Converter;
import com.nxp.swtools.clocks.utils.ExpressionUtils;
import com.nxp.swtools.clocks.utils.Text;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.expression.IContext;
import com.nxp.swtools.common.utils.expression.OperatorType;
import com.nxp.swtools.common.utils.frequency.Frequency;
import com.nxp.swtools.common.utils.frequency.FrequencyCalculator;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.logging.LogManager;
import com.nxp.swtools.common.utils.rational.BigRational;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.common.utils.xml.UtilsXmlDom;
import com.nxp.swtools.configuration.properties.SWToolsProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class ComponentParser {
    @NonNull
    private static final Logger LOGGER = LogManager.getLogger(ComponentParser.class);

    private static @NonNull Element getElementByTagName(Element parent, String tagName) throws ParserException {
        NodeList nodes = parent.getElementsByTagName(tagName);
        if (nodes.getLength() != 1) {
            throw new ParserException("Only one tag supported with name: " + tagName);
        }
        Element element = (Element)nodes.item(0);
        assert (element != null);
        return element;
    }

    public static @NonNull IClockComponent parse(@NonNull BitFieldsCache bitFieldsCache, @NonNull InputStream file, @NonNull String id, @NonNull String name, @NonNull String peripheral, @NonNull String comp, @NonNull String filePath, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> notAvailableElements) throws ParserException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        Map<@NonNull String, IClockElement> elements = new LinkedHashMap<String, IClockElement>();
        HashMap<@NonNull String, @NonNull String> signalMapping = new HashMap<String, String>();
        HashMap<@NonNull String, @NonNull Pin> pins = new HashMap();
        HashMap<@NonNull String, ClockSignalInterface> signalInterfaces = new HashMap();
        ArrayList<@NonNull ClockSlice> slices = new ArrayList<ClockSlice>();
        ArrayList<@NonNull IConfigElement> configElements = new ArrayList<IConfigElement>();
        List<EnableDisableCondition> enableDisableConditions = null;
        try {
            DocumentBuilder dBuilder = factory.newDocumentBuilder();
            XsdValidationHandler handlerXSD = new XsdValidationHandler(LOGGER, filePath);
            dBuilder.setErrorHandler(handlerXSD);
            Document doc = dBuilder.parse(file);
            doc.normalize();
            UtilsXmlDom.setFileNameToUserData((Node)doc, (String)filePath);
            Element root = doc.getDocumentElement();
            if (!comp.equals(root.getAttribute("id"))) {
                LOGGER.severe("Expected component " + comp + " in file " + filePath + " not found!");
            }
            NodeList rootChildNodes = root.getChildNodes();
            int i = 0;
            while (i < rootChildNodes.getLength()) {
                Node node = Objects.requireNonNull(rootChildNodes.item(i));
                if (node.getNodeType() == 1 && "interface".equals(node.getNodeName())) {
                    Element interfaceElement = (Element)node;
                    pins = ComponentParser.parsePins(id, interfaceElement, peripheral, bitFieldsCache, notAvailableElements);
                    signalInterfaces = ComponentParser.parseSignalInterfaces(id, interfaceElement, bitFieldsCache);
                }
                if (node.getNodeType() == 1 && "implementation".equals(node.getNodeName())) {
                    Element implementationElement = (Element)node;
                    ComponentContext context = new ComponentContext(peripheral, id, bitFieldsCache);
                    context.setFilePath(filePath);
                    enableDisableConditions = ComponentParser.parseControlAndConstraints(implementationElement, id, context, constraints, instanceMapping);
                    elements = ComponentParser.parseImplementation(id, bitFieldsCache, implementationElement, signalMapping, instanceMapping, false, notAvailableElements, constraints, configElements, context, pins, signalInterfaces, slices, false);
                }
                ++i;
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            LOGGER.log(Level.SEVERE, "Error while parsing component '" + id + "' at path '" + filePath + "'.", e);
        }
        if (UtilsText.isEmpty((String)id)) {
            LOGGER.log(Level.WARNING, "Component ID must by specified.");
        }
        if (enableDisableConditions == null) {
            enableDisableConditions = new ArrayList<EnableDisableCondition>(0);
        }
        ClockComponent component = new ClockComponent(id, name, peripheral, elements, signalMapping, configElements, null, constraints);
        component.setEnableSetting(new EnableSetting(id, (IElement)component, enableDisableConditions));
        component.setSlices(slices);
        return component;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static @NonNull Map<@NonNull String, ClockSignalInterface> parseSignalInterfaces(@NonNull String componentID, @NonNull Element interfaceElement, @NonNull BitFieldsCache mcuRegisters) {
        HashMap<@NonNull String, ClockSignalInterface> interfaceSignals = new HashMap<String, ClockSignalInterface>();
        @NonNull Stream elems = CollectionsUtils.getInstancesOf(XmlUtil.asList(interfaceElement.getChildNodes()), Element.class);
        elems.filter(x -> "input_clock_signal".equals(x.getTagName()) || "output_clock_signal".equals(x.getTagName())).forEach(x -> {
            String signalID = UtilsText.safeString((String)x.getAttribute("id"));
            String name = UtilsText.safeString((String)x.getAttribute("name"));
            String description = UtilsText.safeString((String)x.getAttribute("description"));
            String group = x.getAttribute("group");
            String availableExpr = UtilsText.safeString((String)x.getAttribute("available"));
            String isTopOutputText = UtilsText.safeString((String)x.getAttribute("top_output"));
            boolean available = availableExpr.isEmpty() ? true : Expression.create(availableExpr, (IContext)new RegistersContext(mcuRegisters)).resolve().getBoolean();
            boolean isInput = "output_clock_signal".equals(x.getTagName());
            String id = componentID.isEmpty() ? signalID : String.valueOf(componentID) + "." + signalID;
            boolean isTopOutput = componentID.isEmpty() || Boolean.parseBoolean(isTopOutputText);
            interfaceSignals.put(id, new ClockSignalInterface(id, name, isInput, isTopOutput, available, group, description));
        });
        return interfaceSignals;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private static @NonNull Map<@NonNull String, @NonNull Pin> parsePins(@NonNull String id, @NonNull Element interfaceElement, @NonNull String peripheral, @NonNull BitFieldsCache mcuRegisters, @NonNull Map<@NonNull String, @NonNull String> notAvailableElements) {
        HashMap<@NonNull String, @NonNull Pin> result = new HashMap<String, Pin>();
        @NonNull Stream elems = CollectionsUtils.getInstancesOf(XmlUtil.asList(interfaceElement.getChildNodes()), Element.class);
        elems.filter(x -> "pin".equals(x.getTagName())).forEach(y -> {
            @NonNull String pinId = UtilsText.safeString((String)y.getAttribute("id"));
            String fullId = String.valueOf(id) + "." + pinId;
            if (ComponentParser.available(mcuRegisters, y)) {
                Pin p = ComponentParser.parsePin(fullId, y, peripheral);
                if (p != null) {
                    result.put(pinId, p);
                }
            } else {
                notAvailableElements.put(fullId, "");
            }
        });
        return result;
    }

    private static Pin parsePin(@NonNull String fullId, @NonNull Element pinElem, @NonNull String peripheral) {
        String id = pinElem.getAttribute("id");
        String name = pinElem.getAttribute("name");
        String direction = pinElem.getAttribute("direction");
        String description = pinElem.getAttribute("description");
        if (UtilsText.isEmpty((String)id) || UtilsText.isEmpty((String)name)) {
            LOGGER.warning("Invalid state for pin " + fullId + ". Expected nonNull,non-empty values of id:'" + id + "', name:'" + name + "'.");
            return null;
        }
        Pin.Direction dir = Pin.Direction.UNDEFINED;
        if ("in".equals(direction)) {
            dir = Pin.Direction.IN;
        }
        if ("out".equals(direction)) {
            dir = Pin.Direction.OUT;
        }
        String string = description = UtilsText.isEmpty((String)description) ? null : description;
        assert (name != null);
        try {
            return new Pin(fullId, name, dir, description, peripheral, ComponentParser.parseSignalRefForPin(pinElem));
        }
        catch (ParserException e) {
            LOGGER.log(Level.SEVERE, "Pin '" + fullId + "' can not be parsed.", e.getMessage());
            return null;
        }
    }

    private static @NonNull ISignalReference parseSignalRefForPin(@NonNull Element pinElem) throws ParserException {
        for (Node node : XmlUtil.asList(pinElem.getChildNodes())) {
            String resourceType;
            if (!(node instanceof Element)) continue;
            Element element = (Element)node;
            if ("peripheral_signal_ref".equals(element.getNodeName())) {
                return new PinSignalRef(element.getAttribute("signal"));
            }
            if (!"dependency".equals(element.getNodeName())) continue;
            String resourceId = element.getAttribute("resource_id_expr");
            if (UtilsText.isEmpty((String)resourceId)) {
                LOGGER.warning("Dependency resource ID for a pin is empty.");
            }
            if ((resourceType = element.getAttribute("resource_type")).isEmpty() || "pinSignal".equals(resourceType)) {
                return new PinSignalRef(resourceId);
            }
            if (!"peripheralUnifiedSignal".equals(resourceType)) continue;
            return new UnifiedSignalRef(resourceId);
        }
        throw new ParserException("No valid pin dependency present.");
    }

    private static @NonNull List<@NonNull EnableDisableCondition> parseControlAndConstraints(@NonNull Element elem, @NonNull String id, @NonNull IContext context, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping) {
        NodeList controlAndConstraintsElements = elem.getElementsByTagName("control_and_constraints");
        List<Object> enableDisableConditions = null;
        if (controlAndConstraintsElements.getLength() == 1) {
            Node controlAndConstraintsElement = Objects.requireNonNull(controlAndConstraintsElements.item(0));
            NodeList childNodes = controlAndConstraintsElement.getChildNodes();
            assert (childNodes != null);
            enableDisableConditions = ComponentParser.parseEnableAndConstraints(id, childNodes, context, constraints, instanceMapping, false);
        } else if (controlAndConstraintsElements.getLength() != 0) {
            LOGGER.warning(String.valueOf(id) + ": Exactly one control and constraints block expected");
        }
        if (enableDisableConditions == null) {
            enableDisableConditions = new ArrayList(0);
        }
        return enableDisableConditions;
    }

    public static @NonNull Map<@NonNull String, IClockElement> parseImplementation(@NonNull String componentID, @NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull Map<@NonNull String, @NonNull String> signalMapping, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, boolean highLevel, @NonNull Map<@NonNull String, @NonNull String> notAvailableElements, @NonNull List<@NonNull Constraint> constraints, @NonNull Collection<@NonNull IConfigElement> confElements, @NonNull ComponentContext context, @NonNull Map<@NonNull String, @NonNull Pin> pins, @NonNull Map<@NonNull String, ClockSignalInterface> signalInterfaces, @NonNull List<@NonNull ClockSlice> slices, boolean sliceUnavailable) throws ParserException {
        String id;
        LinkedHashMap<@NonNull String, IClockElement> elements = new LinkedHashMap<String, IClockElement>();
        NodeList childNodes = elem.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Element pllElement;
            String input;
            IClockElement previousElement;
            IConfigElement config;
            Element configElement;
            Node node = Objects.requireNonNull(childNodes.item(i));
            if (node.getNodeType() == 1 && "configuration_element".equals(node.getNodeName())) {
                configElement = (Element)node;
                config = ComponentParser.parseConfigElement(mcuRegisters, configElement, constraints, true, context, instanceMapping, confElements);
                confElements.add(config);
            } else if (node.getNodeType() == 1 && "configuration_element_category".equals(node.getNodeName())) {
                configElement = (Element)node;
                config = ComponentParser.parseCategoryConfigElement(configElement, confElements);
                confElements.add(config);
            } else if (node.getNodeType() == 1 && "clock_source".equals(node.getNodeName())) {
                Element clocksSourceElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, clocksSourceElement) && !sliceUnavailable) {
                    ClockSource clockSource = ComponentParser.parseClockSource(mcuRegisters, clocksSourceElement, constraints, instanceMapping, context, pins);
                    previousElement = elements.put(clockSource.getID(), clockSource);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, clocksSourceElement);
                    notAvailableElements.put(id, "");
                }
            } else if (node.getNodeType() == 1 && "prescaler".equals(node.getNodeName())) {
                Element prescalerElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, prescalerElement) && !sliceUnavailable) {
                    IClockElement previousElement2;
                    if (prescalerElement.getElementsByTagName("dfs_divider").getLength() != 0) {
                        DFSPrescaler dfsPrescaler = ComponentParser.parseDFSPrescaler(mcuRegisters, prescalerElement, constraints, instanceMapping, context, false);
                        previousElement2 = elements.put(dfsPrescaler.getID(), dfsPrescaler);
                    } else {
                        Prescaler prescaler = ComponentParser.parsePrescaler(componentID, mcuRegisters, prescalerElement, constraints, instanceMapping, context, false);
                        previousElement2 = elements.put(prescaler.getID(), prescaler);
                    }
                    if (previousElement2 != null) {
                        LOGGER.warning(String.valueOf(previousElement2.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, prescalerElement);
                    input = ComponentParser.parseInputSignalElement(context, id, prescalerElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "pll".equals(node.getNodeName())) {
                pllElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, pllElement) && !sliceUnavailable) {
                    Pll pll = ComponentParser.parsePll(componentID, mcuRegisters, pllElement, constraints, instanceMapping, context);
                    previousElement = elements.put(pll.getID(), pll);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, pllElement);
                    input = ComponentParser.parseInputSignalElement(context, id, pllElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "fnpll".equals(node.getNodeName())) {
                pllElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, pllElement) && !sliceUnavailable) {
                    FnPll fnpll = ComponentParser.parseFnPll(mcuRegisters, pllElement, constraints, instanceMapping, context);
                    previousElement = elements.put(fnpll.getID(), fnpll);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, pllElement);
                    input = ComponentParser.parseInputSignalElement(context, id, pllElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "clock_select".equals(node.getNodeName())) {
                Element clockSelectElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, clockSelectElement) && !sliceUnavailable) {
                    ClockSelect clockSelect = ComponentParser.parseClockSelect(mcuRegisters, clockSelectElement, instanceMapping, constraints, context);
                    previousElement = elements.put(clockSelect.getID(), clockSelect);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, clockSelectElement);
                    input = ComponentParser.parseInputSignalElement(context, id, clockSelectElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "fll".equals(node.getNodeName())) {
                Element fllElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, fllElement) && !sliceUnavailable) {
                    Fll fll = ComponentParser.parseFll(mcuRegisters, fllElement, constraints, instanceMapping, context);
                    previousElement = elements.put(fll.getID(), fll);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, fllElement);
                    input = ComponentParser.parseInputSignalElement(context, id, fllElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "map_output".equals(node.getNodeName()) && !highLevel) {
                Element outputMapElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, outputMapElement) && !sliceUnavailable) {
                    IClockElement output = ComponentParser.parseComponentOutput(componentID, mcuRegisters, outputMapElement, signalMapping, instanceMapping, constraints, context, signalInterfaces, pins);
                    previousElement = elements.put(output.getID(), output);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, outputMapElement);
                    input = ComponentParser.parseInputSignalElement(context, id, outputMapElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "clock_enable".equals(node.getNodeName())) {
                Element gateElement = (Element)node;
                if (ComponentParser.available(mcuRegisters, gateElement) && !sliceUnavailable) {
                    ClockGate gate = ComponentParser.parseClockGate(mcuRegisters, gateElement, instanceMapping, constraints, context);
                    previousElement = elements.put(gate.getID(), gate);
                    if (previousElement != null) {
                        LOGGER.warning(String.valueOf(previousElement.getID()) + " duplicated!");
                    }
                } else {
                    id = ComponentParser.getElementID(componentID, gateElement);
                    input = ComponentParser.parseInputSignalElement(context, id, gateElement, instanceMapping);
                    notAvailableElements.put(id, input);
                }
            } else if (node.getNodeType() == 1 && "clock_slice".equals(node.getNodeName())) {
                Element sliceElement = (Element)node;
                String sliceID = ComponentParser.getElementID(componentID, sliceElement);
                ComponentContext sliceContext = new ComponentContext(context.getPeripheral(), sliceID, context.getRegisters());
                sliceContext.setSlice(true);
                boolean unavailable = !ComponentParser.available(mcuRegisters, sliceElement) || sliceUnavailable;
                ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, sliceElement, constraints, instanceMapping, context, false);
                LinkedHashMap<@NonNull String, @NonNull String> sliceSignalMapping = new LinkedHashMap<String, String>();
                LinkedHashMap<@NonNull String, @NonNull String> sliceExtPinMapping = new LinkedHashMap<String, String>();
                ComponentParser.parseClockSliceSignalMap(elementData, instanceMapping, sliceSignalMapping, sliceExtPinMapping);
                HashMap<@NonNull String, @NonNull String> sliceInstanceMapping = new HashMap<String, String>(instanceMapping);
                for (Map.Entry entry : sliceSignalMapping.entrySet()) {
                    sliceInstanceMapping.put(String.valueOf(sliceID) + "." + (String)entry.getKey(), (String)entry.getValue());
                }
                HashMap<@NonNull String, @NonNull Pin> slicePins = new HashMap<String, Pin>(pins);
                for (Map.Entry entry : sliceExtPinMapping.entrySet()) {
                    String slicePin = (String)entry.getKey();
                    String mcuPin = (String)entry.getValue();
                    Pin pin = pins.get(mcuPin);
                    if (pin == null) continue;
                    slicePins.put(slicePin, pin);
                }
                @NonNull HashMap<@NonNull String, @NonNull String> notAvailableInSlice = new HashMap<String, String>();
                Map<@NonNull String, IClockElement> sliceElements = ComponentParser.parseImplementation(sliceID, mcuRegisters, sliceElement, signalMapping, sliceInstanceMapping, false, notAvailableInSlice, constraints, confElements, sliceContext, slicePins, signalInterfaces, slices, unavailable);
                notAvailableElements.putAll(notAvailableInSlice);
                slices.add(ComponentParser.parseClockSlice(context, sliceElement, elementData, sliceID, sliceElements, sliceSignalMapping, sliceExtPinMapping, notAvailableInSlice));
            }
            ++i;
        }
        for (IClockElement element : elements.values()) {
            EnableSetting enableSetting = element.getEnableSetting();
            String string = id = context.isSlice() ? context.getPeripheral() : context.getComponentID();
            if (enableSetting == null || id.isEmpty()) continue;
            enableSetting.setComponentEnableCondition(Expression.create(String.valueOf(id) + "." + "enable"));
        }
        return elements;
    }

    private static @NonNull ClockSlice parseClockSlice(@NonNull ComponentContext context, @NonNull Element sliceElement, @NonNull ClockElementData elementData, @NonNull String sliceID, @NonNull Map<@NonNull String, IClockElement> elements, @NonNull Map<@NonNull String, @NonNull String> sliceSignalMapping, @NonNull Map<@NonNull String, @NonNull String> pinMapping, @NonNull Map<@NonNull String, @NonNull String> unavailableElements) {
        File parentDir;
        List<@NonNull DiagramSymbol> diagramSymbols = new ArrayList<DiagramSymbol>();
        String diagramFileName = UtilsText.safeString((String)sliceElement.getAttribute("diagram_file"));
        String filePath = context.getFilePath();
        if (filePath != null && (parentDir = new File(filePath).getParentFile()) != null) {
            File diagramFile = new File(parentDir, diagramFileName);
            if (diagramFile.isFile()) {
                DiagramLoader loader = new DiagramLoader(diagramFile);
                diagramSymbols = loader.load();
                DiagramData.removeUnwantedJunctions(0.01, diagramSymbols);
                diagramSymbols.forEach(x -> {
                    String id = String.valueOf(sliceID) + "." + x.getId();
                    if (elements.containsKey(id) || unavailableElements.containsKey(id)) {
                        x.setId(id);
                    }
                });
            } else {
                LOGGER.severe(MessageFormat.format("Diagram file : {0} is not found for slice: {1}", diagramFile, sliceID));
            }
        }
        return new ClockSlice(sliceID, UtilsText.safeString((String)elementData.getName()), elements, diagramSymbols, sliceSignalMapping, pinMapping, unavailableElements);
    }

    public static boolean available(@NonNull BitFieldsCache mcuRegisters, @NonNull Element elem) {
        boolean result = true;
        String availableExpr = UtilsText.safeString((String)elem.getAttribute("available"));
        if (!availableExpr.isEmpty()) {
            Expression available = Expression.create(availableExpr, (IContext)new RegistersContext(mcuRegisters));
            result = available.resolve().getBoolean();
        }
        return result;
    }

    private static @NonNull IClockElement parseComponentOutput(@NonNull String componentID, @NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, Map<@NonNull String, @NonNull String> signalMapping, @NonNull Map<@NonNull String, String> instanceMapping, @NonNull List<@NonNull Constraint> constraints, @NonNull ComponentContext context, @NonNull Map<@NonNull String, ClockSignalInterface> signalInterfaces, @NonNull Map<@NonNull String, @NonNull Pin> pins) throws ParserException {
        boolean isOutput = false;
        String group = "component";
        String simpleID = UtilsText.safeString((String)elem.getAttribute("id"));
        ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, elem, constraints, instanceMapping, context, false);
        ClockSignalInterface clockSignalInterface = signalInterfaces.get(elementData.getId());
        if (clockSignalInterface != null) {
            elementData.setName(clockSignalInterface.getName());
            String description = clockSignalInterface.getDescription();
            if (description != null) {
                elementData.setDescription(description);
            }
            isOutput = clockSignalInterface.isTopOutput();
            group = clockSignalInterface.getGroup();
        } else {
            LOGGER.warning(String.valueOf(elementData.getId()) + " component output has no entry matching in component interface of component" + componentID);
        }
        String signal = elementData.getInputSignal();
        String instanceSignal = instanceMapping.get(signal);
        if (instanceSignal != null) {
            signal = instanceSignal;
        }
        assert (signal != null && !"".equals(signal));
        signalMapping.put(elementData.getId(), String.valueOf(elementData.getId()) + ".clk");
        ArrayList<@NonNull Pin> includedPins = new ArrayList<Pin>();
        NodeList childNodes = elem.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = Objects.requireNonNull(childNodes.item(i));
            if (node.getNodeType() == 1 && "pin".equals(node.getNodeName())) {
                Element e = (Element)node;
                String pinId = e.getAttribute("id");
                NodeList pinChildNodes = node.getChildNodes();
                if (pins.containsKey(pinId)) {
                    List<@NonNull EnableDisableCondition> enableConditions = ComponentParser.parseEnableAndConstraints(elementData.getId(), pinChildNodes, context, constraints, instanceMapping, false);
                    Pin pin = Objects.requireNonNull(pins.get(pinId));
                    pin.setEnableSetting(new EnableSetting(pin.getID(), (IElement)pin, enableConditions));
                    includedPins.add(pin);
                } else {
                    LOGGER.warning("Clock output " + elementData.getId() + " refers to pin " + pinId + ", but no such pin exist");
                }
            }
            ++i;
        }
        ComponentParser.createPinSoftEnableConditions(includedPins, simpleID, context);
        if (isOutput) {
            ClockOutput.CMU cmu = ComponentParser.parseCMU(elementData.getConfigElements(), elem);
            ClockOutput clockOutput = new ClockOutput(elementData, signal, cmu, group, includedPins);
            clockOutput.addNestedSetting(new EnableSetting(elementData.getId(), (IElement)clockOutput, elementData.getEnableDisableConditions()));
            return clockOutput;
        }
        return new ComponentOutput(elementData, includedPins);
    }

    public static @Nullable ClockOutput.CMU parseCMU(List<@NonNull IConfigElement> configElems, @NonNull Element elem) {
        String elementID = elem.getAttribute("id");
        Element mapOut = ComponentParser.parseMapOut(elem, elementID);
        if (mapOut != null) {
            NodeList cmu = mapOut.getElementsByTagName("cmu");
            Element cmuElem = null;
            if (cmu.getLength() == 1) {
                cmuElem = (Element)cmu.item(0);
            }
            if (cmuElem != null) {
                String cmuID = cmuElem.getAttribute("id");
                String cmuName = cmuElem.getAttribute("name");
                String cmuDesc = cmuElem.getAttribute("description");
                String controlID = cmuElem.getAttribute("control_id");
                String divTypeID = cmuElem.getAttribute("div_type_id");
                String enableID = cmuElem.getAttribute("enable_id");
                String lowFreqID = cmuElem.getAttribute("min_freq_id");
                String highFreqID = cmuElem.getAttribute("max_freq_id");
                ISetting enableCMUSetting = null;
                ISetting lowFreqSetting = null;
                ISetting highFreqSetting = null;
                ISetting controlSetting = null;
                for (IConfigElement configElem : configElems) {
                    ISetting setting = configElem.getSetting();
                    if (setting.getId().equals(enableID)) {
                        enableCMUSetting = setting;
                        continue;
                    }
                    if (setting.getId().equals(lowFreqID)) {
                        lowFreqSetting = setting;
                        continue;
                    }
                    if (setting.getId().equals(highFreqID)) {
                        highFreqSetting = setting;
                        continue;
                    }
                    if (!setting.getId().equals(controlID)) continue;
                    controlSetting = setting;
                }
                if (enableCMUSetting != null && controlSetting != null) {
                    return new ClockOutput.CMU(cmuID, cmuName, cmuDesc, controlSetting, divTypeID, enableCMUSetting, lowFreqSetting, highFreqSetting);
                }
            }
        }
        return null;
    }

    public static @Nullable Element parseMapOut(@NonNull Element elem, @NonNull String id) {
        NodeList implementation;
        Node grandParent;
        Element mapOut = null;
        Node parent = elem.getParentNode();
        if (parent != null && (grandParent = parent.getParentNode()) != null && (implementation = ((Element)grandParent).getElementsByTagName("implementation")).getLength() == 1) {
            Element implement = (Element)Objects.requireNonNull(implementation.item(0));
            NodeList mapOutputs = implement.getElementsByTagName("map_output");
            int i = 0;
            while (i < mapOutputs.getLength()) {
                Element mapOutputElement = (Element)Objects.requireNonNull(mapOutputs.item(i));
                String mapOutputID = mapOutputElement.getAttribute("id");
                if (mapOutputID.equals(id)) {
                    mapOut = mapOutputElement;
                    break;
                }
                ++i;
            }
            if (mapOut == null) {
                LOGGER.severe("No mapping found for output: " + id);
            }
        }
        return mapOut;
    }

    public static @NonNull List<@NonNull IConfigElement> parseLocalConfigElements(@NonNull BitFieldsCache mcuRegisters, Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull IContext context, @NonNull Map<@NonNull String, String> instanceMapping) throws ParserException {
        ArrayList<@NonNull IConfigElement> result = new ArrayList<IConfigElement>();
        NodeList configElements = elem.getElementsByTagName("configuration_element");
        int i = 0;
        while (i < configElements.getLength()) {
            Element configElement = (Element)configElements.item(i);
            result.add(ComponentParser.parseConfigElement(mcuRegisters, configElement, constraints, false, context, instanceMapping, null));
            ++i;
        }
        return result;
    }

    private static @NonNull IConfigElement parseConfigElement(@NonNull BitFieldsCache mcuRegisters, Element elem, @NonNull List<@NonNull Constraint> constraints, boolean global, @NonNull IContext context, @NonNull Map<@NonNull String, String> instanceMapping, @Nullable Collection<@NonNull IConfigElement> confElements) throws ParserException {
        IRegistersContext regsContext;
        String id = UtilsText.safeString((String)elem.getAttribute("id"));
        String name = UtilsText.safeString((String)elem.getAttribute("name"));
        String description = UtilsText.safeString((String)elem.getAttribute("description"));
        String availablity = UtilsText.safeString((String)elem.getAttribute("available"));
        boolean hidden = "true".equals(elem.getAttribute("hidden"));
        boolean powerModeSpecific = "true".equals(elem.getAttribute("power_mode_specific"));
        boolean componentOnly = "true".equals(elem.getAttribute("component_only"));
        if (availablity.isEmpty()) {
            availablity = "true";
            regsContext = (IRegistersContext)DefaultContext.getInstance();
        } else {
            regsContext = new RegistersContext(mcuRegisters);
        }
        NodeList defaultElements = elem.getElementsByTagName("default");
        String defaultValue = "";
        if (defaultElements.getLength() == 1) {
            Element defaultElement = (Element)Objects.requireNonNull(defaultElements.item(0));
            defaultValue = UtilsText.safeString((String)defaultElement.getAttribute("value"));
        } else {
            LOGGER.warning(MessageFormat.format("Exactly one default item expected at control element id={0}", id));
        }
        NodeList rangeItemElements = elem.getElementsByTagName("range_item");
        NodeList valueFieldElements = elem.getElementsByTagName("value_field");
        Map<@NonNull Object, @NonNull Object> items = new HashMap();
        List<@NonNull EnableDisableCondition> enableDisableConditions = ComponentParser.parseEnableAndConstraints(id, elem.getChildNodes(), context, constraints, instanceMapping, true);
        IConfigElement parent = null;
        if (confElements != null) {
            parent = ComponentParser.parseConfigElementParent(elem, confElements);
        }
        if (rangeItemElements.getLength() == 1) {
            items = ComponentParser.parseRangeItems(ComponentParser.getElementByTagName(elem, "range_item"), id, context, mcuRegisters);
        } else {
            if (valueFieldElements.getLength() == 1) {
                Element valueFieldElement = Objects.requireNonNull((Element)valueFieldElements.item(0));
                String signed = UtilsText.safeString((String)valueFieldElement.getAttribute("signed"));
                String configElemInputType = UtilsText.safeString((String)valueFieldElement.getAttribute("type"));
                items = ComponentParser.parseValueField(valueFieldElement, id, constraints, context, mcuRegisters, instanceMapping);
                return new ValueConfigElement(id, name, description, Objects.requireNonNull((IConfigElementItem)items.get(id)), defaultValue, global, constraints, enableDisableConditions, signed, configElemInputType, availablity, hidden, powerModeSpecific, parent, componentOnly);
            }
            items = ComponentParser.parseItems(elem, id, constraints, context, mcuRegisters, instanceMapping);
        }
        return new ConfigElement(id, name, description, items, defaultValue, global, constraints, enableDisableConditions, availablity, hidden, powerModeSpecific, regsContext, parent, componentOnly);
    }

    private static @NonNull CategoryConfigElement parseCategoryConfigElement(Element element, @NonNull Collection<@NonNull IConfigElement> confElements) {
        String id = UtilsText.safeString((String)element.getAttribute("id"));
        String name = UtilsText.safeString((String)element.getAttribute("name"));
        String description = UtilsText.safeString((String)element.getAttribute("description"));
        boolean componentOnly = "true".equals(element.getAttribute("component_only"));
        IConfigElement parent = ComponentParser.parseConfigElementParent(element, confElements);
        return new CategoryConfigElement(name, id, description, parent, componentOnly);
    }

    private static @Nullable IConfigElement parseConfigElementParent(Element element, @NonNull Collection<@NonNull IConfigElement> confElements) {
        String parentId = UtilsText.safeString((String)element.getAttribute("parent_id"));
        IConfigElement parent = null;
        if (!parentId.equals("") && (parent = (IConfigElement)CollectionsUtils.findFirst(confElements, x -> x.getID().equals(parentId))) == null) {
            LOGGER.severe(MessageFormat.format("Cannot find parent global configuration element with ID: {0}", parentId));
        }
        return parent;
    }

    private static Map<@NonNull String, @NonNull IConfigElementItem> parseValueField(@NonNull Element valueItem, @NonNull String id, @NonNull List<@NonNull Constraint> constraints, @NonNull IContext context, @NonNull BitFieldsCache mcuRegisters, @NonNull Map<@NonNull String, String> instanceMapping) {
        HashMap<@NonNull String, @NonNull IConfigElementItem> valueConfigItems = new HashMap<String, IConfigElementItem>();
        HashMap<@NonNull String, @NonNull BitFieldAssign> assigns = new HashMap();
        HashMap<@NonNull String, @NonNull Expression> conditions = new HashMap<String, Expression>();
        NodeList assignsElements = valueItem.getElementsByTagName("assigns");
        String description = UtilsText.safeString((String)valueItem.getAttribute("description"));
        if (assignsElements.getLength() == 1) {
            Element assignElement = (Element)assignsElements.item(0);
            assert (assignElement != null);
            assigns = ComponentParser.parseAssigns(assignElement, context, mcuRegisters);
        }
        String expression = UtilsText.safeString((String)valueItem.getAttribute("expr"));
        NodeList constraintElements = valueItem.getElementsByTagName("constraint");
        int j = 0;
        while (j < constraintElements.getLength()) {
            Element constraintElement = (Element)constraintElements.item(j);
            assert (constraintElement != null);
            Constraint constraint = ComponentParser.parseConstraint(constraintElement, String.valueOf(id) + "." + id, context, instanceMapping);
            if (constraint != null) {
                constraints.add(constraint);
            }
            ++j;
        }
        ConfigElementItem item = new ConfigElementItem(id, description, assigns, conditions, "", expression);
        valueConfigItems.put(id, item);
        return valueConfigItems;
    }

    private static @NonNull Map<@NonNull String, @NonNull IConfigElementItem> parseRangeItems(@NonNull Element rangeItem, String id, @NonNull IContext context, @NonNull BitFieldsCache mcuRegisters) throws ParserException {
        LinkedHashMap<@NonNull String, @NonNull IConfigElementItem> rangeItems = new LinkedHashMap<String, IConfigElementItem>();
        Element assign = ComponentParser.getElementByTagName(rangeItem, "assign");
        String register = UtilsText.safeString((String)assign.getAttribute("register"));
        String bitField = UtilsText.safeString((String)assign.getAttribute("bit_field"));
        String valueMapping = UtilsText.safeString((String)rangeItem.getAttribute("value_mapping"));
        Map<@NonNull String, @NonNull String> items = ComponentParser.parseValueMapping(valueMapping, rangeItem);
        String bitFieldId = context.getBitFieldId(register, bitField);
        BitFieldElement bf = ClocksBitFieldProvider.getBitFieldById(bitFieldId, mcuRegisters);
        if (bf == null) {
            throw new ParserException(String.valueOf(bitFieldId) + ": no such bitfield exists in config element " + id);
        }
        items.forEach((k, v) -> {
            HashMap<@NonNull String, @NonNull BitFieldAssign> assigns = new HashMap<String, BitFieldAssign>();
            BitFieldAssign bitFieldAssign = new BitFieldAssign(bitFieldId);
            bitFieldAssign.addAssign(Expression.EXPRESSION_TRUE, Expression.create(v, context), null);
            assigns.put(bitFieldId, bitFieldAssign);
            rangeItems.put((String)k, new ConfigElementItem((String)k, (String)k, (Map<String, BitFieldAssign>)assigns, (Map<String, Expression>)new HashMap<String, Expression>(), ""));
        });
        return rangeItems;
    }

    private static @NonNull Map<@NonNull String, @NonNull IConfigElementItem> parseItems(Element elem, String parentID, @NonNull List<@NonNull Constraint> constraints, @NonNull IContext context, @NonNull BitFieldsCache mcuRegisters, @NonNull Map<@NonNull String, String> instanceMapping) {
        LinkedHashMap<@NonNull String, @NonNull IConfigElementItem> items = new LinkedHashMap<String, IConfigElementItem>();
        NodeList itemElements = elem.getElementsByTagName("item");
        int i = 0;
        while (i < itemElements.getLength()) {
            @NonNull HashMap<@NonNull String, BitFieldAssign> assigns = new HashMap();
            HashMap<@NonNull String, @NonNull Expression> conditions = new HashMap<String, Expression>();
            Element itemElement = (Element)Objects.requireNonNull(itemElements.item(i));
            String id = UtilsText.safeString((String)itemElement.getAttribute("id"));
            String description = UtilsText.safeString((String)itemElement.getAttribute("description"));
            NodeList longDescElements = itemElement.getElementsByTagName("long_description");
            String longDesc = longDescElements.getLength() == 1 ? Objects.requireNonNull(longDescElements.item(0)).getTextContent() : null;
            NodeList assignsElements = itemElement.getElementsByTagName("assigns");
            if (assignsElements.getLength() == 1) {
                Element assignElement = (Element)assignsElements.item(0);
                assert (assignElement != null);
                assigns = ComponentParser.parseAssigns(assignElement, context, mcuRegisters);
            }
            NodeList constraintElements = itemElement.getElementsByTagName("constraint");
            int j = 0;
            while (j < constraintElements.getLength()) {
                Element constraintElement = (Element)constraintElements.item(j);
                assert (constraintElement != null);
                Constraint constraint = ComponentParser.parseConstraint(constraintElement, String.valueOf(parentID) + "." + id, context, instanceMapping);
                if (constraint != null) {
                    constraints.add(constraint);
                }
                ++j;
            }
            ConfigElementItem item = new ConfigElementItem(id, description, assigns, conditions, longDesc);
            items.put(id, item);
            ++i;
        }
        return items;
    }

    private static @NonNull Map<@NonNull String, @NonNull BitFieldAssign> parseAssigns(@NonNull Element elem, @NonNull IContext context, @NonNull BitFieldsCache mcuRegisters) {
        HashMap<@NonNull String, @NonNull BitFieldAssign> assigns = new HashMap<String, BitFieldAssign>();
        NodeList assignElements = elem.getElementsByTagName("assign");
        int i = 0;
        while (i < assignElements.getLength()) {
            Element assignElement = (Element)Objects.requireNonNull(assignElements.item(i));
            String register = UtilsText.safeString((String)assignElement.getAttribute("register"));
            String bitField = UtilsText.safeString((String)assignElement.getAttribute("bit_field"));
            String mask = UtilsText.safeString((String)assignElement.getAttribute("mask"));
            String value = UtilsText.safeString((String)assignElement.getAttribute("value"));
            String whenExpression = UtilsText.safeString((String)assignElement.getAttribute("when"));
            String bitFieldId = context.getBitFieldId(register, bitField);
            BitFieldElement bf = ClocksBitFieldProvider.getBitFieldById(bitFieldId, mcuRegisters);
            if (bf != null) {
                Expression maskExpression;
                Expression valueExpression = Expression.create(value, context);
                Expression condition = Expression.EXPRESSION_TRUE;
                Expression expression = maskExpression = mask.equals("") ? null : Expression.create(mask, context);
                if (!whenExpression.isEmpty()) {
                    condition = Expression.create(whenExpression, context);
                }
                BitFieldAssign bitFieldAssign = null;
                if (assigns.containsKey(bf.getID())) {
                    bitFieldAssign = Objects.requireNonNull((BitFieldAssign)assigns.get(bf.getID()));
                    bitFieldAssign.addAssign(condition, valueExpression, maskExpression);
                } else {
                    bitFieldAssign = new BitFieldAssign(bf.getID());
                    bitFieldAssign.addAssign(condition, valueExpression, maskExpression);
                }
                assigns.put(bf.getID(), bitFieldAssign);
            } else {
                LOGGER.warning(String.valueOf(bitFieldId) + ": not found");
            }
            ++i;
        }
        return assigns;
    }

    private static @NonNull ClockSource parseClockSource(@NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull ComponentContext context, @NonNull Map<@NonNull String, @NonNull Pin> pins) throws ParserException {
        String simpleID = UtilsText.safeString((String)elem.getAttribute("id"));
        ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, elem, constraints, instanceMapping, context, true);
        String defaultFrequency = "";
        boolean internal = false;
        boolean trimmable = false;
        boolean connectByDefault = false;
        ArrayList<@NonNull Frequency> frequencies = new ArrayList<Frequency>();
        ArrayList<@NonNull Pin> includedPins = new ArrayList<Pin>();
        HashMap<@NonNull Expression, @NonNull ValueMap> values = new HashMap<Expression, ValueMap>();
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "external_source".equals(node.getNodeName())) {
                internal = false;
                Element externalInputElement = (Element)node;
                defaultFrequency = ComponentParser.parseExternalInput(elementData.getId(), constraints, instanceMapping, frequencies, externalInputElement, mcuRegisters, context, values, pins, includedPins);
                connectByDefault = Boolean.parseBoolean(externalInputElement.getAttribute("default_connected"));
            } else if (node.getNodeType() == 1 && "internal_source".equals(node.getNodeName())) {
                Element internalInputElement = (Element)node;
                defaultFrequency = ComponentParser.parseInternalInput(internalInputElement, elementData.getId(), context, values, constraints, frequencies, mcuRegisters);
                trimmable = internalInputElement.getElementsByTagName("trimmed").getLength() != 0;
                internal = true;
            }
            ++i;
        }
        ComponentParser.createPinSoftEnableConditions(includedPins, simpleID, context);
        return new ClockSource(elementData, internal, trimmable, frequencies, defaultFrequency, connectByDefault, values, includedPins);
    }

    private static void createPinSoftEnableConditions(@NonNull List<@NonNull Pin> includedPins, @NonNull String id, @NonNull IContext context) {
        for (Pin pin : includedPins) {
            EnableSetting pinEnable = pin.getEnableSetting();
            if (pinEnable == null) continue;
            Expression softEnableCondition = pinEnable.getSoftEnableCondition();
            Expression clockEnableCondition = Expression.create(String.valueOf(id) + "." + "enable", context);
            if (softEnableCondition != null) {
                pinEnable.setSoftEnableCondition(new Expression(OperatorType.OR, context, softEnableCondition, clockEnableCondition).simplify());
                continue;
            }
            pinEnable.setSoftEnableCondition(clockEnableCondition);
        }
    }

    private static @Nullable String parseExternalInput(@NonNull String id, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull List<@NonNull Frequency> frequencies, @NonNull Element elem, @NonNull BitFieldsCache mcuRegisters, @NonNull IContext context, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull Map<@NonNull String, Pin> allPins, @NonNull List<Pin> includedPins) throws ParserException {
        String notSupported = MessageFormat.format("{0}: only one type of succesor supported in external clock source at once [value_map, conditional_block, range]", id);
        boolean rangeParsed = false;
        boolean valueMapParsed = false;
        boolean conditionParsed = false;
        NodeList childNodes = elem.getChildNodes();
        String defaultFrequency = UtilsXmlDom.getOptionalAttr((Element)elem, (String)"default_freq");
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = Objects.requireNonNull(childNodes.item(i));
            if (node.getNodeType() == 1 && "range".equals(node.getNodeName())) {
                if (valueMapParsed || conditionParsed) {
                    LOGGER.warning(notSupported);
                    break;
                }
                rangeParsed = true;
                Element rangeElement = (Element)node;
                Range range = ComponentParser.parseRange(id, constraints, rangeElement, Expression.EXPRESSION_TRUE);
                ValueMap rangeValue = new ValueMap(Expression.EXPRESSION_TRUE, mcuRegisters, false);
                rangeValue.addRequirement(UtilsText.safeString((String)Boolean.toString(true)), "", range);
                values.put(Expression.EXPRESSION_TRUE, rangeValue);
            } else if (node.getNodeType() == 1 && "value_map".equals(node.getNodeName())) {
                if (rangeParsed || conditionParsed) {
                    LOGGER.warning(notSupported);
                    break;
                }
                valueMapParsed = true;
                Element valueMapElement = (Element)node;
                ValueMap valueMap = ComponentParser.parseExternalInputValueMap(id, valueMapElement, mcuRegisters, context, constraints, frequencies, Expression.EXPRESSION_TRUE);
                values.put(Expression.EXPRESSION_TRUE, valueMap);
            } else if (node.getNodeType() == 1 && "conditional_range".equals(node.getNodeName())) {
                if (rangeParsed || valueMapParsed) {
                    LOGGER.warning(notSupported);
                    break;
                }
                conditionParsed = true;
                Element conditionElement = (Element)node;
                NodeList caseElements = conditionElement.getElementsByTagName("case");
                NodeList otherwiseElements = conditionElement.getElementsByTagName("otherwise");
                ArrayList<@NonNull Expression> caseExpressions = new ArrayList<Expression>();
                int j = 0;
                while (j < caseElements.getLength()) {
                    Element caseElement = (Element)Objects.requireNonNull(caseElements.item(j));
                    if (Objects.requireNonNull(caseElement.getParentNode()).equals(conditionElement)) {
                        ComponentParser.parseClockSourceConditions(id, constraints, frequencies, mcuRegisters, context, caseElement, values, caseExpressions);
                    } else {
                        LOGGER.warning("Unsupported syntax of the conditional block in element: " + id);
                    }
                    ++j;
                }
                if (otherwiseElements.getLength() == 1) {
                    Element otherwiseElement = (Element)otherwiseElements.item(0);
                    assert (otherwiseElement != null);
                    ComponentParser.parseClockSourceConditions(id, constraints, frequencies, mcuRegisters, context, otherwiseElement, values, caseExpressions);
                } else {
                    LOGGER.info("Unsupported syntax of the conditional block in element: " + id + " Missing otherwise case.");
                }
            } else if (node.getNodeType() == 1 && "pin".equals(node.getNodeName())) {
                Element e = (Element)node;
                String pinId = e.getAttribute("id");
                NodeList pinChildNodes = node.getChildNodes();
                if (allPins.containsKey(pinId)) {
                    List<@NonNull EnableDisableCondition> enableConditions = ComponentParser.parseEnableAndConstraints(id, pinChildNodes, context, constraints, instanceMapping, false);
                    Pin pin = Objects.requireNonNull(allPins.get(pinId));
                    pin.setEnableSetting(new EnableSetting(pin.getID(), (IElement)pin, enableConditions));
                    includedPins.add(pin);
                } else {
                    LOGGER.warning("Clock source " + id + " refers to pin " + pinId + ", but no such pin exist");
                }
            }
            ++i;
        }
        return defaultFrequency;
    }

    private static void parseClockSourceConditions(@NonNull String id, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull Frequency> frequencies, @NonNull BitFieldsCache mcuRegisters, @NonNull IContext context, @NonNull Element elem, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull List<@NonNull Expression> caseExpressions) throws ParserException {
        String powerModes;
        String condition = UtilsText.safeString((String)elem.getAttribute("cond_expr"));
        Expression appendedCondition = ComponentParser.createPowerModesCondition(condition, powerModes = UtilsText.safeString((String)elem.getAttribute("power_modes")), context);
        Expression condExpr = appendedCondition == null ? Expression.EXPRESSION_TRUE : appendedCondition.simplify();
        Expression fullCaseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, condExpr, context).simplify();
        caseExpressions.add(Expression.negate(condExpr, context).simplify());
        condExpr = fullCaseExpr;
        int k = 0;
        while (k < elem.getChildNodes().getLength()) {
            Node caseNode = Objects.requireNonNull(elem.getChildNodes().item(k));
            if (caseNode.getNodeType() == 1 && "range".equals(caseNode.getNodeName())) {
                Element rangeElement = (Element)caseNode;
                Range range = ComponentParser.parseRange(id, constraints, rangeElement, condExpr);
                ValueMap rangeValue = new ValueMap(Expression.EXPRESSION_TRUE, mcuRegisters, false);
                rangeValue.addRequirement(UtilsText.safeString((String)Boolean.toString(true)), "", range);
                values.put(condExpr, rangeValue);
            } else if (caseNode.getNodeType() == 1 && "value_map".equals(caseNode.getNodeName())) {
                Element valueMapElement = (Element)caseNode;
                ValueMap valueMap = ComponentParser.parseExternalInputValueMap(id, valueMapElement, mcuRegisters, context, constraints, frequencies, condExpr);
                values.put(condExpr, valueMap);
            }
            ++k;
        }
    }

    private static @NonNull ValueMap parseExternalInputValueMap(@NonNull String id, @NonNull Element elem, @NonNull BitFieldsCache mcuRegisters, @NonNull IContext context, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull Frequency> frequencies, @NonNull Expression condExpr) throws ParserException {
        String exprValue = UtilsText.safeString((String)elem.getAttribute("expr"));
        NodeList valueMapRanges = elem.getElementsByTagName("range");
        NodeList valueMapSettings = elem.getElementsByTagName("setting");
        ValueMap valueMap = null;
        if (valueMapRanges.getLength() > 0 && valueMapSettings.getLength() == 0) {
            valueMap = new ValueMap(ExpressionUtils.createOrDefault(exprValue, context), mcuRegisters, false);
            int j = 0;
            while (j < valueMapRanges.getLength()) {
                Element rangeElement = (Element)valueMapRanges.item(j);
                if (rangeElement != null) {
                    String ctrlValue = UtilsText.safeString((String)rangeElement.getAttribute("ctrl_value"));
                    Range range = ComponentParser.parseRange(id, constraints, rangeElement, new Expression(OperatorType.AND, context, condExpr, Expression.create(String.valueOf(exprValue) + "==" + ctrlValue, context)).simplify());
                    valueMap.addRequirement(Expression.create(ctrlValue, context).resolve().getString(), "", range);
                }
                ++j;
            }
        } else if (valueMapRanges.getLength() == 0 && valueMapSettings.getLength() > 0) {
            valueMap = ComponentParser.parseFrequencyValueMap(context, frequencies, elem, mcuRegisters);
        } else {
            throw new ParserException("Element :'" + id + "' contains both frequency and range in value map element");
        }
        return valueMap;
    }

    private static @NonNull Range parseRange(@NonNull String id, @NonNull List<@NonNull Constraint> constraints, @NonNull Element rangeElement, @NonNull Expression condExpr) {
        Constraint rangeConstraint = new Constraint(id);
        rangeConstraint.setRestriction(condExpr);
        String min = UtilsText.safeString((String)rangeElement.getAttribute("min_freq"));
        String max = UtilsText.safeString((String)rangeElement.getAttribute("max_freq"));
        String description = UtilsText.safeString((String)rangeElement.getAttribute("description"));
        rangeConstraint.add("min_freq", min);
        rangeConstraint.add("max_freq", max);
        rangeConstraint.add("description", description);
        constraints.add(rangeConstraint);
        Range range = new Range(min, max, description);
        return range;
    }

    public static @NonNull List<@NonNull EnableDisableCondition> parseEnableAndConstraints(@NonNull String elementID, @NonNull NodeList nodes, @NonNull IContext context, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, String> instanceMapping, boolean disableWarnings) {
        List<Object> conditions = null;
        int i = 0;
        while (i < nodes.getLength()) {
            Element constraintElement;
            Constraint constraint;
            Node node = Objects.requireNonNull(nodes.item(i));
            if (node.getNodeType() == 1 && "conditional_block".equals(node.getNodeName())) {
                Element condBlock = (Element)node;
                List<@NonNull EnableDisableCondition> conditionsParsed = ComponentParser.parseConditionalBlock(elementID, condBlock, context, constraints, instanceMapping, disableWarnings);
                if (conditions == null) {
                    if (!conditionsParsed.isEmpty()) {
                        conditions = conditionsParsed;
                    }
                } else if (!disableWarnings) {
                    LOGGER.warning(String.valueOf(elementID) + ": only one of enable, disable or conditional_block element can be present.");
                }
            } else if (node.getNodeType() == 1 && "enable".equals(node.getNodeName())) {
                Element enableElement = (Element)node;
                if (conditions == null) {
                    conditions = CollectionsUtils.asList((Object)ComponentParser.parseEnableDisableElement(enableElement, true, context));
                } else {
                    LOGGER.warning(String.valueOf(elementID) + ": only one of enable, disable or conditional_block element can be present.");
                }
            } else if (node.getNodeType() == 1 && "disable".equals(node.getNodeName())) {
                Element disableElement = (Element)node;
                if (conditions == null) {
                    conditions = CollectionsUtils.asList((Object)ComponentParser.parseEnableDisableElement(disableElement, false, context));
                } else {
                    LOGGER.warning(String.valueOf(elementID) + ": only one of enable, disable or conditional_block element can be present.");
                }
            } else if (node.getNodeType() == 1 && "constraint".equals(node.getNodeName()) && (constraint = ComponentParser.parseConstraint(constraintElement = (Element)node, elementID, context, instanceMapping)) != null) {
                constraints.add(constraint);
            }
            ++i;
        }
        if (conditions == null) {
            conditions = new ArrayList(0);
        }
        return conditions;
    }

    private static @NonNull List<@NonNull EnableDisableCondition> parseConditionalBlock(@NonNull String elementID, @NonNull Element elem, @NonNull IContext context, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, String> instanceMapping, boolean disableWarnings) {
        Expression caseExpr;
        ArrayList<@NonNull EnableDisableCondition> enableDisables = new ArrayList<EnableDisableCondition>();
        ArrayList<@NonNull Expression> caseExpressions = new ArrayList<Expression>();
        NodeList cases = elem.getElementsByTagName("case");
        int i = 0;
        while (i < cases.getLength()) {
            Element caseElement = (Element)Objects.requireNonNull(cases.item(i));
            caseExpr = ComponentParser.parseCondition(caseElement, context);
            Expression fullCaseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, caseExpr, context);
            caseExpressions.add(Expression.negate(caseExpr, context));
            caseExpr = fullCaseExpr;
            NodeList enables = caseElement.getElementsByTagName("enable");
            NodeList disables = caseElement.getElementsByTagName("disable");
            NodeList constraintElements = caseElement.getElementsByTagName("constraint");
            NodeList valueMapElements = caseElement.getElementsByTagName("value_map");
            assert (constraintElements != null);
            if (valueMapElements.getLength() == 1) {
                Element valueMap = (Element)valueMapElements.item(0);
                assert (valueMap != null);
            } else {
                ComponentParser.parseConditionalConstraints(elementID, context, constraints, caseExpr, constraintElements, instanceMapping);
            }
            if (enables.getLength() == 1) {
                Element enableElement = (Element)enables.item(0);
                assert (enableElement != null);
                enableDisables.add(ComponentParser.parseEnableDisableElement(enableElement, true, caseExpr, context));
            } else if (disables.getLength() == 1) {
                Element disableElement = (Element)disables.item(0);
                assert (disableElement != null);
                enableDisables.add(ComponentParser.parseEnableDisableElement(disableElement, false, caseExpr, context));
            } else if (!disableWarnings) {
                LOGGER.warning(String.valueOf(elementID) + ": only one of enable, disable or conditional_block element can be present.");
            }
            ++i;
        }
        NodeList otherwise = elem.getElementsByTagName("otherwise");
        if (otherwise.getLength() == 1) {
            Element otherwiseElement = (Element)Objects.requireNonNull(otherwise.item(0));
            caseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, Expression.EXPRESSION_TRUE, context);
            NodeList enables = otherwiseElement.getElementsByTagName("enable");
            NodeList disables = otherwiseElement.getElementsByTagName("disable");
            NodeList constraintElements = otherwiseElement.getElementsByTagName("constraint");
            assert (constraintElements != null);
            NodeList valueMapElements = otherwiseElement.getElementsByTagName("value_map");
            if (valueMapElements.getLength() == 1) {
                Element valueMap = (Element)valueMapElements.item(0);
                assert (valueMap != null);
                ComponentParser.parseValueMapConstraints(elementID, context, constraints, valueMap, instanceMapping);
            } else {
                ComponentParser.parseConditionalConstraints(elementID, context, constraints, caseExpr, constraintElements, instanceMapping);
            }
            if (enables.getLength() == 1) {
                Element enableElement = (Element)enables.item(0);
                assert (enableElement != null);
                enableDisables.add(ComponentParser.parseEnableDisableElement(enableElement, true, caseExpr, context));
            } else if (disables.getLength() == 1) {
                Element disableElement = (Element)disables.item(0);
                assert (disableElement != null);
                enableDisables.add(ComponentParser.parseEnableDisableElement(disableElement, false, caseExpr, context));
            } else if (!disableWarnings) {
                LOGGER.warning(String.valueOf(elementID) + ": only one of enable, disable or conditional_block element can be present.");
            }
        }
        return enableDisables;
    }

    private static @NonNull Expression appendNegatedCaseConditions(@NonNull List<@NonNull Expression> caseExpressions, @NonNull Expression caseExpr, @NonNull IContext context) {
        Expression fullCaseExpr = caseExpr;
        for (Expression previousCase : caseExpressions) {
            fullCaseExpr = new Expression(OperatorType.AND, context, fullCaseExpr, previousCase).simplify();
        }
        return fullCaseExpr;
    }

    private static void parseValueMapConstraints(@NonNull String elementID, @NonNull IContext context, @NonNull List<@NonNull Constraint> constraints, @NonNull Element valueMap, @NonNull Map<@NonNull String, String> instanceMapping) {
        NodeList valueMapChildNodes = valueMap.getChildNodes();
        int i = 0;
        while (i < valueMapChildNodes.getLength()) {
            Element valueMapItem;
            String uiVal;
            if (valueMapChildNodes.item(i) instanceof Element && !UtilsText.isEmpty((String)(uiVal = (valueMapItem = (Element)Objects.requireNonNull(valueMapChildNodes.item(i))).getAttribute("expr")))) {
                NodeList constraintElements = valueMapItem.getElementsByTagName("constraint");
                int j = 0;
                while (j < constraintElements.getLength()) {
                    if (constraintElements.item(j) instanceof Element) {
                        Element constraintElement = (Element)constraintElements.item(j);
                        assert (constraintElement != null);
                        Constraint constraint = ComponentParser.parseConstraint(constraintElement, elementID, context, instanceMapping);
                        if (constraint != null) {
                            constraint.setRestriction(ComponentParser.createSignalExpression(UtilsText.safeString((String)uiVal), context, instanceMapping));
                            constraints.add(constraint);
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    private static @NonNull List<@NonNull Constraint> parsePrescalerConstraints(@NonNull String elementID, @NonNull IContext context, @NonNull List<@NonNull Constraint> constraints, @NonNull Element valueMap, @NonNull Map<@NonNull String, @NonNull String> instanceMapping) {
        NodeList valueMapChildNodes = valueMap.getChildNodes();
        ArrayList<@NonNull Constraint> prescalerConstraints = new ArrayList<Constraint>();
        int i = 0;
        while (i < valueMapChildNodes.getLength()) {
            Constraint constraint;
            Element valueMapItem;
            String uiVal;
            if (valueMapChildNodes.item(i) instanceof Element && !UtilsText.isEmpty((String)(uiVal = (valueMapItem = (Element)Objects.requireNonNull(valueMapChildNodes.item(i))).getAttribute("cond_expr"))) && (constraint = ComponentParser.parseConstraint(valueMapItem, elementID, context, instanceMapping)) != null) {
                constraints.add(constraint);
                prescalerConstraints.add(constraint);
            }
            ++i;
        }
        return prescalerConstraints;
    }

    private static void parseConditionalConstraints(@NonNull String elementID, @NonNull IContext context, @NonNull List<@NonNull Constraint> constraints, @NonNull Expression caseExpr, @NonNull NodeList constraintElements, @NonNull Map<@NonNull String, String> instanceMapping) {
        int j = 0;
        while (j < constraintElements.getLength()) {
            Element constraintElement = (Element)constraintElements.item(j);
            assert (constraintElement != null);
            Constraint constraint = ComponentParser.parseConstraint(constraintElement, elementID, context, instanceMapping);
            if (constraint != null) {
                Expression restriction = constraint.getRestriction();
                if (restriction != null) {
                    constraint.setRestriction(new Expression(OperatorType.OR, context, restriction, caseExpr).simplify());
                } else {
                    constraint.setRestriction(caseExpr);
                }
                constraints.add(constraint);
            }
            ++j;
        }
    }

    private static @NonNull EnableDisableCondition parseEnableDisableElement(@NonNull Element elem, boolean isEnable, @Nullable Expression caseExpr, @NonNull IContext context) {
        Expression expr = ComponentParser.parseCondition(elem, context);
        if (caseExpr != null) {
            return new EnableDisableCondition(caseExpr, expr, UtilsText.safeString((String)elem.getAttribute("description")), isEnable);
        }
        return new EnableDisableCondition(expr, UtilsText.safeString((String)elem.getAttribute("description")), isEnable);
    }

    private static @NonNull EnableDisableCondition parseEnableDisableElement(@NonNull Element elem, boolean isEnable, @NonNull IContext context) {
        return ComponentParser.parseEnableDisableElement(elem, isEnable, null, context);
    }

    private static @NonNull Expression parseCondition(@NonNull Element elem, @NonNull IContext context) {
        String powerModes;
        String condExpr = elem.getAttribute("cond_expr");
        Expression result = ComponentParser.createPowerModesCondition(condExpr, powerModes = elem.getAttribute("power_modes"), context);
        return result == null ? Expression.EXPRESSION_TRUE : result;
    }

    private static @NonNull String parseInternalInput(@NonNull Element elem, @NonNull String id, @NonNull IContext context, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull List<@NonNull Constraint> constraints, @NonNull List<@NonNull Frequency> frequencies, @NonNull BitFieldsCache mcuRegisters) {
        NodeList inputChildNodes = elem.getChildNodes();
        String defaultFrequency = "0 Hz";
        int i = 0;
        while (i < inputChildNodes.getLength()) {
            Node node = Objects.requireNonNull(inputChildNodes.item(i));
            if (node.getNodeType() == 1 && "trimmed".equals(node.getNodeName())) {
                Element trimedFreqElement = (Element)node;
                defaultFrequency = UtilsText.safeString((String)trimedFreqElement.getAttribute("default_freq"));
                NodeList rangeElements = trimedFreqElement.getElementsByTagName("range");
                if (rangeElements.getLength() == 1) {
                    Element rangeElement = (Element)rangeElements.item(0);
                    assert (rangeElement != null);
                    ComponentParser.parseRange(id, constraints, rangeElement, Expression.EXPRESSION_TRUE);
                }
            } else if (node.getNodeType() == 1 && "fixed_frequency".equals(node.getNodeName())) {
                String frequency;
                Element fixedFreq = (Element)node;
                defaultFrequency = frequency = UtilsText.safeString((String)fixedFreq.getAttribute("freq"));
                Frequency parsedFrequency = Frequency.parse((String)UtilsText.safeString((String)frequency));
                if (parsedFrequency != null) {
                    frequencies.add(parsedFrequency);
                } else {
                    LOGGER.warning("Fixed frequency is not valid frequency format ( {frequency_value}{Hz|kHz|MHz} )");
                }
            } else if (node.getNodeType() == 1 && "value_map".equals(node.getNodeName())) {
                Element valueMapElement = (Element)node;
                ValueMap valueMap = ComponentParser.parseFrequencyValueMap(context, frequencies, valueMapElement, mcuRegisters);
                values.put(Expression.EXPRESSION_TRUE, valueMap);
            }
            ++i;
        }
        return defaultFrequency;
    }

    private static @NonNull ValueMap parseFrequencyValueMap(@NonNull IContext context, @NonNull List<@NonNull Frequency> frequencies, @NonNull Element valueMapElement, @NonNull BitFieldsCache mcuRegisters) {
        String exprValue = UtilsText.safeString((String)valueMapElement.getAttribute("expr"));
        ValueMap valueMap = new ValueMap(ExpressionUtils.createOrDefault(exprValue, context), mcuRegisters, false);
        NodeList settings = valueMapElement.getElementsByTagName("setting");
        if (settings.getLength() > 0) {
            int j = 0;
            while (j < settings.getLength()) {
                Element settingElement = (Element)settings.item(j);
                if (settingElement != null) {
                    String ctrlValue = UtilsText.safeString((String)settingElement.getAttribute("ctrl_value"));
                    String freq = UtilsText.safeString((String)settingElement.getAttribute("freq"));
                    String name = UtilsText.safeString((String)settingElement.getAttribute("name"));
                    Frequency frequency = Frequency.parse((String)freq);
                    if (frequency != null) {
                        frequencies.add(frequency);
                        String uiValue = name.equals("") ? FrequencyCalculator.normalize((Frequency)frequency, (long)1L).toString() : name;
                        valueMap.addRequirement(ExpressionUtils.createOrDefault(ctrlValue, context).resolve().getString(), uiValue, frequency);
                    }
                }
                ++j;
            }
        }
        return valueMap;
    }

    private static @NonNull Prescaler parsePrescaler(@NonNull String componentID, @NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull ComponentContext context, boolean internal) throws ParserException {
        ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, elem, constraints, instanceMapping, context, internal);
        ENodeType elementType = null;
        boolean isDivider = false;
        boolean isMaster = false;
        boolean hasConfigElemMaster = false;
        HashSet<@NonNull String> masters = new HashSet<String>();
        HashSet<@NonNull String> ratios = new HashSet<String>();
        LinkedHashMap<@NonNull Expression, @NonNull ValueMap> values = new LinkedHashMap<Expression, ValueMap>();
        Expression expressionTrue = Expression.EXPRESSION_TRUE;
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            List<Constraint> constraint;
            Element divideElement;
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "divide".equals(node.getNodeName())) {
                divideElement = (Element)node;
                constraint = ComponentParser.parsePrescalerConstraints(elementData.getId(), context, constraints, divideElement, instanceMapping);
                ComponentParser.parseDivideMultiply(elementData.getId(), divideElement, mcuRegisters, context, values, expressionTrue, constraint);
                isDivider = true;
            } else if (node.getNodeType() == 1 && "multiply".equals(node.getNodeName())) {
                divideElement = (Element)node;
                constraint = ComponentParser.parsePrescalerConstraints(elementData.getId(), context, constraints, divideElement, instanceMapping);
                ComponentParser.parseDivideMultiply(elementData.getId(), divideElement, mcuRegisters, context, values, expressionTrue, constraint);
            } else if (node.getNodeType() == 1 && "value_map".equals(node.getNodeName())) {
                Element valeMapElement = (Element)node;
                ValueMap value = ComponentParser.parsePrescalerValueMap(mcuRegisters, elementData.getId(), valeMapElement, context);
                ComponentParser.parseValueMapConstraints(elementData.getId(), context, constraints, valeMapElement, instanceMapping);
                assert (value != null);
                values.put(expressionTrue, value);
            } else if (node.getNodeType() == 1 && ("conditional_block".equals(node.getNodeName()) || "conditional_scale".equals(node.getNodeName()))) {
                Element condBlock = (Element)node;
                ComponentParser.parsePrescalerConditionalBlock(condBlock, elementData.getId(), mcuRegisters, context, values);
            } else if (node.getNodeType() == 1 && "interlock_master".equals(node.getNodeName())) {
                isMaster = true;
            } else if (node.getNodeType() == 1 && "interlock_slave".equals(node.getNodeName())) {
                boolean masterIsConfigElement;
                Element slave = (Element)node;
                String ratioAttribute = UtilsText.safeString((String)slave.getAttribute("ratios"));
                String master = UtilsText.safeString((String)slave.getAttribute("master"));
                String integerDivide = UtilsText.safeString((String)slave.getAttribute("integer_divide_freq"));
                String controlledByManageCounter = UtilsText.safeString((String)slave.getAttribute("controlled_by_manage_counter"));
                boolean controlledSpecified = controlledByManageCounter.equals(Text.TRUE);
                boolean notIntergerDevideNorRatios = !integerDivide.equals(Text.TRUE) && ratioAttribute.isEmpty();
                boolean bl = masterIsConfigElement = controlledSpecified || notIntergerDevideNorRatios;
                if (masterIsConfigElement && !controlledSpecified) {
                    LOGGER.warning(String.valueOf(elementData.getId()) + ": None of the " + "ratios" + ", " + "integer_divide_freq" + " or " + "controlled_by_manage_counter" + "attributes were specified. Assuming that this interlock slave is controlled by manage counter!");
                }
                if (controlledSpecified & !notIntergerDevideNorRatios) {
                    LOGGER.warning(String.valueOf(elementData.getId()) + ": Controlled by manage counter is specified. Attributes " + "ratios" + " and " + "integer_divide_freq" + "are redundant and should be removed, because this combination of attributes is not allowed.");
                }
                master = componentID.isEmpty() || masterIsConfigElement ? master : String.valueOf(componentID) + "." + master;
                boolean bl2 = hasConfigElemMaster = masterIsConfigElement || hasConfigElemMaster;
                if (!masters.isEmpty() && masterIsConfigElement) {
                    LOGGER.warning(String.valueOf(elementData.getId()) + ": combination of 2 divider groups or a divider group (with manage counter) and a normal interlock is not supported. Maybe interlock_slave is missing integer_divide_freq or ratios attribute?");
                }
                masters.add(master);
                if (!masterIsConfigElement) {
                    List<String> rationals = null;
                    String ratio = UtilsText.safeString((String)slave.getAttribute("max_ratio"));
                    if (!UtilsText.isEmpty((String)ratioAttribute)) {
                        @NonNull String @NonNull [] splittedRationalAttrributes = UtilsText.splitLines((String)ratioAttribute, (String)";");
                        rationals = Arrays.asList(splittedRationalAttrributes);
                    }
                    if (ratios.isEmpty()) {
                        if (rationals != null) {
                            ratios.addAll(rationals);
                        } else {
                            ratios.add(ratio);
                        }
                    } else if (ratios.size() != 1 || !ratio.equals(ratios.stream().findFirst().get())) {
                        LOGGER.warning(String.valueOf(elementData.getId()) + ": wrong master slave division ratios.");
                    }
                }
            }
            ++i;
        }
        if (elem.getElementsByTagName("divide").getLength() != 0) {
            elementType = isMaster ? (masters.isEmpty() ? ENodeType.DivMaster : ENodeType.DivMasterSlave) : (!masters.isEmpty() ? (masters.size() == 1 ? (hasConfigElemMaster ? ENodeType.Divider : ENodeType.DivSlave) : ENodeType.DivMultiSlave) : ENodeType.Divider);
            isDivider = true;
        } else if (elem.getElementsByTagName("multiply").getLength() != 0) {
            elementType = ENodeType.Multiplier;
        }
        if (elementType == null) {
            throw new ParserException("Missing divide/multiply tag in prescaler element with id " + elementData.getId());
        }
        if (hasConfigElemMaster && (!ratios.isEmpty() || masters.size() != 1 || isMaster)) {
            LOGGER.severe(String.valueOf(elementData.getId()) + ": Wrong interlock_slave setting.");
        }
        return new Prescaler(elementData, elementType, isDivider, values, masters, ratios);
    }

    private static @NonNull DFSPrescaler parseDFSPrescaler(@NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull ComponentContext context, boolean internal) throws ParserException {
        ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, elem, constraints, instanceMapping, context, internal);
        ENodeType elementType = ENodeType.DFSDivider;
        Expression expressionTrue = Expression.EXPRESSION_TRUE;
        HashMap<@NonNull Expression, @NonNull ValueMap> values = new HashMap<Expression, ValueMap>();
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "dfs_divider".equals(node.getNodeName())) {
                Element divideElement = (Element)node;
                List<Constraint> constraint = ComponentParser.parsePrescalerConstraints(elementData.getId(), context, constraints, divideElement, instanceMapping);
                ComponentParser.parseDivideMultiply(elementData.getId(), divideElement, mcuRegisters, context, values, expressionTrue, constraint);
            } else if (node.getNodeType() == 1 && "value_map".equals(node.getNodeName())) {
                Element valeMapElement = (Element)node;
                ValueMap value = ComponentParser.parsePrescalerValueMap(mcuRegisters, elementData.getId(), valeMapElement, context);
                ComponentParser.parseValueMapConstraints(elementData.getId(), context, constraints, valeMapElement, instanceMapping);
                assert (value != null);
                values.put(expressionTrue, value);
            } else if (node.getNodeType() == 1 && ("conditional_block".equals(node.getNodeName()) || "conditional_scale".equals(node.getNodeName()))) {
                Element condBlock = (Element)node;
                ComponentParser.parsePrescalerConditionalBlock(condBlock, elementData.getId(), mcuRegisters, context, values);
            }
            ++i;
        }
        return new DFSPrescaler(elementData, elementType, values);
    }

    public static @NonNull ClockElementData parseElementData(@NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, String> instanceMapping, @NonNull ComponentContext context, boolean skipInputparsing) throws ParserException {
        String id = ComponentParser.getElementID(context.getComponentID(), elem);
        String name = elem.getAttribute("name");
        String description = UtilsText.safeString((String)elem.getAttribute("description"));
        String min = elem.getAttribute("min");
        String max = elem.getAttribute("max");
        String powerModeSpecific = UtilsText.safeString((String)elem.getAttribute("power_mode_specific"));
        String inputSignal = skipInputparsing ? "" : ComponentParser.parseInputSignalElement(context, id, elem, instanceMapping);
        String priority = elem.getAttribute("master");
        long minScale = min.isEmpty() ? 0L : Long.parseLong(min);
        long maxScale = max.isEmpty() ? Long.MAX_VALUE : Long.parseLong(max);
        boolean isPowerModeSpecific = !powerModeSpecific.isEmpty() && Boolean.parseBoolean(powerModeSpecific);
        NodeList childNodes = elem.getChildNodes();
        List<@NonNull EnableDisableCondition> enableDisableConditions = ComponentParser.parseEnableAndConstraints(id, childNodes, context, constraints, instanceMapping, true);
        List<@NonNull IConfigElement> configElements = ComponentParser.parseLocalConfigElements(mcuRegisters, elem, constraints, context, instanceMapping);
        if ("".equals(id)) {
            throw new ParserException("Element ID must by specified.");
        }
        return new ClockElementData(mcuRegisters, context, id, name, description, inputSignal, constraints, childNodes, enableDisableConditions, configElements, priority.equals(Text.TRUE), minScale, maxScale, isPowerModeSpecific);
    }

    private static void parseDivideMultiply(@NonNull String id, @NonNull Element element, @NonNull BitFieldsCache mcuRegisters, @NonNull IContext context, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull Expression expression, @NonNull List<@NonNull Constraint> constraint) {
        int fractionalBits = ComponentParser.parseFracBits(element, id);
        String expressionValue = element.getAttribute("expr");
        assert (expressionValue != null);
        ValueMap value = ComponentParser.parseValueMapFromMapping(element, expressionValue, context, mcuRegisters);
        value.setDescriptionsEnabled(false);
        value.setFractional(fractionalBits);
        values.put(expression, value);
        value.setConstraint(constraint);
    }

    private static @NonNull ValueMap parseValueMapFromMapping(@NonNull Element element, @NonNull String expressionValue, @NonNull IContext context, @NonNull BitFieldsCache mcuRegisters) {
        String valueMapping = UtilsText.safeString((String)element.getAttribute("value_mapping"));
        String range = UtilsText.safeString((String)element.getAttribute("range"));
        ValueMap valueMap = new ValueMap(ExpressionUtils.createOrDefault(expressionValue, context), mcuRegisters, valueMapping.isEmpty());
        if (!valueMapping.isEmpty()) {
            Map<@NonNull String, @NonNull String> values = ComponentParser.parseValueMapping(valueMapping, element);
            values.forEach((x, y) -> {
                IValueMapBuilder iValueMapBuilder = valueMap.addRequirement((String)y, (String)x, x);
            });
        } else if (!range.isEmpty()) {
            BigRational parsedStep;
            Range parsedRange = ComponentParser.parseRangeGeneral(range);
            String step = UtilsText.safeString((String)element.getAttribute("step"));
            if (!step.isEmpty() && (parsedStep = BigRational.parse((String)step)).compareTo(BigRational.ZERO) > 0) {
                parsedRange.setStep(parsedStep);
            }
            BigRational i = parsedRange.getMin();
            while (parsedRange.getMax().compareTo(i) > 0) {
                valueMap.addRequirement(i.toString(), i.toString(), i);
                i = i.add(parsedRange.getStep());
            }
        }
        return valueMap;
    }

    private static @NonNull Range parseRangeGeneral(String range) throws NumberFormatException {
        String[] limits = range.split("-");
        if (limits.length == 2) {
            BigRational min = BigRational.parse((String)UtilsText.safeString((String)limits[0]));
            BigRational max = BigRational.parse((String)UtilsText.safeString((String)limits[1]));
            return new Range(min, max, false);
        }
        throw new NumberFormatException(MessageFormat.format("Error while parsing range=\"{}\": incorrect format.", range));
    }

    public static @NonNull Map<@NonNull String, @NonNull String> parseValueMapping(@NonNull String valueMapping, @Nullable Element element) {
        LinkedHashMap<@NonNull String, @NonNull String> values = new LinkedHashMap<String, String>();
        int len = valueMapping.length();
        int i = 0;
        while (i < len) {
            int j = valueMapping.indexOf(58, i);
            if (j < 0) break;
            int k = valueMapping.indexOf(44, i);
            if (k < 0) {
                k = len;
            }
            if (k > j) {
                values.put(valueMapping.substring(i, j), valueMapping.substring(j + 1, k));
            }
            i = k + 1;
        }
        if (SWToolsProperties.isVerificationOn()) {
            ComponentParser.checkSimpleValueMapping(values, element);
        }
        return values;
    }

    private static int parseFracBits(@NonNull Element element, @NonNull String id) {
        String fracBits = UtilsText.safeString((String)element.getAttribute("frac_bits"));
        int fracBitsInt = 0;
        if (!fracBits.isEmpty()) {
            try {
                fracBitsInt = Integer.parseInt(fracBits);
            }
            catch (NumberFormatException e) {
                LOGGER.log(Level.WARNING, String.valueOf(fracBits) + " not parsed properly in element: " + id, e);
            }
        }
        return fracBitsInt;
    }

    private static void parsePrescalerConditionalBlock(@NonNull Element elem, @NonNull String id, @NonNull BitFieldsCache mcuRegisters, @NonNull IContext context, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values) {
        Expression caseExpr;
        NodeList cases = elem.getElementsByTagName("case");
        ArrayList<@NonNull Expression> caseExpressions = new ArrayList<Expression>();
        int j = 0;
        while (j < cases.getLength()) {
            Element caseElement = (Element)cases.item(j);
            assert (caseElement != null);
            if (!caseElement.getAttribute("cond_expr").isEmpty() || !caseElement.getAttribute("power_modes").isEmpty() || caseElement.getElementsByTagName("*").getLength() != 0) {
                caseExpr = ComponentParser.parseCondition(caseElement, context);
                Expression fullCaseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, caseExpr, context);
                caseExpressions.add(Expression.negate(caseExpr, context));
                caseExpr = fullCaseExpr;
                ComponentParser.parseCaseOtherwise(id, mcuRegisters, context, caseExpr, values, caseElement);
            }
            ++j;
        }
        NodeList otherwise = elem.getElementsByTagName("otherwise");
        if (otherwise.getLength() == 1) {
            Element otherwiseElement = (Element)otherwise.item(0);
            caseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, Expression.EXPRESSION_TRUE, context);
            assert (otherwiseElement != null);
            ComponentParser.parseCaseOtherwise(id, mcuRegisters, context, caseExpr, values, otherwiseElement);
        }
    }

    private static void parseCaseOtherwise(@NonNull String id, @NonNull BitFieldsCache mcuRegisters, @NonNull IContext context, @NonNull Expression caseExpr, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull Element element) {
        NodeList valeMapElements = element.getElementsByTagName("value_map");
        NodeList divideElements = element.getElementsByTagName("divide");
        NodeList multiplyElements = element.getElementsByTagName("multiply");
        if (valeMapElements.getLength() == 1) {
            Element valeMapElement = (Element)valeMapElements.item(0);
            assert (valeMapElement != null);
            ValueMap value = ComponentParser.parsePrescalerValueMap(mcuRegisters, id, valeMapElement, context);
            assert (value != null);
            values.put(caseExpr, value);
        } else if (divideElements.getLength() == 1) {
            Element divideElement = (Element)divideElements.item(0);
            assert (divideElement != null);
            ComponentParser.parseDivideMultiply(id, divideElement, mcuRegisters, context, values, caseExpr, new ArrayList<Constraint>());
        } else if (multiplyElements.getLength() == 1) {
            Element multiplyElement = (Element)multiplyElements.item(0);
            assert (multiplyElement != null);
            ComponentParser.parseDivideMultiply(id, multiplyElement, mcuRegisters, context, values, caseExpr, new ArrayList<Constraint>());
        } else {
            LOGGER.warning(String.valueOf(id) + ": Exactly one " + "value_map" + "expected as child of the " + "case" + " element");
        }
    }

    private static @Nullable ValueMap parsePrescalerValueMap(@NonNull BitFieldsCache mcuRegisters, @NonNull String id, @NonNull Element element, @NonNull IContext context) {
        Expression valueMapExpr = ExpressionUtils.createOrDefault(UtilsText.safeString((String)element.getAttribute("expr")), context);
        int fractionalBits = ComponentParser.parseFracBits(element, id);
        NodeList modifiers = element.getElementsByTagName("divide");
        if (modifiers.getLength() == 0) {
            modifiers = element.getElementsByTagName("multiply");
        }
        if (modifiers.getLength() > 0) {
            ValueMap valueMap = new ValueMap(valueMapExpr, mcuRegisters, false);
            valueMap.setDescriptionsEnabled(false);
            valueMap.setFractional(fractionalBits);
            int i = 0;
            while (i < modifiers.getLength()) {
                Element valueMapItem = (Element)Objects.requireNonNull(modifiers.item(i));
                String uiVal = UtilsText.safeString((String)valueMapItem.getAttribute("expr"));
                String ctrl_value = UtilsText.safeString((String)valueMapItem.getAttribute("ctrl_value"));
                String value = ctrl_value.isEmpty() ? uiVal : ctrl_value;
                valueMap.addRequirement(Expression.create(value, context).resolve().getString(), uiVal, uiVal);
                ++i;
            }
            return valueMap;
        }
        LOGGER.severe(String.valueOf(id) + ": No divide or multiply element specified!");
        return null;
    }

    public static @Nullable Constraint parseConstraint(@NonNull Element element, @NonNull String parentElementID, @NonNull IContext context, @NonNull Map<@NonNull String, String> instanceMapping) {
        Constraint constraint;
        String elementID = UtilsText.safeString((String)element.getAttribute("element_id"));
        String relatesTo = UtilsText.safeString((String)element.getAttribute("relates_to"));
        String condExpr = UtilsText.safeString((String)element.getAttribute("cond_expr"));
        String when = UtilsText.safeString((String)element.getAttribute("when"));
        String frequencies = UtilsText.safeString((String)element.getAttribute("freq_range"));
        String freq = UtilsText.safeString((String)element.getAttribute("freq"));
        String maxFreq = UtilsText.safeString((String)element.getAttribute("max_freq"));
        String minFreq = UtilsText.safeString((String)element.getAttribute("min_freq"));
        String description = UtilsText.safeString((String)element.getAttribute("description"));
        String powerModes = UtilsText.safeString((String)element.getAttribute("power_modes"));
        String level = UtilsText.safeString((String)element.getAttribute("level"));
        String accuracy = UtilsText.safeString((String)element.getAttribute("accuracy"));
        boolean isOnInput = relatesTo.equals("input");
        if (elementID.isEmpty()) {
            elementID = parentElementID;
        }
        Constraint constraint2 = constraint = level.isEmpty() ? new Constraint(elementID, isOnInput, Constraint.Level.ERROR) : new Constraint(elementID, isOnInput, level);
        if (!condExpr.isEmpty()) {
            constraint.setCondition(ComponentParser.createSignalExpression(condExpr, context, instanceMapping));
        }
        Expression powerModesExp = Converter.convertPowerModesToExpression(powerModes, context);
        Expression conditionExp = ComponentParser.createPowerModesCondition(constraint.getCondition(), powerModesExp, context);
        if (conditionExp != null) {
            constraint.setCondition(conditionExp);
        }
        if (!when.isEmpty()) {
            constraint.setRestriction(ComponentParser.createSignalExpression(when, context, instanceMapping));
        }
        constraint.add("freq_range", frequencies);
        if (!frequencies.isEmpty()) {
            constraint.getFrequencyRanges();
        }
        constraint.add("freq", freq);
        constraint.add("max_freq", maxFreq);
        constraint.add("min_freq", minFreq);
        constraint.add("description", description);
        if (!accuracy.isEmpty()) {
            try {
                BigRational accuracyRational = new BigRational(new BigDecimal(accuracy));
                constraint.setAccuracy(accuracyRational);
            }
            catch (NumberFormatException numberFormatException) {
                LOGGER.warning("Expected decimal accuracy but got: " + accuracy);
            }
        }
        return constraint;
    }

    private static @Nullable Expression createPowerModesCondition(@NonNull String condExpr, @NonNull String powerModes, @NonNull IContext context) {
        Expression expPowerModes = Converter.convertPowerModesToExpression(powerModes, context);
        if (condExpr.isEmpty()) {
            return ComponentParser.createPowerModesCondition(null, expPowerModes, context);
        }
        Expression expCond = Expression.create(condExpr, context);
        return ComponentParser.createPowerModesCondition(expCond, expPowerModes, context);
    }

    private static @Nullable Expression createPowerModesCondition(@Nullable Expression condExp, @Nullable Expression powerModesExp, @NonNull IContext context) {
        if (powerModesExp != null) {
            if (condExp != null) {
                return new Expression(OperatorType.AND, context, condExp, powerModesExp);
            }
            return powerModesExp;
        }
        return condExp;
    }

    private static @NonNull Pll parsePll(@NonNull String componentID, @NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull ComponentContext context) throws ParserException {
        Prescaler divider = null;
        Prescaler multiplier = null;
        Prescaler postDivider = null;
        ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, elem, constraints, instanceMapping, context, false);
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "prescaler".equals(node.getNodeName())) {
                Element prescalerElement = (Element)node;
                Prescaler prescaler = ComponentParser.parsePrescaler(componentID, mcuRegisters, prescalerElement, constraints, instanceMapping, context, true);
                if (prescaler.isDivider()) {
                    divider = prescaler;
                } else {
                    multiplier = prescaler;
                }
            } else if (node.getNodeType() == 1 && "post_divider".equals(node.getNodeName())) {
                Element postDivElement = (Element)node;
                postDivider = ComponentParser.parsePrescaler(componentID, mcuRegisters, ComponentParser.getElementByTagName(postDivElement, "prescaler"), constraints, instanceMapping, context, true);
            }
            ++i;
        }
        if (divider == null || multiplier == null) {
            throw new ParserException(MessageFormat.format("PLL '%s' must have exactly one divider and one multiplier element.", elementData.getId()));
        }
        return new Pll(elementData, divider, multiplier, postDivider);
    }

    private static FnPll parseFnPll(@NonNull BitFieldsCache mcuRegisters, @NonNull Element pllElement, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull ComponentContext context) throws ParserException {
        ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, pllElement, constraints, instanceMapping, context, false);
        FnPllRange range = ComponentParser.parseFnPllRange(elementData);
        List<@NonNull FnPllConfigElement> configElements = ComponentParser.parseFnPllConfigElements(elementData);
        List<@NonNull BigRational> suitableFrequencies = ComponentParser.getSuitableFrequencies(pllElement);
        return new FnPll(elementData, configElements, suitableFrequencies, range, false);
    }

    private static @NonNull List<@NonNull BigRational> getSuitableFrequencies(Element pllElement) throws ParserException {
        ArrayList<@NonNull BigRational> suitableFrequencies = new ArrayList<BigRational>();
        Element selectListElement = ComponentParser.getElementByTagName(pllElement, "fnpll_select_list");
        Element listElement = ComponentParser.getElementByTagName(selectListElement, "list");
        NodeList itemElements = listElement.getElementsByTagName("item");
        int i = 0;
        while (i < itemElements.getLength()) {
            Node node = Objects.requireNonNull(itemElements.item(i));
            if (node.getNodeType() == 1) {
                Element item = (Element)node;
                String value = UtilsText.safeString((String)item.getAttribute("value"));
                try {
                    suitableFrequencies.add(Converter.toHertz(Frequency.parseNonNull((String)value)));
                }
                catch (IllegalArgumentException e) {
                    LOGGER.log(Level.WARNING, String.valueOf(value) + " is not valid frequency of fnpll select list", e);
                }
            }
            ++i;
        }
        return suitableFrequencies;
    }

    private static @NonNull List<@NonNull FnPllConfigElement> parseFnPllConfigElements(ClockElementData elementData) throws ParserException {
        ArrayList<@NonNull FnPllConfigElement> configElements = new ArrayList<FnPllConfigElement>();
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "fnpll_element".equals(node.getNodeName())) {
                Element confElement = (Element)node;
                String id = String.valueOf(elementData.getId()) + "." + UtilsText.safeString((String)confElement.getAttribute("id"));
                String name = UtilsText.safeString((String)confElement.getAttribute("name"));
                String description = UtilsText.safeString((String)confElement.getAttribute("description"));
                NodeList rangeElements = confElement.getElementsByTagName("range");
                if (rangeElements.getLength() == 1) {
                    Element rangeElement = (Element)Objects.requireNonNull(rangeElements.item(0));
                    String min = UtilsText.safeString((String)rangeElement.getAttribute("min"));
                    String max = UtilsText.safeString((String)rangeElement.getAttribute("max"));
                    String defaultValue = UtilsText.safeString((String)rangeElement.getAttribute("default"));
                    Range range = new Range(BigRational.parse((String)min), BigRational.parse((String)max), false);
                    Map<String, BitFieldAssign> assigns = ComponentParser.parseAssigns(confElement, elementData.getComponentContext(), elementData.getRegisters());
                    configElements.add(new FnPllConfigElement(id, name, description, range, defaultValue, assigns));
                } else {
                    throw new ParserException("Only one range element allowed in fnpll_element with id: " + id);
                }
            }
            ++i;
        }
        return configElements;
    }

    private static @NonNull FnPllRange parseFnPllRange(ClockElementData elementData) {
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "fnpll_fractional_range".equals(node.getNodeName())) {
                Element rangeElement = (Element)node;
                String min = UtilsText.safeString((String)rangeElement.getAttribute("min"));
                String max = UtilsText.safeString((String)rangeElement.getAttribute("max"));
                String minEq = UtilsText.safeString((String)rangeElement.getAttribute("min_eq"));
                String maxEq = UtilsText.safeString((String)rangeElement.getAttribute("max_eq"));
                return new FnPllRange(BigRational.parse((String)min), BigRational.parse((String)max), Boolean.parseBoolean(minEq), Boolean.parseBoolean(maxEq));
            }
            ++i;
        }
        return FnPllRange.DEFAULT_RANGE;
    }

    private static @NonNull ClockSelect parseClockSelect(@NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull List<@NonNull Constraint> constraints, @NonNull ComponentContext context) throws ParserException {
        ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, elem, constraints, instanceMapping, context, false);
        HashMap<@NonNull Expression, @NonNull ValueMap> values = new HashMap<Expression, ValueMap>();
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "value_map".equals(node.getNodeName())) {
                Element switchElement = (Element)node;
                ValueMap valueMap = ComponentParser.parseClockSelectValueMap(switchElement, mcuRegisters, instanceMapping, context);
                values.put(Expression.EXPRESSION_TRUE, valueMap);
            } else if (node.getNodeType() == 1 && ("conditional_block".equals(node.getNodeName()) || "conditional_select".equals(node.getNodeName()))) {
                Element conditionalValue = (Element)node;
                ComponentParser.parseClockSelectConditonalBlock(conditionalValue, elementData.getId(), context, values, mcuRegisters, instanceMapping);
            }
            ++i;
        }
        return new ClockSelect(elementData, values);
    }

    private static void parseClockSelectConditonalBlock(@NonNull Element element, @NonNull String elementID, @NonNull ComponentContext context, @NonNull Map<@NonNull Expression, @NonNull ValueMap> values, @NonNull BitFieldsCache mcuRegisters, @NonNull Map<@NonNull String, @NonNull String> instanceMapping) {
        Expression caseExpr;
        ArrayList<@NonNull Expression> caseExpressions = new ArrayList<Expression>();
        NodeList cases = element.getElementsByTagName("case");
        int j = 0;
        while (j < cases.getLength()) {
            Element caseElement = (Element)Objects.requireNonNull(cases.item(j));
            caseExpr = ComponentParser.parseCondition(caseElement, context);
            Expression fullCaseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, caseExpr, context);
            caseExpressions.add(Expression.negate(caseExpr, context));
            NodeList valueMapElements = caseElement.getElementsByTagName("value_map");
            if (valueMapElements.getLength() == 1) {
                Element valueMapElement = (Element)valueMapElements.item(0);
                assert (valueMapElement != null);
                ValueMap valueMap = ComponentParser.parseClockSelectValueMap(valueMapElement, mcuRegisters, instanceMapping, context);
                values.put(fullCaseExpr, valueMap);
            } else {
                LOGGER.warning(String.valueOf(elementID) + ": Exactly one value_map element expected in case/otherwise element");
            }
            ++j;
        }
        NodeList otherwise = element.getElementsByTagName("otherwise");
        if (otherwise.getLength() == 1) {
            Element otherwiseElement = (Element)Objects.requireNonNull(otherwise.item(0));
            caseExpr = ComponentParser.appendNegatedCaseConditions(caseExpressions, Expression.EXPRESSION_TRUE, context);
            NodeList valueMapElements = otherwiseElement.getElementsByTagName("value_map");
            if (valueMapElements.getLength() == 1) {
                Element valueMapElement = (Element)valueMapElements.item(0);
                assert (valueMapElement != null);
                ValueMap valueMap = ComponentParser.parseClockSelectValueMap(valueMapElement, mcuRegisters, instanceMapping, context);
                values.put(caseExpr, valueMap);
            } else {
                LOGGER.warning(String.valueOf(elementID) + ": Exactly one value_map element expected in case/otherwise element");
            }
        }
    }

    private static @NonNull ValueMap parseClockSelectValueMap(@NonNull Element element, @NonNull BitFieldsCache mcuRegisters, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull ComponentContext context) {
        String expressionValue = UtilsText.safeString((String)element.getAttribute("expr"));
        ValueMap valueMap = new ValueMap(ExpressionUtils.createOrDefault(expressionValue, context), mcuRegisters, false);
        NodeList switchElementchildNodes = element.getChildNodes();
        int j = 0;
        while (j < switchElementchildNodes.getLength()) {
            Element inputElement;
            Node inputNode = Objects.requireNonNull(switchElementchildNodes.item(j));
            if (inputNode.getNodeType() == 1 && "input".equals(inputNode.getNodeName())) {
                inputElement = (Element)inputNode;
                ComponentParser.parseSelectorInput(inputElement, valueMap, instanceMapping, context);
            } else if (inputNode.getNodeType() == 1 && "no_clock".equals(inputNode.getNodeName())) {
                inputElement = (Element)inputNode;
                ComponentParser.parseNoClock(inputElement, valueMap);
            }
            ++j;
        }
        return valueMap;
    }

    private static void parseNoClock(Element inputElement, ValueMap values) {
        String expressionControlValue = UtilsText.safeString((String)inputElement.getAttribute("ctrl_value"));
        String controlValueResolved = Expression.create(expressionControlValue).resolve().getString();
        String signalName = UtilsText.safeString((String)inputElement.getAttribute("name"));
        values.addRequirement(controlValueResolved, signalName.isEmpty() ? "No clock" : signalName, "NO_CLOCK");
    }

    private static void parseSelectorInput(@NonNull Element inputElement, @NonNull ValueMap values, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull ComponentContext context) {
        String expressionControlValue = UtilsText.safeString((String)inputElement.getAttribute("ctrl_value"));
        String signalName = UtilsText.safeString((String)inputElement.getAttribute("name"));
        String signal = UtilsText.safeString((String)ComponentParser.parseInputSignalElement(context, signalName, inputElement, instanceMapping));
        if (signal.endsWith(".clk")) {
            signal = signal.substring(0, signal.length() - ".clk".length());
        }
        String controlValueResolved = expressionControlValue.isEmpty() ? "" : Expression.create(expressionControlValue).resolve().getString();
        values.addRequirement(controlValueResolved, signalName.isEmpty() ? null : signalName, signal);
    }

    private static @NonNull Fll parseFll(@NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull List<@NonNull Constraint> constraints, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull ComponentContext context) throws ParserException {
        Prescaler multiplier = null;
        ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, elem, constraints, instanceMapping, context, false);
        int i = 0;
        while (i < elementData.getChildNodes().getLength()) {
            Node node = Objects.requireNonNull(elementData.getChildNodes().item(i));
            if (node.getNodeType() == 1 && "prescaler".equals(node.getNodeName())) {
                Element prescalerElement = (Element)node;
                Prescaler prescaler = ComponentParser.parsePrescaler(context.getComponentID(), mcuRegisters, prescalerElement, constraints, new HashMap<String, String>(), context, true);
                if (!prescaler.isDivider()) {
                    multiplier = prescaler;
                } else {
                    throw new AssertionError((Object)"FLL '%s' must have exactly one divider and one multiplier element.");
                }
            }
            ++i;
        }
        if (multiplier == null) {
            throw new ParserException(MessageFormat.format("FLL '%s' must have exactly one divider and one multiplier element.", elementData.getId()));
        }
        Fll fll = new Fll(elementData, multiplier);
        return fll;
    }

    static @NonNull String parseInputSignalElement(@NonNull ComponentContext context, @NonNull String elementID, @NonNull Element elem, @NonNull Map<@NonNull String, String> instanceMapping) {
        String inputSignalWithoutExt;
        Element input;
        if ("input".equals(elem.getNodeName())) {
            input = elem;
        } else {
            NodeList inputs = elem.getElementsByTagName("input");
            input = null;
            if (inputs.getLength() == 0) {
                LOGGER.warning(String.format("%s: ".concat("Exactly one '%s' tag expected, but %s parsed."), elementID, "input", Integer.toString(inputs.getLength())));
            } else {
                input = (Element)inputs.item(0);
            }
        }
        String inputSignal = "";
        if (input != null) {
            String simpleID = input.getAttribute("signal");
            boolean isFullID = context.isSlice() && simpleID.startsWith(context.getPeripheral());
            String string = inputSignal = context.getComponentID().isEmpty() || isFullID ? simpleID : String.valueOf(context.getComponentID()) + "." + simpleID;
        }
        if ((inputSignalWithoutExt = inputSignal).endsWith(".clk")) {
            inputSignalWithoutExt = inputSignalWithoutExt.substring(0, inputSignalWithoutExt.length() - ".clk".length());
        }
        while (instanceMapping.containsKey(inputSignalWithoutExt)) {
            inputSignalWithoutExt = inputSignal = instanceMapping.get(inputSignalWithoutExt);
        }
        return UtilsText.safeString((String)inputSignal);
    }

    private static @NonNull String getElementID(@NonNull String componentID, @NonNull Element elem) {
        String simpleID = UtilsText.safeString((String)elem.getAttribute("id"));
        return componentID.isEmpty() ? simpleID : String.valueOf(componentID) + "." + simpleID;
    }

    private static @NonNull ClockGate parseClockGate(@NonNull BitFieldsCache mcuRegisters, @NonNull Element elem, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull List<@NonNull Constraint> constraints, @NonNull ComponentContext context) throws ParserException {
        ClockElementData elementData = ComponentParser.parseElementData(mcuRegisters, elem, constraints, instanceMapping, context, false);
        return new ClockGate(elementData);
    }

    private static void parseClockSliceSignalMap(ClockElementData sliceData, @NonNull Map<@NonNull String, @NonNull String> instanceMapping, @NonNull Map<@NonNull String, @NonNull String> signalMapping, @NonNull Map<@NonNull String, @NonNull String> pinMapping) {
        boolean found = false;
        NodeList childNodes = sliceData.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node node = Objects.requireNonNull(childNodes.item(i));
            if (node.getNodeType() == 1 && "signal_map".equals(node.getNodeName())) {
                Element signalMap = (Element)node;
                found = true;
                int j = 0;
                while (j < signalMap.getChildNodes().getLength()) {
                    Element input;
                    Node childNode = Objects.requireNonNull(signalMap.getChildNodes().item(j));
                    if (childNode.getNodeType() == 1 && "input".equals(childNode.getNodeName())) {
                        input = (Element)childNode;
                        String inputValue = input.getAttribute("signal");
                        String inputSignalWithoutExt = inputValue.replace(".clk", "");
                        while (instanceMapping.containsKey(inputSignalWithoutExt)) {
                            inputSignalWithoutExt = inputValue = instanceMapping.get(inputSignalWithoutExt);
                        }
                        String inputKey = input.getAttribute("component_signal");
                        if (inputValue != null) {
                            signalMapping.put(inputKey, inputValue);
                        }
                    } else if (childNode.getNodeType() == 1 && "pin".equals(childNode.getNodeName())) {
                        input = (Element)childNode;
                        String pinID = input.getAttribute("id");
                        String pinSliceID = input.getAttribute("component_id");
                        pinMapping.put(pinSliceID, pinID);
                    }
                    ++j;
                }
                break;
            }
            ++i;
        }
        if (!found) {
            LOGGER.severe(MessageFormat.format("Clock slice {0} expected to have exactly one signal_map, but none found.", sliceData.getId()));
        }
    }

    private static @NonNull Expression createSignalExpression(@NonNull String expression, @NonNull IContext context, @NonNull Map<@NonNull String, String> instanceMapping) {
        if (context instanceof ComponentContext) {
            String componentID = String.valueOf(((ComponentContext)context).getComponentID()) + ".";
            for (Map.Entry<String, String> entry : instanceMapping.entrySet()) {
                String signalRaw;
                String signal = entry.getKey();
                String string = signalRaw = signal.contains(componentID) ? signal.substring(componentID.length()) : signal;
                if (!expression.contains(signalRaw)) continue;
                expression = expression.replace(signalRaw, entry.getValue());
            }
        } else {
            for (Map.Entry<String, String> entry : instanceMapping.entrySet()) {
                String signal = entry.getKey();
                if (!expression.contains(signal)) continue;
                expression = expression.replace(signal, entry.getValue());
            }
        }
        return Expression.create(expression, context).simplify();
    }

    private static void checkSimpleValueMapping(Map<@NonNull String, @NonNull String> valueMapping, @Nullable Element element) {
        NamedNodeMap attributes;
        ArrayList<Integer> keys = new ArrayList<Integer>();
        ArrayList<Integer> values = new ArrayList<Integer>();
        for (Map.Entry<String, String> entry : valueMapping.entrySet()) {
            keys.add(Integer.valueOf(entry.getKey()));
            values.add(Integer.valueOf(entry.getValue()));
        }
        if (element != null && ComponentParser.isSequence(keys) && ComponentParser.isSequence(values) && (attributes = element.getAttributes()) != null) {
            Node node = attributes.item(0);
            LOGGER.warning("Simple value mapping was found for expression: " + node);
        }
    }

    private static boolean isSequence(List<Integer> values) {
        if (values.size() < 3) {
            return false;
        }
        int firstValue = values.get(0);
        int secondValue = values.get(1);
        boolean isArithmetic = true;
        int difference = secondValue - firstValue;
        int i = 2;
        while (i < values.size()) {
            if (values.get(i) - values.get(i - 1) != difference) {
                isArithmetic = false;
            }
            ++i;
        }
        if (isArithmetic) {
            return true;
        }
        int multiplier = 0;
        if (firstValue != 0) {
            multiplier = secondValue / firstValue;
        } else if (secondValue != 0) {
            multiplier = values.get(2) / secondValue;
        }
        if (multiplier == 0) {
            return false;
        }
        int i2 = 2;
        while (i2 < values.size()) {
            if (values.get(i2 - 1) * multiplier != values.get(i2)) {
                return false;
            }
            ++i2;
        }
        return true;
    }
}

