/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.clocks.data;

import com.nxp.swtools.clocks.data.ClockSlice;
import com.nxp.swtools.clocks.data.IClockComponent;
import com.nxp.swtools.clocks.data.IMcu;
import com.nxp.swtools.clocks.data.elements.IClockElement;
import com.nxp.swtools.clocks.data.model.IClocksConfig;
import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.stream.CollectorsUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class ClockSliceUtils {
    public static boolean isAnySliceElementOnPath(Set<@NonNull String> selectedPathIds, @NonNull IClocksConfig config) {
        List<@NonNull String> sliceElements = ClockSliceUtils.getAllSliceElementIDs(config, true);
        for (String sliceElement : sliceElements) {
            if (!selectedPathIds.contains(sliceElement)) continue;
            return true;
        }
        return false;
    }

    public static @NonNull List<@NonNull IClockElement> getAllSliceElements(@NonNull IClocksConfig config) {
        ArrayList<@NonNull IClockElement> sliceElements = new ArrayList<IClockElement>();
        for (IClockComponent component : config.getMcu().getClockComponents().values()) {
            for (ClockSlice slice : component.getSlices()) {
                sliceElements.addAll((Collection)slice.getElements().values().stream().filter(Objects::nonNull).collect(CollectorsUtils.toList()));
            }
        }
        return sliceElements;
    }

    public static @NonNull List<@NonNull String> getAllSliceElementIDs(@NonNull IClocksConfig config, boolean includeUnavailable) {
        ArrayList<@NonNull String> sliceElementIDs = new ArrayList<String>();
        for (IClockComponent component : config.getMcu().getClockComponents().values()) {
            for (ClockSlice slice : component.getSlices()) {
                sliceElementIDs.addAll(slice.getElements().keySet());
                if (!includeUnavailable) continue;
                sliceElementIDs.addAll(slice.getUnavailableElementsIDs());
            }
        }
        return sliceElementIDs;
    }

    public static @NonNull List<@NonNull ClockSlice> getAllClockSlices(@NonNull IMcu mcu) {
        ArrayList<@NonNull ClockSlice> clockSlices = new ArrayList<ClockSlice>();
        for (IClockComponent component : mcu.getClockComponents().values()) {
            clockSlices.addAll(component.getSlices());
        }
        return clockSlices;
    }

    public static boolean isFromSlice(@NonNull String id, @NonNull IClocksConfig config) {
        return ClockSliceUtils.getAllSliceElementIDs(config, true).contains(id);
    }

    public static @Nullable ClockSlice getClockSliceWithElement(@NonNull String id, @NonNull IClocksConfig config) {
        for (IClockComponent component : config.getMcu().getClockComponents().values()) {
            for (ClockSlice slice : component.getSlices()) {
                if (!slice.getElements().containsKey(id) && !slice.getUnavailableElementsIDs().contains(id)) continue;
                return slice;
            }
        }
        return null;
    }
}

