/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.ui.newconfig;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import java.util.Objects;
import java.util.function.Supplier;

public class ProcessorNode
implements Comparable<ProcessorNode> {
    public static final String GENERIC = "Generic";
    private String name;
    private String id;
    private Supplier<@NonNull ? extends Object[]> childrenSupplier;
    private int sortingGroup = 0;

    public ProcessorNode(String nodeName) {
        this(nodeName, nodeName, () -> new Object[0]);
    }

    public ProcessorNode(String nodeName, String id) {
        this(nodeName, id, () -> new Object[0]);
    }

    public ProcessorNode(String nodeName, String id, Supplier<? extends Object[]> childrenSupplier) {
        this.name = nodeName;
        this.id = id;
        this.childrenSupplier = childrenSupplier;
        if (GENERIC.equalsIgnoreCase(nodeName)) {
            this.sortingGroup = 1;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public Object[] getChildren() {
        return this.childrenSupplier.get();
    }

    public void setChildrenSupplier(Supplier<? extends Object[]> childrenSupplier) {
        this.childrenSupplier = childrenSupplier;
    }

    public int hashCode() {
        return Objects.hash(this.name, this.id);
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProcessorNode other = (ProcessorNode)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "[name=" + this.name + " id=" + this.id + "]";
    }

    @Override
    public int compareTo(ProcessorNode o) {
        int res = this.sortingGroup - o.sortingGroup;
        if (res != 0) {
            return res;
        }
        return this.name.compareToIgnoreCase(o.getName());
    }
}

