/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.framework.handlers;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.configuration.SwToolsProduct;
import com.nxp.swtools.configuration.SwToolsProductConfiguration;
import com.nxp.swtools.framework.Messages;
import com.nxp.swtools.utils.about.SwToolsAboutDialog;
import java.util.Collection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.about.AboutSystemPage;
import org.eclipse.ui.internal.about.ProductInfoDialog;
import org.eclipse.ui.internal.about.ProductInfoPage;

public class FrameworkAboutDialog
extends SwToolsAboutDialog {
    static final int DETAILS_BUTTON_ID = 1025;

    public FrameworkAboutDialog(Shell shell, @NonNull String productName, @NonNull String productVersion, @NonNull String productDescription, @Nullable Image productImage) {
        super(shell, productName, productVersion, productDescription, productImage);
    }

    protected void buttonPressed(int buttonId) {
        if (1025 == buttonId) {
            Shell shell = this.getShell();
            assert (shell != null);
            BusyIndicator.showWhile((Display)shell.getDisplay(), () -> {
                SwToolsDetailDialog detailDialog = new SwToolsDetailDialog(this.getShell());
                AboutSystemPage page = new AboutSystemPage();
                detailDialog.initializeDialog((ProductInfoPage)page, Messages.get().FrameworkAboutDialog_Details, null);
                detailDialog.open();
            });
        } else {
            super.buttonPressed(buttonId);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        Composite compooste = new Composite(area, 0);
        RowLayout rowLayout = new RowLayout();
        rowLayout.wrap = true;
        rowLayout.fill = true;
        compooste.setLayout((Layout)rowLayout);
        @NonNull @NonNull Collection toolProducts = SwToolsProductConfiguration.getRegisteredProducts();
        for (final SwToolsProduct product : toolProducts) {
            if (product.isHeadless()) continue;
            Button button = new Button(compooste, 0x800008);
            Image icon = FrameworkAboutDialog.getToolIcon((String)product.getIconLocation());
            button.setImage(icon != null ? icon : FrameworkAboutDialog.getDefaultImage());
            button.setToolTipText(product.getProductNameWithVersion());
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    SwToolsAboutDialog.open((Shell)FrameworkAboutDialog.this.getShell(), (SwToolsProduct)product, (boolean)false);
                }
            });
        }
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 1025, Messages.get().FrameworkAboutDialog_Details, false);
        Label separator = new Label(parent, 0);
        separator.setLayoutData((Object)new GridData(768));
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        super.createButtonsForButtonBar(parent);
    }

    public static class SwToolsDetailDialog
    extends ProductInfoDialog {
        protected SwToolsDetailDialog(Shell shell) {
            super(shell);
        }
    }
}

