/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cle.ide.software.manager.internal.registry.core;

import com.nxp.s32ds.cle.ide.software.manager.internal.marker.SoftwareManifestMarker;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.SoftwareManagerActivator;
import com.nxp.s32ds.cle.ide.software.manager.internal.registry.core.implementation.SoftwareManifestFilesManagerImplementation;
import com.nxp.s32ds.cle.ide.software.manager.internal.utils.MementoIOUtils;
import com.nxp.s32ds.cle.ide.software.manager.parser.SaxParserUtils;
import com.nxp.s32ds.cle.ide.software.manager.registry.core.SoftwareManagerMessages;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageDescriptor;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPackageRegistry;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManagerPayload;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManifestFilesManager;
import com.nxp.s32ds.cle.runtime.software.manager.SoftwareManifestHandler;
import com.nxp.s32ds.ext.rcp.runtime.RcpBundle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.ui.WorkbenchException;
import org.xml.sax.SAXException;

public class SoftwareManagerJob
extends Job {
    private final SoftwareManagerPackageRegistry registry;
    private final Set<String> softwareDescriptorsLocations;
    private IStringVariableManager stringVariableManager;
    private final SoftwareManagerPayload managerPayload;

    public SoftwareManagerJob(String name, Set<String> strings, SoftwareManagerPackageRegistry registry, SoftwareManagerPayload managerPayload) {
        super(name);
        this.registry = registry;
        this.softwareDescriptorsLocations = strings;
        this.stringVariableManager = VariablesPlugin.getDefault().getStringVariableManager();
        this.managerPayload = managerPayload;
    }

    protected IStatus run(IProgressMonitor monitor) {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        SoftwareManifestFilesManagerImplementation handlerManagerImplementation = new SoftwareManifestFilesManagerImplementation(workspaceRoot, this.softwareDescriptorsLocations);
        HashSet<SoftwareManagerPackageDescriptor> storedSoftwareManagerPackageDescriptor = new HashSet<SoftwareManagerPackageDescriptor>();
        String storedPreferensString = SoftwareManagerActivator.getInstance().getConfigurationScopePreferences().get("storedSoftwareDescriptors", "");
        SoftwareManifestHandler manifestHandler = new SoftwareManifestHandler((SoftwareManifestFilesManager)handlerManagerImplementation);
        try {
            MementoIOUtils.uploadMapFileLocation2MD5(storedPreferensString, storedSoftwareManagerPackageDescriptor);
            if (manifestHandler.isFilesChanged((RcpBundle)SoftwareManagerActivator.getInstance())) {
                Set<SoftwareManagerPackageDescriptor> currentSoftwareManagerPackageDescriptor = this.parseSoftwareDescriptors(workspaceRoot, this.softwareDescriptorsLocations, this.stringVariableManager);
                MementoIOUtils.storeMapFileLocation2MD5(currentSoftwareManagerPackageDescriptor);
                Set missedDescriptors = storedSoftwareManagerPackageDescriptor.stream().filter(descriptor -> !currentSoftwareManagerPackageDescriptor.contains(descriptor)).collect(Collectors.toSet());
                Set newDescriptors = currentSoftwareManagerPackageDescriptor.stream().filter(descriptor -> !storedSoftwareManagerPackageDescriptor.contains(descriptor)).collect(Collectors.toSet());
                currentSoftwareManagerPackageDescriptor.stream().forEach(arg_0 -> ((SoftwareManagerPackageRegistry)this.registry).addSwPackageDescriptor(arg_0));
                this.managerPayload.setPlatformStateChanged(true);
                this.managerPayload.addAllToCurrentSoftwareManagerDescriptors(currentSoftwareManagerPackageDescriptor);
                this.managerPayload.addAllToMissedSoftwareManagerDescriptors(missedDescriptors);
                this.managerPayload.addAllToNewSoftwareManagerDescriptors(newDescriptors);
            } else {
                this.managerPayload.addAllToCurrentSoftwareManagerDescriptors(storedSoftwareManagerPackageDescriptor);
            }
        }
        catch (WorkbenchException e) {
            SoftwareManagerActivator.getInstance().logError(SoftwareManagerMessages.SoftwareManagerJob_MemetoError, e);
        }
        catch (ParserConfigurationException e) {
            SoftwareManagerActivator.getInstance().logError(SoftwareManagerMessages.SoftwareManagerActivator_ParserConfigurationErrorMessage, e);
        }
        return Status.OK_STATUS;
    }

    private Set<SoftwareManagerPackageDescriptor> parseSoftwareDescriptors(IWorkspaceRoot workspaceRoot, Set<String> softwareDescriptorsLocations, IStringVariableManager stringVariableManager) throws ParserConfigurationException {
        HashSet<SoftwareManagerPackageDescriptor> descriptors = new HashSet<SoftwareManagerPackageDescriptor>();
        HashMap<String, String> descriptorsIdToLocations = new HashMap<String, String>();
        for (String path : softwareDescriptorsLocations) {
            try {
                File file = new File(stringVariableManager.performStringSubstitution(path));
                if (!file.exists()) {
                    SoftwareManifestMarker.createMarker((IResource)workspaceRoot, path, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerJob_SoftwareManifestNotFoundByPath, (Object)path.toString()));
                    break;
                }
                IPath location = Path.fromOSString((String)file.getPath());
                try {
                    Throwable throwable = null;
                    Object var11_12 = null;
                    try (FileInputStream is = new FileInputStream(file);){
                        SoftwareManagerPackageDescriptor parceDescriptions = SaxParserUtils.parceDescriptions(file, is);
                        if (parceDescriptions == null) continue;
                        if (descriptorsIdToLocations.containsKey(parceDescriptions.getId())) {
                            String bind = SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerJobChangeListener_DuplicateSoftwareDescriptorId, (Object)path.toString(), descriptorsIdToLocations.get(parceDescriptions.getId()));
                            SoftwareManifestMarker.createMarker((IResource)workspaceRoot, bind);
                            SoftwareManagerActivator.getInstance().logWarning(bind);
                            continue;
                        }
                        descriptors.add(parceDescriptions);
                        descriptorsIdToLocations.put(parceDescriptions.getId(), path);
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException | SAXException exception) {
                    IFile fileForLocation = workspaceRoot.getFileForLocation(location);
                    if (fileForLocation != null) {
                        SoftwareManifestMarker.createMarker((IResource)fileForLocation, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerJob_SoftwareManifestNotFoundByPath, (Object)path.toString()));
                    } else {
                        SoftwareManifestMarker.createMarker((IResource)workspaceRoot, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerJob_SoftwareManifestNotFoundByPath, (Object)path.toString()));
                    }
                    SoftwareManagerActivator.getInstance().log((IStatus)new Status(4, "com.nxp.s32ds.cle.ide.software.manager", SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_FileOpenParseError, (Object)path)));
                }
            }
            catch (CoreException coreException) {
                SoftwareManifestMarker.createMarker((IResource)workspaceRoot, path, SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_VaribleCantResolve, (Object)path));
                SoftwareManagerActivator.getInstance().log((IStatus)new Status(4, "com.nxp.s32ds.cle.ide.software.manager", SoftwareManagerMessages.bind((String)SoftwareManagerMessages.SoftwareManagerActivator_VaribleCantResolve, (Object)path)));
            }
        }
        return descriptors;
    }
}

