/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.svd.parser.cache;

import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;

public class SvdLaunchCache<L extends ILaunch, T> {
    private final Map<L, T> launchesMap = new WeakHashMap<L, T>();
    private final Function<L, T> mappingFunction;

    public SvdLaunchCache(Function<L, T> mappingFunction) {
        this.mappingFunction = mappingFunction;
        DebugPlugin.getDefault().addDebugEventListener(e -> this.handleDebugEvents(e));
    }

    private void handleDebugEvents(DebugEvent[] events) {
        DebugEvent[] debugEventArray = events;
        int n = events.length;
        int n2 = 0;
        while (n2 < n) {
            DebugEvent event = debugEventArray[n2];
            Object source = event.getSource();
            if (event.getKind() == 8 && source instanceof IProcess) {
                this.launchesMap.remove(((IProcess)source).getLaunch());
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T computeIfAbsent(L launch) {
        Map<L, T> map = this.launchesMap;
        synchronized (map) {
            return this.launchesMap.computeIfAbsent(launch, this.mappingFunction);
        }
    }
}

