/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf.memory;

import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRange;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.core.IAddress;

public class SvdDsfMemoryRangeChains {
    public static boolean remove(List<SvdDsfMemoryRange> ranges, SvdDsfMemoryRange range) {
        int startIndex = SvdDsfMemoryRangeChains.getNearestLessIndex(ranges, range);
        if (startIndex < 0) {
            return false;
        }
        int endIndex = SvdDsfMemoryRangeChains.getNearestLessIndex(ranges, range.getLastAddress());
        ArrayList<SvdDsfMemoryRange> affecteds = new ArrayList<SvdDsfMemoryRange>();
        ArrayList<List<SvdDsfMemoryRange>> results = new ArrayList<List<SvdDsfMemoryRange>>();
        int index = startIndex;
        while (index <= endIndex) {
            SvdDsfMemoryRange nearestLess = ranges.get(index);
            if (nearestLess.intersects(range)) {
                affecteds.add(nearestLess);
                results.add(nearestLess.delete(range));
            }
            ++index;
        }
        boolean modified = false;
        int i = 0;
        while (i < affecteds.size()) {
            modified |= SvdDsfMemoryRangeChains.replace(ranges, ranges.indexOf(affecteds.get(i)), (List)results.get(i));
            ++i;
        }
        return modified;
    }

    public static void add(List<SvdDsfMemoryRange> ranges, SvdDsfMemoryRange range) {
        int index = SvdDsfMemoryRangeChains.getNearestLessIndex(ranges, range);
        if (index < 0) {
            ranges.add(range);
            return;
        }
        ArrayList<SvdDsfMemoryRange> affecteds = new ArrayList<SvdDsfMemoryRange>();
        ArrayList<ArrayList<SvdDsfMemoryRange>> results = new ArrayList<ArrayList<SvdDsfMemoryRange>>();
        while (true) {
            int tailIndex;
            SvdDsfMemoryRange affected = ranges.get(index);
            ArrayList<SvdDsfMemoryRange> result = new ArrayList<SvdDsfMemoryRange>(affected.join(range));
            affecteds.add(affected);
            results.add(result);
            int affectedIndex = result.indexOf(affected);
            int rangeIndex = result.indexOf(range);
            if (affectedIndex == -1 && rangeIndex == -1 && result.size() == 1) {
                tailIndex = 0;
            } else if (affectedIndex >= 0 && affectedIndex + 1 < result.size()) {
                tailIndex = affectedIndex + 1;
            } else {
                if (rangeIndex < 0 || result.size() != rangeIndex + 1) break;
                tailIndex = rangeIndex;
            }
            if (++index == ranges.size()) break;
            range = (SvdDsfMemoryRange)result.remove(tailIndex);
        }
        int i = 0;
        while (i < affecteds.size()) {
            SvdDsfMemoryRangeChains.replace(ranges, ranges.indexOf(affecteds.get(i)), (List)results.get(i));
            ++i;
        }
    }

    private static boolean equals(SvdDsfMemoryRange range, List<SvdDsfMemoryRange> ranges) {
        return Collections.singletonList(range).equals(ranges);
    }

    private static boolean replace(List<SvdDsfMemoryRange> ranges, int index, List<SvdDsfMemoryRange> toReplace) {
        if (SvdDsfMemoryRangeChains.equals(ranges.get(index), toReplace)) {
            return false;
        }
        ranges.remove(index);
        int i = 0;
        while (i < toReplace.size()) {
            ranges.add(index + i, toReplace.get(i));
            ++i;
        }
        return true;
    }

    public static int getNearestLessIndex(List<SvdDsfMemoryRange> ranges, SvdDsfMemoryRange range) {
        return SvdDsfMemoryRangeChains.getNearestLessIndex(ranges, range.getAddress());
    }

    public static int getNearestLessIndex(List<SvdDsfMemoryRange> ranges, IAddress target) {
        IAddress[] array = (IAddress[])ranges.stream().map(e -> e.getAddress()).toArray(IAddress[]::new);
        return SvdDsfMemoryRangeChains.getNearestLessIndex(array, target);
    }

    public static int getNearestLessIndex(IAddress[] array, IAddress target) {
        if (array.length == 0) {
            return -1;
        }
        int length = array.length;
        if (target.compareTo((Object)array[0]) <= 0) {
            return 0;
        }
        if (target.compareTo((Object)array[length - 1]) > 0) {
            return length - 1;
        }
        int left = 0;
        int right = length;
        int middle = 0;
        while (left < right) {
            middle = left + (right - left) / 2;
            if (target.compareTo((Object)array[middle]) == 0) {
                return middle;
            }
            if (target.compareTo((Object)array[middle]) < 0) {
                if (middle > 0 && target.compareTo((Object)array[middle - 1]) > 0) {
                    return middle - 1;
                }
                right = middle;
                continue;
            }
            if (middle < length - 1 && target.compareTo((Object)array[middle + 1]) < 0) {
                return middle;
            }
            left = middle + 1;
        }
        return middle;
    }
}

