/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf.memory;

import com.nxp.s32ds.cdt.internal.svd.dsf.SvdDsfUpdatableCache;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRange;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRangeChain;
import com.nxp.s32ds.cdt.internal.svd.dsf.memory.SvdDsfMemoryRanges;
import com.nxp.s32ds.ext.cdt.dsf.DsfRequestor;
import java.math.BigInteger;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.service.DsfSession;
import org.eclipse.debug.core.model.MemoryByte;

public class SvdDsfMemoryRangeChainCache
extends SvdDsfUpdatableCache<SvdDsfMemoryRange, BigInteger, MemoryByte[]> {
    private final SvdDsfMemoryRangeChain chain;
    private final Map<SvdDsfMemoryRange, MemoryByte[]> values = new ConcurrentHashMap<SvdDsfMemoryRange, MemoryByte[]>();

    public SvdDsfMemoryRangeChainCache(DsfSession session, DsfRequestor<SvdDsfMemoryRange, BigInteger, MemoryByte[]> requestor, SvdDsfMemoryRangeChain chain) {
        super(session, requestor);
        this.chain = chain;
    }

    public boolean contains(SvdDsfMemoryRange range) {
        return this.chain.contains(range);
    }

    public BigInteger getValue(SvdDsfMemoryRange range) {
        SvdDsfMemoryRange containingRange = this.chain.getContainingRange(range);
        if (containingRange == null) {
            return null;
        }
        MemoryByte[] memoryBytes = this.values.get(containingRange);
        if (memoryBytes == null) {
            return null;
        }
        return SvdDsfMemoryRanges.extract(containingRange, memoryBytes, range);
    }

    public SvdDsfMemoryRangeChain getMemoryRangeChain() {
        return this.chain;
    }

    public void update(IDMContext idmContext) {
        super.update(idmContext, this.chain.getRanges());
    }

    @Override
    public void apply(SvdDsfMemoryRange range, MemoryByte[] result) {
        if (result != null) {
            this.values.put(range, result);
        }
    }

    public SvdDsfMemoryRangeChain getChain() {
        return this.chain;
    }

    public Map<SvdDsfMemoryRange, MemoryByte[]> getValues() {
        return this.values;
    }
}

