/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.s32ds.cdt.internal.svd.dsf;

import com.nxp.s32ds.cdt.internal.svd.SvdActivator;
import com.nxp.s32ds.cdt.svd.dsf.SvdDsfSessionCacheManager;
import com.nxp.s32ds.cdt.svd.utils.SvdTrace;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.cdt.dsf.concurrent.DsfRunnable;
import org.eclipse.cdt.dsf.datamodel.IDMContext;
import org.eclipse.cdt.dsf.datamodel.IDMEvent;
import org.eclipse.cdt.dsf.debug.service.IMemory;
import org.eclipse.cdt.dsf.debug.service.IRunControl;
import org.eclipse.cdt.dsf.service.DsfServiceEventHandler;
import org.eclipse.cdt.dsf.service.DsfSession;

public class SvdDsfEventListener {
    private final DsfSession session;

    public SvdDsfEventListener(DsfSession session) {
        this.session = session;
        SvdDsfEventListener.addServiceEventListener(session, this);
    }

    public void dispose() {
        SvdDsfEventListener.removeServiceEventListener(this.session, this);
    }

    @DsfServiceEventHandler
    public void handleEvent(IRunControl.ISuspendedDMEvent event) {
        if (event instanceof IRunControl.IContainerSuspendedDMEvent) {
            this.requestUpdate((IDMEvent<? extends IDMContext>)event);
        }
    }

    @DsfServiceEventHandler
    public void handleEvent(IMemory.IMemoryChangedEvent event) {
        this.requestUpdate((IDMEvent<? extends IDMContext>)event);
    }

    private void requestUpdate(IDMEvent<? extends IDMContext> event) {
        IDMContext idmContext = event.getDMContext();
        SvdTrace.trace("request updateValues for session {}", this.session);
        SvdDsfSessionCacheManager.getInstance().updateValues(this.session, idmContext);
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    private static void addServiceEventListener(final DsfSession session, final Object listener) {
        try {
            SvdTrace.trace("Submit commant to addServiceEventListener for DsfSession({}) ", session.getId());
            session.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    SvdTrace.trace("addServiceEventListener for DsfSession({}) ", session.getId());
                    session.addServiceEventListener(listener, null);
                }
            });
        }
        catch (RejectedExecutionException e) {
            SvdActivator.getInstance().logError("Execution rejected", e);
        }
    }

    @ConfinedToDsfExecutor(value="getSession().getExecutor()")
    private static void removeServiceEventListener(final DsfSession session, final Object listener) {
        try {
            session.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    session.removeServiceEventListener(listener);
                }
            });
        }
        catch (RejectedExecutionException e) {
            SvdActivator.getInstance().logError("Execution rejected", e);
        }
    }
}

