/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller.report;

import com.nxp.swtools.common.utils.Nullable;
import com.nxp.swtools.common.utils.lang.CollectionsUtils;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Controller;
import com.nxp.swtools.periphs.controller.Messages;
import com.nxp.swtools.periphs.model.config.PeriphsProfile;
import com.nxp.swtools.resourcetables.model.config.AStructuredSettingConfig;
import com.nxp.swtools.resourcetables.model.config.IChild;
import com.nxp.swtools.resourcetables.model.config.IComponentConfig;
import com.nxp.swtools.resourcetables.model.config.IComponentInstanceConfig;
import com.nxp.swtools.resourcetables.model.config.IConfigSetConfig;
import com.nxp.swtools.resourcetables.model.config.IFunctionalGroup;
import com.nxp.swtools.resourcetables.model.config.IRoot;
import com.nxp.swtools.resourcetables.model.validation.ValidationHelper;
import com.nxp.swtools.utils.report.CssStyle;
import com.nxp.swtools.utils.report.HtmlAttribute;
import com.nxp.swtools.utils.report.HtmlBuilder;
import com.nxp.swtools.utils.report.ReportGenerator;
import com.nxp.swtools.utils.wizards.exportWizard.AExportWizard;
import com.nxp.swtools.validation.engine.ProblemUtils;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.graphics.RGB;

public class PeriphsHtmlReportGenerator {
    public static final int TWO_TABS = 2;
    public static final int FOUR_TABS = 4;
    public static final String HEX_COLOR_DISABLED = ReportGenerator.getHexColor((RGB)ReportGenerator.COLOR_DISABLED);
    public static final String HEX_COLOR_ERROR = ReportGenerator.getHexColor((RGB)ReportGenerator.COLOR_ERROR);
    public static final String HEX_COLOR_WARNING = ReportGenerator.getHexColor((RGB)ReportGenerator.COLOR_WARNING);
    public static final String HEX_COLOR_INVERTED_TEXT = ReportGenerator.getHexColor((RGB)ReportGenerator.COLOR_INVERTED_FOREGROUND);
    public static final String HEX_COLOR_HEADER = ReportGenerator.getHexColor((RGB)ReportGenerator.COLOR_TABLE_HEADER2);
    public static final CssStyle STYLE_BOLD_TEXT = new CssStyle("font-weight", "bold");
    public static final CssStyle STYLE_ITALIC_TEXT = new CssStyle("font-style", "italic");
    public static final CssStyle STYLE_GRAY_TEXT = new CssStyle("color", HEX_COLOR_DISABLED);
    public static final CssStyle STYLE_RED_TEXT = new CssStyle("color", HEX_COLOR_ERROR);
    public static final CssStyle STYLE_YELLOW_TEXT = new CssStyle("color", HEX_COLOR_WARNING);
    public static final CssStyle STYLE_WHITE_TEXT = new CssStyle("color", HEX_COLOR_INVERTED_TEXT);
    public static final CssStyle STYLE_STROKE_TEXT = new CssStyle("text-decoration", "line-through");
    public static final CssStyle STYLE_UNDERLINE_TEXT = new CssStyle("text-decoration", "underline");
    public static final CssStyle STYLE_GRAY_BACKGROUND = new CssStyle("background-color", HEX_COLOR_DISABLED);
    public static final CssStyle STYLE_RED_BACKGROUND = new CssStyle("background-color", HEX_COLOR_ERROR);
    public static final CssStyle STYLE_YELLOW_BACKGROUND = new CssStyle("background-color", HEX_COLOR_WARNING);
    public static final CssStyle STYLE_LIGHT_GRAY_BACKGROUND = new CssStyle("background-color", HEX_COLOR_HEADER);
    public static final String HTML_TAG_TR = "tr";
    public static final String HTML_TAG_TD = "td";
    public static final String HTML_TAG_UL = "ul";
    public static final String HTML_TAG_LI = "li";
    public static final String HTML_TAG_SPAN = "span";
    public static final String BREAK_LINE = "<br/>";
    public static final String SPACE = "&nbsp;";

    public static String getHtmlFileName() {
        return "html_report_Peripherals.html";
    }

    public static AExportWizard.GenerationResult generateReport() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(PeriphsHtmlReportGenerator.getHtmlFileName(), PeriphsHtmlReportGenerator.generateHtml());
        return AExportWizard.GenerationResult.success(map);
    }

    public static String generateHtml() {
        PeriphsProfile profile = Controller.getInstance().getProfile();
        StringBuilder report = new StringBuilder();
        String toolError = Controller.getInstance().getToolError();
        report.append(ReportGenerator.getIntro());
        report.append(ReportGenerator.getHeadings((String)"Peripherals"));
        ReportGenerator.appendText((StringBuilder)report, (int)0, (String)ReportGenerator.getHeader((int)0, (String)UtilsText.safeString((String)Messages.get().PeriphsHtmlReportGenerator_Header)), (boolean)true);
        if (toolError == null) {
            ReportGenerator.appendText((StringBuilder)report, (int)2, (String)PeriphsHtmlReportGenerator.getTableOfFunctionalGroups((IRoot)profile, 2), (boolean)true);
            report.append(ReportGenerator.getEnd());
        } else {
            report.append(ReportGenerator.getHeader((int)3, (String)UtilsText.safeString((String)toolError)));
        }
        return UtilsText.safeString((String)report.toString());
    }

    public static String getHtmlTagBeginning(String htmlTag, @Nullable List<CssStyle> styles, @Nullable List<HtmlAttribute> attributes) {
        return "<" + htmlTag + " " + HtmlBuilder.buildCss(styles) + HtmlBuilder.buildHtml(attributes) + htmlTag + ">";
    }

    public static String getHtmlTagEnd(String htmlTag) {
        return "</" + htmlTag + ">";
    }

    public static String getHtmlTag(String htmlTag, @Nullable String content, @Nullable List<CssStyle> styles, @Nullable List<HtmlAttribute> attributes) {
        if (content == null) {
            content = "";
        }
        return String.valueOf(PeriphsHtmlReportGenerator.getHtmlTagBeginning(htmlTag, styles, attributes)) + content + PeriphsHtmlReportGenerator.getHtmlTagEnd(htmlTag);
    }

    public static String getBreakLine() {
        return BREAK_LINE;
    }

    public static String getSpace() {
        return SPACE;
    }

    public static String getTableOfFunctionalGroups(IRoot profile, int indentation) {
        StringBuilder result = new StringBuilder();
        List functionalGroups = profile.getFunctionalGroups();
        ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)ReportGenerator.getTableBeginning(), (boolean)true);
        ReportGenerator.appendText((StringBuilder)result, (int)(indentation + 2), (String)PeriphsHtmlReportGenerator.getHtmlTagBeginning(HTML_TAG_TR, null, null), (boolean)true);
        ReportGenerator.appendText((StringBuilder)result, (int)(indentation + 4), (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, Messages.get().PeriphsHtmlReportGenerator_FunctionalGroup, null, null), (boolean)true);
        ReportGenerator.appendText((StringBuilder)result, (int)(indentation + 4), (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, Messages.get().PeriphsHtmlReportGenerator_Component, null, null), (boolean)true);
        ReportGenerator.appendText((StringBuilder)result, (int)(indentation + 4), (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, Messages.get().PeriphsHtmlReportGenerator_ComponentInstance, null, null), (boolean)true);
        ReportGenerator.appendText((StringBuilder)result, (int)(indentation + 4), (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, Messages.get().PeriphsHtmlReportGenerator_ConfigSet, null, null), (boolean)true);
        ReportGenerator.appendText((StringBuilder)result, (int)(indentation + 4), (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, Messages.get().PeriphsHtmlReportGenerator_Setting, null, null), (boolean)true);
        Map dependencies = ValidationHelper.collectValidationProblemsOnPeripheralsTool();
        String message = ProblemUtils.getDependenciesWarningMessage((Map)dependencies);
        for (IFunctionalGroup group : functionalGroups) {
            CollectionsUtils.Pair<String, Integer> tableComponents = PeriphsHtmlReportGenerator.getTableContentOfComponents(profile, group, indentation + 4);
            long numOfRows = ((Integer)tableComponents.getSecond()).longValue();
            ArrayList<HtmlAttribute> functionalGroupRowAttributes = new ArrayList<HtmlAttribute>();
            ArrayList<CssStyle> functionalGroupStyles = new ArrayList<CssStyle>();
            functionalGroupStyles.add(STYLE_BOLD_TEXT);
            if (!dependencies.isEmpty()) {
                numOfRows = numOfRows > 0L ? numOfRows : 1L;
                functionalGroupRowAttributes.add(new HtmlAttribute("title", message));
                functionalGroupStyles.add(STYLE_YELLOW_BACKGROUND);
            } else {
                functionalGroupStyles.add(STYLE_LIGHT_GRAY_BACKGROUND);
            }
            if (numOfRows == 0L) continue;
            String rowSpanValue = String.valueOf(numOfRows);
            functionalGroupRowAttributes.add(new HtmlAttribute("rowspan", rowSpanValue));
            ReportGenerator.appendText((StringBuilder)result, (int)(indentation + 2), (String)PeriphsHtmlReportGenerator.getHtmlTagBeginning(HTML_TAG_TR, null, null), (boolean)true);
            ReportGenerator.appendText((StringBuilder)result, (int)(indentation + 4), (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, group.getUiName(), functionalGroupStyles, functionalGroupRowAttributes), (boolean)true);
            ReportGenerator.appendText((StringBuilder)result, (int)(indentation + 4), (String)((String)tableComponents.getFirst()), (boolean)true);
        }
        ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)ReportGenerator.getTableEnding(), (boolean)true);
        return UtilsText.safeString((String)result.toString());
    }

    public static CollectionsUtils.Pair<String, Integer> getTableContentOfComponents(IRoot profile, IFunctionalGroup group, int indentation) {
        StringBuilder result = new StringBuilder();
        Collection components = profile.getConfiguredComponents().values();
        int rowCount = 0;
        for (IComponentConfig component : components) {
            if ("System".equals(component.getComponent().getCategory()) || component.getGlobalConfigSet() == null && group.getInstancesOfType(component.getId()).isEmpty()) continue;
            int configSetsCount = 0;
            Collection instancesOfType = group.getInstancesOfType(component.getName());
            for (IComponentInstanceConfig instance : instancesOfType) {
                configSetsCount += instance.getChildren().size();
            }
            @Nullable IConfigSetConfig globalConfigSet = component.getGlobalConfigSet();
            if (globalConfigSet != null) {
                ++configSetsCount;
            }
            String numOfConfigSets = UtilsText.safeString((String)String.valueOf(configSetsCount));
            ArrayList<HtmlAttribute> rowSpanAttribute = new ArrayList<HtmlAttribute>();
            rowSpanAttribute.add(new HtmlAttribute("rowspan", numOfConfigSets));
            rowCount += configSetsCount;
            String nameOfComponent = component.getUiName();
            ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, nameOfComponent, null, rowSpanAttribute), (boolean)true);
            if (globalConfigSet != null) {
                ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)(String.valueOf(PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, Messages.get().PeriphsHtmlReportGenerator_GlobalConfigSet, null, null)) + PeriphsHtmlReportGenerator.getTableContentOfConfigSets(Arrays.asList(globalConfigSet), indentation)), (boolean)true);
                ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getHtmlTagEnd(HTML_TAG_TR), (boolean)true);
                ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getHtmlTagBeginning(HTML_TAG_TR, null, null), (boolean)true);
            }
            ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getTableContentOfInstances(component.getName(), group, indentation), (boolean)true);
        }
        return new CollectionsUtils.Pair((Object)UtilsText.safeString((String)result.toString()), (Object)rowCount);
    }

    public static String getTableContentOfInstances(String componentType, IFunctionalGroup group, int indentation) {
        StringBuilder result = new StringBuilder();
        for (IComponentInstanceConfig instance : group.getInstancesOfType(componentType)) {
            List<CssStyle> peripheralStyles = null;
            List<CssStyle> instanceStyles = null;
            int configSetsCount = instance.getChildren().size();
            String numOfSettings = UtilsText.safeString((String)String.valueOf(configSetsCount));
            ArrayList<HtmlAttribute> rowSpanAttribute = new ArrayList<HtmlAttribute>();
            rowSpanAttribute.add(new HtmlAttribute("rowspan", numOfSettings));
            if (instance.getMasterPeripheralError() != null) {
                peripheralStyles = Arrays.asList(STYLE_RED_TEXT, STYLE_BOLD_TEXT, STYLE_ITALIC_TEXT, STYLE_UNDERLINE_TEXT);
            } else if (!instance.isEnabled()) {
                instanceStyles = Arrays.asList(STYLE_GRAY_TEXT);
            }
            String comment = PeriphsHtmlReportGenerator.getComment(instance);
            String instanceCellContent = String.valueOf(instance.getUiName()) + PeriphsHtmlReportGenerator.getBreakLine() + PeriphsHtmlReportGenerator.getBreakLine() + PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_SPAN, PeriphsHtmlReportGenerator.getPeripheral(instance), peripheralStyles, null) + PeriphsHtmlReportGenerator.getBreakLine() + PeriphsHtmlReportGenerator.getBreakLine() + PeriphsHtmlReportGenerator.getMode(instance);
            if (comment != null) {
                instanceCellContent = String.valueOf(instanceCellContent) + PeriphsHtmlReportGenerator.getBreakLine() + PeriphsHtmlReportGenerator.getBreakLine() + comment;
            }
            ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, instanceCellContent, instanceStyles, rowSpanAttribute), (boolean)true);
            List configSets = instance.getChildren();
            ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getTableContentOfConfigSets(configSets, indentation), (boolean)true);
        }
        return UtilsText.safeString((String)result.toString());
    }

    public static String getTableContentOfConfigSets(@Nullable Collection<IConfigSetConfig> configSets, int indentation) {
        StringBuilder result = new StringBuilder();
        if (configSets != null) {
            int counter = 0;
            for (IConfigSetConfig configSet : configSets) {
                ++counter;
                String nameOfConfigSet = configSet.getUiName();
                String htmlTitle = PeriphsHtmlReportGenerator.getHtmlTitle((IChild)configSet);
                ArrayList<CssStyle> styles = PeriphsHtmlReportGenerator.getHtmlStyle((IChild)configSet);
                ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, nameOfConfigSet, styles, Arrays.asList(new HtmlAttribute("title", htmlTitle))), (boolean)true);
                List settings = configSet.getChildren();
                ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_TD, PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_UL, PeriphsHtmlReportGenerator.getSettingsDetails(settings, indentation), null, null), null, null), (boolean)true);
                ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getHtmlTagEnd(HTML_TAG_TR), (boolean)true);
                if (counter >= configSets.size()) continue;
                ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getHtmlTagBeginning(HTML_TAG_TR, null, null), (boolean)true);
            }
        }
        return UtilsText.safeString((String)result.toString());
    }

    public static String getPeripheral(IComponentInstanceConfig instance) {
        return UtilsText.safeString((String)(String.valueOf(Messages.get().PeriphsHtmlReportGenerator_Peripheral) + instance.getPeripheral()));
    }

    public static String getMode(IComponentInstanceConfig instance) {
        return UtilsText.safeString((String)(String.valueOf(Messages.get().PeriphsHtmlReportGenerator_Mode) + instance.getMode().getUIName(instance.getExpressionContext())));
    }

    public static @Nullable String getComment(IComponentInstanceConfig instance) {
        String comment = instance.getComment();
        if (UtilsText.isEmpty((String)comment)) {
            return null;
        }
        return MessageFormat.format(Messages.get().PeriphsHtmlReportGenerator_Comment, comment);
    }

    public static String getSettingsDetails(List<? extends IChild> settings, int indentation) {
        StringBuilder result = new StringBuilder();
        for (IChild iChild : settings) {
            if (!iChild.isAvailable()) continue;
            String nameOfSetting = iChild.getUiName();
            ArrayList<CssStyle> settingStyle = PeriphsHtmlReportGenerator.getHtmlStyle(iChild);
            String htmlTitle = PeriphsHtmlReportGenerator.getHtmlTitle(iChild);
            List<HtmlAttribute> htmlAttributes = Arrays.asList(new HtmlAttribute("title", htmlTitle));
            if (iChild instanceof AStructuredSettingConfig) {
                AStructuredSettingConfig structuredConfig = (AStructuredSettingConfig)iChild;
                ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_LI, String.valueOf(PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_SPAN, nameOfSetting, settingStyle, htmlAttributes)) + PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_UL, PeriphsHtmlReportGenerator.getSettingsDetails(structuredConfig.getChildren(), indentation), null, null), null, null), (boolean)true);
                continue;
            }
            String valueOfSetting = UtilsText.safeString((String)iChild.getValueName());
            String valueTag = PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_SPAN, valueOfSetting, Arrays.asList(STYLE_ITALIC_TEXT), null);
            String nameTag = PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_SPAN, String.valueOf(nameOfSetting) + PeriphsHtmlReportGenerator.getSpace() + "=" + PeriphsHtmlReportGenerator.getSpace(), null, null);
            String contentTag = PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_SPAN, String.valueOf(nameTag) + valueTag, settingStyle, htmlAttributes);
            ReportGenerator.appendText((StringBuilder)result, (int)indentation, (String)PeriphsHtmlReportGenerator.getHtmlTag(HTML_TAG_LI, contentTag, null, null), (boolean)true);
        }
        return UtilsText.safeString((String)result.toString());
    }

    public static ArrayList<CssStyle> getHtmlStyle(IChild setting) {
        ArrayList<CssStyle> settingStyle = new ArrayList<CssStyle>();
        if (!setting.isEnabled()) {
            settingStyle.add(STYLE_GRAY_TEXT);
        } else if (setting.getError() != null) {
            settingStyle.add(STYLE_RED_BACKGROUND);
            settingStyle.add(STYLE_UNDERLINE_TEXT);
        } else if (setting.getWarning() != null) {
            settingStyle.add(STYLE_YELLOW_BACKGROUND);
            settingStyle.add(STYLE_UNDERLINE_TEXT);
        }
        return settingStyle;
    }

    public static String getHtmlTitle(IChild setting) {
        if (setting.getError() != null) {
            return UtilsText.safeString((String)setting.getError());
        }
        if (setting.getWarning() != null) {
            return UtilsText.safeString((String)setting.getWarning());
        }
        return "";
    }
}

