/*
 * Decompiled with CFR 0.152.
 */
package com.nxp.swtools.periphs.controller;

import com.nxp.swtools.common.utils.NonNull;
import com.nxp.swtools.common.utils.text.UtilsText;
import com.nxp.swtools.periphs.controller.Messages;
import com.nxp.swtools.resourcetables.model.data.ConfigurationComponentTypeId;
import com.nxp.swtools.resourcetables.model.data.SWComponent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import org.osgi.framework.Version;

public class ConfigurationComponentUtils {
    private static final int HIGHEST_PERMITED_VERSION_PART = 99;

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public static String buildDriverDependencyInfo(ConfigurationComponentTypeId configComp, boolean mustBeRequired) {
        @NonNull List sdkComponents = configComp.getConfigurationComponent().getComponents();
        return ConfigurationComponentUtils.buildDriverDependencyInfo(mustBeRequired, sdkComponents);
    }

    public static String buildDriverDependencyInfo(boolean mustBeRequired, List<SWComponent> sdkComponents) {
        StringJoiner joiner = new StringJoiner("; ");
        for (SWComponent component : sdkComponents) {
            if (mustBeRequired != component.getRequired()) continue;
            StringBuilder builder = new StringBuilder();
            Version version = component.getVersion();
            if (version == null) continue;
            Version untilVersion = component.getUntilVersion();
            SWComponent.Match match = component.getMatch();
            if (match == null) {
                match = SWComponent.Match.EQUIVALENT;
            }
            if (match == SWComponent.Match.PERFECT) {
                untilVersion = version;
            }
            if (untilVersion == null) {
                if (match == SWComponent.Match.COMPATIBLE) {
                    untilVersion = new Version(version.getMajor(), 99, 99);
                }
                if (match == SWComponent.Match.GREATER_OR_EQUAL) {
                    untilVersion = new Version(99, 99, 99);
                }
            }
            builder.append(component.getName()).append("[").append(version.toString());
            if (!Objects.equals(version, untilVersion) && untilVersion != null) {
                builder.append("-").append(untilVersion.toString());
            }
            ArrayList<@NonNull T> revisionsList = new ArrayList(component.getRevisionsList());
            revisionsList.sort(Comparator.naturalOrder());
            if (!revisionsList.isEmpty()) {
                builder.append(", ");
                builder.append(MessageFormat.format(Messages.get().ComponentUtils_SDKComponentReferences_RevisionsList, UtilsText.join(revisionsList, (String)",")));
            }
            builder.append("]");
            if (match == SWComponent.Match.EQUIVALENT) {
                String effectiveVersion = String.valueOf(version.getMajor()) + "." + version.getMinor() + "." + "x";
                builder.append("(").append(effectiveVersion).append(")");
            }
            if (builder.length() == 0) continue;
            joiner.add(builder.toString());
        }
        return joiner.toString();
    }
}

