/*******************************************************************************
 * Copyright 2023 NXP
 * SPDX-License-Identifier: EPL-1.0
 *******************************************************************************/

package com.freescale.system.browser.epl.help;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import com.freescale.system.browser2.ISimpleTableDataProvider2;

public class SimpleTableDataDescriptorEpl extends SectionDescriptorEpl {
	
	private static final String ATT_CLASS = "class"; //$NON-NLS-1$
	
	public SimpleTableDataDescriptorEpl(IConfigurationElement configurationElement) {
		super(configurationElement, TasksTabDescriptorEpl.class.toString());
		if (getId() == null || getTargetTab() == null) {
			// the section id and tab are mandatory - log error
			handleSectionError(null);
		}
	}

	public final ISimpleTableDataProvider2 createDataProvider() {
		ISimpleTableDataProvider2 section = null;

		try {
			section = (ISimpleTableDataProvider2)getConfigurationElement().createExecutableExtension(ATT_CLASS);
		} catch (CoreException exception) {
			handleSectionError(exception);
		}

		return section;
	}
}
