/*******************************************************************************
 * Copyright 2023 NXP
 *
 * SPDX-License-Identifier: EPL-1.0
 *******************************************************************************/

package com.freescale.s32ds.ext.cdt.utils.epl.help;

import java.util.stream.Stream;
import org.eclipse.core.runtime.Platform;
import com.freescale.s32ds.ext.cdt.utils.epl.EclipseUtilsEpl;

public enum OSFamilyEpl {

	WINDOWS("windows", osStartsWith("win")), 
	LINUX("linux", osStartsWith(Platform.OS_LINUX)), 
	OSX("osx", osStartsWith("mac")),
	OTHER("other", false);

	public static final OSFamilyEpl current = Stream.of(values()).filter(f -> f.isCurrent).findAny().orElse(OTHER);
	public final String family; 
	private final boolean isCurrent;
	
	private OSFamilyEpl(String family, boolean isCurrent) {
		this.family = family;
		this.isCurrent = isCurrent;
	}
	
	public boolean isCurrent() {
		return equals(current);
	}
	
	private static boolean osStartsWith(String prefix) {
		return System.getProperty(EclipseUtilsEpl.PROPERTY_OS_NAME).toLowerCase().startsWith(prefix);
	}
	
}
